/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.SystemPropertiesList;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.TestSnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.security.Authenticator;
import org.gridgain.grid.security.passcode.AuthenticationAclBasicProvider;
import org.gridgain.grid.security.passcode.AuthenticationAclProvider;
import org.gridgain.grid.security.passcode.PasscodeAuthenticator;
import org.junit.Test;

@SystemPropertiesList(value={@WithSystemProperty(key="GG_SNAPSHOT_SECURITY_FEATURE", value="true"), @WithSystemProperty(key="IGNITE_DISTRIBUTED_META_STORAGE_FEATURE", value="true")})
public class SnapshotSecurityLevelSetupTest
extends AbstractSnapshotTest {
    private static final String DIST_CONF_PREFIX = "distrConf-";
    private static final String LEVEL_KEY = "distrConf-snapshotSecurityLevel";
    private static final String[] CREDS = new String[]{"arthur", UUID.randomUUID().toString(), "merlin", UUID.randomUUID().toString()};
    private static MessageDigestFactory TEST_DIGEST_FACTORY = new MessageDigestFactory(){

        public String getAlgorithmCode() {
            return this.createDigest().getAlgorithm();
        }

        public MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static SnapshotRegistryTransformer TEST_TRANSFORMER = new TestSnapshotRegistryTransformer("secret");

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        System.clearProperty("GG_SNAPSHOT_SECURITY_LEVEL");
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="bad_level")
    public void testStartFailureWithMisspelledSystemProperty() {
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.startGrid(0), IgniteCheckedException.class, (String)"Failed to resolve snapshot security level using system property (are there any misspellings?).");
        GridTestUtils.assertThrows((IgniteLogger)log, () -> this.startGrid("client"), IgniteCheckedException.class, (String)"Failed to resolve snapshot security level using system property (are there any misspellings?).");
    }

    @Test
    public void testNoMetastorageMigrationWithUnsetProperty() throws Exception {
        SnapshotSecurityLevelSetupTest.assertNull((Object)System.getProperty("GG_SNAPSHOT_SECURITY_LEVEL"));
        this.startGrids(2);
        IgniteEx client = this.startGrid("client");
        this.grid(0).cluster().active(true);
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.DISABLED, (Object)this.getSnapshot(this.grid(0)).getSecurityLevel());
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.DISABLED, (Object)this.getSnapshot(this.grid(1)).getSecurityLevel());
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.DISABLED, (Object)this.getSnapshot(client).getSecurityLevel());
        this.printMetastoreContent(this.grid(0));
        SnapshotSecurityLevelSetupTest.assertNull((Object)this.grid(0).context().distributedMetastorage().read(LEVEL_KEY));
        SnapshotSecurityLevelSetupTest.assertNull((Object)this.grid(1).context().distributedMetastorage().read(LEVEL_KEY));
        SnapshotSecurityLevelSetupTest.assertNull((Object)client.context().distributedMetastorage().read(LEVEL_KEY));
    }

    @Test
    @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="REQUIRE")
    public void testMetastorageMigrationWithPropertySet() throws Exception {
        this.startGrids(2);
        this.grid(0).cluster().active(true);
        IgniteEx client = this.startGrid("client");
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.getSnapshot(this.grid(0)).getSecurityLevel());
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.getSnapshot(this.grid(1)).getSecurityLevel());
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.getSnapshot(client).getSecurityLevel());
        this.printMetastoreContent(this.grid(0));
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.grid(0).context().distributedMetastorage().read(LEVEL_KEY));
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.grid(1).context().distributedMetastorage().read(LEVEL_KEY));
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)client.context().distributedMetastorage().read(LEVEL_KEY));
    }

    @Test
    public void testCreateSnapshotMismatchDigestAlgoAcrossNodes() throws Exception {
        this.doTestCreateSnapshotMismatchSettingsAcrossNodes(TEST_DIGEST_FACTORY, null);
    }

    @Test
    public void testCreateSnapshotMismatchTransformerAcrossNodes() throws Exception {
        this.doTestCreateSnapshotMismatchSettingsAcrossNodes(null, TEST_TRANSFORMER);
    }

    @Test
    public void testRestoreSnapshotMismatchDigestAlgoAcrossNode() throws Exception {
        this.doTestRestoreSnapshotMismatchSettingsAcrossNodes(TEST_DIGEST_FACTORY, null);
    }

    @Test
    public void testRestoreSnapshotMismatchTransformerAcrossNodes() throws Exception {
        this.doTestRestoreSnapshotMismatchSettingsAcrossNodes(null, TEST_TRANSFORMER);
    }

    @Test
    public void testCheckSnapshotMismatchDigestAlgoAcrossNodes() throws Exception {
        this.doTestCheckSnapshotMismatchSettingsAcrossNodes(TEST_DIGEST_FACTORY, null);
    }

    @Test
    public void testCheckSnapshotMismatchTransformerAcrossNodes() throws Exception {
        this.doTestCheckSnapshotMismatchSettingsAcrossNodes(null, TEST_TRANSFORMER);
    }

    @Test
    public void testVerifyIsCalledForEmptyVerificationCode() throws Exception {
        final AtomicInteger cntr = new AtomicInteger();
        SnapshotRegistryTransformer transformer = new SnapshotRegistryTransformer(){

            public byte[] transform(byte[] data) {
                return new byte[0];
            }

            public void verify(byte[] data, byte[] verificationData) {
                if (F.isEmpty((byte[])verificationData)) {
                    cntr.incrementAndGet();
                }
            }
        };
        IgniteEx grid1 = this.startGrid(this.getConfiguration("grid1", null, transformer));
        this.startGrid(this.getConfiguration("grid2", null, transformer));
        grid1.cluster().active(true);
        GridSnapshotEx db = this.getSnapshot(grid1);
        db.updateSecurityLevel(SnapshotSecurityLevel.REQUIRE);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        List issues = (List)db.checkSnapshot(snapshotId, null, false, null).get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        SnapshotSecurityLevelSetupTest.assertNotNull((Object)issues);
        SnapshotSecurityLevelSetupTest.assertEquals((int)0, (int)issues.size());
        SnapshotSecurityLevelSetupTest.assertEquals((int)2, (int)cntr.get());
        SnapshotFuture restFut = db.restoreSnapshot(snapshotId, null, null);
        restFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        SnapshotSecurityLevelSetupTest.assertEquals((int)5, (int)cntr.get());
    }

    @Test
    public void testDifferentTransformerName() throws Exception {
        IgniteEx grid1 = this.startGrid(this.getConfiguration("grid1", TEST_DIGEST_FACTORY, TEST_TRANSFORMER));
        TestSnapshotRegistryTransformer transformer = new TestSnapshotRegistryTransformer("secret"){

            public String getTransformerName() {
                return "OTHER";
            }
        };
        this.startGrid(this.getConfiguration("grid2", TEST_DIGEST_FACTORY, transformer));
        IgniteEx client = this.startGrid("client");
        grid1.cluster().active(true);
        GridSnapshotEx db = this.getSnapshot(client);
        db.updateSecurityLevel(SnapshotSecurityLevel.REQUIRE);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)"Incompatible snapshot security settings detected on some nodes.");
    }

    @Test
    @WithSystemProperty(key="GG_SNAPSHOT_SECURITY_LEVEL", value="REQUIRE")
    public void testChangeSecurityLevelApiAuthorization() throws Exception {
        IgniteEx grid1 = this.startGrid(this.getConfigurationWithAuth(this.getTestIgniteInstanceName(0), TEST_DIGEST_FACTORY, TEST_TRANSFORMER));
        IgniteEx grid2 = this.startGrid(this.getConfigurationWithAuth(this.getTestIgniteInstanceName(1), TEST_DIGEST_FACTORY, TEST_TRANSFORMER));
        grid1.cluster().active(true);
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.getSnapshot(grid2).getSecurityLevel());
        try {
            this.getSnapshot(grid2).updateSecurityLevel(SnapshotSecurityLevel.DISABLED);
            SnapshotSecurityLevelSetupTest.fail((String)"must fail with security exception.");
        }
        catch (SecurityException e) {
            SnapshotSecurityLevelSetupTest.assertTrue((boolean)e.getMessage().contains("Authorization failed"));
            SnapshotSecurityLevelSetupTest.assertTrue((boolean)e.getMessage().contains(SecurityPermission.CHANGE_SNAPSHOT_SECURITY_LEVEL.name()));
        }
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.REQUIRE, (Object)this.getSnapshot(grid2).getSecurityLevel());
        this.getSnapshot(grid1).updateSecurityLevel(SnapshotSecurityLevel.DISABLED);
        SnapshotSecurityLevelSetupTest.assertEquals((Object)SnapshotSecurityLevel.DISABLED, (Object)this.getSnapshot(grid2).getSecurityLevel());
    }

    private void doTestCreateSnapshotMismatchSettingsAcrossNodes(MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer) throws Exception {
        this.startGrid(this.getConfiguration("grid1", null, null));
        IgniteEx grid2 = this.startGrid(this.getConfiguration("grid2", msgDigestFactory, registryTransformer));
        grid2.cluster().active(true);
        GridSnapshotEx db = this.getSnapshot(grid2);
        db.updateSecurityLevel(SnapshotSecurityLevel.REQUIRE);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)"Incompatible snapshot security settings detected on some nodes.");
    }

    private void doTestRestoreSnapshotMismatchSettingsAcrossNodes(MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer) throws Exception {
        IgniteEx grid1 = this.startGrid(this.getConfiguration("grid1", null, null));
        this.startGrid(this.getConfiguration("grid2", null, null));
        grid1.cluster().active(true);
        GridSnapshotEx db = this.getSnapshot(grid1);
        db.updateSecurityLevel(SnapshotSecurityLevel.REQUIRE);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        this.stopGrid("grid2");
        this.startGrid(this.getConfiguration("grid2", msgDigestFactory, registryTransformer));
        grid1.cluster().active(true);
        SnapshotFuture restFut = db.restoreSnapshot(snapshotId, null, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS), IgniteException.class, (String)"Incompatible snapshot security settings detected on some nodes.");
    }

    private void doTestCheckSnapshotMismatchSettingsAcrossNodes(MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer) throws Exception {
        IgniteEx grid1 = this.startGrid(this.getConfiguration("grid1", null, null));
        this.startGrid(this.getConfiguration("grid2", null, null));
        grid1.cluster().active(true);
        GridSnapshotEx db = this.getSnapshot(grid1);
        db.updateSecurityLevel(SnapshotSecurityLevel.REQUIRE);
        SnapshotFuture fut = db.createFullSnapshot(null, null);
        fut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
        long snapshotId = fut.snapshotOperation().snapshotId();
        this.stopGrid("grid2");
        this.startGrid(this.getConfiguration("grid2", msgDigestFactory, registryTransformer));
        grid1.cluster().active(true);
        SnapshotFuture checkFut = db.checkSnapshot(snapshotId, null, false, null);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            checkFut.get(this.getTestTimeout(), TimeUnit.MILLISECONDS);
            return null;
        }, IgniteException.class, (String)"Incompatible snapshot security settings detected on some nodes.");
    }

    private GridSnapshotEx getSnapshot(IgniteEx igniteEx) {
        GridGain gg = (GridGain)igniteEx.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        assert (snapshot != null);
        return snapshot;
    }

    private IgniteConfiguration getConfiguration(String gridName, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer transformer) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(gridName);
        GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)cfg).getSnapshotConfiguration().setMessageDigestFactory(msgDigestFactory).setRegistryTransformer(transformer);
        return cfg;
    }

    private IgniteConfiguration getConfigurationWithAuth(String gridName, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer transformer) throws Exception {
        IgniteConfiguration cfg = this.getConfiguration(gridName, msgDigestFactory, transformer);
        GridGainConfiguration gCfg = GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)cfg);
        PasscodeAuthenticator auth = new PasscodeAuthenticator();
        SecurityCredentials cred1 = new SecurityCredentials(CREDS[0], CREDS[1]);
        SecurityCredentials cred2 = new SecurityCredentials(CREDS[2], CREDS[3]);
        String perms1 = this.getPermissionDefinitions(cred1.getLogin().toString());
        String perms2 = this.getPermissionDefinitions(cred2.getLogin().toString());
        auth.setAclProvider((AuthenticationAclProvider)new AuthenticationAclBasicProvider(F.asMap((Object)cred1, (Object)perms1, (Object)cred2, (Object)perms2)));
        gCfg.setAuthenticator((Authenticator)auth);
        if (this.getTestIgniteInstanceName(0).equals(gridName)) {
            gCfg.setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(cred1));
        } else {
            gCfg.setSecurityCredentialsProvider((SecurityCredentialsProvider)new SecurityCredentialsBasicProvider(cred2));
        }
        return cfg;
    }

    private String getPermissionDefinitions(String login) {
        return "{defaultAllow:true,{cache:'*',permissions:[CACHE_READ,CACHE_PUT,CACHE_REMOVE]},{task:'*',permissions:[TASK_EXECUTE]}, {system:[JOIN_AS_SERVER,CACHE_CREATE,CACHE_DESTROY,ADMIN_CACHE,ADMIN_OPS,ADMIN_VIEW" + (CREDS[0].equals(login) ? "," + SecurityPermission.CHANGE_SNAPSHOT_SECURITY_LEVEL.name() : "") + "]}}";
    }

    private void printMetastoreContent(IgniteEx grid) {
        try {
            grid.context().distributedMetastorage().iterate("", (k, s) -> System.out.println("Key = " + k + ", Value = " + s));
        }
        catch (Exception e) {
            SnapshotSecurityLevelSetupTest.fail((String)e.getMessage());
        }
    }
}

