/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotCreateParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfoEx;
import org.gridgain.grid.persistentstore.SnapshotInfoParams;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotOperationIncludeExcludeParametersTest
extends AbstractSnapshotTest {
    private static final Set<String> allCacheNames = Sets.newHashSet((Object[])new String[]{"cache1", "cache2", "cache3", "cache4", "cache5_g1", "cache6_g1", "cache7_g1", "cache8_g2", "cache9_g2", "cache10_g2", "cache11", "cache12", "cache13"});
    private static final SortedSet<String> nonExistentCaches = new TreeSet<String>(Arrays.asList("NON_EXISTENT_CACHE_OR_GROUP_NAME_0", "NON_EXISTENT_CACHE_OR_GROUP_NAME_1"));
    private static final List<String> cachesWithData = Arrays.asList("cache5_g1", "cache6_g1", "cache8_g2", "cache9_g2", "cache11", "cache12");
    private static final Set<String> caches8to12 = Sets.newHashSet((Object[])new String[]{"cache8_g2", "cache9_g2", "cache10_g2", "cache11", "cache12"});
    private static final Set<String> groups1_2 = new HashSet<String>(Arrays.asList("group_1", "group_2"));
    private static final Set<String> cachesFromGroups1_2 = Sets.newHashSet((Object[])new String[]{"cache5_g1", "cache6_g1", "cache7_g1", "cache8_g2", "cache9_g2", "cache10_g2"});
    private static final Set<String> caches8to12WithGroups1_2 = Stream.concat(caches8to12.stream(), groups1_2.stream()).collect(Collectors.toSet());
    private static final Set<String> caches8to12AndFromGroups1_2 = Stream.concat(caches8to12.stream(), cachesFromGroups1_2.stream()).collect(Collectors.toSet());
    @Parameterized.Parameter(value=0)
    public Set<String> includeCachesOrGroups;
    @Parameterized.Parameter(value=1)
    public Set<String> excludeCachesOrGroups;
    @Parameterized.Parameter(value=2)
    public Set<String> expectedCacheNames;
    @Parameterized.Parameter(value=3)
    public Matcher<String> excMsgForCreate;
    @Parameterized.Parameter(value=4)
    public Matcher<String> excMsgForCheckRestore;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        IgniteEx ignite = this.startGrid(0);
        this.startGrid(1);
        ignite.cluster().state(ClusterState.ACTIVE);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        IgniteEx ignite = this.ignite(0);
        allCacheNames.stream().map(this::getCacheConfig).forEach(arg_0 -> ((IgniteEx)ignite).getOrCreateCache(arg_0));
    }

    @Parameterized.Parameters(name="included = {0}; excluded = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{null, null, allCacheNames, null, null}, {caches8to12, null, caches8to12, null, null}, {groups1_2, null, cachesFromGroups1_2, null, null}, {caches8to12WithGroups1_2, null, caches8to12AndFromGroups1_2, null, null}, {nonExistentCaches, null, null, Matchers.equalTo((Object)("Caches or groups from command parameters not found: " + nonExistentCaches)), Matchers.allOf((Matcher)Matchers.startsWith((String)"Caches (cache groups) are not contained in snapshot "), (Matcher)Matchers.endsWith((String)nonExistentCaches.toString()))}, {null, caches8to12, SnapshotOperationIncludeExcludeParametersTest.setSubtraction(allCacheNames, caches8to12), null, null}, {null, groups1_2, SnapshotOperationIncludeExcludeParametersTest.setSubtraction(allCacheNames, cachesFromGroups1_2), null, null}, {null, caches8to12WithGroups1_2, SnapshotOperationIncludeExcludeParametersTest.setSubtraction(allCacheNames, caches8to12AndFromGroups1_2), null, null}, {null, nonExistentCaches, null, Matchers.equalTo((Object)("Caches or groups from command parameters not found: " + nonExistentCaches)), Matchers.allOf((Matcher)Matchers.startsWith((String)"Caches (cache groups) are not contained in snapshot "), (Matcher)Matchers.endsWith((String)nonExistentCaches.toString()))}, {caches8to12, groups1_2, null, Matchers.equalTo((Object)"Pass either include caches or exclude caches parameter."), Matchers.equalTo((Object)"Pass either include caches or exclude caches parameter.")}};
    }

    @Test
    public void testSnapshotCreateFull() {
        if (this.excMsgForCreate != null) {
            this.thrown.expectMessage(this.excMsgForCreate);
        }
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        long snapId = this.fillDataAndCreateFullSnapshot(this.includeCachesOrGroups, this.excludeCachesOrGroups);
        SnapshotInfoEx snapInfo = gg.snapshot().snapshot(new SnapshotInfoParams().snapshotId(snapId));
        SnapshotOperationIncludeExcludeParametersTest.assertEquals(this.expectedCacheNames, (Object)snapInfo.cacheNames());
    }

    @Test
    public void testSnapshotCreateIncremental() {
        if (this.excMsgForCreate != null) {
            this.thrown.expectMessage(this.excMsgForCreate);
        }
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        this.fillDataAndCreateFullSnapshot(null, null);
        this.mutateData();
        SnapshotFuture snap = gg.snapshot().createSnapshot(this.includeCachesOrGroups, this.excludeCachesOrGroups, null, null, null, null);
        snap.get();
        long snapId = snap.snapshotOperation().snapshotId();
        SnapshotInfoEx snapInfo = gg.snapshot().snapshot(new SnapshotInfoParams().snapshotId(snapId));
        SnapshotOperationIncludeExcludeParametersTest.assertEquals(this.expectedCacheNames, (Object)snapInfo.cacheNames());
    }

    @Test
    public void testSnapshotCheck() {
        if (this.excMsgForCheckRestore != null) {
            this.thrown.expectMessage(this.excMsgForCheckRestore);
        }
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        long snapId = this.fillDataAndCreateFullSnapshot(null, null);
        SnapshotFuture check = gg.snapshot().check(new CheckSnapshotParams().snapshotId(snapId).operationType(SnapshotOperationType.CHECK).cacheNames(this.includeCachesOrGroups).excludedCacheNames(this.excludeCachesOrGroups));
        check.get();
        SnapshotOperationIncludeExcludeParametersTest.assertEquals(this.expectedCacheNames, (Object)check.snapshotOperation().cacheNames());
    }

    @Test
    public void testSnapshotRestore() {
        if (this.excMsgForCheckRestore != null) {
            this.thrown.expectMessage(this.excMsgForCheckRestore);
        }
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        long snapId = this.fillDataAndCreateFullSnapshot(null, null);
        ignite.destroyCaches(cachesWithData);
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snapId).forceRestore(true).cacheNames(this.includeCachesOrGroups).excludedCacheNames(this.excludeCachesOrGroups)).get();
        this.validateDataRestoredOnlyForSpecifiedCaches(this.expectedCacheNames);
    }

    private void mutateData() {
        IgniteEx ignite = this.ignite(0);
        List caches = cachesWithData.stream().map(arg_0 -> ((IgniteEx)ignite).cache(arg_0)).collect(Collectors.toList());
        for (int i = 0; i < 10; ++i) {
            for (int cacheIdx = 0; cacheIdx < caches.size(); ++cacheIdx) {
                ((IgniteCache)caches.get(cacheIdx)).put((Object)i, (Object)(1000 * cacheIdx + i));
            }
        }
    }

    private long fillDataAndCreateFullSnapshot(Set<String> includeCaches, Set<String> excludeCaches) {
        IgniteEx ignite = this.ignite(0);
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        List caches = cachesWithData.stream().map(arg_0 -> ((IgniteEx)ignite).cache(arg_0)).collect(Collectors.toList());
        for (int i = 0; i < 30; ++i) {
            for (int cacheIdx = 0; cacheIdx < caches.size(); ++cacheIdx) {
                ((IgniteCache)caches.get(cacheIdx)).put((Object)i, (Object)(100 * cacheIdx + i));
            }
        }
        SnapshotFuture snapshotCreateFut = gg.snapshot().createFullSnapshot(includeCaches, excludeCaches, null, null, new SnapshotCreateParams(CompressionOption.NONE, -1), null);
        snapshotCreateFut.get();
        return snapshotCreateFut.snapshotOperation().snapshotId();
    }

    private void validateDataRestoredOnlyForSpecifiedCaches(Collection<String> restoredCaches) {
        IgniteEx ignite = this.ignite(0);
        for (int cacheIdx = 0; cacheIdx < cachesWithData.size(); ++cacheIdx) {
            String cacheName = cachesWithData.get(cacheIdx);
            IgniteCache cache = ignite.cache(cacheName);
            if (restoredCaches.contains(cacheName)) {
                SnapshotOperationIncludeExcludeParametersTest.assertNotNull((String)("Expected " + cacheName + " is not null."), (Object)cache);
                for (int i = 0; i < 30; ++i) {
                    SnapshotOperationIncludeExcludeParametersTest.assertEquals((Object)(100 * cacheIdx + i), (Object)cache.get((Object)i));
                }
                continue;
            }
            SnapshotOperationIncludeExcludeParametersTest.assertNull((String)("Expected " + cacheName + " is null."), (Object)cache);
        }
    }

    @SafeVarargs
    public static <T> Set<T> setSubtraction(Set<? extends T> lhs, Set<? extends T> ... rhs) {
        if (lhs == null || rhs == null) {
            return Collections.emptySet();
        }
        HashSet<T> result = new HashSet<T>();
        for (T val : lhs) {
            boolean contains = false;
            for (Set<T> set : rhs) {
                if (!set.contains(val)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            result.add(val);
        }
        return result;
    }
}

