/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.List;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IgniteSnapshotRestoreCustomSqlSchemaTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache_4";
    private static final String SCHEMA_NAME_1 = "SCHEMA_1";
    private static final String SCHEMA_NAME_2 = "SCHEMA_2";
    private static final String SCHEMA_NAME_3 = "ScHeMa3";
    private static final String SCHEMA_NAME_4 = "SCHEMA_4";
    private static final String TABLE_NAME = "T1";
    private static final String[] ALL_SCHEMAS = new String[]{"SCHEMA_1", "SCHEMA_2", "ScHeMa3", "SCHEMA_4"};
    private boolean includeSchemas;

    private static String t(String schema, String tbl) {
        return schema + "." + tbl;
    }

    private static String q(String str) {
        return "\"" + str + "\"";
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        if (this.includeSchemas) {
            cfg.setSqlSchemas(new String[]{SCHEMA_NAME_1, SCHEMA_NAME_2, IgniteSnapshotRestoreCustomSqlSchemaTest.q(SCHEMA_NAME_3)});
        }
        return cfg.setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("DFLT_TEMPLATE*").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)), new CacheConfiguration(CACHE_NAME).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 8)).setSqlSchema(SCHEMA_NAME_4)}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    @Before
    public void init() {
        this.includeSchemas = true;
    }

    @After
    public void tearDown() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    @Test
    public void testRestoreFromSnapshot() throws Exception {
        this.startAndActivate();
        for (String schemaName : ALL_SCHEMAS) {
            this.execSql("CREATE TABLE " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + "(id INT PRIMARY KEY, val VARCHAR) WITH \"TEMPLATE=DFLT_TEMPLATE\"");
            for (int i = 0; i < 10; ++i) {
                this.execSql("INSERT INTO " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + "(id, val) VALUES (" + i + ", '" + schemaName + "')");
            }
        }
        long snapshotId = this.makeSnapshot();
        for (String schemaName : ALL_SCHEMAS) {
            this.execSql("DROP TABLE " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME));
        }
        this.restoreSnapshot(snapshotId);
        for (String schemaName : ALL_SCHEMAS) {
            List<List<?>> act = this.execSql("SELECT COUNT(*) FROM " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + " WHERE val = '" + schemaName + "'");
            Assert.assertEquals((Object)10L, act.get(0).get(0));
        }
    }

    @Test
    public void testRestoreFromSnapshotAfterRestart() throws Exception {
        this.startAndActivate();
        for (String schemaName : ALL_SCHEMAS) {
            this.execSql("CREATE TABLE " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + "(id INT PRIMARY KEY, val VARCHAR) WITH \"TEMPLATE=DFLT_TEMPLATE\"");
            for (int i = 0; i < 10; ++i) {
                this.execSql("INSERT INTO " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + "(id, val) VALUES (" + i + ", '" + schemaName + "')");
            }
        }
        long snapshotId = this.makeSnapshot();
        for (String schemaName : ALL_SCHEMAS) {
            this.execSql("DROP TABLE " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME));
        }
        this.stopGrid(0);
        this.includeSchemas = false;
        this.startAndActivate();
        this.restoreSnapshot(snapshotId);
        for (String schemaName : ALL_SCHEMAS) {
            List<List<?>> act = this.execSql("SELECT COUNT(*) FROM " + IgniteSnapshotRestoreCustomSqlSchemaTest.t(IgniteSnapshotRestoreCustomSqlSchemaTest.q(schemaName), TABLE_NAME) + " WHERE val = '" + schemaName + "'");
            Assert.assertEquals((Object)10L, act.get(0).get(0));
        }
    }

    private long makeSnapshot() {
        GridGain gg = (GridGain)this.grid(0).plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        fut.get();
        return snapshotId;
    }

    private void restoreSnapshot(long snapshotId) {
        ((GridGain)this.grid(0).plugin("GridGain")).snapshot().restoreSnapshot(snapshotId, null, null).get();
    }

    private IgniteEx startAndActivate() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        Assert.assertTrue((boolean)ignite.cluster().active());
        return ignite;
    }

    private List<List<?>> execSql(String qry) {
        return this.grid(0).context().query().querySqlFields(new SqlFieldsQuery(qry).setLazy(true), false).getAll();
    }
}

