/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.TestRecordingCommunicationSpi;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.junit.Test;

@WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="true")
public class IgniteDbSnapshotWalStateChangeTest
extends AbstractSnapshotTest {
    private static final int EXPECTED_CACHES_COUNT = 15;
    private static final int NODES_COUNT = 2;
    protected static IgniteEx ignite;
    protected static IgniteEx ignite2;
    protected static IgniteEx dummyNode;
    protected static GridGain gg;
    private IgniteBiPredicate<ClusterNode, Message> blockMsgPred;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCommunicationSpi((CommunicationSpi)new TestRecordingCommunicationSpi());
        if (this.blockMsgPred != null) {
            ((TestRecordingCommunicationSpi)cfg.getCommunicationSpi()).blockMessages(this.blockMsgPred);
        }
        return cfg;
    }

    @Override
    protected int getBackupCount() {
        return 2;
    }

    protected void beforeTest() throws Exception {
        IgniteDbSnapshotWalStateChangeTest.assertTrue((boolean)ignite.cluster().active());
        IgniteCache cache1 = ignite.getOrCreateCache(this.getOrCreateDefaultCacheName((Ignite)ignite));
        IgniteCache cache2 = ignite.getOrCreateCache(this.getCacheConfig("cache2"));
        IgniteCache cache3 = ignite.getOrCreateCache(this.getCacheConfig("cache3"));
        IgniteCache cache4 = ignite.getOrCreateCache(this.getCacheConfig("localCache"));
        cache1.clear();
        cache2.clear();
        cache3.clear();
        cache4.clear();
        this.load((Ignite)ignite);
        IgniteDbSnapshotWalStateChangeTest.loadWithTestValuesAsync((Ignite)ignite, "cache3", 300, 0).get();
        IgniteDbSnapshotWalStateChangeTest.loadWithIntsAsync((Ignite)ignite, "localCache", 0, 1).get();
        IgniteDbSnapshotWalStateChangeTest.assertEquals((String)"beforeTest", (int)300, (int)cache1.size(new CachePeekMode[0]));
        IgniteDbSnapshotWalStateChangeTest.assertEquals((String)"beforeTest", (int)300, (int)cache2.size(new CachePeekMode[0]));
        IgniteDbSnapshotWalStateChangeTest.assertEquals((String)"beforeTest", (int)300, (int)cache3.size(new CachePeekMode[0]));
        IgniteDbSnapshotWalStateChangeTest.assertEquals((String)"beforeTest", (int)300, (int)cache4.size(new CachePeekMode[0]));
    }

    @Override
    protected void afterTest() throws Exception {
        SnapshotStatus op = gg.snapshot().ongoingSnapshotOperation();
        if (op != null) {
            gg.snapshot().cancelSnapshotOperation(op.operationId(), "afterTest").get();
        }
        this.clearSnapshotNodeDir(this.snapshotFolders());
        IgniteDbSnapshotWalStateChangeTest.assertEquals((String)ignite.cacheNames().toString(), (int)15, (int)ignite.cacheNames().size());
    }

    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        dummyNode = this.startGrid("dummy");
        ignite = this.startGrid(0);
        ignite2 = this.startGrid(1);
        dummyNode.cluster().active(true);
        gg = (GridGain)ignite.plugin("GridGain");
        this.load((Ignite)ignite);
        this.startGrid("client");
    }

    @Test
    public void testWalDisabledCacheGroup() throws Exception {
        IgniteEx node = this.grid(0);
        try {
            node.cluster().disableWal("cache1");
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, "test-exchangeless-snapshot");
            GridTestUtils.assertThrows((IgniteLogger)log, () -> fut.get(60L, TimeUnit.SECONDS), IgniteException.class, null);
        }
        finally {
            node.cluster().enableWal("cache1");
        }
    }

    @Test
    public void testWalDisabledOnCreatingConsistentCut() throws Exception {
        this.testWalDisabledOnConsistentCut(SnapshotOperationStage.SECOND, true);
    }

    @Test
    public void testWalDisabledAfterCreatingConsistentCut() throws Exception {
        this.testWalDisabledOnConsistentCut(SnapshotOperationStage.FOURTH, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @WithSystemProperty(key="IGNITE_DISABLE_WAL_DURING_REBALANCING", value="true")
    public void testCreatingSnapshotRebalanceIsInProgress() throws Exception {
        IgniteEx newBltNode = null;
        AffinityTopologyVersion topVer = this.grid(0).context().discovery().topologyVersionEx();
        try {
            int restartedId = G.allGrids().size();
            newBltNode = this.startGrid(restartedId);
            this.grid(0).cluster().setBaselineTopology(this.grid(0).cluster().forServers().nodes());
            this.awaitPartitionMapExchange(false, true, null);
            this.stopGrid(restartedId);
            IgniteDbSnapshotWalStateChangeTest.loadWithTestValuesAsync((Ignite)ignite, "cache3", 300, 300).get();
            this.blockMsgPred = (IgniteBiPredicate & Serializable)(node, msg) -> {
                if (msg instanceof GridDhtPartitionDemandMessage) {
                    GridDhtPartitionDemandMessage msg0 = (GridDhtPartitionDemandMessage)msg;
                    return msg0.groupId() == CU.cacheId((String)"cache3");
                }
                return false;
            };
            newBltNode = this.startGrid(restartedId);
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, "test-exchangeless-snapshot");
            fut.get(60L, TimeUnit.SECONDS);
            TestRecordingCommunicationSpi.spi((Ignite)newBltNode).stopBlock();
        }
        finally {
            if (newBltNode != null) {
                this.stopGrid(newBltNode.configuration().getIgniteInstanceName());
            }
            this.grid(0).cluster().setBaselineTopology(topVer.topologyVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWalDisabledOnConsistentCut(SnapshotOperationStage stage, boolean shouldFail) throws Exception {
        IgniteEx nonCrd = this.grid(1);
        try {
            AtomicReference err = new AtomicReference();
            final AtomicReference cutOpId = new AtomicReference();
            nonCrd.context().discovery().setCustomEventListener(StartSnapshotOperationAckDiscoveryMessage.class, (CustomEventListener)new CustomEventListener<StartSnapshotOperationAckDiscoveryMessage>(){

                public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartSnapshotOperationAckDiscoveryMessage msg) {
                    if (msg.snapshotOperation().type() == SnapshotOperationType.CONSISTENT_CUT) {
                        cutOpId.compareAndSet(null, msg.operationId());
                    }
                }
            });
            TestRecordingCommunicationSpi spi = TestRecordingCommunicationSpi.spi((Ignite)nonCrd);
            spi.blockMessages((IgniteBiPredicate & Serializable)(node, msg) -> {
                SnapshotOperationStageFinishedMessage stageFinishedMsg;
                if (msg instanceof SnapshotOperationStageFinishedMessage && (stageFinishedMsg = (SnapshotOperationStageFinishedMessage)msg).stage() == stage) {
                    GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)nonCrd.context().cache().context().snapshot();
                    SnapshotOperationFuture snapFut = (SnapshotOperationFuture)((IgniteFutureImpl)snapMgr.getOngoingOperationFuture()).internalFuture();
                    IgniteUuid cutId = (IgniteUuid)cutOpId.get();
                    return snapFut.type() == SnapshotOperationType.CREATE && cutId != null && !snapFut.id().equals((Object)cutId);
                }
                return false;
            });
            SnapshotFuture fut = gg.snapshot().createFullSnapshot(null, "test-exchangeless-snapshot");
            spi.waitForBlocked();
            nonCrd.cluster().disableWal("cache1");
            spi.stopBlock();
            try {
                fut.get(60L, TimeUnit.SECONDS);
                IgniteDbSnapshotWalStateChangeTest.assertFalse((String)"Snapshot should fail.", (boolean)shouldFail);
            }
            catch (IgniteFutureCancelledException | IgniteFutureTimeoutException e) {
                IgniteDbSnapshotWalStateChangeTest.fail((String)("Snapshot was cancelled or was not created [err=" + e + ']'));
            }
            catch (IgniteException e) {
                IgniteDbSnapshotWalStateChangeTest.assertTrue((String)("Snapshot should not fail [err=" + (Object)((Object)e) + ']'), (boolean)shouldFail);
            }
            IgniteDbSnapshotWalStateChangeTest.assertNull((String)("Unexpected exception [err = " + err.get() + ']'), err.get());
        }
        finally {
            nonCrd.cluster().enableWal("cache1");
        }
    }
}

