/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.IgniteDbSnapshotSameTopologyTest;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotTestFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class IgniteDbSnapshotSameTopologyTestWithBaseline
extends IgniteDbSnapshotSameTopologyTest {
    protected static final int NON_BASELINE_NODE_IDX = 3;
    protected static final long DEFAULT_WAIT_TIMEOUT = 10L;

    @Override
    protected void beforeTestsStarted() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
        this.setProperties();
        dummyNode = this.startGrid("dummy");
        ignite = this.startGrid(0);
        ignite.cluster().baselineAutoAdjustEnabled(false);
        ignite2 = this.startGrid(1);
        this.startGrid(2);
        ignite.cluster().active(true);
        ignite.cluster().setBaselineTopology(ignite.cluster().topologyVersion());
        this.stopGrid(2);
        this.startGrid(3);
        gg = (GridGain)ignite.plugin("GridGain");
        this.startGrid("client");
    }

    @Override
    protected int getBackupCount() {
        return 1;
    }

    @Test
    public void testSnapshotOperationOnNonBaselineNodesSimple() throws Exception {
        IgniteEx crd = this.getSnapshotCrdNode();
        IgniteEx nonBltNode = this.grid(3);
        DiscoCache disco = crd.context().discovery().discoCache();
        int requiredAcks = disco.aliveServerNodes().size();
        CountDownLatch latch = this.addWaitingLocalStageFinishListener(SnapshotOperationStage.FIRST, crd, requiredAcks - 2, true);
        SnapshotFuture fut = this.getSnapshotManager(crd).startGlobalTestSnapshotOperation((Map)ImmutableMap.of((Object)"DELEGATE_FACTORY", (Object)NonBltFactory.class.getName()), null);
        fut.initFuture().get();
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertTrue((String)"Filed to wait for required acks.", (boolean)latch.await(10L, TimeUnit.SECONDS));
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertFalse((boolean)GridTestUtils.waitForCondition(() -> {
            try {
                SnapshotStatus crdStatus = this.getSnapshotManager(crd).getOngoingOperation();
                return crdStatus == null || crdStatus.getStageNum() != SnapshotOperationStage.FIRST.ordinal();
            }
            catch (IgniteCheckedException e) {
                log.error("Failed to get ongoing snapshot operation status on the coordinator node", (Throwable)e);
                return true;
            }
        }, (long)5000L));
        SnapshotStatus nonBltStatus = this.getSnapshotManager(nonBltNode).getOngoingOperation();
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertNotNull((Object)nonBltStatus);
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertEquals((String)"The status of snapshot operation must be in the FIRST stage", (int)nonBltStatus.getStageNum(), (int)SnapshotOperationStage.FIRST.ordinal());
        latch = this.addWaitingLocalStageFinishListener(SnapshotOperationStage.FIRST, crd, 1, true);
        SnapshotTestFuture testFut = (SnapshotTestFuture)((IgniteFutureImpl)this.getSnapshotManager(nonBltNode).getOngoingOperationFuture()).internalFuture();
        CountDownLatch initLatch = ((NonBltFactory.DelayedInitSnapshotFuture)testFut.delegate()).initLatch();
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertEquals((long)1L, (long)initLatch.getCount());
        initLatch.countDown();
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertTrue((String)"Failed to wait for the last ack message.", (boolean)latch.await(10L, TimeUnit.SECONDS));
        fut.get();
    }

    private GridCacheSnapshotManager getSnapshotManager(IgniteEx ig) {
        IgniteCacheSnapshotManager snapshot = ig.context().cache().context().snapshot();
        IgniteDbSnapshotSameTopologyTestWithBaseline.assertTrue((boolean)(snapshot instanceof GridCacheSnapshotManager));
        return (GridCacheSnapshotManager)snapshot;
    }

    protected CountDownLatch addWaitingLocalStageFinishListener(final SnapshotOperationStage stage, final IgniteEx ig, int msgCntr, final boolean ignoreClients) {
        final CountDownLatch latch = new CountDownLatch(msgCntr);
        ig.context().io().addMessageListener(GridTopic.TOPIC_SNAPSHOT, new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                SnapshotOperationStageFinishedMessage stageFinishedMsg;
                if (msg instanceof SnapshotOperationStageFinishedMessage && (stageFinishedMsg = (SnapshotOperationStageFinishedMessage)msg).stage() == stage) {
                    boolean ignore = ignoreClients && ig.cluster().node(nodeId).isClient();
                    log.info("!!! Stage: " + stageFinishedMsg.stage() + " from node: " + nodeId + ", shouldBeIgnored: " + ignore);
                    if (!ignore) {
                        latch.countDown();
                    }
                    if (latch.getCount() == 0L) {
                        ig.context().io().removeMessageListener(GridTopic.TOPIC_SNAPSHOT, (GridMessageListener)this);
                    }
                }
            }
        });
        return latch;
    }

    public static class NonBltFactory
    implements SnapshotTestFuture.DelegateFactory {
        public SnapshotOperationFuture<Object> createDelegate(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
            boolean baselineNode;
            boolean bl = baselineNode = !SnapshotUtils.nodeIsNotInBaseline((ClusterNode)cctx.localNode(), (GridCacheSharedContext)cctx, null);
            if (cctx.localNode().isClient() || baselineNode) {
                return null;
            }
            return new DelayedInitSnapshotFuture(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        }

        public static class DelayedInitSnapshotFuture
        extends SnapshotTestFuture {
            private final CountDownLatch initLatch = new CountDownLatch(1);

            DelayedInitSnapshotFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
                super(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
            }

            public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
                try {
                    this.initLatch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new AssertionError("initLatch was interrupted", e);
                }
                super.init(snapshotInfo);
            }

            @Nullable
            protected SnapshotOperationFuture<Object> createDelegate(SnapshotOperationInfoImpl snapshotInfo) {
                return null;
            }

            public CountDownLatch initLatch() {
                return this.initLatch;
            }
        }
    }
}

