/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Test;

public class IgniteDbSnapshotRestartWithFailingRestoreTest
extends GridCommonAbstractTest {
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY)).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())});
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
        this.deleteWorkFiles();
    }

    @Test
    public void test() throws Exception {
        IgniteEx ignite = this.startCluster();
        GridGain gg = (GridGain)ignite.plugin("GridGain");
        IgniteCache cache = ignite.getOrCreateCache("default");
        int entriesCnt = 1024;
        for (int i = 0; i < entriesCnt; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SnapshotFuture createFut = gg.snapshot().createFullSnapshot(null, "create_full_snap");
        createFut.get(1L, TimeUnit.MINUTES);
        for (int i = 0; i < entriesCnt; ++i) {
            cache.put((Object)i, (Object)(i + 1));
        }
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ignite.context().cache().context().snapshot();
        GridFutureAdapter cancelOnSecondStageRestoreSnapshotFut = new GridFutureAdapter();
        snapMgr.registerLocalStageCompletedListener((IgniteBiInClosure & Serializable)(snapOpFut, snapOpStage) -> {
            if (snapOpFut.type() == SnapshotOperationType.RESTORE && snapOpStage == SnapshotOperationStage.SECOND) {
                snapOpFut.cancelAsync(true).listen((IgniteInClosure & Serializable)fut -> {
                    try {
                        fut.get(1L);
                        cancelOnSecondStageRestoreSnapshotFut.onDone((Object)null);
                    }
                    catch (IgniteCheckedException e) {
                        cancelOnSecondStageRestoreSnapshotFut.onDone((Throwable)e);
                    }
                });
            }
        });
        SnapshotFuture restoreFut = gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(createFut.snapshotOperation().snapshotId()).message("restore_full_snap"));
        cancelOnSecondStageRestoreSnapshotFut.get(1L, TimeUnit.MINUTES);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> (Void)restoreFut.get(1L), IgniteException.class, (String)"Snapshot operation has been cancelled");
        this.stopAllGrids();
        ignite = this.startCluster();
        cache = ignite.getOrCreateCache("default");
        for (int i = 0; i < entriesCnt; ++i) {
            IgniteDbSnapshotRestartWithFailingRestoreTest.assertEquals((int)(i + 1), (int)((Integer)cache.get((Object)i)));
        }
    }

    private IgniteEx startCluster() throws Exception {
        IgniteEx ignite = this.startGrids(2);
        ignite.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        return ignite;
    }

    private void deleteWorkFiles() throws Exception {
        this.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"snapshot", (boolean)false));
    }
}

