/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotPathOperationsHelper {
    public static <T extends SnapshotPath> T buildPartitonPath(T wrapper, int grpId, int partId) throws IgniteCheckedException {
        SnapshotPath cacheDir = wrapper.resolve(String.valueOf(grpId));
        SnapshotPathOperationsHelper.ensureDirectory(cacheDir, "snapshot directory for cache group '" + grpId + "'", null);
        if (partId == 65535) {
            return (T)cacheDir.resolve("index.bin");
        }
        if (partId <= 65500) {
            return (T)cacheDir.resolve("part-" + partId + ".bin");
        }
        throw new IgniteCheckedException("Invalid partition value: " + partId);
    }

    public static void ensureDirectory(@NotNull SnapshotPath snapshotPath, @NotNull String msg, @Nullable IgniteLogger log) throws IgniteCheckedException {
        if (!snapshotPath.exists()) {
            if (!snapshotPath.createDirectories() && !snapshotPath.exists()) {
                throw new IgniteCheckedException("Failed to create " + msg + ": " + snapshotPath.getAbsolutePath());
            }
        } else if (!snapshotPath.isDirectory()) {
            throw new IgniteCheckedException("Failed to initialize " + msg + " (a file with the same name already exists): " + snapshotPath.getAbsolutePath());
        }
        if (log != null && log.isInfoEnabled()) {
            log.info("Resolved " + msg + ": " + snapshotPath.getAbsolutePath());
        }
    }
}

