/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;

@Deprecated
public class ZipCompressionTask
implements Runnable {
    private static final int COPY_BUFFER_SIZE = IgniteSystemProperties.getInteger((String)"GG_SNAPSHOT_COPY_LARGE_BUFFER_SIZE", (int)8192);
    private final FsSnapshotPath file;
    private final IgniteLogger logger;
    private final int compressionLevel;
    private final SnapshotOperationContext snapshotOperationContext;
    private final SnapshotMetricsMXBeanImpl snapshotMetricsMXBean;

    public ZipCompressionTask(FsSnapshotPath file, int compressionLevel, SnapshotOperationContext snapshotOperationContext, SnapshotMetricsMXBeanImpl snapshotMetricsMXBean, IgniteLogger logger) {
        if (!file.isFile()) {
            throw new IgniteException("Invalid file " + file + "passed for compression.");
        }
        this.file = file;
        this.compressionLevel = compressionLevel;
        this.snapshotOperationContext = snapshotOperationContext;
        this.snapshotMetricsMXBean = snapshotMetricsMXBean;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            long size;
            File compressedFile = new File(this.file.getAbsolutePath() + ".zip");
            File tmpFile = new File(compressedFile.getAbsolutePath() + ".tmp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating ZipOutputStream for " + tmpFile + ", compressionLevel=" + this.compressionLevel);
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile), COPY_BUFFER_SIZE));
                 InputStream fileInputStream = this.file.inputStream();){
                zipOutputStream.setLevel(this.compressionLevel);
                zipOutputStream.putNextEntry(new ZipEntry(this.file.getName()));
                size = SnapshotUtils.copyLarge(fileInputStream, zipOutputStream, COPY_BUFFER_SIZE, this.snapshotOperationContext);
            }
            this.snapshotMetricsMXBean.incrementTotalBytesWrittenOnStorage(tmpFile.length());
            SnapshotUtils.checkSnapshotCancellation(this.snapshotOperationContext);
            Files.move(tmpFile.toPath(), compressedFile.toPath(), new CopyOption[0]);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Archived " + this.file + " to " + compressedFile + ", bytes archived " + size);
            }
            SnapshotUtils.checkSnapshotCancellation(this.snapshotOperationContext);
            boolean result = this.file.delete();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Removed " + this.file + ", result=" + result);
            }
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
    }
}

