/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.gridgain.grid.internal.compression.CompressionTask;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOutputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.util.GridUtils;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.snapshot.file.SnapshotOutputStreamFactory;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathOperationsHelper;
import org.jetbrains.annotations.Nullable;

public class FileSnapshotSession
implements SnapshotSession {
    public static final String SAVE_REGISTRY_ERROR = "Error writing snapshot file registry.";
    private final ConcurrentMap<StreamKey, StreamHolder> streams = new ConcurrentHashMap<StreamKey, StreamHolder>();
    private final FsSnapshotPath snapshotDir;
    private final IgniteLogger log;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean notCheckLock;
    private final SnapshotOutputStreamFactory partitionsStreamFactory;
    private final SnapshotOutputStreamFactory metadataStreamFactory;
    private final CompressionOption compressionOption;
    private final int compressionLevel;
    private final SnapshotOperationContext snapshotOperationContext;
    private final SnapshotMetricsMXBeanImpl snapshotMetricsMXBean;
    private final SnapshotEncryptionOptions encryptionOptions;
    private final Predicate<Integer> postponedCompression;

    FileSnapshotSession(FsSnapshotPath snapshotDir, IgniteLogger log, boolean notCheckLock, CompressionOption compressionOption, int compressionLevel, @Nullable SnapshotMetricsMXBeanImpl snapshotMetricsMXBean, FutureTaskQueue<GroupPartitionId> partitionsFutureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions, EncryptionSpi encryptionSpi, int pageSize) {
        this.snapshotDir = snapshotDir;
        this.log = log;
        this.notCheckLock = notCheckLock;
        this.compressionOption = compressionOption;
        this.compressionLevel = compressionLevel;
        this.snapshotMetricsMXBean = snapshotMetricsMXBean;
        this.encryptionOptions = encryptionOptions;
        this.postponedCompression = grpId -> {
            if (grpId == null) {
                return false;
            }
            if (!compressionOption.isCompressed()) {
                return false;
            }
            if (encryptionOptions == null || encryptionOptions.getGroupKey(grpId) == null) {
                return true;
            }
            return !encryptionOptions.optimizedCompressedEncryption();
        };
        this.partitionsStreamFactory = new SnapshotOutputStreamFactory(this.postponedCompression, compressionOption, compressionLevel, msgDigestFactory, snapshotMetricsMXBean, encryptionOptions, encryptionSpi, pageSize);
        this.metadataStreamFactory = new SnapshotOutputStreamFactory(grpId -> false, compressionOption, compressionLevel, null, snapshotMetricsMXBean, null, encryptionSpi, pageSize);
        this.snapshotOperationContext = snapshotOperationContext;
    }

    public SnapshotEncryptionOptions snapshotEncryptionOptions() {
        return this.encryptionOptions;
    }

    FsSnapshotPath snapshotDirectory() {
        return this.snapshotDir;
    }

    public SnapshotOutputStream getOrOpenForFile(int grpId, int partId) throws IgniteCheckedException {
        StreamHolder holder = this.streams.computeIfAbsent(new StreamKey(grpId, partId), key -> {
            try {
                FsSnapshotPath file = SnapshotPathOperationsHelper.buildPartitonPath(this.snapshotDir, grpId, partId);
                SnapshotOutputStream stream = this.partitionsStreamFactory.makeOutputStream(file, grpId);
                return new StreamHolder(stream);
            }
            catch (IOException e) {
                return new StreamHolder(new IgniteCheckedException("Failed to initialize snapshot stream (snapshot will be cancelled) [snapshotDir=" + this.snapshotDir.getAbsolutePath() + ", grpId=" + grpId + ", partId=" + partId + ']', (Throwable)e));
            }
            catch (IgniteCheckedException e) {
                return new StreamHolder(e);
            }
        });
        return holder.stream();
    }

    public void writeMetadata(ByteBuffer metadata) throws IgniteCheckedException {
        FsSnapshotPath snapshotMetaPath = this.snapshotDir.resolve("snapshot-meta.bin");
        try (SnapshotOutputStream stream = this.metadataStreamFactory.makeOutputStream(snapshotMetaPath);){
            stream.write(metadata);
        }
        catch (IOException e) {
            if (GridUtils.isDiskFullException((IOException)e)) {
                throw new IgniteCheckedException("Storage device is full, error writing snapshot metadata.", (Throwable)e);
            }
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public void writeRegistry(ByteBuffer registry) throws IgniteCheckedException {
        FsSnapshotPath snapshotRegPath = this.snapshotDir.resolve("snapshot-registry.bin");
        try (SnapshotOutputStream stream = this.metadataStreamFactory.makeOutputStream(snapshotRegPath);){
            stream.write(registry);
        }
        catch (IOException e) {
            if (GridUtils.isDiskFullException((IOException)e)) {
                throw new IgniteCheckedException("Storage device is full, Error writing snapshot file registry.", (Throwable)e);
            }
            throw new IgniteCheckedException(SAVE_REGISTRY_ERROR, (Throwable)e);
        }
    }

    public void cancel() throws IgniteException {
        if (!this.cancelled.compareAndSet(false, true)) {
            return;
        }
        FsSnapshotPath file = this.snapshotDir.resolve("cancelled");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void close() throws IgniteException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        for (Map.Entry entry : this.streams.entrySet()) {
            try {
                SnapshotOutputStream stream = ((StreamHolder)entry.getValue()).stream();
                try {
                    stream.close();
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to close file snapshot stream: " + stream), (Throwable)e);
                }
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to obtain stream for key: " + entry.getKey()), (Throwable)e);
            }
        }
        if (this.notCheckLock) {
            return;
        }
        FsSnapshotPath lockFile = this.snapshotDir.resolve("lock");
        if (!lockFile.exists()) {
            throw new IllegalStateException("Lock file doesn't exist: " + lockFile);
        }
        lockFile.delete();
    }

    public Runnable onPartitionFinished(GroupPartitionId groupPartitionId) throws IgniteCheckedException {
        StreamHolder streamHolder = (StreamHolder)this.streams.get(new StreamKey(groupPartitionId.getGroupId(), groupPartitionId.getPartitionId()));
        if (streamHolder != null) {
            streamHolder.stream().close();
            if (this.postponedCompression.test(groupPartitionId.getGroupId())) {
                FsSnapshotPath partitionFile = SnapshotPathOperationsHelper.buildPartitonPath(this.snapshotDir, groupPartitionId.getGroupId(), groupPartitionId.getPartitionId());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Compression task will be scheduled for " + partitionFile);
                }
                return new CompressionTask(partitionFile, this.compressionOption, this.compressionLevel, this.snapshotOperationContext, this.snapshotMetricsMXBean, this.log);
            }
        }
        return null;
    }

    private static class StreamHolder {
        private final SnapshotOutputStream stream;
        private final IgniteCheckedException err;

        public StreamHolder(SnapshotOutputStream stream) {
            this.stream = stream;
            this.err = null;
        }

        public StreamHolder(IgniteCheckedException err) {
            this.stream = null;
            this.err = err;
        }

        private SnapshotOutputStream stream() throws IgniteCheckedException {
            if (this.err != null) {
                throw this.err;
            }
            return this.stream;
        }
    }

    private static class StreamKey {
        private int cacheId;
        private int partId;

        private StreamKey(int cacheId, int partId) {
            this.cacheId = cacheId;
            this.partId = partId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamKey)) {
                return false;
            }
            StreamKey fileKey = (StreamKey)o;
            return this.cacheId == fileKey.cacheId && this.partId == fileKey.partId;
        }

        public int hashCode() {
            int result = this.cacheId;
            result = 31 * result + this.partId;
            return result;
        }
    }
}

