/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.typedef.CX2;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.copy.CopyStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.CachedSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotMetricsMXBean;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotRegistryTransformer;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.snapshot.file.CopyFileVisitor;
import org.gridgain.grid.persistentstore.snapshot.file.DeleteFileVisitor;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshotSession;
import org.gridgain.grid.persistentstore.snapshot.file.copy.TwoPhaseFilesCopyStrategy;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathOperationsHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDatabaseSnapshotSpi
implements DatabaseSnapshotSpi {
    private static final String NULL_CACHE_NAME = UUID.randomUUID().toString();
    public static final String SNAPSHOT_DIR_SUFFIX = ".snapshot";
    public static final String SNAPSHOT_WAL_DIR = "wal";
    public static final String LOCK_FILENAME = "lock";
    public static final String CANCELLED_FILENAME = "cancelled";
    public static final String COPY_MARKER_FILENAME = ".copy";
    private static final DateTimeFormatter DIRECTORY_PREFIX_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.systemDefault());
    private static final String SNAPSHOT_TIME_PREFIX = "ts_";
    private static final Pattern SNAPSHOT_ID_EXTRACT_PTRN = Pattern.compile(".*ts_.*_(\\d+).snapshot");
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;
    private String snapshotDir = "snapshot";
    @Nullable
    private File snapshotWorkDir;
    private String folderName;
    private SnapshotMetricsMXBeanImpl snapshotMetrics;
    private GridCacheSharedContext cctx;

    public File snapshotWorkingDirectory() {
        return this.snapshotWorkDir;
    }

    public void setSnapshotDirectory(String snapshotDir) {
        this.snapshotDir = snapshotDir;
    }

    public void setSnapshotMetrics(SnapshotMetricsMXBean snapshotMetrics) {
        if (snapshotMetrics instanceof SnapshotMetricsMXBeanImpl) {
            this.snapshotMetrics = (SnapshotMetricsMXBeanImpl)snapshotMetrics;
        }
    }

    public void start() throws IgniteCheckedException {
        File workDir0 = new File(this.snapshotDir);
        this.snapshotWorkDir = workDir0.isAbsolute() ? workDir0 : U.resolveWorkDirectory((String)this.ignite.configuration().getWorkDirectory(), (String)this.snapshotDir, (boolean)false);
        GridKernalContext ctx = ((IgniteEx)this.ignite).context();
        this.folderName = U.maskForFileName((CharSequence)ctx.pdsFolderResolver().resolveFolders().consistentId().toString());
        this.cctx = ctx.cache().context();
    }

    public void stop() throws IgniteCheckedException {
    }

    public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, @Nullable File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futureTaskQueue, SnapshotOperationContext snapshotOperationContext, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
        File snapshotDir;
        File file = snapshotDir = storePath == null ? this.snapshotWorkDir : storePath;
        assert (snapshotDir != null);
        FsSnapshotPath path = new FsSnapshotPath(snapshotDir);
        SnapshotOperationInfo info = snapshotOperationContext.snapshotOperationInfo();
        String label = "";
        if (info instanceof SnapshotOperationInfoImpl) {
            GridSnapshotOperationEx ex = ((SnapshotOperationInfoImpl)info).snapshotOperation();
            label = GridSnapshotOperationAttrs.getSnapshotLabel((GridSnapshotOperationEx)ex);
        }
        FsSnapshotPath snapshot = this.generateCurNodeSnapshotFolderPathWithLabel(path, id, label);
        SnapshotPathOperationsHelper.ensureDirectory((SnapshotPath)snapshot, "snapshot directory", this.log);
        this.createLockFile((SnapshotPath)snapshot);
        return new FileSnapshotSession(snapshot, this.log, false, compression, compressionLevel, this.snapshotMetrics, futureTaskQueue, snapshotOperationContext, msgDigestFactory, encryptionOptions, this.ignite.configuration().getEncryptionSpi(), this.ignite.configuration().getDataStorageConfiguration().getPageSize());
    }

    private void createLockFile(SnapshotPath snapshot) throws IgniteCheckedException {
        SnapshotPath lockFile = snapshot.resolve(LOCK_FILENAME);
        if (lockFile.exists()) {
            throw new IgniteCheckedException("Lockfile already exists: " + lockFile.getAbsolutePath());
        }
        try {
            lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Could not create lock file: " + lockFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public Iterable<SnapshotMetadataV2> localSnapshots(boolean sort) throws IgniteCheckedException {
        assert (this.folderName != null);
        if (this.snapshotWorkDir == null || !this.snapshotWorkDir.exists()) {
            return Collections.emptySet();
        }
        return new SnapshotMetaContainer((SnapshotPath)new FsSnapshotPath(this.snapshotWorkDir), true, sort);
    }

    public Iterable<SnapshotMetadataV2> listRemoteSnapshots(@Nullable SnapshotPath searchPath) throws IgniteCheckedException {
        if (searchPath == null) {
            return Collections.emptySet();
        }
        return new SnapshotMetaContainer(searchPath, false, false);
    }

    public Map<Long, Long> remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath) {
        return this.remoteSnapshotWalSizes0(searchPath, -1L);
    }

    public long remoteSnapshotWalSizes(@Nullable SnapshotPath searchPath, long snapshotId) {
        if (snapshotId < 0L) {
            return 0L;
        }
        return this.remoteSnapshotWalSizes0(searchPath, snapshotId).getOrDefault(snapshotId, 0L);
    }

    private Map<Long, Long> remoteSnapshotWalSizes0(@Nullable SnapshotPath searchPath, long snapshotId) {
        Collection snapshotPaths;
        if (searchPath == null) {
            return Collections.emptyMap();
        }
        assert (searchPath.exists() && searchPath.isDirectory()) : "Directory does not exist: " + searchPath;
        Collection collection = snapshotPaths = snapshotId == -1L ? searchPath.getEntries() : (Collection)searchPath.getEntries().stream().filter(p -> FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName(p.getName()) == snapshotId).findAny().map(Collections::singleton).orElseGet(Collections::emptySet);
        if (snapshotPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> walSizes = new HashMap<Long, Long>();
        for (SnapshotPath snapshotPath : snapshotPaths) {
            if (!snapshotPath.isDirectory() || !snapshotPath.getName().endsWith(SNAPSHOT_DIR_SUFFIX)) continue;
            for (SnapshotPath cidPath : snapshotPath.getEntries()) {
                SnapshotPath walPath;
                if (!cidPath.isDirectory() || !(walPath = cidPath.resolve(SNAPSHOT_WAL_DIR)).exists() || !walPath.isDirectory()) continue;
                long walSize = walPath.getEntries().stream().filter(p -> p.isFile() && FileWriteAheadLogManager.isSegmentFileName((String)p.getName())).mapToLong(SnapshotPath::length).sum();
                walSizes.merge(FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName(snapshotPath.getName()), walSize, Long::sum);
            }
        }
        return walSizes;
    }

    @Nullable
    public SnapshotMetadataV2 nextLocalSnapshot(long id) {
        assert (this.folderName != null);
        if (this.snapshotWorkDir == null || !this.snapshotWorkDir.exists()) {
            return null;
        }
        TreeMap snapshotPaths = new FsSnapshotPath(this.snapshotWorkDir).getEntries().stream().filter(p -> p.exists() && p.isDirectory() && !p.isEmptyDirectory()).collect(Collectors.toMap(p -> FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName(p.getName()), Function.identity(), (p1, p2) -> p2, TreeMap::new));
        Map.Entry higher = snapshotPaths.higherEntry(id);
        if (higher == null) {
            return null;
        }
        T2<Long, SnapshotMetadataV2> readMeata = this.tryReadMetadata((SnapshotPath)higher.getValue(), this.consistentIdFolderPath((SnapshotPath)higher.getValue()), null, false, true);
        return readMeata != null ? (SnapshotMetadataV2)readMeata.get2() : null;
    }

    @Nullable
    private T2<Long, SnapshotMetadataV2> tryReadMetadata(SnapshotPath snapshotFolder, SnapshotPath nodeSnapshotFolder, @Nullable CX2<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, boolean defaultPath) {
        long id;
        String folderName = snapshotFolder.getName();
        folderName = folderName.substring(folderName.lastIndexOf(95) + 1);
        try {
            id = Long.parseLong(folderName.replace(SNAPSHOT_DIR_SUFFIX, ""));
        }
        catch (NumberFormatException ex) {
            throw new IgniteException("Wrong snapshot id in folder name: " + snapshotFolder);
        }
        SnapshotConfiguration snapshotCfg = this.getSnapshotConfiguration();
        FileSnapshot snapshot = this.createFileSnapshot(this.ignite.configuration(), this, id, snapshotFolder, null, (IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>)c, ignoreMissedClasses, defaultPath, SnapshotSecurityLevel.DISABLED, snapshotCfg.getMessageDigestFactory(), snapshotCfg.getRegistryTransformer(), this.cctx);
        if (nodeSnapshotFolder == null) {
            SnapshotMetadataV2 metadata = snapshot.metadata(snapshotFolder);
            return metadata == null ? null : new T2((Object)id, (Object)metadata);
        }
        SnapshotPath lockFile = nodeSnapshotFolder.resolve(LOCK_FILENAME);
        if (lockFile.exists()) {
            return null;
        }
        SnapshotPath cancelledFile = nodeSnapshotFolder.resolve(CANCELLED_FILENAME);
        if (cancelledFile.exists()) {
            return null;
        }
        SnapshotMetadataV2 metadata = snapshot.metadata(nodeSnapshotFolder);
        if (metadata == null) {
            U.error((IgniteLogger)this.log, (Object)("Can't read snapshot metadata for snapshot with id: " + id));
            return null;
        }
        return new T2((Object)id, (Object)metadata);
    }

    @Nullable
    private FileSnapshot tryReadSnapshot(SnapshotPath snapshotFolder, SnapshotPath nodeSnapshotFolder, @Nullable Collection<SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, boolean defaultPath, SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
        FileSnapshot fileSnapshot;
        long id;
        SnapshotPath lockFile = nodeSnapshotFolder.resolve(LOCK_FILENAME);
        if (lockFile.exists()) {
            LT.warn((IgniteLogger)this.log, (String)("Can't read snapshot, snapshot creation hasn't finished normally. Lock file found: " + lockFile.getAbsolutePath()));
            return null;
        }
        SnapshotPath cancelledFile = nodeSnapshotFolder.resolve(CANCELLED_FILENAME);
        if (cancelledFile.exists()) {
            U.warn((IgniteLogger)this.log, (Object)("Can't read snapshot, snapshot was cancelled. Cancel mark file found: " + cancelledFile.getAbsolutePath()));
            return null;
        }
        String folderName = snapshotFolder.getName();
        folderName = folderName.substring(folderName.lastIndexOf(95) + 1);
        try {
            id = Long.parseLong(folderName.replace(SNAPSHOT_DIR_SUFFIX, ""));
        }
        catch (NumberFormatException ex) {
            throw new IgniteException("Wrong snapshot id in folder name: " + snapshotFolder);
        }
        try {
            SnapshotConfiguration snapshotCfg = this.getSnapshotConfiguration();
            fileSnapshot = this.createFileSnapshot(this.ignite.configuration(), this, id, snapshotFolder, optSearchPaths, c, ignoreMissedClasses, defaultPath, securityLevel, snapshotCfg.getMessageDigestFactory(), snapshotCfg.getRegistryTransformer(), this.cctx);
            SnapshotMetadataV2 metadata = fileSnapshot.metadata(needDecryptKeys);
            if (metadata == null) {
                U.warn((IgniteLogger)this.log, (Object)("Snapshot metadata not found for snapshot " + id));
                return null;
            }
        }
        catch (IgniteSpiException e) {
            throw e;
        }
        catch (IgniteException e) {
            U.error((IgniteLogger)this.log, (Object)("Snapshot metadata can't be merged for snapshot with id: " + id), (Throwable)e);
            return null;
        }
        return fileSnapshot;
    }

    protected FileSnapshot createFileSnapshot(IgniteConfiguration igCfg, FileDatabaseSnapshotSpi snapshotSpi, long id, SnapshotPath snapshotDir, Collection<SnapshotPath> optSearchPath, IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, boolean remote, SnapshotSecurityLevel securityLevel, MessageDigestFactory msgDigestFactory, SnapshotRegistryTransformer registryTransformer, GridCacheSharedContext cctx) {
        return new FileSnapshot(igCfg, snapshotSpi, id, snapshotDir, optSearchPath, c, ignoreMissedClasses, remote, securityLevel, msgDigestFactory, registryTransformer, cctx);
    }

    @Nullable
    public FileSnapshot snapshot(long id, @Nullable Collection<SnapshotPath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, boolean ignoreMissedClasses, @Nullable SnapshotSecurityLevel securityLevel, boolean needDecryptKeys) {
        FileSnapshot fileSnapshot;
        FsSnapshotPath found;
        if (id == 0L) {
            return null;
        }
        if (optSearchPaths != null) {
            optSearchPaths = optSearchPaths.stream().map(CachedSnapshotPath::cachedPath).collect(Collectors.toList());
            for (SnapshotPath extSearchDir : optSearchPaths) {
                FileSnapshot fileSnapshot2;
                SnapshotPath found2 = this.findSnapshotDir(extSearchDir, id);
                if (found2 == null || !found2.isDirectory() || found2.isEmptyDirectory() || (fileSnapshot2 = this.tryReadSnapshot(found2, this.consistentIdFolderPath(found2), optSearchPaths, c, ignoreMissedClasses, false, securityLevel, needDecryptKeys)) == null) continue;
                return fileSnapshot2;
            }
        }
        if ((found = this.findSnapshotDir(new FsSnapshotPath(this.snapshotWorkDir), id)) != null && found.isDirectory() && !found.isEmptyDirectory() && (fileSnapshot = this.tryReadSnapshot((SnapshotPath)found, (SnapshotPath)this.consistentIdFolderPath(found), optSearchPaths, c, ignoreMissedClasses, true, securityLevel, needDecryptKeys)) != null) {
            return fileSnapshot;
        }
        return null;
    }

    public void deleteSnapshot(long id, SnapshotOperationContext ctx) throws IgniteCheckedException {
        FsSnapshotPath found = this.findLocalSnapshotDir(id);
        if (found == null) {
            return;
        }
        this.deleteSnapshotAt(this.consistentIdFolderPath(found), ctx);
    }

    private void deleteSnapshotAt(FsSnapshotPath consistentIdFolder, SnapshotOperationContext ctx) throws IgniteCheckedException {
        this.createLockFile((SnapshotPath)consistentIdFolder);
        try {
            FsSnapshotPath resolve = consistentIdFolder.resolveRegularOrCompressed("snapshot-meta.bin");
            if (resolve == null) {
                throw new IgniteCheckedException("Unable to find file snapshot-meta.bin in path " + this.snapshotDir);
            }
            resolve.delete();
            if (consistentIdFolder.exists()) {
                Files.walkFileTree(consistentIdFolder.getFile().toPath(), new DeleteFileVisitor(ctx, this.log));
            } else if (this.log.isInfoEnabled()) {
                this.log.info("[" + consistentIdFolder + "] doesn't exist, skip delete");
            }
        }
        catch (IOException ex) {
            throw new IgniteCheckedException("Failed to delete snapshot [" + consistentIdFolder + "]", (Throwable)ex);
        }
        finally {
            FsSnapshotPath toSync;
            block23: {
                toSync = consistentIdFolder;
                boolean exists = consistentIdFolder.exists();
                if (!exists || consistentIdFolder.isEmptyDirectory()) {
                    try {
                        if (exists) {
                            consistentIdFolder.deleteIfEmpty();
                        }
                        FsSnapshotPath parentFile = consistentIdFolder.getParent();
                        try {
                            if (parentFile.exists() && parentFile.isEmptyDirectory()) {
                                parentFile.deleteIfEmpty();
                                toSync = parentFile.getParent();
                            } else {
                                toSync = parentFile;
                            }
                        }
                        catch (IgniteException e) {
                            if (!parentFile.exists()) {
                                U.warn((IgniteLogger)this.log, (Object)("Concurrent file deletion " + parentFile));
                                toSync = parentFile.getParent();
                                break block23;
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        U.error((IgniteLogger)this.log, (Object)"Failure deleting empty folders", (Throwable)e);
                    }
                }
            }
            toSync.sync();
        }
    }

    public boolean isCopyRequired(long snapshotId, SnapshotPath targetDirectory) throws IgniteCheckedException {
        SnapshotPath snapshotFolderPath = this.generateSnapshotFolderPath(targetDirectory, snapshotId);
        SnapshotPath targetConsistentIdDir = this.generateCurNodeSnapshotFolderPath(targetDirectory, snapshotId);
        if (!targetConsistentIdDir.createDirectories() && !targetConsistentIdDir.exists()) {
            String msg = "Invalid destination path. Couldn't create directories before snapshot moving, path = [" + targetConsistentIdDir + "]";
            U.error((IgniteLogger)this.log, (Object)msg);
            throw new IgniteCheckedException(msg);
        }
        if (!targetConsistentIdDir.isDirectory()) {
            throw new IgniteCheckedException("Invalid destination path. Path [" + targetConsistentIdDir + "] is not directory! ");
        }
        boolean needCopy = false;
        SnapshotPath markerFile = targetConsistentIdDir.resolve(COPY_MARKER_FILENAME);
        if (markerFile.exists()) {
            needCopy = true;
            if (this.log.isInfoEnabled()) {
                this.log.info("Previous wasn't finished properly, copy marker exists, perform copy operation");
            }
        } else if (!this.isMetadataPresent(snapshotFolderPath) && !this.isMetadataPresent(targetConsistentIdDir)) {
            needCopy = true;
            if (this.log.isInfoEnabled()) {
                this.log.info("Metadata is missing in target directory, perform copy operation");
            }
        }
        return needCopy;
    }

    private boolean isMetadataPresent(SnapshotPath dir) {
        SnapshotMetadataV2 metadata = SnapshotUtils.readSnapshotMetadata(dir, true, this.ignite.configuration(), this.log, false, null);
        if (metadata != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Metadata exists in target directory, skipping copy operation");
            }
            return true;
        }
        return false;
    }

    public void copySnapshotEntirely(long snapshotId, SnapshotPath pathToCopy, SnapshotOperationContext ctx, ExecutorService taskExecutor) throws IgniteCheckedException {
        FsSnapshotPath consistentIdDir = this.findLocalCurNodeSnapshotDir(snapshotId);
        SnapshotPath destDir = this.findCurNodeSnapshotDir(pathToCopy, snapshotId);
        if (destDir == null) {
            destDir = this.generateCurNodeSnapshotFolderPath(pathToCopy, snapshotId);
        }
        FutureTaskQueue taskQueue = new FutureTaskQueue(taskExecutor, this.log);
        try {
            Files.walkFileTree(consistentIdDir.getFile().toPath(), new CopyFileVisitor(consistentIdDir.getFile().toPath(), destDir, ctx, this.createCopyStrategy(true), arg_0 -> ((FutureTaskQueue)taskQueue).submit(arg_0)));
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        taskQueue.awaitCompletion(ctx);
    }

    private CopyStrategy createCopyStrategy(boolean onlyIfNotExists) {
        return new TwoPhaseFilesCopyStrategy(onlyIfNotExists, this.log);
    }

    public void copySinglePartition(long snapshotId, int grpId, int partId, SnapshotPath pathToCopy, SnapshotOperationContext context) throws IgniteCheckedException {
        SnapshotPathOperationsHelper.ensureDirectory(pathToCopy, "directory before partition copying", null);
        FsSnapshotPath consistentIdDir = this.generateCurNodeSnapshotFolderPath(snapshotId);
        SnapshotPath destDir = this.findCurNodeSnapshotDir(pathToCopy, snapshotId);
        if (destDir == null) {
            destDir = this.generateCurNodeSnapshotFolderPath(pathToCopy, snapshotId);
        }
        try {
            FsSnapshotPath path = SnapshotPathOperationsHelper.buildPartitonPath(consistentIdDir, grpId, partId);
            FsSnapshotPath localPartFile = path.getParent().resolveRegularOrCompressed(path.getName());
            SnapshotPath remotePartFile = destDir.resolve(consistentIdDir.relativize(localPartFile));
            SnapshotPath grpFolder = remotePartFile.getParent();
            if (!grpFolder.exists()) {
                grpFolder.createDirectories();
            }
            if (!grpFolder.isDirectory()) {
                throw new IgniteCheckedException("Path is not directory!");
            }
            CopyStrategy copyStrategy = this.createCopyStrategy(false);
            if (context.isCancelled()) {
                throw new IgniteCheckedException("Snapshot operation has been cancelled");
            }
            copyStrategy.copy(localPartFile.getFile().toPath(), grpFolder);
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public void copyWalSegments(long snapshotId, Collection<File> segments, SnapshotPath dir, SnapshotOperationContext ctx) throws IgniteCheckedException {
        try {
            SnapshotPath root;
            SnapshotPath destDir = this.findCurNodeSnapshotDir(dir, snapshotId);
            if (destDir == null) {
                U.warn((IgniteLogger)this.log, (Object)("Couldn't find snapshot folder for snapshotId=" + snapshotId + ", at path=" + dir + " before copying WAL segments."));
                destDir = this.generateCurNodeSnapshotFolderPath(dir, snapshotId);
            }
            if (!(root = destDir.resolve(SNAPSHOT_WAL_DIR)).exists()) {
                root.createDirectories();
            }
            CopyStrategy copyStrategy = this.createCopyStrategy(false);
            for (File segment : segments) {
                if (ctx.isCancelled()) {
                    throw new IgniteCheckedException("Snapshot operation has been cancelled");
                }
                copyStrategy.copy(segment.toPath(), root);
            }
        }
        catch (IOException ex) {
            throw new IgniteCheckedException((Throwable)ex);
        }
    }

    public void copyMetadata(long snapshotId, SnapshotPath pathToMove, SnapshotOperationContext context) throws IgniteCheckedException {
        this.copyConsistentIdDirFile(snapshotId, pathToMove, "snapshot-meta.bin");
    }

    public void copyDigestRegistry(long snapshotId, SnapshotPath file, SnapshotOperationContext context) throws IgniteCheckedException {
        this.copyConsistentIdDirFile(snapshotId, file, "snapshot-registry.bin");
    }

    private void copyConsistentIdDirFile(long snapshotId, SnapshotPath firToMove, String baseFileName) throws IgniteCheckedException {
        try {
            FsSnapshotPath localSnapshotFolder = this.findLocalSnapshotDir(snapshotId);
            if (localSnapshotFolder == null) {
                return;
            }
            FsSnapshotPath consistentIdFolderPath = this.consistentIdFolderPath(localSnapshotFolder);
            FsSnapshotPath resolvedPFile = consistentIdFolderPath.resolveRegularOrCompressed(baseFileName);
            if (resolvedPFile == null || !resolvedPFile.exists()) {
                return;
            }
            SnapshotPath destPath = this.findCurNodeSnapshotDir(firToMove, snapshotId);
            if (destPath == null) {
                U.warn((IgniteLogger)this.log, (Object)("Couldn't find current node folder in path=" + firToMove + " before copying snapshot file '" + baseFileName + "', snapshotId=" + snapshotId));
                destPath = this.generateCurNodeSnapshotFolderPath(firToMove, snapshotId);
            }
            CopyStrategy copyStrategy = this.createCopyStrategy(false);
            copyStrategy.copy(resolvedPFile.getFile().toPath(), destPath);
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to copy snapshot to the destination folder: " + e.getMessage(), (Throwable)e);
        }
    }

    public void startCopy(long snapshotId, SnapshotPath pathToCopy) throws IgniteCheckedException {
        try {
            this.findCurNodeSnapshotDir(pathToCopy, snapshotId).resolve(COPY_MARKER_FILENAME).createNewFile();
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Unable to create \".copy\" file  for " + snapshotId + " in path [" + pathToCopy + "]", (Throwable)e);
        }
    }

    public void finishCopy(long snapshotId, SnapshotPath pathToCopy) {
        this.findCurNodeSnapshotDir(pathToCopy, snapshotId).resolve(COPY_MARKER_FILENAME).delete();
    }

    private <T extends SnapshotPath> T consistentIdFolderPath(T snapshotBaseFolder) {
        return (T)snapshotBaseFolder.resolve(this.folderName);
    }

    public <T extends SnapshotPath> T generateSnapshotFolderPath(T snapshotBaseFolder, long id) {
        return FileDatabaseSnapshotSpi.generateSnapshotFolderPath0(snapshotBaseFolder, id, null);
    }

    private static <T extends SnapshotPath> T generateSnapshotFolderPath0(T snapshotBaseFolder, long id, String label) {
        return (T)snapshotBaseFolder.resolve(FileDatabaseSnapshotSpi.generateSnapshotDirName(id, label));
    }

    @NotNull
    public FsSnapshotPath generateCurNodeSnapshotFolderPath(long id) {
        return (FsSnapshotPath)this.generateCurNodeSnapshotFolderPath((SnapshotPath)new FsSnapshotPath(this.snapshotWorkDir), id);
    }

    public <T extends SnapshotPath> T generateCurNodeSnapshotFolderPathWithLabel(T snapshotBaseFolder, long id, String label) {
        return this.consistentIdFolderPath(FileDatabaseSnapshotSpi.generateSnapshotFolderPath0(snapshotBaseFolder, id, label));
    }

    @Nullable
    public <T extends SnapshotPath> T findSnapshotDir(T snapshotBaseFolder, long id) {
        if (!snapshotBaseFolder.exists()) {
            return null;
        }
        T generated = this.generateSnapshotFolderPath(snapshotBaseFolder, id);
        if (!generated.exists()) {
            List found = snapshotBaseFolder.getEntries().stream().filter(file -> file.isDirectory() && file.getName().contains(SNAPSHOT_TIME_PREFIX) && file.getName().endsWith("_" + id + SNAPSHOT_DIR_SUFFIX)).collect(Collectors.toList());
            if (found.size() > 1) {
                U.warn((IgniteLogger)this.log, (Object)("Several path for the same snapshotId=" + id + ", first path would be chosen: " + found.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            if (found.isEmpty()) {
                return null;
            }
            return (T)((SnapshotPath)found.get(0));
        }
        return generated;
    }

    @Nullable
    public <T extends SnapshotPath> T findCurNodeSnapshotDir(T snapshotBaseFolder, long id) {
        T found = this.findSnapshotDir(snapshotBaseFolder, id);
        if (found == null) {
            return null;
        }
        return this.consistentIdFolderPath(found);
    }

    @Nullable
    public FsSnapshotPath findLocalCurNodeSnapshotDir(long id) {
        FsSnapshotPath found = this.findSnapshotDir(new FsSnapshotPath(this.snapshotWorkDir), id);
        if (found == null) {
            return null;
        }
        return this.consistentIdFolderPath(found);
    }

    @Nullable
    public FsSnapshotPath findLocalSnapshotDir(long id) throws IgniteCheckedException {
        return this.findSnapshotDir(new FsSnapshotPath(this.snapshotWorkDir), id);
    }

    private SnapshotConfiguration getSnapshotConfiguration() {
        return ((GridCacheSnapshotManager)((IgniteEx)this.ignite).context().cache().context().snapshot()).config();
    }

    public static String generateSnapshotDirName(long id, @Nullable String lb) {
        if (lb == null) {
            lb = "";
        } else if (!lb.isEmpty()) {
            lb = lb + "_";
        }
        return lb + SNAPSHOT_TIME_PREFIX + DIRECTORY_PREFIX_FORMAT.format(Instant.ofEpochMilli(id)) + '_' + id + SNAPSHOT_DIR_SUFFIX;
    }

    public static long extractIdFromSnapshotDirName(String dirName) {
        try {
            Matcher m = SNAPSHOT_ID_EXTRACT_PTRN.matcher(dirName);
            if (m.find()) {
                return Long.parseLong(m.group(1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1L;
    }

    static String maskNull(String cacheName) {
        return cacheName == null ? NULL_CACHE_NAME : cacheName;
    }

    static String unmaskNull(String cacheName) {
        return cacheName == NULL_CACHE_NAME ? null : cacheName;
    }

    class SnapshotMetaContainer
    implements Iterable<SnapshotMetadataV2> {
        private final Iterator<SnapshotPath> it;
        private final boolean dfltPath;
        private final boolean ignoreMissed;
        private SnapshotMetadataV2 next;

        SnapshotMetaContainer(SnapshotPath dir, boolean dfltPath, boolean sort) throws IgniteCheckedException {
            if (dir.exists() && dir.isDirectory()) {
                if (!sort) {
                    this.it = dir.getEntries().iterator();
                } else {
                    TreeMap<Long, SnapshotPath> paths = new TreeMap<Long, SnapshotPath>();
                    for (SnapshotPath e : dir.getEntries()) {
                        paths.put(FileDatabaseSnapshotSpi.extractIdFromSnapshotDirName(e.getName()), e);
                    }
                    this.it = paths.values().iterator();
                }
            } else {
                throw new IgniteCheckedException("Directory does not exist [dir=" + dir + "]");
            }
            this.dfltPath = dfltPath;
            this.ignoreMissed = !dfltPath;
        }

        @Override
        @NotNull
        public Iterator<SnapshotMetadataV2> iterator() {
            return new Iterator<SnapshotMetadataV2>(){
                {
                    this.advance();
                }

                private void advance() {
                    while (SnapshotMetaContainer.this.it.hasNext()) {
                        SnapshotPath snapshotDir = (SnapshotPath)SnapshotMetaContainer.this.it.next();
                        assert (snapshotDir != null);
                        if (!snapshotDir.isDirectory() || !snapshotDir.getName().endsWith(FileDatabaseSnapshotSpi.SNAPSHOT_DIR_SUFFIX)) continue;
                        T2 tup = FileDatabaseSnapshotSpi.this.tryReadMetadata(snapshotDir, SnapshotMetaContainer.this.dfltPath ? FileDatabaseSnapshotSpi.this.consistentIdFolderPath(snapshotDir) : null, (CX2<String, CacheConfiguration, CacheConfiguration>)null, SnapshotMetaContainer.this.ignoreMissed, SnapshotMetaContainer.this.dfltPath);
                        if (tup != null) {
                            SnapshotMetaContainer.this.next = (SnapshotMetadataV2)tup.getValue();
                        } else if (!SnapshotMetaContainer.this.dfltPath) {
                            for (SnapshotPath consId : snapshotDir.getEntries()) {
                                if (!consId.isDirectory() || (tup = FileDatabaseSnapshotSpi.this.tryReadMetadata(snapshotDir, consId, (CX2<String, CacheConfiguration, CacheConfiguration>)null, SnapshotMetaContainer.this.ignoreMissed, SnapshotMetaContainer.this.dfltPath)) == null) continue;
                                SnapshotMetaContainer.this.next = (SnapshotMetadataV2)tup.getValue();
                                break;
                            }
                        }
                        if (SnapshotMetaContainer.this.next == null) continue;
                        break;
                    }
                }

                @Override
                public boolean hasNext() {
                    return SnapshotMetaContainer.this.next != null;
                }

                @Override
                public SnapshotMetadataV2 next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    SnapshotMetadataV2 retTup = SnapshotMetaContainer.this.next;
                    SnapshotMetaContainer.this.next = null;
                    this.advance();
                    return retTup;
                }
            };
        }
    }
}

