/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptionUtil;
import org.apache.ignite.spi.encryption.EncryptionSpi;

public class EncryptedOutputStream
extends OutputStream {
    private final OutputStream delegate;
    private final GroupKey encryptionKey;
    private final EncryptionUtil encUtil;
    private final int encryptionOverhead;
    private final ByteBuffer pageBuffer;
    private final ByteBuffer destBuffer;
    private final byte[] singleByteArray = new byte[]{0};

    public EncryptedOutputStream(OutputStream delegate, GroupKey encryptionKey, EncryptionSpi encSpi, int pageSize) {
        this.delegate = delegate;
        this.encryptionKey = encryptionKey;
        this.encUtil = new EncryptionUtil(encSpi, pageSize);
        this.encryptionOverhead = this.encUtil.encryptionOverhead();
        this.pageBuffer = ByteBuffer.allocate(pageSize);
        this.destBuffer = ByteBuffer.allocate(pageSize).order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            this.singleByteArray[0] = (byte)b;
            this.write(this.singleByteArray, 0, 1);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            while (len > 0) {
                int size = Math.min(len, this.pageBuffer.remaining() - this.encryptionOverhead);
                this.pageBuffer.put(bytes, off, size);
                off += size;
                len -= size;
                if (this.pageBuffer.remaining() != this.encryptionOverhead) continue;
                this.flushPageBuffer(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ByteBuffer byteBuffer = this.pageBuffer;
        synchronized (byteBuffer) {
            int position = this.pageBuffer.position();
            if (position != 0) {
                while (this.pageBuffer.hasRemaining()) {
                    this.pageBuffer.put((byte)0);
                }
                try (OutputStream out = this.delegate;){
                    this.flushPageBuffer(position);
                }
            }
        }
    }

    private void flushPageBuffer(int position) throws IOException {
        this.pageBuffer.rewind();
        this.encUtil.encrypt(this.pageBuffer, this.destBuffer, this.encryptionKey);
        this.pageBuffer.rewind();
        this.destBuffer.putInt(position);
        this.destBuffer.rewind();
        this.delegate.write(this.destBuffer.array(), 0, this.destBuffer.remaining());
    }
}

