/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;

public class VisorReplicationInfo
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private ClusterRole role;
    private ReplicationState state;
    private String snapshotFolder;
    private long sesId;
    private boolean forcibleStop;
    private boolean recovery;
    private Long resultRecoveryTime;
    private int parallelism;
    private CompressionOption compressionOption;
    private int compressionLevel;
    private boolean singleFileCopy;

    public VisorReplicationInfo() {
    }

    public VisorReplicationInfo(Builder builder) {
        this.role = builder.role;
        this.state = builder.state;
        this.snapshotFolder = builder.snapshotFolder;
        this.sesId = builder.sesId;
        this.forcibleStop = builder.forcibleStop;
        this.recovery = builder.recovery;
        this.resultRecoveryTime = builder.resultRecoveryTime;
        this.parallelism = builder.parallelism;
        this.compressionOption = builder.compressionOption;
        this.compressionLevel = builder.compressionLevel;
        this.singleFileCopy = builder.singleFileCopy;
    }

    public ClusterRole role() {
        return this.role;
    }

    public String snapshotFolder() {
        return this.snapshotFolder;
    }

    public long sessionId() {
        return this.sesId;
    }

    public boolean forcibleStop() {
        return this.forcibleStop;
    }

    public boolean recovery() {
        return this.recovery;
    }

    public Long resultRecoveryTime() {
        return this.resultRecoveryTime;
    }

    public int parallelism() {
        return this.parallelism;
    }

    public CompressionOption compressionOption() {
        return this.compressionOption;
    }

    public int compressionLevel() {
        return this.compressionLevel;
    }

    public boolean singleFileCopy() {
        return this.singleFileCopy;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum((DataOutput)out, (Enum)this.role);
        U.writeEnum((DataOutput)out, (Enum)this.state);
        U.writeString((DataOutput)out, (String)this.snapshotFolder);
        out.writeLong(this.sesId);
        out.writeBoolean(this.forcibleStop);
        out.writeBoolean(this.recovery);
        out.writeLong(this.resultRecoveryTime == null ? -1L : this.resultRecoveryTime);
        out.writeInt(this.parallelism);
        U.writeEnum((DataOutput)out, (Enum)this.compressionOption);
        out.writeInt(this.compressionLevel);
        out.writeBoolean(this.singleFileCopy);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.role = ClusterRole.fromOrdinal((int)in.readByte());
        this.state = ReplicationState.fromOrdinal((int)in.readByte());
        this.snapshotFolder = U.readString((DataInput)in);
        this.sesId = in.readLong();
        this.forcibleStop = in.readBoolean();
        this.recovery = in.readBoolean();
        this.resultRecoveryTime = in.readLong();
        if (this.resultRecoveryTime == -1L) {
            this.resultRecoveryTime = null;
        }
        this.parallelism = in.readInt();
        this.compressionOption = CompressionOption.fromOrdinal((int)in.readByte());
        this.compressionLevel = in.readInt();
        this.singleFileCopy = in.readBoolean();
    }

    public String toString() {
        return S.toString(VisorReplicationInfo.class, (Object)((Object)this));
    }

    public static class Builder {
        private ClusterRole role;
        private ReplicationState state;
        private String snapshotFolder;
        private long sesId;
        private boolean forcibleStop;
        private boolean recovery;
        private Long resultRecoveryTime;
        private int parallelism = 2;
        private CompressionOption compressionOption = CompressionOption.ZIP;
        private int compressionLevel = -1;
        private boolean singleFileCopy;

        public Builder withRole(ClusterRole role) {
            this.role = role;
            return this;
        }

        public Builder withState(ReplicationState state) {
            this.state = state;
            return this;
        }

        public Builder withSnapshotFolder(String folder) {
            this.snapshotFolder = folder;
            return this;
        }

        public Builder withSessionId(long sesId) {
            this.sesId = sesId;
            return this;
        }

        public Builder withForcibleStop(boolean force) {
            this.forcibleStop = force;
            return this;
        }

        public Builder withRecovery(boolean recovery) {
            this.recovery = recovery;
            return this;
        }

        public Builder withResultRecoveryTime(Long resultRecoveryTime) {
            this.resultRecoveryTime = resultRecoveryTime;
            return this;
        }

        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder withCompressionOption(CompressionOption compressionOption) {
            this.compressionOption = compressionOption;
            return this;
        }

        public Builder withCompressionLevel(int compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        public Builder withSingleFileCopy(boolean singleFileCopy) {
            this.singleFileCopy = singleFileCopy;
            return this;
        }

        public VisorReplicationInfo build() {
            return new VisorReplicationInfo(this);
        }
    }
}

