/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorServerNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotIssue;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotIssue;

@GridInternal
public class VisorCheckSnapshotTask
extends VisorServerNodeTask<VisorSnapshotInfo, List<VisorSnapshotIssue>> {
    private static final long serialVersionUID = 0L;

    protected VisorCheckSnapshotJob job(VisorSnapshotInfo arg) {
        return new VisorCheckSnapshotJob(arg, this.debug);
    }

    protected boolean nodeFilter(ClusterNode node, VisorSnapshotInfo argument) {
        if (!F.isEmpty(argument.getExcludedCacheNames())) {
            return IgniteFeatures.allNodesSupport((GridKernalContext)this.ignite.context(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_OPERATION_WITH_EXCLUDE_AND_GROUPS_FILTER);
        }
        return true;
    }

    private static class VisorCheckSnapshotJob
    extends VisorJob<VisorSnapshotInfo, List<VisorSnapshotIssue>> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture<List<SnapshotIssue>> fut;

        private VisorCheckSnapshotJob(VisorSnapshotInfo arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected List<VisorSnapshotIssue> run(VisorSnapshotInfo arg) throws IgniteException {
            if (this.fut == null) {
                GridSnapshotEx snapshot = VisorSnapshots.snapshot((Ignite)this.ignite);
                this.fut = snapshot.check(new CheckSnapshotParams().snapshotId(arg.getSnapshotId()).optionalSearchPaths(arg.paths()).forceRestore(arg.isForce()).cacheNames(arg.getCacheNames()).excludedCacheNames(arg.getExcludedCacheNames()).skipCrc(arg.isSkipCrc()).message(arg.getMessage()).parallelism(Integer.valueOf(arg.getSnapshotCommonParameters().getSnapshotOperationParallelism())));
                if (!this.fut.isDone()) {
                    this.jobCtx.holdcc();
                    this.fut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture<List<SnapshotIssue>>>(){

                        public void apply(IgniteFuture<List<SnapshotIssue>> f) {
                            jobCtx.callcc();
                        }
                    });
                    return null;
                }
            }
            List issues = (List)this.fut.get();
            ArrayList<VisorSnapshotIssue> res = new ArrayList<VisorSnapshotIssue>(issues.size());
            for (SnapshotIssue issue : issues) {
                res.add(new VisorSnapshotIssue(issue));
            }
            return res;
        }

        public String toString() {
            return S.toString(VisorCheckSnapshotJob.class, (Object)((Object)this));
        }
    }
}

