/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class ReplicationStateChangeFuture
extends SnapshotOperationFuture<Void> {
    private final TransactionalDrProcessorImpl txdrProc;
    private volatile Object locPayload;
    private final Map<UUID, Object> globalPayload = new ConcurrentHashMap<UUID, Object>();
    private volatile ReplicationState state;
    private volatile ClusterRole clusterRole;
    private volatile long sesId;
    private final ReplicationState prevState;
    private final ClusterRole prevRole;

    public ReplicationStateChangeFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        GridGainImpl gg = (GridGainImpl)cctx.kernalContext().grid().plugin("GridGain");
        TransactionalDr txDr = gg.txDr();
        TransactionalDrProcessorImpl transactionalDrProcessorImpl = this.txdrProc = txDr instanceof TransactionalDrProcessorImpl ? (TransactionalDrProcessorImpl)txDr : null;
        if (this.txdrProc != null) {
            ReplicationSessionDescriptor desc = this.txdrProc.localState();
            this.prevState = desc.state();
            this.prevRole = desc.role();
        } else {
            this.prevState = null;
            this.prevRole = null;
        }
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.REPLICATION_STATE_CHANGE;
    }

    @Override
    protected boolean cancelable() {
        return false;
    }

    @Override
    protected boolean isSupportCancelProtocol() {
        return false;
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        super.init(snapshotInfo);
        this.clusterRole = ClusterRole.fromOrdinal((int)GridSnapshotOperationAttrs.getReplicationClusterRole((GridSnapshotOperationEx)snapshotInfo.snapshotOperation()));
        this.state = ReplicationState.fromOrdinal((int)GridSnapshotOperationAttrs.getReplicationState((GridSnapshotOperationEx)snapshotInfo.snapshotOperation()));
        this.sesId = GridSnapshotOperationAttrs.getReplicationSessionId((GridSnapshotOperationEx)snapshotInfo.snapshotOperation());
    }

    @Override
    protected boolean doFirstStage() throws IgniteCheckedException {
        assert (!this.nodeShouldSkipActiveActions());
        this.cctx.exchange().affinityReadyFuture(this.topVer).get();
        Long newSesId = GridSnapshotOperationAttrs.getReplicationNewSessionId((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
        this.locPayload = this.txdrProc.localPrepareStateChange(this.clusterRole, this.state, this.sesId, newSesId == null ? 0L : newSesId, this.topVer);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        assert (this.clusterRole != null);
        assert (this.state != null);
        if (this.clusterRole == ClusterRole.REPLICA && this.state == ReplicationState.RUNNING) {
            this.cctx.cache().restartProxies();
        }
        if (this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon()) {
            return;
        }
        if (this.notInBaseline) {
            try {
                this.clusterRole = ClusterRole.fromOrdinal((int)GridSnapshotOperationAttrs.getReplicationClusterRole((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()));
                this.state = ReplicationState.fromOrdinal((int)GridSnapshotOperationAttrs.getReplicationState((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()));
                this.sesId = GridSnapshotOperationAttrs.getReplicationSessionId((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
                if (this.state == ReplicationState.SWITCH) {
                    this.cctx.exchange().affinityReadyFuture(this.topVer).get();
                    Long newSesId = GridSnapshotOperationAttrs.getReplicationNewSessionId((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
                    this.txdrProc.localPrepareStateChange(this.clusterRole, this.state, this.sesId, newSesId == null ? 0L : newSesId, this.topVer);
                    this.txdrProc.localCompleteStateChange(this.clusterRole, this.state, this.sesId, null, this.topVer, msg.success(), null);
                    return;
                }
                if (this.state.isTransient()) return;
                this.txdrProc.setLocalReplicationState(new ReplicationSessionDescriptor().role(this.clusterRole).state(this.state).sessionId(this.sesId));
                return;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        } else {
            Map payload = null;
            if (msg.payload() != null) {
                payload = (Map)U.unmarshal((Marshaller)this.cctx.marshaller(), (byte[])msg.payload(), (ClassLoader)U.gridClassLoader());
            }
            this.txdrProc.localCompleteStateChange(this.clusterRole, this.state, this.sesId, payload, this.topVer, msg.success(), msg.errorMessage());
        }
    }

    @Override
    protected void onFinish(Void res, Throwable err) {
        if (this.state == null) {
            this.state = ReplicationState.fromOrdinal((int)GridSnapshotOperationAttrs.getReplicationState((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()));
        }
        if (err == null && this.state == ReplicationState.STOP_AND_RECOVERY) {
            if (this.crd.isLocal()) {
                try {
                    Set<UUID> nodes = this.globalPayload.entrySet().stream().filter(e -> !((ReplicationSessionDescriptor)e.getValue()).laggingBehind()).map(Map.Entry::getKey).collect(Collectors.toSet());
                    this.snapMgr.startGlobalReplicationRecovery(nodes, GridSnapshotOperationAttrs.getReplicationSessionId((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()), "");
                }
                catch (Exception e2) {
                    this.txdrProc.localFinishStateChange(this.clusterRole, ReplicationState.STOP_AND_RECOVERY, this.sesId, e2, null);
                }
            }
        } else {
            if (this.txdrProc == null) {
                assert (this.nodeShouldSkipActiveActions());
                return;
            }
            this.txdrProc.localFinishStateChange(this.clusterRole, this.state, this.sesId, err, null);
            if (err == null && this.log.isInfoEnabled()) {
                this.log.info("TX DR state transition successfully completed [prevRole=" + this.prevRole + ", prevState=" + this.prevState + ", currentRole=" + this.clusterRole + ", currentState=" + this.state + ']');
            }
        }
    }

    @Override
    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.FIRST && !F.isEmpty(this.globalPayload)) {
            return U.marshal((Marshaller)this.cctx.marshaller(), this.globalPayload);
        }
        return null;
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.FIRST && this.locPayload != null) {
            return U.marshal((Marshaller)this.cctx.marshaller(), (Object)this.locPayload);
        }
        return null;
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
        if (payload != null && this.shouldParticipateInSnapshotOperation(nodeId)) {
            this.globalPayload.put(nodeId, U.unmarshal((Marshaller)this.cctx.marshaller(), (byte[])payload, (ClassLoader)U.gridClassLoader()));
        }
    }

    @Override
    protected boolean needExchangeOnFinish() {
        return this.success() && this.clusterRole == ClusterRole.REPLICA && (this.state == ReplicationState.PAUSED || this.state == ReplicationState.STOPPED || this.state == ReplicationState.SWITCH);
    }
}

