/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.LocalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;

public class GlobalConsistentCutData
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final int TOPOLOGY_CHANGED_FLAG_MASK = 1;
    private Set<GridCacheVersion> globalTxs;
    private Map<Integer, Map<Integer, Long>> atomicUpdCntrs;
    private TopologyEventsSnapshot topEvtSnapshot;
    private byte flags;

    public GlobalConsistentCutData() {
        this.globalTxs = new HashSet<GridCacheVersion>();
    }

    private GlobalConsistentCutData(Set<GridCacheVersion> globalTxs, Map<Integer, Map<Integer, Long>> atomicUpdCntrs, boolean topChanged, TopologyEventsSnapshot snapshot) {
        this.globalTxs = globalTxs;
        this.atomicUpdCntrs = atomicUpdCntrs;
        this.topEvtSnapshot = snapshot;
        if (topChanged) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    public Set<GridCacheVersion> globalTxs() {
        return this.globalTxs;
    }

    public boolean topologyChanged() {
        return (this.flags & 1) != 0;
    }

    public TopologyEventsSnapshot eventLogSnapshot() {
        return this.topEvtSnapshot;
    }

    public Map<Integer, Map<Integer, Long>> atomicUpdateCounters() {
        return this.atomicUpdCntrs;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection((ObjectOutput)out, this.globalTxs);
        out.writeObject(this.topEvtSnapshot);
        out.writeByte(this.flags);
        U.writeMap((ObjectOutput)out, this.atomicUpdCntrs);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.globalTxs = U.readSet((ObjectInput)in);
        this.topEvtSnapshot = (TopologyEventsSnapshot)in.readObject();
        this.flags = in.readByte();
        if (protoVer >= 2) {
            this.atomicUpdCntrs = U.readHashMap((ObjectInput)in);
        }
    }

    public String toString() {
        return S.toString(GlobalConsistentCutData.class, (Object)((Object)this));
    }

    public static class Builder {
        private final Set<GridCacheVersion> globalSkipTxs = new HashSet<GridCacheVersion>();
        private final Map<GridCacheVersion, Set<GridCacheVersion>> globalDependentTxsGraph = new HashMap<GridCacheVersion, Set<GridCacheVersion>>();
        private Map<Integer, Map<Integer, Long>> globalAtomicUpdCntrs = new HashMap<Integer, Map<Integer, Long>>();
        private boolean topChanged;
        private GridKernalContext ctx;
        private final HashMap<UUID, TopologyEventsSnapshot> snapshots = new HashMap();

        public Builder() {
        }

        public Builder(GridKernalContext ctx) {
            this.ctx = ctx;
        }

        public void merge(UUID nodeId, LocalConsistentCutData locData) {
            this.globalSkipTxs.addAll(locData.localTxs());
            this.topChanged |= locData.topologyChanged();
            if (this.topChanged) {
                this.globalDependentTxsGraph.clear();
                this.snapshots.clear();
                return;
            }
            for (Map.Entry<GridCacheVersion, Set<GridCacheVersion>> entry : locData.dependentTxsGraph().entrySet()) {
                this.globalDependentTxsGraph.compute(entry.getKey(), (tx, depTxsSet) -> {
                    Set dependentTxs = depTxsSet == null ? new HashSet() : depTxsSet;
                    dependentTxs.addAll((Collection)e.getValue());
                    return dependentTxs;
                });
            }
            if (!F.isEmpty(locData.atomicUpdateCounters())) {
                for (Map.Entry<Object, Object> entry : locData.atomicUpdateCounters().entrySet()) {
                    this.globalAtomicUpdCntrs.compute((Integer)entry.getKey(), (grp, cntrs) -> {
                        Map currCntrs = cntrs == null ? new HashMap() : cntrs;
                        ((Map)e.getValue()).forEach((part, cntr) -> currCntrs.merge(part, cntr, (oldVal, newVal) -> oldVal == null ? newVal : Math.min(oldVal, newVal)));
                        return currCntrs;
                    });
                }
            }
            if (locData.topologyEventsSnapshot() != null) {
                this.snapshots.put(nodeId, locData.topologyEventsSnapshot());
            }
        }

        public GlobalConsistentCutData build() {
            HashSet<GridCacheVersion> skipTxs;
            HashSet<GridCacheVersion> currSearchStep = skipTxs = new HashSet<GridCacheVersion>(this.globalSkipTxs);
            while (!currSearchStep.isEmpty()) {
                HashSet<GridCacheVersion> nextSearchStep = new HashSet<GridCacheVersion>();
                for (GridCacheVersion nearXidVersion : currSearchStep) {
                    Set dependentTxs = this.globalDependentTxsGraph.getOrDefault(nearXidVersion, Collections.emptySet());
                    for (GridCacheVersion dependentTx : dependentTxs) {
                        if (skipTxs.contains(dependentTx)) continue;
                        nextSearchStep.add(dependentTx);
                    }
                }
                currSearchStep = nextSearchStep;
                skipTxs.addAll(currSearchStep);
            }
            TopologyEventsSnapshot crdSnapshot = TopologyEventsSnapshot.EMPTY_SNAPSHOT;
            if (this.ctx != null && !this.topChanged && !this.snapshots.isEmpty()) {
                AffinityTopologyVersion topVer = this.snapshots.entrySet().stream().map(e -> ((TopologyEventsSnapshot)e.getValue()).topology()).findAny().get();
                ClusterNode crd = SnapshotUtils.getSnapshotCrd(topVer, this.ctx.cache().context());
                assert (crd != null) : "Snapshot coordinator must not be null.";
                crdSnapshot = this.snapshots.get(crd.id());
                assert (crdSnapshot != null) : "Cannot find topology events snapshot from coordinator node [crd=" + crd + ", topEvtsSnapshot=" + this.snapshots + ']';
            }
            return new GlobalConsistentCutData(skipTxs, this.globalAtomicUpdCntrs, this.topChanged, crdSnapshot);
        }
    }
}

