/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;

public class FileConsistentCutStore
implements ConsistentCutStore {
    private final File ccDir;
    private final Marshaller marshaller;
    private static final String CONSISTENT_CUT_FILE_SUFFIX = ".cut";
    private static final DirectoryStream.Filter<? super Path> CONSISTENT_CUT_FILE_FILTER = path -> path.getFileName().toString().endsWith(CONSISTENT_CUT_FILE_SUFFIX);

    private static String consistentCutFileName(long id) {
        return Long.toString(id) + CONSISTENT_CUT_FILE_SUFFIX;
    }

    public FileConsistentCutStore(File ccDir, Marshaller marshaller) {
        this.ccDir = ccDir;
        this.marshaller = marshaller;
    }

    @Override
    public void save(ConsistentCut consistentCut) throws IgniteCheckedException {
        try {
            File tmp = new File(this.ccDir, FileConsistentCutStore.consistentCutFileName(consistentCut.id()) + ".tmp");
            File file = new File(this.ccDir, FileConsistentCutStore.consistentCutFileName(consistentCut.id()));
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmp, false)));){
                byte[] serializedCut = U.marshal((Marshaller)this.marshaller, (Object)consistentCut);
                bw.write(Base64.getEncoder().encodeToString(serializedCut));
                bw.newLine();
                bw.write(consistentCut.toStringVerbose());
            }
            Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to save consistent cut: " + consistentCut.id(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConsistentCut restore(long id) throws IgniteCheckedException {
        File file = new File(this.ccDir, FileConsistentCutStore.consistentCutFileName(id));
        if (!file.exists()) {
            throw new IgniteCheckedException("Consistent cut " + id + " not found");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String encodedSerializedCut = br.readLine();
            ConsistentCut consistentCut = (ConsistentCut)U.unmarshal((Marshaller)this.marshaller, (byte[])Base64.getDecoder().decode(encodedSerializedCut), (ClassLoader)U.gridClassLoader());
            return consistentCut;
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to restore consistent cut from file: " + file.getName(), (Throwable)e);
        }
    }

    @Override
    public boolean delete(long id) throws IgniteCheckedException {
        File file = new File(this.ccDir, FileConsistentCutStore.consistentCutFileName(id));
        if (!file.exists()) {
            return false;
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            throw new IgniteCheckedException("Failed to delete consistent cut: " + file.getName(), (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws IgniteCheckedException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.ccDir.toPath(), CONSISTENT_CUT_FILE_FILTER);){
            for (Path path : files) {
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup consistent cut directory: " + this.ccDir, (Throwable)e);
        }
    }

    @Override
    public List<Long> list() throws IgniteCheckedException {
        return this.list(0L);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long> list(long startId, long endId) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> list(long startId) throws IgniteCheckedException {
        return this.list(startId, Long.MAX_VALUE);
    }
}

