/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;

public class ConsistentCutGC {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private final IgniteLogger log;
    private final ConsistentCutStore cutsStore;
    private final File walDir;
    private volatile File spawnWalDir;
    private volatile ConsistentCut lastAppliedCut;

    public ConsistentCutGC(IgniteLogger log, ConsistentCutStore cutsStore, File walDir) {
        this.log = log.getLogger(this.getClass());
        this.cutsStore = cutsStore;
        this.walDir = walDir;
    }

    public boolean perform() {
        long cutId;
        List<Long> cutIds;
        ConsistentCut lastAppliedCut0 = this.lastAppliedCut;
        if (lastAppliedCut0 == null) {
            return false;
        }
        for (File file2 : (File[])Objects.requireNonNull(U.firstNotNull((Object[])new File[][]{this.walDir.listFiles(file -> {
            try {
                return file.isDirectory() && Long.valueOf(file.getName()) < Long.valueOf(this.spawnWalDir.getName());
            }
            catch (NumberFormatException e) {
                U.warn((IgniteLogger)this.log, (Object)("Illegal spawnWalDir name: " + file.getName()));
                return false;
            }
        }), EMPTY_FILE_ARRAY}))) {
            boolean walFileDeleted = false;
            boolean walDirNotEmpty = false;
            for (FileDescriptor desc : FileWriteAheadLogManager.scan((File[])file2.listFiles(FileWriteAheadLogManager.WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER))) {
                if (walFileDeleted) {
                    walDirNotEmpty = true;
                    break;
                }
                if (desc.file().delete()) {
                    walFileDeleted = true;
                    continue;
                }
                U.warn((IgniteLogger)this.log, (Object)("Failed to delete applied WAL segment (make sure the process has enough rights): " + desc.file().getAbsolutePath()));
            }
            if (!walDirNotEmpty) {
                U.delete((File)file2);
            }
            if (!walFileDeleted) continue;
            return true;
        }
        for (File file3 : FileWriteAheadLogManager.scan((File[])this.spawnWalDir.listFiles(FileWriteAheadLogManager.WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER))) {
            FileWALPointer highPtr = (FileWALPointer)lastAppliedCut0.fuzzyBorderStartPtr();
            if (file3.idx() >= highPtr.index()) break;
            if (file3.file().delete()) {
                return true;
            }
            U.warn((IgniteLogger)this.log, (Object)("Failed to delete applied WAL segment (make sure the process has enough rights): " + file3.file().getAbsolutePath()));
        }
        try {
            cutIds = this.cutsStore.list();
        }
        catch (IgniteCheckedException e) {
            U.warn((IgniteLogger)this.log, (Object)"Failed to list consistent cut ids", (Throwable)e);
            return false;
        }
        Iterator<Long> iterator = cutIds.iterator();
        while (iterator.hasNext() && (cutId = iterator.next().longValue()) < lastAppliedCut0.id()) {
            try {
                if (this.cutsStore.delete(cutId)) {
                    return true;
                }
                U.warn((IgniteLogger)this.log, (Object)("Failed to delete applied consistent cut (make sure the process has enough rights): " + cutId));
            }
            catch (IgniteCheckedException e) {
                U.warn((IgniteLogger)this.log, (Object)("Failed to delete applied consistent cut: " + cutId), (Throwable)e);
            }
        }
        return false;
    }

    public void updateLastAppliedCut(ConsistentCut lastAppliedCut) {
        assert (lastAppliedCut != null);
        ConsistentCut prevLastAppliedCut = this.lastAppliedCut;
        if (prevLastAppliedCut != null && prevLastAppliedCut.id() > lastAppliedCut.id()) {
            throw new IllegalArgumentException("New last applied cut must not be older than old!");
        }
        this.lastAppliedCut = lastAppliedCut;
        this.spawnWalDir = new File(this.walDir, Long.toString(lastAppliedCut.spawnId()));
    }
}

