/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.EncryptionUtil;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.gridgain.grid.configuration.GridGainCacheConfiguration;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.GridPluginUtils;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ResultOfOperationWithSnapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCountersDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreAndCheckFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.dr.DrUtils;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.FileIndexMissingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotRestoreFuture
extends SnapshotRestoreAndCheckFuture {
    public static final String SNAPSHOT_METADATA_IS_BROKEN_ERR_MSG = "Snapshot metadata is broken! snapshotId=";
    public static final String SNAPSHOT_WAS_NOT_FULLY_RESTORED = "Snapshot was not fully restored!";
    private final FilePageStoreManager storeMgr;
    private int nodeFail;
    private boolean initFailCond;
    protected int minBackups = Integer.MAX_VALUE;
    protected String cacheNameWithMinBackups;
    protected volatile boolean noSnapshot;
    protected final Queue<File> files = new ConcurrentLinkedQueue<File>();
    private final Collection<StoredCacheData> stoppedCache = new ConcurrentLinkedQueue<StoredCacheData>();
    private volatile Map<Integer, SnapshotCountersDescriptor> backupSnapCntrs;
    private final Deque<WALRecord> walRecords = new ConcurrentLinkedDeque<WALRecord>();
    private final AtomicBoolean walRecordsApplied = new AtomicBoolean(false);

    public static File getLockFile(File cacheWorkDir) {
        return new File(cacheWorkDir, "snapshot-started.loc");
    }

    public static void syncDir(File cacheWorkDir) {
        if (IgniteSystemProperties.getBoolean((String)"GG_TEST_SKIP_SNAPSHOT_SYNC")) {
            return;
        }
        try (FileChannel ch = FileChannel.open(cacheWorkDir.toPath(), StandardOpenOption.WRITE);){
            ch.force(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected SnapshotRestoreFuture(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protocolVersion, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        this.storeMgr = SnapshotRestoreFuture.getStoreMgr(cctx);
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.SECOND;
            }
            case SECOND: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError((Object)("Unexpected stage in nextStage, passed stage=" + (Object)((Object)stage)));
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.RESTORE;
    }

    @Override
    protected boolean doFirstStage() throws Exception {
        Map cacheGrpDescriptors = this.cctx.cache().cacheGroupDescriptors();
        Map cacheDescriptors = this.cctx.cache().cacheDescriptors();
        this.backupSnapCntrs = this.snapMgr.getSnapshotCounters(this.snapshotInfo.snapshotOperation().cacheGroupIds());
        for (Integer grpId : this.snapshotInfo.snapshotOperation().cacheGroupIds()) {
            CacheGroupDescriptor desc = (CacheGroupDescriptor)cacheGrpDescriptors.get(grpId);
            if (desc == null) continue;
            for (String cacheName : desc.caches().keySet()) {
                this.stoppedCache.add(((DynamicCacheDescriptor)cacheDescriptors.get(cacheName)).toStoredData(this.cctx.cache().splitter()));
            }
            CacheGroupContext ctx = this.cctx.cache().cacheGroup(grpId.intValue());
            if (ctx == null) continue;
            File file = this.storeMgr.cacheWorkDir(ctx.sharedGroup(), ctx.cacheOrGroupName());
            this.files.add(file);
        }
        return true;
    }

    @Override
    protected boolean onFirstStageDoneCrdHook() throws IgniteCheckedException {
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting stop caches before RESTORE, cacheNames = " + op.cacheNames());
        }
        Set<String> cacheToDestroyWoRestart = this.collectUnknownLogicalCachesToDestroy(this.log, this.cctx, op.cacheGroupIds(), op.cacheNames());
        boolean restoreForceOption = GridSnapshotOperationAttrs.getRestoreForceOption((GridSnapshotOperationEx)op);
        if (!cacheToDestroyWoRestart.isEmpty() && !restoreForceOption) {
            throw new IgniteCheckedException("Cache groups in snapshot contains caches " + cacheToDestroyWoRestart + " not presented in snapshot. Please set snapshot restore force option or manually destroy cache(s): " + cacheToDestroyWoRestart);
        }
        this.cctx.tm().checkEmptyTransactions((IgniteOutClosure & Serializable)() -> "Failed to destroy cache before RESTORE. It can't be done within lock or transation.");
        ArrayList<DynamicCacheChangeRequest> cacheStopReqs = new ArrayList<DynamicCacheChangeRequest>(op.cacheNames().size());
        for (String cacheWoRestart : cacheToDestroyWoRestart) {
            cacheStopReqs.add(this.cctx.cache().createStopRequest(cacheWoRestart, false, null, false));
        }
        for (String cacheName : op.cacheNames()) {
            cacheStopReqs.add(this.cctx.cache().createStopRequest(cacheName, true, this.isSupportRestartId() ? this.id : null, false));
        }
        try {
            this.cctx.cache().dynamicChangeCaches(cacheStopReqs).get();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stop caches before RESTORE finished successfully");
            }
        }
        catch (Throwable th) {
            throw new IgniteException("Error during destroying cache before RESTORE", th);
        }
        return true;
    }

    @Override
    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        if (!this.nodeShouldSkipActiveActions() && !this.isCancelled()) {
            AffinityTopologyVersion ver = this.lastKnownVersion();
            assert (ver != null);
            while (true) {
                try {
                    IgniteInternalFuture affReadFut = this.cctx.cache().context().exchange().affinityReadyFuture(ver);
                    if (affReadFut == null) break;
                    affReadFut.get(100L);
                }
                catch (IgniteFutureTimeoutCheckedException | IgniteInterruptedCheckedException ex) {
                    if (!this.isCancelled()) continue;
                    throw new IgniteCheckedException("Snapshot operation has been cancelled: " + this.snapshotInfo, ex);
                }
                break;
            }
            this.doOperation(GridSnapshotOperationAttrs.getRestoreStrategyOrDefault((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation(), (SnapshotRestoreStrategy)SnapshotRestoreStrategy.defaultStrategy((SnapshotOperationType)this.snapshotInfo.snapshotOperation().type())));
        }
        return true;
    }

    @Override
    protected boolean onSecondStageDoneCrdHook() throws IgniteCheckedException {
        if (this.isRestoreOwnConsistentIdStrategyAvailable() && this.success()) {
            Map<Integer, Integer> partCountForCache;
            ResultOfOperationWithSnapshot resultOfOperation = (ResultOfOperationWithSnapshot)((Object)this.resultOfOperation.get());
            if (resultOfOperation == null) {
                throw new IgniteCheckedException("Snapshot does not exist [id=" + this.snapshotInfo().snapshotOperation().snapshotId() + ']');
            }
            Map<Integer, BitSet> partIdsForCache = resultOfOperation.partitionIdsForCacheGroup();
            Map<Integer, Set<Integer>> issues = this.checkOperationResultOnCrd(partIdsForCache, partCountForCache = resultOfOperation.partitionCountForCacheGroup());
            if (issues != null) {
                throw new IgniteCheckedException("Snapshot was not fully restored!:\n" + this.toErrorMessage(issues));
            }
        }
        return true;
    }

    @Override
    protected SnapshotOperationStage stageForResultOfOperation() {
        return SnapshotOperationStage.SECOND;
    }

    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws IgniteCheckedException {
        boolean complete;
        if (this.cctx.localNode().isClient()) {
            return;
        }
        boolean bl = complete = this.error.get() != null || this.resetBranchingHistory(msg.operationId().globalId().getLeastSignificantBits());
        if (complete) {
            this.completeSnapshotRestore(this.success());
        }
    }

    @Override
    protected void checkSecurityLevel(UUID initiatorId, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
        try {
            SnapshotUtils.checkSecurityLevel(this.cctx, initiatorId, snapshotOperation, this.snapMgr.resolveSecurityLevel());
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    @Override
    protected void cancelComplete(boolean force) throws IgniteCheckedException {
        if (!this.nodeShouldSkipActiveActions() && !force) {
            this.completeSnapshotRestore(this.success());
        }
        if (force) {
            this.resetSnapshotCounters(false);
            this.cctx.cache().resetRestartingProxies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onLastStageDoneCrdHook(SnapshotOperationStage stage) throws IgniteCheckedException {
        Collection<StoredCacheData> cacheToStart = null;
        try {
            if (stage == SnapshotOperationStage.CANCELLED) {
                T2 fut = (T2)this.cancelFut.get();
                assert (fut != null) : "State is CANCELLED, but there is no cancel future.";
                if (((Boolean)fut.get1()).booleanValue()) {
                    return;
                }
            } else {
                cacheToStart = this.getConfigurationsToStart();
            }
        }
        catch (IgniteCheckedException | IgniteException e) {
            U.error((IgniteLogger)this.log, (Object)"Error during collecting cache configurations", (Throwable)e);
        }
        finally {
            if (cacheToStart == null) {
                cacheToStart = this.stoppedCache;
            }
        }
        if (GridSnapshotOperationAttrs.getReplicationBootstrapReplicaFlag((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation())) {
            this.startCaches(true, cacheToStart, stage == SnapshotOperationStage.CANCELLED);
        } else {
            this.startCaches(false, cacheToStart, stage == SnapshotOperationStage.CANCELLED);
            for (StoredCacheData data : cacheToStart) {
                String name = data.config().getName();
                if (DataStructuresProcessor.isDataStructureCache((String)name)) continue;
                IgniteCacheProxy entries = this.cctx.cache().publicJCache(name);
                entries.sizeLong(new CachePeekMode[0]);
            }
        }
    }

    @Override
    protected void onFinish(Object res, Throwable err) {
        if (this.type() == SnapshotOperationType.RESTORE && this.crdIsLocal() && GridSnapshotOperationAttrs.getReplicationBootstrapReplicaFlag((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()) && err == null) {
            this.snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, this.snapshotInfo.snapshotId(), 0L);
        }
    }

    protected void startCaches(boolean startInactive, Collection<StoredCacheData> storedCacheDataList, boolean isCancelSnapOper) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info((isCancelSnapOper ? "Start caches after RESTORE CANCELLED operation, caches=" : "Start caches after RESTORE finished, caches=") + (this.log.isDebugEnabled() ? storedCacheDataList : (Collection)storedCacheDataList.stream().map((? super T x) -> x.config().getName()).collect(Collectors.toList())));
        }
        this.cctx.cache().dynamicStartCachesByStoredConf(storedCacheDataList, false, true, startInactive, this.isSupportRestartId() ? this.id : null, false).get();
        if (this.log.isInfoEnabled()) {
            this.log.info(isCancelSnapOper ? "Start caches after RESTORE CANCELLED operation finished successfully" : "Start caches after RESTORE finished successfully");
        }
    }

    @NotNull
    protected Collection<StoredCacheData> getConfigurationsToStart() throws IgniteCheckedException {
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        SnapshotDescriptor desc = this.snapMgr.getSnapshotDescriptorFromCluster(op.snapshotId(), GridSnapshotOperationAttrs.getOptionalPathsParameter((GridSnapshotOperationEx)op), (IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>)op.cacheConfigClo());
        if (desc == null || desc.snapshotMetadata() == null) {
            throw new IgniteException("Failed to collect snapshot descriptor: " + desc);
        }
        SnapshotMetadata meta = desc.snapshotMetadata();
        ArrayList<StoredCacheData> cacheCfgs = new ArrayList<StoredCacheData>();
        for (Integer grpId : op.cacheGroupIds()) {
            cacheCfgs.addAll(((CacheSnapshotMetadata)meta.cacheMetadata().get(grpId)).storedCacheDataList());
        }
        return cacheCfgs;
    }

    @Override
    protected void onBeforeSnapshotRead() throws IgniteCheckedException {
        this.renameDirs(this.files);
    }

    @Override
    protected boolean beforeOperationStarted(GridKernalContext ctx, Snapshot snapshot) throws IgniteCheckedException {
        SnapshotMetadataV2 metadata = snapshot.metadata();
        this.initializeFailCondition(metadata.cacheGroupsMetadata());
        this.restoreMarshallerMappings((MarshallerContext)ctx.marshallerContext(), metadata);
        this.restoreBinaryMetadata((CacheObjectBinaryProcessorImpl)ctx.cacheObjects(), metadata);
        this.afterMappingsWasRestored();
        return true;
    }

    @Override
    protected SnapshotRestoreAndCheckFuture.OperationOnGroup startOperationOnGroup(final SnapshotRestoreStrategy stgy, final Snapshot snapshot, final Integer grpId, String cacheOrGrpName, CacheConfiguration cacheCfg, final BitSet partitions, final String cId, final int pageSize, GroupKeyEncrypted encryptionKey, EncryptionSpi encSpi) throws Exception {
        File snapshotRestoreLockFile;
        final File cacheWorkDir = this.storeMgr.cacheWorkDir(cacheCfg);
        if (!cacheWorkDir.exists()) {
            cacheWorkDir.mkdirs();
        }
        if ((snapshotRestoreLockFile = this.createLockFile(cacheWorkDir)) == null) {
            throw new IgniteCheckedException("Failed to create a restore lock file for cache [cache=" + cacheCfg.getName() + ']');
        }
        return new SnapshotRestoreAndCheckFuture.OperationOnGroup(pageSize, encryptionKey, encSpi){

            @Override
            ByteBuffer createBuffer() {
                ByteBuffer buf = ByteBuffer.allocateDirect(pageSize);
                buf.order(ByteOrder.nativeOrder());
                return buf;
            }

            @Override
            public void init() throws Exception {
                ByteBuffer buf = this.readBuf();
                long readAddr = GridUnsafe.bufferAddress((ByteBuffer)buf);
                SnapshotRestoreFuture.this.restoreIndex(snapshot, grpId, partitions, cacheWorkDir, buf, readAddr, cId, stgy, this.encryptionKey, this.encSpi);
            }

            @Override
            public int doJobOnPartition(SnapshotInputStream stream, int part) throws IOException, IgniteCheckedException {
                ByteBuffer buf = this.readBuf();
                long readAddr = GridUnsafe.bufferAddress((ByteBuffer)buf);
                int pageCnt = SnapshotRestoreFuture.this.copyFromStreamToFile(buf, readAddr, cacheWorkDir, stream, this.encryptionKey, this.encSpi);
                if (SnapshotRestoreFuture.this.exchangelessSnapshot() && SnapshotRestoreFuture.this.readWalRecordsFromStream(stream)) {
                    ++pageCnt;
                }
                return pageCnt;
            }

            @Override
            public void onMetadataBroken(Integer grpId2, int part) {
                throw new IllegalStateException("Page were find for partition=" + part + " while by information from metadata there shouldn't be any.");
            }

            @Override
            public void onNotAnyPageReadWhileShould(Integer grpId2, int part) {
                throw new IllegalStateException("No page were found, grpId=" + grpId2 + ", partition=" + part);
            }

            @Override
            public void onNotAllPageRead(Integer grpId2, int part, int pageCnt, Integer cntFromMeta) {
                throw new IllegalStateException("Partition hasn't been restored properly [expPageCnt=" + cntFromMeta + ", actualPageCnt=" + pageCnt + "]");
            }

            @Override
            public void onError(Exception e, int part) throws IgniteCheckedException {
                throw new IgniteCheckedException((Throwable)e);
            }

            @Override
            public void finish() {
                boolean deleted;
                if (cacheWorkDir != null && !IgniteSystemProperties.getBoolean((String)"GG_TEST_SKIP_SNAPSHOT_SYNC")) {
                    SnapshotRestoreFuture.syncDir(cacheWorkDir);
                }
                if (snapshotRestoreLockFile != null && !(deleted = snapshotRestoreLockFile.delete())) {
                    U.warn((IgniteLogger)SnapshotRestoreFuture.this.log, (Object)("Failed to delete snapshot restore lock file (was it deleted manually?): " + snapshotRestoreLockFile.getAbsolutePath()));
                }
            }
        };
    }

    private void restoreDrState() {
        SnapshotMetadata snapshotMeta;
        if (!DrUtils.isDrEnabled((GridGainConfiguration)GridPluginUtils.gridPluginConfiguration((IgniteConfiguration)this.cctx.gridConfig()))) {
            return;
        }
        try {
            GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
            SnapshotDescriptor descriptor = this.snapMgr.getSnapshotDescriptorFromCluster(op.snapshotId(), GridSnapshotOperationAttrs.getOptionalPathsParameter((GridSnapshotOperationEx)op), (IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>)op.cacheConfigClo());
            snapshotMeta = descriptor.snapshotMetadata();
        }
        catch (Throwable th) {
            throw new IgniteException("Failed to restore DR state after snapshot recovery: snapshot=" + this.snapshotInfo.snapshotId(), th);
        }
        if (snapshotMeta == null) {
            return;
        }
        Iterator iterator = this.snapshotInfo.snapshotOperation().cacheGroupIds().iterator();
        while (iterator.hasNext()) {
            int grpId = (Integer)iterator.next();
            CacheSnapshotMetadata metadata = (CacheSnapshotMetadata)snapshotMeta.cacheMetadata().get(grpId);
            for (CacheConfiguration ccfg : metadata.cacheConfigurations()) {
                GridGainCacheConfiguration pluginCfg = (GridGainCacheConfiguration)GridCacheUtils.cachePluginConfiguration((CacheConfiguration)ccfg, GridGainCacheConfiguration.class);
                String key = DrUtils.drStateMetastorageKey((String)ccfg.getName());
                if (pluginCfg == null || pluginCfg.getDrSenderConfiguration() == null || metadata.partitionCounters() == null) {
                    try {
                        DrUtils.resetDrState((IgniteCacheDatabaseSharedManager)this.cctx.database(), (String)key);
                        continue;
                    }
                    catch (Throwable th) {
                        throw new IgniteException("Failed to reset DR state after snapshot recovery: snapshot=" + this.snapshotInfo.snapshotId() + ", cache=" + ccfg.getName(), th);
                    }
                }
                try {
                    DrUtils.writeDrState((IgniteCacheDatabaseSharedManager)this.cctx.database(), (String)key, (Map)metadata.partitionCounters());
                }
                catch (Throwable th) {
                    throw new IgniteException("Failed to restore DR state after snapshot recovery: snapshot=" + this.snapshotInfo.snapshotId() + ", cache=" + ccfg.getName(), th);
                }
            }
        }
    }

    private boolean readWalRecordsFromStream(SnapshotInputStream stream) throws IOException {
        WALRecord rec;
        boolean res = false;
        while ((rec = stream.readNextRecord()) != null) {
            res = true;
            this.walRecords.offer(rec);
        }
        return res;
    }

    @Override
    protected void onNoSnapshotOnNode(long snapshotId, SnapshotRestoreStrategy stgy) throws IgniteCheckedException {
        switch (stgy) {
            case RESTORE_BY_AFFINITY: 
            case RESTORE_OWN_CONSISTENT_ID: {
                throw new IgniteException("Could not restore snapshot " + snapshotId + " from node " + this.cctx.localNodeId() + ", snapshot not found with id = " + snapshotId);
            }
        }
        this.noSnapshot = true;
        this.afterMappingsWasRestored();
    }

    @Override
    protected synchronized void onNodeLeft0(ClusterNode node, boolean crd) throws IgniteCheckedException {
        ++this.nodeFail;
        this.checkFailCondition();
    }

    @Override
    protected double adjustProgress(SnapshotOperationStage stage, double progress) {
        switch (stage) {
            case FIRST: {
                return progress * 0.05;
            }
            case SECOND: {
                return progress * 0.85 + 0.05;
            }
            case FINISH: {
                return progress * 0.1 + 0.9;
            }
        }
        return 0.0;
    }

    protected void afterMappingsWasRestored() throws IgniteCheckedException {
    }

    private void restoreBinaryMetadata(CacheObjectBinaryProcessorImpl proc, SnapshotMetadataV2 metadata) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Restoring binary metadata started.");
        }
        BinaryContext binCtx = proc.binaryContext();
        for (Map.Entry e : metadata.binaryMetadataMap().entrySet()) {
            proc.addMetaLocally(((Integer)e.getKey()).intValue(), (BinaryType)((BinaryMetadata)e.getValue()).wrap(binCtx));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Restoring binary metadata finished.");
        }
    }

    private void restoreMarshallerMappings(MarshallerContext marshallerCtx, SnapshotMetadataV2 metadata) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Restoring marshaller mapping started.");
        }
        for (Map.Entry platformMap : metadata.typeMap().entrySet()) {
            byte platformId = (Byte)platformMap.getKey();
            if (platformMap.getValue() == null) continue;
            for (Map.Entry mappingEntry : ((Map)platformMap.getValue()).entrySet()) {
                marshallerCtx.registerClassNameLocally(platformId, ((Integer)mappingEntry.getKey()).intValue(), (String)mappingEntry.getValue());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Restoring marshaller mapping finished.");
        }
    }

    protected final void completeSnapshotRestore(boolean success) throws IgniteCheckedException {
        File workDir = this.storeMgr.workDir();
        try {
            try (DirectoryStream<Path> files = Files.newDirectoryStream(workDir.toPath());){
                for (Path tmpDir : files) {
                    String fileName = tmpDir.getFileName().toString();
                    if (!Files.isDirectory(tmpDir, new LinkOption[0]) || !fileName.endsWith(".tmp")) continue;
                    String newDirName = fileName.substring(0, fileName.length() - 4);
                    Path newDir = tmpDir.getParent().resolve(newDirName);
                    if (success) {
                        boolean deleted;
                        File snapshotRestoreLockFile = SnapshotRestoreFuture.getLockFile(newDir.toFile());
                        if (snapshotRestoreLockFile.exists() && !(deleted = snapshotRestoreLockFile.delete())) {
                            U.warn((IgniteLogger)this.log, (Object)("Failed to delete snapshot restore lock file (was it deleted manually?): " + snapshotRestoreLockFile.getAbsolutePath()));
                        }
                        tmpDir.resolve("finished.tmp").toFile().delete();
                        U.delete((Path)tmpDir);
                        continue;
                    }
                    if (Files.exists(newDir, new LinkOption[0])) {
                        U.delete((Path)newDir);
                    }
                    Files.move(tmpDir, newDir, StandardCopyOption.ATOMIC_MOVE);
                    newDir.resolve("finished.tmp").toFile().delete();
                }
            }
            if (success) {
                this.restoreDrState();
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Error during completing snapshot restore", (Throwable)e);
        }
        finally {
            this.resetSnapshotCounters(success);
            this.resetEncryptionKeys(success);
            SnapshotRestoreFuture.syncDir(workDir);
        }
    }

    private void resetEncryptionKeys(boolean success) {
        if (success) {
            Iterator iterator = this.snapshotInfo.snapshotOperation().cacheGroupIds().iterator();
            while (iterator.hasNext()) {
                GroupKeyEncrypted encKey;
                int grpId = (Integer)iterator.next();
                Map keys = GridSnapshotOperationAttrs.getRestoreEncryptionKeys((GridSnapshotOperationEx)this.snapshotInfo().snapshotOperation());
                if (F.isEmpty((Map)keys) || (encKey = (GroupKeyEncrypted)keys.get(grpId)) == null) continue;
                this.cctx.kernalContext().encryption().setInitialGroupKey(grpId, encKey.key());
            }
        }
    }

    private void renameDirs(Collection<File> dirs) throws IgniteCheckedException {
        for (File file : dirs) {
            if (!file.exists()) continue;
            Path src = file.toPath();
            try {
                Path tmpDir = src.getParent().resolve(src.getFileName() + ".tmp");
                if (Files.exists(tmpDir, new LinkOption[0]) && !F.isEmptyDirectory((Path)tmpDir)) {
                    U.warn((IgniteLogger)this.log, (Object)("Temp directory is not empty! " + tmpDir + " will be removed."));
                    U.delete((Path)tmpDir);
                }
                Files.move(src, tmpDir, StandardCopyOption.ATOMIC_MOVE);
                Path tmpLock = tmpDir.resolve("finished.tmp");
                Files.createFile(tmpLock, new FileAttribute[0]);
                SnapshotRestoreFuture.syncDir(tmpDir.toFile());
            }
            catch (IOException ioe) {
                throw new IgniteCheckedException((Throwable)ioe);
            }
        }
    }

    private String toErrorMessage(Map<Integer, Set<Integer>> issues) {
        SB sb = new SB();
        for (Map.Entry<Integer, Set<Integer>> entry : issues.entrySet()) {
            sb.a("\tGroupId=").a((Object)entry.getKey()).a(": ");
            Set<Integer> value = entry.getValue();
            if (value == null) {
                sb.a("Not restored at all;");
            } else {
                sb.a("Next partitions were not restored - (");
                for (Integer partId : value) {
                    sb.a((Object)partId).a(", ");
                }
                sb.d(sb.length() - 2, sb.length());
                sb.a(')');
            }
            sb.a("\n");
        }
        return sb.toString();
    }

    private void initializeFailCondition(Map<Integer, CacheSnapshotMetadata> metadata) throws IgniteCheckedException {
        int minBackups = Integer.MAX_VALUE;
        String cacheNameWithMinBackups = null;
        GridSnapshotOperationEx snapOpr = this.snapshotInfo().snapshotOperation();
        assert (snapOpr.type() == SnapshotOperationType.RESTORE || snapOpr.type() == SnapshotOperationType.RECOVERY);
        for (Integer grpId : snapOpr.cacheGroupIds()) {
            Collection cfgs = metadata.get(grpId).cacheConfigurations();
            for (CacheConfiguration cfg : cfgs) {
                assert (cfg != null);
                if (cfg.getCacheMode() != CacheMode.PARTITIONED || cfg.getBackups() >= minBackups) continue;
                minBackups = cfg.getBackups();
                cacheNameWithMinBackups = cfg.getName();
            }
        }
        this.initializeFailCondition(minBackups, cacheNameWithMinBackups);
    }

    private void checkFailCondition() throws IgniteCheckedException {
        if (this.initFailCond && this.nodeFail > this.minBackups) {
            throw new IgniteCheckedException("Failed to complete snapshot operation (" + this.nodeFail + " nodes left topology during snapshot operation, which may lead to a potential data loss) [cacheMinBackups=" + this.cacheNameWithMinBackups + ", backups=" + this.minBackups + "]");
        }
    }

    private synchronized void initializeFailCondition(int minBackups, String cacheNameWithMinBackups) throws IgniteCheckedException {
        this.minBackups = minBackups;
        this.cacheNameWithMinBackups = cacheNameWithMinBackups;
        this.initFailCond = true;
        this.checkFailCondition();
    }

    private boolean isSupportRestartId() {
        return GridGainFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (GridGainFeatures)GridGainFeatures.RESTART_ID_SUPPORT);
    }

    private void restoreIndex(Snapshot snapshot, Integer grpId, BitSet partitions, File cacheWorkDir, ByteBuffer readBuf, long readAddr, String cId, SnapshotRestoreStrategy stgy, GroupKeyEncrypted encryptionKey, EncryptionSpi encSpi) throws Exception {
        boolean indexRestored = false;
        try (SnapshotInputStream stream2 = this.getSnapshotIndexStream(snapshot, grpId, partitions, cId, stgy);){
            if (stream2 != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Restoring index: " + stream2);
                }
                this.copyFromStreamToFile(readBuf, readAddr, cacheWorkDir, stream2, encryptionKey, encSpi);
                indexRestored = true;
            }
        }
        catch (FileIndexMissingException stream2) {
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Index was " + (indexRestored ? "" : " not ") + "restored for grpId=" + grpId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int copyFromStreamToFile(ByteBuffer readBuf, long readAddr, File cacheWorkDir, SnapshotInputStream stream, GroupKeyEncrypted encryptionKey, EncryptionSpi encSpi) throws IOException, IgniteCheckedException {
        byte type;
        Path path;
        int pageSize = this.snapMgr.pageSize();
        if (stream.partId() <= 65500) {
            path = cacheWorkDir.toPath().resolve("part-" + stream.partId() + ".bin");
            type = 1;
        } else {
            if (stream.partId() != 65535) throw new IgniteException("Unknown partition value: " + stream.partId());
            path = cacheWorkDir.toPath().resolve("index.bin");
            type = 2;
        }
        ByteBuffer hdrBuf = this.headerBuffer(type, path);
        EncryptionUtil encUtil = null;
        GroupKey decryptedKey = null;
        if (encryptionKey != null) {
            assert (!(encSpi instanceof NoopEncryptionSpi));
            encUtil = new EncryptionUtil(encSpi, pageSize);
            decryptedKey = new GroupKey(encryptionKey.id(), encSpi.decryptKey(encryptionKey.key()));
        }
        try (FileChannel ch = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            int hdrSize = hdrBuf.limit();
            ch.write(hdrBuf, 0L);
            int pageCnt = 0;
            while (stream.readNextPage(readBuf)) {
                ++pageCnt;
                readBuf.rewind();
                long pageId = PageIO.getPageId((long)readAddr);
                assert (pageId != 0L);
                int pageIdx = PageIdUtils.pageIndex((long)pageId);
                int crcSaved = PageIO.getCrc((long)readAddr);
                PageIO.setCrc((long)readAddr, (int)0);
                if (FastCrc.calcCrc((ByteBuffer)readBuf, (int)pageSize) != crcSaved) {
                    throw new IgniteCheckedException("Snapshot corrupted: part - " + stream.partId() + ", cacheWorkDir - " + cacheWorkDir);
                }
                PageIO.setCrc((long)readAddr, (int)crcSaved);
                readBuf.rewind();
                boolean changed = false;
                int pageType = PageIO.getType((long)readAddr);
                switch (pageType) {
                    case 15: {
                        PageHandler.zeroMemory((long)readAddr, (int)40, (int)(readBuf.capacity() - 40));
                        changed = true;
                        break;
                    }
                    case 11: 
                    case 14: {
                        PageMetaIO io = (PageMetaIO)PageIO.getPageIO((int)pageType, (int)PageIO.getVersion((long)readAddr));
                        io.setLastAllocatedPageCount(readAddr, 0);
                        io.setLastSuccessfulFullSnapshotId(readAddr, 0L);
                        io.setLastSuccessfulSnapshotId(readAddr, 0L);
                        io.setLastSuccessfulSnapshotTag(readAddr, 0L);
                        io.setNextSnapshotTag(readAddr, 1L);
                        io.setCandidatePageCount(readAddr, 0);
                        changed = true;
                        break;
                    }
                }
                if (changed) {
                    PageIO.setCrc((long)readAddr, (int)0);
                    int crc32 = FastCrc.calcCrc((ByteBuffer)readBuf, (int)pageSize);
                    PageIO.setCrc((long)readAddr, (int)crc32);
                    readBuf.rewind();
                }
                if (encryptionKey != null) {
                    ByteBuffer resBuf = ByteBuffer.allocateDirect(pageSize);
                    resBuf.order(ByteOrder.nativeOrder());
                    encUtil.encrypt(readBuf, resBuf, decryptedKey);
                    resBuf.rewind();
                    ch.write(resBuf, (long)hdrSize + (long)pageIdx * (long)pageSize);
                } else {
                    ch.write(readBuf, (long)hdrSize + (long)pageIdx * (long)pageSize);
                }
                readBuf.rewind();
            }
            if (!IgniteSystemProperties.getBoolean((String)"GG_TEST_SKIP_SNAPSHOT_SYNC")) {
                ch.force(true);
            }
            int n = pageCnt;
            return n;
        }
        catch (IgniteDataIntegrityViolationException e) {
            throw new IgniteCheckedException("Snapshot corrupted: part - " + stream.partId() + ", cacheWorkDir - " + cacheWorkDir, (Throwable)e);
        }
    }

    @Nullable
    private File createLockFile(File cacheWorkDir) throws IOException {
        File snapshotLockFile = SnapshotRestoreFuture.getLockFile(cacheWorkDir);
        boolean lockFileCreated = snapshotLockFile.createNewFile();
        if (!lockFileCreated) {
            return null;
        }
        if (!IgniteSystemProperties.getBoolean((String)"GG_TEST_SKIP_SNAPSHOT_SYNC")) {
            SnapshotRestoreFuture.syncDir(cacheWorkDir);
        }
        return snapshotLockFile;
    }

    private ByteBuffer headerBuffer(byte type, Path p) throws IgniteCheckedException {
        DataStorageConfiguration dsCfg = this.cctx.gridConfig().getDataStorageConfiguration();
        FileVersionCheckingFactory factory = new FileVersionCheckingFactory(dsCfg.getFileIOFactory(), dsCfg.getFileIOFactory(), dsCfg);
        FilePageStore store = factory.createPageStore(type, (IgniteOutClosure & Serializable)() -> p, factory.latestVersion(), i -> {});
        return store.header(type, dsCfg.getPageSize());
    }

    private void resetSnapshotCounters(boolean success) {
        Map<Integer, SnapshotCountersDescriptor> backupSnapCntrs0 = this.backupSnapCntrs;
        if (backupSnapCntrs0 != null) {
            this.snapMgr.resetSnapshotCounters(backupSnapCntrs0, success);
        }
        this.backupSnapCntrs = null;
        if (success) {
            this.snapMgr.setLastSuccessfulFullSnapshotIdForAllCaches(0L, true, true);
        }
    }

    boolean resetBranchingHistory(long newBranchingHash) {
        try {
            this.cctx.kernalContext().state().resetBranchingHistory(newBranchingHash);
            return true;
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Error occurred on writing BaselineTopology to metastore, stopping node", (Throwable)e);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String gridName = SnapshotRestoreFuture.this.cctx.kernalContext().grid().name();
                        Ignition.stop((String)gridName, (boolean)true);
                        U.log((IgniteLogger)SnapshotRestoreFuture.this.log, (Object)"Node stopped successfully.");
                    }
                    catch (Throwable th) {
                        U.error((IgniteLogger)SnapshotRestoreFuture.this.log, (Object)"Failed to stop the node due to the error", (Throwable)th);
                    }
                }
            }).start();
            return false;
        }
    }

    protected void applyWALRecords(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        Set cachesFromRestoreFut;
        if (!this.exchangelessSnapshot() || GridFunc.isEmpty((Collection)fut.exchangeActions().cacheStartRequests())) {
            return;
        }
        HashSet cachesFromExchange = new HashSet(GridFunc.transform((Collection)fut.exchangeActions().cacheStartRequests(), (IgniteClosure & Serializable)req -> req.request().cacheName()));
        if (!cachesFromExchange.equals(cachesFromRestoreFut = this.snapshotInfo.snapshotOperation().cacheNames())) {
            this.log.warning("Exchange with starting caches on snapshot RESTORE finish has been detected, but set of cache names from exchange is not equal to cache names from future [cachesFromExchange=" + cachesFromExchange + ", cachesFromRestoreFut=" + cachesFromRestoreFut + "]");
            return;
        }
        if (!this.walRecordsApplied.compareAndSet(false, true)) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying WAL records from snapshot [walRecordsCount=" + this.walRecords.size() + ']');
        }
        ((GridCacheDatabaseSharedManager)this.cctx.database()).applyUpdates(this.walRecordsIterator(), null, (IgniteBiPredicate & Serializable)(a, b) -> true, true, null, false);
        HashSet<Integer> finalizedGrpIds = new HashSet<Integer>();
        Collection cacheContexts = this.cctx.cacheContexts();
        for (GridCacheContext cacheCtx : cacheContexts) {
            CacheGroupContext groupContext;
            if (!cachesFromExchange.contains(cacheCtx.name()) || finalizedGrpIds.contains((groupContext = cacheCtx.group()).groupId())) continue;
            groupContext.topology().finalizeUpdateCounters(groupContext.topology().localPartitionMap().keySet());
            finalizedGrpIds.add(groupContext.groupId());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished applying WAL records from snapshot.");
        }
    }

    private WALIterator walRecordsIterator() {
        return new IterableWALIterator(this.walRecords);
    }

    @Override
    public void onPartitionStatesRestored(GridDhtPartitionsExchangeFuture fut) {
        if (this.stage() == SnapshotOperationStage.FINISH) {
            try {
                this.applyWALRecords(fut);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
        super.onPartitionStatesRestored(fut);
    }

    private class IterableWALIterator
    implements WALIterator {
        private static final long serialVersionUID = 0L;
        private IgniteBiTuple<WALPointer, WALRecord> lastRead;
        private Iterator<WALRecord> iter;
        private volatile boolean isClosed = false;

        public IterableWALIterator(Iterable<WALRecord> iterable) {
            this.iter = iterable.iterator();
        }

        public Optional<WALPointer> lastRead() {
            return Optional.ofNullable(this.lastRead == null ? null : (WALPointer)this.lastRead.get1());
        }

        public void close() {
            this.isClosed = true;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public boolean hasNextX() {
            return this.iter.hasNext();
        }

        public IgniteBiTuple<WALPointer, WALRecord> nextX() {
            WALRecord rec = this.iter.next();
            this.lastRead = new IgniteBiTuple((Object)rec.position(), (Object)rec);
            return this.lastRead;
        }

        public void removeX() {
            this.iter.remove();
        }

        @NotNull
        public Iterator<IgniteBiTuple<WALPointer, WALRecord>> iterator() {
            return this;
        }

        public boolean hasNext() {
            return this.hasNextX();
        }

        public IgniteBiTuple<WALPointer, WALRecord> next() {
            return this.nextX();
        }
    }
}

