/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStageContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStageContextImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagePayloadWrapper;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class SnapshotConfigurableFuture<R>
extends SnapshotOperationFuture<R> {
    private CustomStagesConfiguration customStagesConfiguration;
    private volatile CustomStageContext stageContext = null;

    protected SnapshotConfigurableFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<R> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        super.init(snapshotInfo);
        this.customStagesConfiguration = GridSnapshotOperationAttrs.customStagesConfiguration((SnapshotOperation)snapshotInfo.snapshotOperation());
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.CONFIGURABLE;
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success) {
            return SnapshotOperationStage.CANCELLED;
        }
        return (SnapshotOperationStage)((Object)this.nextStageCustom().get1());
    }

    private IgniteBiTuple<SnapshotOperationStage, Integer> nextStageCustom() {
        int stageNum;
        int n = stageNum = this.stageContext == null ? 0 : this.stageContext.stageNum() + 1;
        if (stageNum == this.customStagesConfiguration.stagesNum()) {
            return new IgniteBiTuple((Object)SnapshotOperationStage.FINISH, (Object)stageNum);
        }
        return new IgniteBiTuple((Object)SnapshotOperationStage.CUSTOM, (Object)stageNum);
    }

    @Override
    protected boolean doFirstStage() throws IgniteCheckedException {
        return this.doStage(null, null);
    }

    @Override
    protected boolean doCustomStage(ClusterNode node, @Nullable ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return this.doStage(node, msg);
    }

    @Override
    protected void doFinalStage(@Nullable ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        CustomStage stage = this.customStagesConfiguration.finalStage();
        if (stage != null) {
            this.doStage(null, msg);
        }
    }

    private boolean doStage(@Nullable ClusterNode node, @Nullable ClusterWideSnapshotOperationStageFinishedMessage msg) throws IgniteCheckedException {
        CustomStage stage;
        int stageNum;
        Object payload;
        if (this.stageInProgress == SnapshotOperationStage.CANCELLED) {
            payload = null;
            stageNum = -1;
        } else if (msg != null) {
            if (msg.stage() != SnapshotOperationStage.FIRST && msg.stage() != SnapshotOperationStage.CUSTOM) {
                throw new AssertionError((Object)("Unexpected stage [stage=" + (Object)((Object)msg.stage()) + "]"));
            }
            CustomStagePayloadWrapper wrapper = this.unmarshalWrapped(msg.payload(), U.gridClassLoader());
            if (wrapper.stageNum() != this.stageContext.stageNum() && this.stageInProgress != SnapshotOperationStage.CANCELLED) {
                U.warn((IgniteLogger)this.log, (Object)("Received message with wrong stage [curStage=" + this.stageContext.currentStage() + ":" + this.stageContext.stageNum() + "], receivedStage=" + (Object)((Object)msg.stage()) + ":" + wrapper.stageNum() + "], msg=" + msg + ", node=" + node + ']'));
                return false;
            }
            payload = wrapper.payload();
            stageNum = (Integer)this.nextStageCustom().get2();
        } else if (this.stageContext == null) {
            payload = null;
            stageNum = (Integer)this.nextStageCustom().get2();
        } else {
            throw new AssertionError((Object)("Can't execute custom stage [stage=" + (Object)((Object)this.stageInProgress) + ", msg=" + msg + ", stageContext=" + this.stageContext + "]"));
        }
        CustomStage customStage = stage = stageNum == this.customStagesConfiguration.stagesNum() || this.stageInProgress == SnapshotOperationStage.CANCELLED ? this.customStagesConfiguration.finalStage() : this.customStagesConfiguration.stage(stageNum);
        if (stage == null) {
            return true;
        }
        this.switchStageContext(stageNum, stage, payload);
        return stage.execute(this.stageContext);
    }

    private void switchStageContext(int stageNum, CustomStage stage, @Nullable Object payload) {
        this.stageContext = new CustomStageContextImpl(this.cctx.kernalContext(), this, stage, this.snapMgr, payload, this.stageContext == null ? null : Integer.valueOf(this.stageContext.stageNum()), stageNum, this.stageInProgress, (Throwable)this.error.get());
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (this.stageContext == null) {
            assert (this.nodeShouldSkipActiveActions());
            return null;
        }
        return this.wrapAndMarshal(this.stageContext.stageResultPayload());
    }

    @Override
    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        return this.wrapAndMarshal(this.stageContext.globalPayload());
    }

    @Override
    protected byte[] getPreviousClusterWidePayload(SnapshotOperationFuture.StageDescriptor prevStage) throws IgniteCheckedException {
        int stageNum = Objects.requireNonNull(prevStage.customStageIdx, "stageNum cannot be null here");
        return this.wrapAndMarshal(this.stageContext.previousStageClusterWidePayload(), stageNum);
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
        if (this.stageContext == null || payload == null) {
            return;
        }
        CustomStagePayloadWrapper wrapper = this.unmarshalWrapped(payload, U.gridClassLoader());
        this.stageContext.currentStage().mergePayloadOnCrd(this.stageContext, nodeId, wrapper.payload());
    }

    @Override
    protected boolean onFirstStageDoneCrdHook() {
        return this.stageContext.currentStage().onStageDoneCrdHook(this.stageContext, false);
    }

    @Override
    protected boolean onCustomStageDoneCrdHook() {
        return this.stageContext.currentStage().onStageDoneCrdHook(this.stageContext, false);
    }

    @Override
    protected void onLastStageDoneCrdHook(SnapshotOperationStage stage) {
        this.stageContext.currentStage().onStageDoneCrdHook(this.stageContext, stage == SnapshotOperationStage.CANCELLED);
    }

    @Override
    protected void onNodeLeft0(ClusterNode node, boolean crdChanged) {
        if (this.customStagesConfiguration.onNodeLeftCallback() != null) {
            this.customStagesConfiguration.onNodeLeftCallback().onNodeLeft((IgniteInternalFuture)this, node, crdChanged);
        }
    }

    @Override
    protected void cancelComplete(boolean force) {
        if (this.customStagesConfiguration.onCancelCompleteCallback() != null) {
            this.customStagesConfiguration.onCancelCompleteCallback().apply((Object)force);
        }
    }

    @Override
    protected String stageStr(SnapshotOperationStage stage) {
        int stageNum = this.stageContext == null ? 0 : this.stageContext.stageNum();
        return stage.toString() + (stageNum >= 0 ? ":" + stageNum : "");
    }

    public void cancelOperation(@Nullable String msg, @Nullable Throwable err) {
        this.error0(msg, err);
    }

    private byte[] wrapAndMarshal(Object obj) throws IgniteCheckedException {
        return this.wrapAndMarshal(obj, this.stageContext.stageNum());
    }

    private byte[] wrapAndMarshal(Object obj, int stageNum) throws IgniteCheckedException {
        CustomStagePayloadWrapper wrapper = new CustomStagePayloadWrapper(stageNum, obj);
        return this.cctx.marshaller().marshal((Object)wrapper);
    }

    private CustomStagePayloadWrapper unmarshalWrapped(byte[] bytes, ClassLoader ldr) throws IgniteCheckedException {
        return (CustomStagePayloadWrapper)this.cctx.marshaller().unmarshal(bytes, ldr);
    }

    @Override
    SnapshotOperationFuture.StageDescriptor wrapStage(ClusterNode node, SnapshotOperationStageFinishedMessage msg) {
        return this.wrapStage0(node, msg.payload(), msg.stage());
    }

    @Override
    SnapshotOperationFuture.StageDescriptor wrapStage(ClusterNode node, ClusterWideSnapshotOperationStageFinishedMessage msg) {
        return this.wrapStage0(node, msg.payload(), msg.stage());
    }

    private SnapshotOperationFuture.StageDescriptor wrapStage0(ClusterNode node, byte[] payload, SnapshotOperationStage stage) {
        try {
            if (payload == null) {
                assert (this.nodeShouldSkipActiveActions(node));
                return new SnapshotOperationFuture.StageDescriptor(stage);
            }
            CustomStagePayloadWrapper wrapper = this.unmarshalWrapped(payload, U.gridClassLoader());
            return new SnapshotOperationFuture.StageDescriptor(stage, wrapper.stageNum());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    @Override
    SnapshotOperationFuture.StageDescriptor wrapPreviousStage() {
        if (this.stageContext == null) {
            assert (this.nodeShouldSkipActiveActions());
            return new SnapshotOperationFuture.StageDescriptor(this.previousStage);
        }
        return new SnapshotOperationFuture.StageDescriptor(this.previousStage, this.stageContext.stageNum());
    }
}

