/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutContextSupplier;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutContext;
import org.gridgain.grid.internal.processors.cache.database.txdr.GlobalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.LocalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class ConsistentCutFuture
extends SnapshotOperationFuture<Void> {
    private volatile ConsistentCutContext cutCtx;
    private volatile LocalConsistentCutData locData;
    private volatile GlobalConsistentCutData.Builder globData;
    private volatile ConsistentCutContextSupplier cutCtxSupplier;
    private final JdkMarshaller jdkMarsh;

    public ConsistentCutFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter clientInitFut, @Nullable GridFutureAdapter clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, (GridFutureAdapter<Void>)clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
        this.globData = new GlobalConsistentCutData.Builder(cctx.kernalContext());
        this.jdkMarsh = cctx.kernalContext().marshallerContext().jdkMarshaller();
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.CONSISTENT_CUT;
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        switch (stage) {
            case FIRST: 
            case THIRD: {
                return U.marshal((Marshaller)this.jdkMarsh, (Object)((Object)this.locData));
            }
        }
        return null;
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) {
        LocalConsistentCutData nodeData;
        if (payload == null || !this.shouldParticipateInSnapshotOperation(nodeId)) {
            return;
        }
        if (this.stage() != SnapshotOperationStage.FIRST && this.stage() != SnapshotOperationStage.THIRD) {
            return;
        }
        try {
            nodeData = (LocalConsistentCutData)((Object)U.unmarshal((Marshaller)this.jdkMarsh, (byte[])payload, (ClassLoader)U.resolveClassLoader((IgniteConfiguration)this.cctx.gridConfig())));
        }
        catch (IgniteCheckedException e) {
            this.error0("Can't deserialize payload on coordinator", e);
            return;
        }
        try {
            this.globData.merge(nodeId, nodeData);
        }
        catch (Exception e) {
            this.error0("Error while processing consistent cut data from node " + nodeId + " [data=" + (Object)((Object)nodeData) + ']', e);
        }
    }

    @Override
    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        switch (stage) {
            case FIRST: 
            case THIRD: {
                return U.marshal((Marshaller)this.jdkMarsh, (Object)((Object)this.globData.build()));
            }
        }
        return null;
    }

    @Override
    protected boolean doFirstStage() throws IgniteCheckedException {
        assert (!this.nodeShouldSkipActiveActions());
        this.cutCtxSupplier = ConsistentCutContextSupplier.create((SnapshotOperation)this.snapshotInfo.snapshotOperation(), this.cctx.kernalContext());
        this.cutCtx = this.cutCtxSupplier.createConsistentCutContext(this.snapshotInfo.snapshotId());
        IgniteInternalFuture readyFut = this.cctx.exchange().affinityReadyFuture(this.topVer);
        if (readyFut != null) {
            readyFut.get();
        }
        this.locData = this.cutCtx.startTrackingTransactionsLocally();
        this.locData.topologyChanged(this.cutCtxSupplier.shouldSkipConsistentCut(this.cutCtx, this.topVer));
        return true;
    }

    @Override
    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        assert (!this.nodeShouldSkipActiveActions());
        byte[] payload = msg.payload();
        ClassLoader clsLdr = U.resolveClassLoader((IgniteConfiguration)this.cctx.gridConfig());
        GlobalConsistentCutData globDataFromCrd = (GlobalConsistentCutData)((Object)U.unmarshal((Marshaller)this.jdkMarsh, (byte[])payload, (ClassLoader)clsLdr));
        this.cutCtx.awaitPendingTransactionsLocally(globDataFromCrd.globalTxs());
        this.cutCtx.markConsistentCutPoint();
        this.globData = new GlobalConsistentCutData.Builder(this.cctx.kernalContext());
        return true;
    }

    @Override
    protected boolean doThirdStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        assert (!this.nodeShouldSkipActiveActions());
        this.locData = this.cutCtx.finishTrackingTransactionsLocally();
        TopologyEventsSnapshot snapshot = this.cutCtxSupplier.localTopologySnapshot(this.cutCtx);
        this.locData.topologyEventsSnapshot(snapshot);
        this.locData.topologyChanged(this.cutCtxSupplier.shouldSkipConsistentCut(this.cutCtx, this.topVer));
        return true;
    }

    @Override
    protected boolean doFourthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        ClassLoader clsLdr;
        assert (!this.nodeShouldSkipActiveActions());
        byte[] payload = msg.payload();
        GlobalConsistentCutData globDataFromCrd = (GlobalConsistentCutData)((Object)U.unmarshal((Marshaller)this.jdkMarsh, (byte[])payload, (ClassLoader)(clsLdr = U.resolveClassLoader((IgniteConfiguration)this.cctx.gridConfig()))));
        if (globDataFromCrd.topologyChanged()) {
            String errMsg = "Skipped consistent cut [id=" + this.snapshotInfo.snapshotId() + ", cancelSnapshotOp=" + this.cutCtxSupplier.shouldCancelOnSkippedCut() + ']';
            if (this.cutCtxSupplier.shouldCancelOnSkippedCut()) {
                this.error0(null, new IgniteCheckedException(errMsg));
                return false;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(errMsg);
                this.log.info("Consistent cut metrics: " + this.cutCtx.metrics());
            }
            return true;
        }
        ConsistentCut consistentCut = this.cutCtx.completeConsistentCutCreation(globDataFromCrd, this.cutCtxSupplier.binaryMetadata());
        if (this.log.isInfoEnabled()) {
            this.log.info("Consistent cut created: " + consistentCut.toString());
            this.log.info("Consistent cut metrics: " + this.cutCtx.metrics().toString());
        }
        this.cutCtxSupplier.updateLocalTopologySnapshot(globDataFromCrd.eventLogSnapshot());
        this.cutCtxSupplier.consistentCutStore().save(consistentCut);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stored binaryMetadata in consistent cut [id=" + consistentCut.id() + ", binaryMetas=" + consistentCut.binaryMetadata().stream().map((? super T m) -> "[typeId=" + m.typeId() + ", typeName=" + m.typeName() + ", schemas=" + m.schemas().stream().map(BinarySchema::schemaId).collect(Collectors.toList()) + "]").collect(Collectors.joining(", ", "[", "]")));
        }
        return true;
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.SECOND;
            }
            case SECOND: {
                return SnapshotOperationStage.THIRD;
            }
            case THIRD: {
                return SnapshotOperationStage.FOURTH;
            }
            case FOURTH: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected void cancelComplete(boolean force) throws IgniteCheckedException {
        ConsistentCutContext cutCtx0 = this.cutCtx;
        if (cutCtx0 != null) {
            cutCtx0.reset();
        }
    }
}

