/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class RecoveryMessageWrapper
implements Message {
    private static final long serialVersionUID = 0L;
    private transient Object senderNodeCId;
    private transient Object receiverNodeCId;
    private IgniteUuid id;
    private byte[] fromNodeBytes;
    private byte[] toNodeBytes;
    private Message msg;

    public RecoveryMessageWrapper() {
    }

    public RecoveryMessageWrapper(IgniteUuid id, Object senderNodeCId, Object receiverNodeCId, Message msg) {
        this.id = id;
        this.senderNodeCId = senderNodeCId;
        this.receiverNodeCId = receiverNodeCId;
        this.msg = msg;
    }

    public Object senderNodeConstId() {
        return this.senderNodeCId;
    }

    public Object receiverNodeConstId() {
        return this.receiverNodeCId;
    }

    public Message msg() {
        return this.msg;
    }

    public IgniteUuid recoveryId() {
        return this.id;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("fromNodeBytes", this.fromNodeBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeIgniteUuid("id", this.id)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMessage("msg", this.msg)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("toNodeBytes", this.toNodeBytes)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.fromNodeBytes = reader.readByteArray("fromNodeBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.id = reader.readIgniteUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg = reader.readMessage("msg");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.toNodeBytes = reader.readByteArray("toNodeBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RecoveryMessageWrapper.class);
    }

    public void marshal(Marshaller marshaller) throws IgniteCheckedException {
        if (this.fromNodeBytes == null) {
            this.fromNodeBytes = U.marshal((Marshaller)marshaller, (Object)this.senderNodeCId);
        }
        if (this.toNodeBytes == null) {
            this.toNodeBytes = U.marshal((Marshaller)marshaller, (Object)this.receiverNodeCId);
        }
    }

    public void unmarshal(Marshaller marshaller) throws IgniteCheckedException {
        if (this.senderNodeCId == null) {
            this.senderNodeCId = U.unmarshal((Marshaller)marshaller, (byte[])this.fromNodeBytes, (ClassLoader)U.gridClassLoader());
        }
        if (this.receiverNodeCId == null) {
            this.receiverNodeCId = U.unmarshal((Marshaller)marshaller, (byte[])this.toNodeBytes, (ClassLoader)U.gridClassLoader());
        }
    }

    public short directType() {
        return 2060;
    }

    public byte fieldsCount() {
        return 4;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return "RecoveryMessageWrapper{id=" + this.id + ", senderNodeCId=" + this.senderNodeCId + ", receiverNodeConstId=" + this.receiverNodeCId + ", msg=" + this.msg + '}';
    }
}

