/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RecoveryDebug;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRUtils;
import org.gridgain.grid.internal.processors.cache.database.recovery.Sender;
import org.gridgain.grid.internal.processors.cache.database.recovery.WALPointerIntervalProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.jetbrains.annotations.NotNull;

abstract class PITRRecoveryContext {
    protected final GridKernalContext ig;
    protected final IgniteLogger log;
    protected final BaselineTopology snpBlt;
    protected final SnapshotMetadataV2 metadata;
    protected final Object locNodeConstId;
    protected final AffinityTopologyVersion topVer;
    protected final RecoveryDebug rd;
    protected final long time;
    protected final long snpId;
    protected final GridCacheDatabaseSharedManager psMgr;
    private final Sender snd;
    protected final GridRecovery recovery;

    protected PITRRecoveryContext(GridKernalContext ig, IgniteLogger log, BaselineTopology snpBlt, SnapshotMetadataV2 metadata, Object locNodeConstId, AffinityTopologyVersion topVer, long time, long snpId) {
        this.ig = ig;
        this.log = log;
        this.snpBlt = snpBlt;
        this.metadata = metadata;
        this.locNodeConstId = locNodeConstId;
        this.topVer = topVer;
        this.time = time;
        this.snpId = snpId;
        BaselineTopology curBlt = ig.state().clusterState().baselineTopology();
        this.snd = new MapperSender(ig.cache().context().gridIO(), curBlt.consistentIdMapping(), ig.discovery().nodeIdMap(topVer));
        this.psMgr = (GridCacheDatabaseSharedManager)ig.cache().context().database();
        this.recovery = ((GridGainImpl)ig.grid().plugin("GridGain")).provider().recovery();
        this.rd = PITRUtils.DEBUG_ENABLE ? new RecoveryDebug(locNodeConstId, time, this.log) : null;
    }

    abstract GridMessageListener init() throws IgniteCheckedException;

    abstract IgniteInternalFuture<Set<Object>> scanForLeftNodes();

    abstract IgniteInternalFuture<?> continueScan(Set<Object> var1, SnapshotOperationContext var2);

    abstract IgniteInternalFuture<?> recovery(SnapshotOperationContext var1);

    abstract void onNodeLeft(ClusterNode var1, boolean var2);

    public void onComplete(Throwable e) {
        if (this.rd != null) {
            this.rd.close();
        }
    }

    protected Sender sender() {
        return this.snd;
    }

    protected Object mapToConstId(UUID node) {
        return this.ig.discovery().node(node).consistentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyUpdate(WALIterator it, PITRFuture.Result res, Map<Integer, Set<Integer>> partsForApply, MultiWalApplyPredicate multiWalApplyPred, WALPointerIntervalProgressCalculator progressCalculator, Integer iteratorIndex) throws IgniteCheckedException {
        FileWALPointer lastWalPnt = (FileWALPointer)res.getEndWalPointer();
        Map<Integer, Set<Integer>> cachesToRebalance = res.getPartToRebalance();
        HashMap<GroupPartitionId, Integer> partStates = new HashMap<GroupPartitionId, Integer>();
        AtomicLong appliedEntries = new AtomicLong();
        AtomicLong totalEntries = new AtomicLong();
        this.addRebalancePartition(partStates, cachesToRebalance);
        AtomicLong lastReadIdx = new AtomicLong(-1L);
        this.ig.query().skipFieldLookup(true);
        try {
            this.psMgr.applyUpdatesOnRecovery(it, (IgniteBiPredicate & Serializable)(pointer, record) -> {
                FileWALPointer ptr = (FileWALPointer)record.position();
                totalEntries.incrementAndGet();
                int res1 = lastWalPnt != null ? ptr.compareTo(lastWalPnt) : 1;
                long lastRead0 = lastReadIdx.get();
                if (lastRead0 != -1L) {
                    if (lastRead0 != ptr.index() && this.log.isInfoEnabled()) {
                        this.log.info("Segment idx=" + lastRead0 + " applied");
                    }
                } else if (this.log.isInfoEnabled()) {
                    this.log.info("Start apply segment idx=" + ptr.index());
                }
                lastReadIdx.set(ptr.index());
                progressCalculator.reportWork(ptr, iteratorIndex);
                return res1 > 0;
            }, this.getEntryPredicate(res, multiWalApplyPred, appliedEntries));
            for (CacheGroupContext grp : this.ig.cache().cacheGroups()) {
                grp.offheap().restorePartitionStates(partStates);
            }
        }
        finally {
            this.ig.query().skipFieldLookup(false);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished apply updates on recovery localNodeConstId=" + this.locNodeConstId + " applied:" + appliedEntries.get() + " notApplied:" + (totalEntries.get() - appliedEntries.get()));
        }
    }

    protected IgniteBiPredicate<WALRecord, DataEntry> getEntryPredicate(PITRFuture.Result res, MultiWalApplyPredicate multiWalApplyPred, AtomicLong appliedEntries) {
        return (IgniteBiPredicate & Serializable)(rec, entry) -> {
            if (rec.type() != WALRecord.RecordType.DATA_RECORD && rec.type() != WALRecord.RecordType.DATA_RECORD_V2) {
                return false;
            }
            if (entry == null) {
                return true;
            }
            GridCacheVersion txId = entry.nearXidVersion();
            int cacheId = entry.cacheId();
            int partId = entry.partitionId();
            Map<Integer, Set<Integer>> cachesToRebalance = res.getPartToRebalance();
            Set<Integer> parts = cachesToRebalance.get(cacheId);
            if (parts != null && parts.contains(partId)) {
                return false;
            }
            boolean apply = true;
            Set<GridCacheVersion> skipTxUpdates = res.getSkipTxs();
            if (txId != null) {
                boolean bl = apply = !skipTxUpdates.contains(txId);
            }
            if (apply && multiWalApplyPred != null) {
                apply = multiWalApplyPred.apply((DataEntry)entry);
            }
            if (apply) {
                GridCacheContext ctx = this.ig.cache().context().cacheContext(cacheId);
                if (ctx == null) {
                    return false;
                }
                appliedEntries.incrementAndGet();
                if (this.rd != null) {
                    this.rd.append((Object)(txId + " key=" + entry.key() + " val=" + entry.value() + "\n"));
                }
            }
            return apply;
        };
    }

    protected int castAndCompareFileWalPoint(WALPointer less, WALPointer more) {
        if (less == null || more == null) {
            return 0;
        }
        FileWALPointer less0 = (FileWALPointer)less;
        FileWALPointer more0 = (FileWALPointer)more;
        return less0.compareTo(more0);
    }

    protected static String walPoint(WALPointer ptr) {
        if (ptr == null) {
            return "null";
        }
        FileWALPointer ptr0 = (FileWALPointer)ptr;
        return "idx=" + ptr0.index() + " offset=" + ptr0.fileOffset();
    }

    private void addRebalancePartition(Map<GroupPartitionId, Integer> partStates, Map<Integer, Set<Integer>> grpToRebalance) {
        for (Map.Entry<Integer, Set<Integer>> en : grpToRebalance.entrySet()) {
            if (this.rd != null) {
                this.rd.append((Object)("grpId=" + en.getKey() + "\n")).append((Object)"[");
            }
            int grpId = en.getKey();
            for (Integer part : en.getValue()) {
                partStates.put(new GroupPartitionId(grpId, part.intValue()), GridDhtPartitionState.MOVING.ordinal());
                if (this.rd == null) continue;
                this.rd.append((Object)(part + " "));
            }
            if (this.rd == null) continue;
            this.rd.append((Object)"]\n");
        }
        if (this.rd != null) {
            this.rd.append((Object)"\n");
        }
    }

    protected WALPointer metadataWalPointer(Object nodeConstId) {
        BaselineTopology blt = this.metadata.baselineTopology();
        Map walPoints = this.metadata.walPoints();
        return (WALPointer)walPoints.get(blt.resolveShortConsistentId(nodeConstId));
    }

    private static class MapperSender
    implements Sender {
        protected final GridIoManager io;
        protected final Map<Object, Short> compactIdByConsId;
        protected final Map<Short, UUID> nodeIdMap;

        public MapperSender(GridIoManager io, Map<Object, Short> compactIdByConsId, Map<Short, UUID> nodeIdMap) {
            this.io = io;
            this.compactIdByConsId = compactIdByConsId;
            this.nodeIdMap = nodeIdMap;
        }

        @Override
        public void sendRequest(Object curCId, @NotNull Message req) throws IgniteCheckedException {
            Short compConstId = this.compactIdByConsId.get(curCId);
            if (compConstId == null) {
                throw new IgniteCheckedException("Node is not present in topology, constId=" + curCId);
            }
            UUID nodeId = this.nodeIdMap.get(compConstId);
            if (nodeId == null) {
                throw new IgniteCheckedException("Node is not present in topology, constId=" + curCId);
            }
            this.io.sendToGridTopic(nodeId, GridTopic.TOPIC_SNAPSHOT, req, (byte)2);
        }
    }

    protected static class MultiWalApplyPredicate {
        private final ConcurrentHashMap<T2<Integer, Integer>, String> multiApplyMap = new ConcurrentHashMap();

        protected MultiWalApplyPredicate() {
        }

        public boolean apply(DataEntry entry) {
            String threadName = Thread.currentThread().getName();
            int cacheId = entry.cacheId();
            int partId = entry.partitionId();
            String threadOwner = this.multiApplyMap.putIfAbsent((T2<Integer, Integer>)new T2((Object)cacheId, (Object)partId), threadName);
            return threadOwner == null || threadOwner.equals(threadName);
        }
    }
}

