/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRLocalFolderRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRParameters;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContextFactory;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRSharedFolderRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryMessageWrapper;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.txdr.recovery.PITRReplicationRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.txdr.recovery.PITRReplicationRecoveryParameters;
import org.jetbrains.annotations.Nullable;

public class PITRFolderRecoveryContextFactory
implements PITRRecoveryContextFactory {
    protected final IgniteLogger log;
    protected final GridKernalContext ctx;
    private final Object locNodeConstId;
    private final BlockingQueue<RecoveryMessageWrapper> queue;

    public PITRFolderRecoveryContextFactory(IgniteLogger log, GridKernalContext ctx, Object locNodeConstId, BlockingQueue<RecoveryMessageWrapper> queue) {
        this.log = log;
        this.ctx = ctx;
        this.locNodeConstId = locNodeConstId;
        this.queue = queue;
    }

    @Override
    @Nullable
    public PITRRecoveryContext build(PITRParameters params) throws IgniteCheckedException {
        assert (params.topologyVersion() != null);
        assert (params.time() > 0L);
        if (params instanceof PITRReplicationRecoveryParameters) {
            return this.createReplicationRecoveryContext((PITRReplicationRecoveryParameters)params);
        }
        assert (params.snapshotId() > 0L);
        assert (!F.isEmpty((Collection)params.caches()));
        assert (params.metadata() != null);
        if (params.strategy() == SnapshotRestoreStrategy.RESTORE_LOCAL_PARTITIONS || params.localSnapshot() != null && params.localSnapshot().booleanValue()) {
            return this.createLocalFolderRecoveryContext(params);
        }
        return this.createSharedFolderRecoveryContext(params);
    }

    private static Map<Object, Map<Integer, Set<Integer>>> partsToRestore(SnapshotMetadataV2 meta, Set<Object> costIdsToRestore) {
        HashMap<String, Object> cIds = new HashMap<String, Object>();
        for (Object cId : costIdsToRestore) {
            cIds.put(U.maskForFileName((CharSequence)cId.toString()), cId);
        }
        HashMap<Object, Map<Integer, Set<Integer>>> res = new HashMap<Object, Map<Integer, Set<Integer>>>();
        for (Map.Entry e : meta.cacheGroupsMetadata().entrySet()) {
            Integer grpId = (Integer)e.getKey();
            for (Map.Entry e0 : ((CacheSnapshotMetadata)e.getValue()).partitionSizesPerNode().entrySet()) {
                Integer partId = (Integer)e0.getKey();
                for (Map.Entry e1 : cIds.entrySet()) {
                    HashSet<Integer> partitions;
                    String cIdMasked = (String)e1.getKey();
                    Integer cnt = (Integer)((Map)e0.getValue()).get(cIdMasked);
                    if (cnt == null) continue;
                    Object cId = e1.getValue();
                    HashMap<Integer, HashSet<Integer>> grp2Parts = (HashMap<Integer, HashSet<Integer>>)res.get(cId);
                    if (grp2Parts == null) {
                        grp2Parts = new HashMap<Integer, HashSet<Integer>>();
                        res.put(cId, grp2Parts);
                    }
                    if ((partitions = (HashSet<Integer>)grp2Parts.get(grpId)) == null) {
                        partitions = new HashSet<Integer>();
                        grp2Parts.put(grpId, partitions);
                    }
                    partitions.add(partId);
                }
            }
        }
        return res;
    }

    private PITRReplicationRecoveryContext createReplicationRecoveryContext(PITRReplicationRecoveryParameters params) {
        return new PITRReplicationRecoveryContext(this.ctx, this.locNodeConstId, params.aliveNodes(), params.topologyVersion(), params.time(), params.lastAppliedCut());
    }

    private PITRLocalFolderRecoveryContext createLocalFolderRecoveryContext(PITRParameters params) {
        SnapshotRestoreStrategy stgy = params.strategy();
        if (stgy != SnapshotRestoreStrategy.RESTORE_LOCAL_PARTITIONS) {
            this.log.warning("Recovery will be from a local snapshot for strategy: " + stgy);
        }
        BaselineTopology snpBlt = params.metadata().baselineTopology();
        assert (snpBlt != null);
        if (snpBlt.consistentIds().contains(this.locNodeConstId)) {
            return new PITRLocalFolderRecoveryContext(this.log, params.snapshotId(), params.snapshotDirectory(), params.time(), this.ctx, snpBlt, params.metadata(), this.locNodeConstId, params.topologyVersion());
        }
        return null;
    }

    private PITRSharedFolderRecoveryContext createSharedFolderRecoveryContext(PITRParameters params) throws IgniteCheckedException {
        if (F.isEmpty((Collection)params.localConsistentIds())) {
            throw new IgniteCheckedException("Shared folder is not specific.");
        }
        Map<Object, Map<Integer, Set<Integer>>> partsToRestore = PITRFolderRecoveryContextFactory.partsToRestore(params.metadata(), params.localConsistentIds());
        return new PITRSharedFolderRecoveryContext(this.log, params.snapshotId(), params.time(), this.ctx, params.metadata(), this.locNodeConstId, params.topologyVersion(), partsToRestore, params.oldNodeConsistentIdMappingOnActualConsistentId(), params.snapshotDirectory(), this.queue, params.recoveryId());
    }
}

