/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.messages;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class ChunkOfWorkInProgressMessage
implements Message {
    private static final long serialVersionUID = 0L;
    private IgniteUuid operationId;
    private String consistentId;
    private byte[] finishedWork;
    private byte[] workInProgress;

    public ChunkOfWorkInProgressMessage() {
    }

    public ChunkOfWorkInProgressMessage(IgniteUuid operationId, String consistentId, byte[] finishedWork, byte[] workInProgress) {
        this.operationId = operationId;
        this.consistentId = consistentId;
        this.finishedWork = finishedWork;
        this.workInProgress = workInProgress;
    }

    public IgniteUuid operationId() {
        return this.operationId;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public byte[] finishedWork() {
        return this.finishedWork;
    }

    public byte[] workInProgress() {
        return this.workInProgress;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeString("consistentId", this.consistentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByteArray("finishedWork", this.finishedWork)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeIgniteUuid("operationId", this.operationId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("workInProgress", this.workInProgress)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.consistentId = reader.readString("consistentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.finishedWork = reader.readByteArray("finishedWork");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.operationId = reader.readIgniteUuid("operationId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.workInProgress = reader.readByteArray("workInProgress");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ChunkOfWorkInProgressMessage.class);
    }

    public short directType() {
        return 2064;
    }

    public byte fieldsCount() {
        return 4;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return "ChunkOfWorkInProgressMessage{operationId=" + this.operationId + ", consistentId='" + this.consistentId + '\'' + ", finishedWork=" + Arrays.toString(this.finishedWork) + ", workInProgress=" + Arrays.toString(this.workInProgress) + '}';
    }
}

