/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnasphotListTaskResult;
import org.gridgain.grid.internal.processors.cache.database.SnapshotCompatibilityJob;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutMeta;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInfoEssential;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.jetbrains.annotations.Nullable;

@GridInternal
@ComputeTaskNoResultCache
public class CollectSnapshotListTask
extends SnapshotTaskBase<Void, CollectSnasphotListTaskResult> {
    private static final long serialVersionUID = 0L;
    private final Map<Long, SnapshotInfoEssential> res = new ConcurrentHashMap<Long, SnapshotInfoEssential>();

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) throws IgniteException {
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        Map<ComputeJob, ClusterNode> jobs = nodes.stream().filter(n -> !n.isClient() && !n.isDaemon()).collect(Collectors.toMap(n -> new CollectSnapshotListJobV3(), Function.identity()));
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Sending CollectSnasphotListJob [nodesCount=" + jobs.size() + "]");
        }
        return jobs;
    }

    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
        if (res.getException() != null) {
            return super.result(res, rcvd);
        }
        Object data = res.getData();
        if (data instanceof byte[]) {
            try {
                data = new JdkMarshaller().unmarshal((byte[])data, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to deserialize job execution result", (Throwable)e);
            }
        }
        if (data instanceof Collection) {
            for (Object d : (Collection)data) {
                assert (d instanceof SnapshotInfoEssential) : "Unexpected type of snapshot info [class=" + d.getClass().getName() + ", info=" + d + ']';
                SnapshotInfoEssential info = (SnapshotInfoEssential)d;
                this.res.merge(info.snapshotId(), info, (info1, info2) -> {
                    Set cacheNames = info1.cacheNames();
                    cacheNames.addAll(info2.cacheNames());
                    HashSet versions = new HashSet();
                    versions.addAll(info1.clusterNodesVersions());
                    versions.addAll(info2.clusterNodesVersions());
                    HashMap cutTimestamps = new HashMap();
                    cutTimestamps.putAll(info1.clusterCutTimestamps());
                    cutTimestamps.putAll(info2.clusterCutTimestamps());
                    return new SnapshotInfoEssential(info1.snapshotId(), info1.fullSnapshot(), info1.initiatorNode(), cacheNames, info1.message(), info1.serverNodeCount(), info1.baselineTopologySize(), info1.snapshotAttributes(), info1.compressionOption(), info1.compressionLevel(), info1.size() + info2.size(), info1.walSize() + info2.walSize(), versions, cutTimestamps);
                });
            }
        }
        return ComputeJobResultPolicy.WAIT;
    }

    public CollectSnasphotListTaskResult reduce(List<ComputeJobResult> results) throws IgniteException {
        return new CollectSnasphotListTaskResult(this.res);
    }

    @Nullable
    private static List<SnapshotInfoEssential> listSnapshots(Ignite ignite) {
        IgniteCacheSnapshotManager dbMgr = ((IgniteEx)ignite).context().cache().context().snapshot();
        if (!(dbMgr instanceof GridCacheSnapshotManager)) {
            return null;
        }
        IgniteLogger log = ignite.log().getLogger(CollectSnapshotListTask.class);
        if (log != null && log.isInfoEnabled()) {
            log.info("Starting CollectSnapshotListJob");
        }
        try {
            GridCacheSnapshotManager ggSnapshotMgr = (GridCacheSnapshotManager)dbMgr;
            Iterator metaIt = ggSnapshotMgr.snapshotSpi().localSnapshots(true).iterator();
            SnapshotMetadataV2 curr = metaIt.hasNext() ? (SnapshotMetadataV2)metaIt.next() : null;
            SnapshotMetadataV2 next = metaIt.hasNext() ? (SnapshotMetadataV2)metaIt.next() : null;
            ArrayList<SnapshotInfoEssential> infos = new ArrayList<SnapshotInfoEssential>();
            while (curr != null) {
                long snapshotId = curr.id();
                if (!curr.isCorrect()) {
                    U.warn((IgniteLogger)log, (Object)("Metadata is broken for snapshotId = " + snapshotId + ", meta = " + curr));
                } else {
                    infos.add(new SnapshotInfoEssential(snapshotId, curr.fullSnapshot(), curr.initiatorNodeId(), curr.cacheNames(), curr.message(), curr.topology().size(), curr.baselineTopology() != null ? curr.baselineTopology().size() : -1, Collections.singletonMap(ignite.configuration().getConsistentId(), Collections.singletonMap("SNAPSHOT_DIR", "<LOCAL>")), curr.compressionOption(), curr.compressionLevel(), curr.sizeInBytes(), ggSnapshotMgr.localWalSize(curr, next), curr.topology().stream().map(ClusterNode::version).collect(Collectors.toSet()), curr.consistentCutMetas().entrySet().stream().collect(Collectors.toMap(k -> (Short)k.getKey(), v -> ((ConsistentCutMeta)v.getValue()).cutPtrTime()))));
                }
                curr = next;
                next = metaIt.hasNext() ? (SnapshotMetadataV2)metaIt.next() : null;
            }
            if (log != null && log.isInfoEnabled()) {
                log.info("CollectSnapshotListJob: Finished reading list of snapshots from local store, valid snapshots [size = " + infos.size() + "]");
            }
            return infos;
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)log, (Object)"Exception in CollectSnapshotListJob", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    @GridInternal
    private static class CollectSnapshotListJobV3
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;

        private CollectSnapshotListJobV3() {
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotListTask.listSnapshots(this.ignite);
        }
    }
}

