/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskNoResultCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTask;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResult;
import org.gridgain.grid.internal.processors.cache.database.CollectSnapshotInfoTaskResultV2;
import org.gridgain.grid.internal.processors.cache.database.SnapshotCompatibilityJob;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotRemotePath;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CollectSnapshotInfoTaskV2
extends SnapshotTaskBase<CollectSnapshotInfoTaskV2Params, CollectSnapshotInfoTaskResultV2> {
    private static final long serialVersionUID = 0L;

    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, CollectSnapshotInfoTaskV2Params p) throws IgniteException {
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        Map<ComputeJob, ClusterNode> jobs = nodes.stream().filter(n -> !n.isClient() && !n.isDaemon()).collect(Collectors.toMap(n -> new CollectShortSnapshotInfoCompatibleJob(p.snapshotId, p.optSearchPaths, null), Function.identity()));
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Sent CollectSnapshotInfoJob to " + jobs.size() + " nodes");
        }
        return jobs;
    }

    @Nullable
    public CollectSnapshotInfoTaskResultV2 reduce(List<ComputeJobResult> results) throws IgniteException {
        IgniteLogger log = this.getLog();
        if (log != null && log.isInfoEnabled()) {
            log.info("Starting reducing CollectSnapshotInfoTaskResult, count = " + results.size());
        }
        CollectSnapshotInfoTaskResultV2 taskRes = null;
        JdkMarshaller jdkMarshaller = new JdkMarshaller();
        for (ComputeJobResult result : results) {
            Object data0;
            block7: {
                data0 = result.getData();
                try {
                    if (!(data0 instanceof byte[])) break block7;
                    data0 = jdkMarshaller.unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)("Failed to deserialize job execution result (will skip the node): " + U.toShortString((ClusterNode)result.getNode())), (Throwable)e);
                    continue;
                }
            }
            if (!(data0 instanceof CollectSnapshotInfoTaskResultV2)) {
                throw new AssertionError((Object)("Not expected class was received : " + data0.getClass().getName()));
            }
            CollectSnapshotInfoTaskResultV2 data = (CollectSnapshotInfoTaskResultV2)data0;
            if (taskRes == null) {
                taskRes = data;
                continue;
            }
            taskRes.merge(data);
        }
        if (log != null) {
            log.info("Finished reducing CollectSnapshotInfoTaskResult");
        }
        return taskRes;
    }

    public static class CollectSnapshotInfoTaskV2Params
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private long snapshotId;
        @Nullable
        private Collection<SnapshotRemotePath> optSearchPaths;

        public CollectSnapshotInfoTaskV2Params() {
        }

        public CollectSnapshotInfoTaskV2Params(long snapshotId, @Nullable Collection<SnapshotRemotePath> optSearchPaths) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
        }

        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeLong(this.snapshotId);
            out.writeObject(this.optSearchPaths);
        }

        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.snapshotId = in.readLong();
            this.optSearchPaths = (Collection)in.readObject();
        }
    }

    @GridInternal
    private static class CollectShortSnapshotInfoCompatibleJob
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        @Nullable
        private final Collection<SnapshotRemotePath> optSearchPaths;
        @Nullable
        private final IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
        private final long snapshotId;

        private CollectShortSnapshotInfoCompatibleJob(long snapshotId, @Nullable Collection<SnapshotRemotePath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotInfoTask.collectShortSnapshotInfo(this.ignite, this.optSearchPaths, this.c, this.snapshotId);
        }
    }

    @GridInternal
    private static class CollectFullSnapshotInfoCompatibleJob
    extends SnapshotCompatibilityJob {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected Ignite ignite;
        @Nullable
        private Collection<SnapshotRemotePath> optSearchPaths;
        @Nullable
        private IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;
        private final long snapshotId;

        private CollectFullSnapshotInfoCompatibleJob(long snapshotId, @Nullable Collection<SnapshotRemotePath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
        }

        @Override
        @Nullable
        public Object executeCompatible() throws IgniteException {
            return CollectSnapshotInfoTask.collectFullSnapshotInfo(this.ignite, this.optSearchPaths, this.c, this.snapshotId, true, false);
        }
    }

    public static class CollectSnapshotDescriptorTaskParams
    extends IgniteDataTransferObject {
        private static final long serialVersionUID = 0L;
        private long snapshotId;
        @Nullable
        private Collection<SnapshotRemotePath> optSearchPaths;
        @Nullable
        private Set<UUID> nodes;
        private int spins;
        @Nullable
        private IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c;

        public CollectSnapshotDescriptorTaskParams() {
        }

        public CollectSnapshotDescriptorTaskParams(long snapshotId, @Nullable Collection<SnapshotRemotePath> optSearchPaths, @Nullable IgniteBiClosure<String, CacheConfiguration, CacheConfiguration> c, @Nullable Set<UUID> nodes, int spins) {
            this.snapshotId = snapshotId;
            this.optSearchPaths = optSearchPaths;
            this.c = c;
            this.nodes = nodes;
            this.spins = spins;
        }

        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeLong(this.snapshotId);
            out.writeObject(this.optSearchPaths);
            out.writeObject(this.c);
            out.writeObject(this.nodes);
            out.writeInt(this.spins);
        }

        protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
            this.snapshotId = in.readLong();
            this.optSearchPaths = (Collection)in.readObject();
            this.c = (IgniteBiClosure)in.readObject();
            this.nodes = (Set)in.readObject();
            this.spins = in.readInt();
        }
    }

    @ComputeTaskNoResultCache
    public static class CollectSnapshotDescriptorTask
    extends SnapshotTaskBase<CollectSnapshotDescriptorTaskParams, CollectSnapshotInfoTask.SnapshotDescriptorOptional> {
        private static final long serialVersionUID = 0L;
        private final CollectSnapshotInfoTask.SnapshotDescriptorOptional taskRes = new CollectSnapshotInfoTask.SnapshotDescriptorOptional();

        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, CollectSnapshotDescriptorTaskParams p) throws IgniteException {
            HashSet<UUID> respondedNodes = p.nodes == null ? new HashSet() : p.nodes;
            Integer maxNodes = p.spins;
            Map<ComputeJob, ClusterNode> jobs = CollectSnapshotInfoTask.calculateTaskSubgrid(subgrid, respondedNodes, maxNodes).stream().collect(Collectors.toMap(n -> new CollectFullSnapshotInfoCompatibleJob(p.snapshotId, p.optSearchPaths, p.c), Function.identity()));
            IgniteLogger log = this.getLog();
            if (log != null && log.isInfoEnabled()) {
                log.info("Send CollectSnapshotInfoJob on " + jobs.size() + " nodes");
            }
            return jobs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) throws IgniteException {
            CollectSnapshotInfoTaskResult data;
            if (res.getException() != null) {
                return super.result(res, rcvd);
            }
            JdkMarshaller jdkMarshaller = new JdkMarshaller();
            IgniteLogger log = this.getLog();
            Object data0 = res.getData();
            if (data0 instanceof byte[]) {
                try {
                    data = (CollectSnapshotInfoTaskResult)jdkMarshaller.unmarshal((byte[])data0, U.resolveClassLoader((IgniteConfiguration)this.ignite.configuration()));
                }
                catch (IgniteCheckedException e) {
                    U.error((IgniteLogger)log, (Object)("Failed to deserialize job execution result (will skip the node): " + U.toShortString((ClusterNode)res.getNode())), (Throwable)e);
                    return ComputeJobResultPolicy.WAIT;
                }
            } else {
                data = (CollectSnapshotInfoTaskResult)data0;
            }
            CollectSnapshotInfoTask.SnapshotDescriptorOptional e = this.taskRes;
            synchronized (e) {
                if (!this.taskRes.isPresent() && log != null && log.isInfoEnabled()) {
                    log.info("Starting reducing CollectSnapshotInfoTaskResult");
                }
            }
            if (data == null || data.descriptorForNode().isEmpty()) {
                this.taskRes.reportMissOnNode(res.getNode().id());
            } else {
                try {
                    for (Map.Entry entry : data.descriptorForNode().entrySet()) {
                        this.taskRes.merge((SnapshotDescriptor)entry.getValue());
                    }
                }
                catch (IgniteCheckedException e2) {
                    throw new IgniteException((Throwable)e2);
                }
            }
            return ComputeJobResultPolicy.WAIT;
        }

        public CollectSnapshotInfoTask.SnapshotDescriptorOptional reduce(List<ComputeJobResult> results) throws IgniteException {
            IgniteLogger log = this.getLog();
            if (log != null && log.isInfoEnabled()) {
                log.info("Finished reducing CollectSnapshotDescriptorTask");
            }
            return this.taskRes;
        }
    }
}

