/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp;

import com.jcraft.jsch.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.sftp.SftpFileNameParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp.SftpClientFactory;
import org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp.SftpFileSystem;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    private static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.RANDOM_ACCESS_READ, Capability.APPEND_CONTENT));

    private static Session createSession(GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)fileSystemOptions, (UserAuthenticationData.Type[])AUTHENTICATOR_TYPES);
            Session session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)rootName.getUserName())), UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)rootName.getPassword())), fileSystemOptions);
            return session;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)rootName, (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        }
    }

    public SftpFileProvider() {
        this.setFileNameParser(SftpFileNameParser.getInstance());
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new SftpFileSystem((GenericFileName)name, SftpFileProvider.createSession((GenericFileName)name, fileSystemOptions), fileSystemOptions);
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return SftpFileSystemConfigBuilder.getInstance();
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

