/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.config.GridTestProperties;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.copy.CopyStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.CopyFileVisitorTest;
import org.gridgain.grid.persistentstore.snapshot.file.copy.TwoPhaseFilesCopyStrategy;

public class InterruptibleCopyStrategyTest
extends TestCase {
    private static final Random RANDOM = new Random();
    private static final String FAST_FILE_NAME = "part-1.bin";
    private static final int ORIGIN_FILE_SIZE = 1048576000;
    private static File srcFatFileFolder;
    private static File targetFolder;
    private IgniteLogger log;

    protected void setUp() throws Exception {
        srcFatFileFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("fatFileTmp/" + CopyFileVisitorTest.class.getSimpleName() + "/src"), (boolean)true);
        targetFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("fatFileTmp/" + CopyFileVisitorTest.class.getSimpleName() + "/dest"), (boolean)true);
        byte[] buf = new byte[0x100000];
        Path path = srcFatFileFolder.toPath().resolve(FAST_FILE_NAME);
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.CREATE);){
            for (int rem = 1048576000; rem > 0; rem -= buf.length) {
                RANDOM.nextBytes(buf);
                out.write(buf, 0, Math.min(rem, buf.length));
            }
        }
        GridTestProperties.init();
        this.log = new GridTestLog4jLogger();
    }

    protected void tearDown() throws Exception {
        InterruptibleCopyStrategyTest.assertTrue((boolean)srcFatFileFolder.toPath().resolve(FAST_FILE_NAME).toFile().exists());
        FileUtils.deleteDirectory((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"fatFileTmp", (boolean)false));
    }

    public void testFatFileCopyInterruptible() throws Exception {
        System.setProperty("GG_COPY_NOT_INTERRUPTIBLE_INTERVAL", "300");
        IgniteInternalFuture fut = this.copyFileAndCancel();
        try {
            fut.get(1000L);
            InterruptibleCopyStrategyTest.fail((String)"Failed to cancel operation.");
        }
        catch (IgniteCheckedException ex) {
            if (X.hasCause((Throwable)ex, (Class[])new Class[]{FileSystemException.class})) {
                InterruptibleCopyStrategyTest.assertTrue((!Files.exists(targetFolder.toPath().resolve(FAST_FILE_NAME), new LinkOption[0]) || Files.size(targetFolder.toPath().resolve(FAST_FILE_NAME)) < 1048576000L ? 1 : 0) != 0);
                this.log.error("Catched error: ", (Throwable)ex);
            }
            this.log.error("Exception on cancellation copy file.", (Throwable)ex);
            InterruptibleCopyStrategyTest.fail((String)("Exception on cancellation copy file err= " + ex.getMessage()));
        }
    }

    private CopyStrategy createCopyStrategy(boolean onlyIfNotExists) {
        return new TwoPhaseFilesCopyStrategy(onlyIfNotExists, this.log);
    }

    private IgniteInternalFuture copyFileAndCancel() throws Exception {
        CopyStrategy cpStgy = this.createCopyStrategy(true);
        CountDownLatch latch = new CountDownLatch(1);
        IgniteInternalFuture fut = GridTestUtils.runAsync(() -> {
            try {
                latch.countDown();
                cpStgy.copy(srcFatFileFolder.toPath().resolve(FAST_FILE_NAME), (SnapshotPath)new FsSnapshotPath(targetFolder));
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new IgniteException((Throwable)e);
            }
        });
        latch.await();
        long startTime = System.currentTimeMillis();
        fut.cancel();
        InterruptibleCopyStrategyTest.assertTrue((System.currentTimeMillis() - startTime < 1000L ? 1 : 0) != 0);
        return fut;
    }
}

