/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.copy.CopyStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.CopyFileVisitor;
import org.gridgain.grid.persistentstore.snapshot.file.copy.TwoPhaseFilesCopyStrategy;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CopyFileVisitorTest
extends TestCase {
    private static final Random RANDOM = new Random();
    private File srcFolder;
    private File targetFolder;
    private IgniteLogger logger;
    private byte[] fileContent;
    private static ExecutorService snapshotCpExecutorSrvc;

    protected void setUp() throws Exception {
        this.srcFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("tmp/" + CopyFileVisitorTest.class.getSimpleName() + "/src"), (boolean)true);
        U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("tmp/" + CopyFileVisitorTest.class.getSimpleName() + "/src/parts"), (boolean)true);
        this.targetFolder = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)("tmp/" + CopyFileVisitorTest.class.getSimpleName() + "/target"), (boolean)true);
        this.logger = (IgniteLogger)Mockito.mock(IgniteLogger.class);
        this.fileContent = new byte[20];
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("parts/part-1.bin"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("parts/part-2.bin"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("parts/part-1.bin.zip"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("parts/somefile"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("index.bin"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("somefile"), this.fileContent, StandardOpenOption.CREATE);
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("index.bin.zip"), this.fileContent, StandardOpenOption.CREATE);
        snapshotCpExecutorSrvc = Executors.newSingleThreadExecutor((ThreadFactory)new IgniteThreadFactory("test", "db-snapshot-copy-executor"));
    }

    protected void tearDown() throws Exception {
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("parts/part-1.bin").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("parts/part-2.bin").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("parts/part-1.bin.zip").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("parts/somefile").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("index.bin").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("somefile").toFile().exists());
        CopyFileVisitorTest.assertTrue((boolean)this.srcFolder.toPath().resolve("index.bin.zip").toFile().exists());
        FileUtils.deleteDirectory((File)this.srcFolder);
        FileUtils.deleteDirectory((File)this.targetFolder);
        snapshotCpExecutorSrvc.shutdownNow();
    }

    public void testRevisitFileOnlyIfNotExists() throws IOException {
        SnapshotOperationContext context = (SnapshotOperationContext)Mockito.mock(SnapshotOperationContext.class);
        ((SnapshotOperationContext)Mockito.doReturn((Object)false).when((Object)context)).isCancelled();
        FsSnapshotPath targetSnapshotPath = new FsSnapshotPath(this.targetFolder);
        CopyFileVisitor copyFileVisitor = new CopyFileVisitor(this.srcFolder.toPath(), (SnapshotPath)targetSnapshotPath, context, (CopyStrategy)new TwoPhaseFilesCopyStrategy(true, this.logger), Runnable::run);
        Files.walkFileTree(this.srcFolder.toPath(), (FileVisitor<? super Path>)copyFileVisitor);
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-1.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-2.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "index.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-1.bin.zip").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "index.bin.zip").exists());
        ((SnapshotOperationContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)5))).reportWork(Matchers.eq((long)20L));
        Files.walkFileTree(this.srcFolder.toPath(), (FileVisitor<? super Path>)copyFileVisitor);
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-1.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-2.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "index.bin").exists());
        CopyFileVisitorTest.assertFalse((boolean)new File(this.targetFolder, "somefile").exists());
        CopyFileVisitorTest.assertFalse((boolean)new File(this.targetFolder, "parts/somefile").exists());
        ((SnapshotOperationContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)10))).reportWork(Matchers.eq((long)20L));
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-1.bin").delete());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "index.bin").delete());
        RANDOM.nextBytes(this.fileContent);
        Files.write(this.srcFolder.toPath().resolve("parts/part-1.bin"), this.fileContent, StandardOpenOption.CREATE);
        Files.walkFileTree(this.srcFolder.toPath(), (FileVisitor<? super Path>)copyFileVisitor);
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-1.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "parts/part-2.bin").exists());
        CopyFileVisitorTest.assertTrue((boolean)new File(this.targetFolder, "index.bin").exists());
        CopyFileVisitorTest.assertFalse((boolean)new File(this.targetFolder, "somefile").exists());
        CopyFileVisitorTest.assertFalse((boolean)new File(this.targetFolder, "parts/somefile").exists());
        ((SnapshotOperationContext)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)15))).reportWork(Matchers.eq((long)20L));
    }
}

