/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.database.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class VisorSnapshotInfoTest
extends TestCase {
    public void testVisorSnapshotInfoCreationFromSnapshotOperationInfoWithMapExtraParam() {
        HashMap<String, Object> extraParam = new HashMap<String, Object>();
        extraParam.put("SNAPSHOT_CREATE_PARAMETERS", new SnapshotCreateParameters(CompressionOption.ZIP, 1, 0));
        extraParam.put("FULL_SNAPSHOT", true);
        extraParam.put("SNAPSHOT_COMMON_PARAMETERS_KEY", new SnapshotCommonParameters(3));
        VisorSnapshotInfo info = VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)this.getSnapshotOperationWithExtraParam(extraParam)).build();
        VisorSnapshotInfoTest.assertEquals((long)1L, (long)info.getSnapshotId());
        VisorSnapshotInfoTest.assertEquals((Object)SnapshotOperationType.CREATE, (Object)info.getOperationType());
        VisorSnapshotInfoTest.assertTrue((boolean)info.isFullSnapshot());
        VisorSnapshotInfoTest.assertTrue((boolean)info.isSkipCrc());
        VisorSnapshotInfoTest.assertEquals((int)2, (int)info.getCacheNames().size());
        VisorSnapshotInfoTest.assertEquals((String)"Message", (String)info.getMessage());
        VisorSnapshotInfoTest.assertEquals((Object)UUID.fromString("b-b-b-b-b"), (Object)info.getInitiatorNodeId());
        VisorSnapshotInfoTest.assertEquals((int)0, (int)info.getClusterSize());
        VisorSnapshotInfoTest.assertEquals((int)-1, (int)info.getBaselineTopologySize());
        VisorSnapshotInfoTest.assertNull((Object)info.getClusterNodes());
        VisorSnapshotInfoTest.assertNull((Object)info.getSnapshotAttributes((Object)"1"));
        VisorSnapshotInfoTest.assertNull((Object)info.getPreviousSnapshots());
        SnapshotCommonParameters snapshotCommonParameters = info.getSnapshotCommonParameters();
        VisorSnapshotInfoTest.assertEquals((int)3, (int)snapshotCommonParameters.getSnapshotOperationParallelism());
        SnapshotCreateParameters actualSnapshotCreateParams = info.getSnapshotCreateParameters();
        VisorSnapshotInfoTest.assertEquals((int)1, (int)actualSnapshotCreateParams.getCompressionLevel());
        VisorSnapshotInfoTest.assertEquals((Object)CompressionOption.ZIP, (Object)actualSnapshotCreateParams.getCompressionOption());
    }

    public void testVisorSnapshotInfoCreationFromSnapshotOperationInfoWithBooleanExtraParam() {
        VisorSnapshotInfo info = VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)this.getSnapshotOperationWithExtraParam(true)).build();
        SnapshotCreateParameters actualSnapshotCreateParams = info.getSnapshotCreateParameters();
        VisorSnapshotInfoTest.assertEquals((int)-1, (int)actualSnapshotCreateParams.getCompressionLevel());
        VisorSnapshotInfoTest.assertEquals((Object)CompressionOption.NONE, (Object)actualSnapshotCreateParams.getCompressionOption());
    }

    public void testVisorSnapshotInfoCreationFromSnapshotOperationInfoWithTupleExtraParam() {
        VisorSnapshotInfo info = VisorSnapshotInfo.Builder.fromSnapshotOperationInfo((SnapshotOperationInfoImpl)this.getSnapshotOperationWithExtraParam(new T2((Object)false, (Object)false))).build();
        SnapshotCreateParameters actualSnapshotCreateParams = info.getSnapshotCreateParameters();
        VisorSnapshotInfoTest.assertNull((Object)actualSnapshotCreateParams);
    }

    public void testReadWriteNullCacheCfgs() throws Exception {
        VisorSnapshotInfoTest.checkReadWriteCacheConfigurations(null);
    }

    public void testReadWriteSmallCacheCfgs() throws Exception {
        VisorSnapshotInfoTest.checkReadWriteCacheConfigurations("small");
    }

    public void testReadWriteNotLongCacheCfgs() throws Exception {
        VisorSnapshotInfoTest.checkReadWriteCacheConfigurations(GridTestUtils.nCopiesOfChar((int)21845, (char)'0'));
    }

    public void testReadWriteLongCacheCfgs() throws Exception {
        VisorSnapshotInfoTest.checkReadWriteCacheConfigurations(GridTestUtils.nCopiesOfChar((int)65536, (char)'1'));
    }

    private static void checkReadWriteCacheConfigurations(@Nullable String cacheCfgs) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            VisorSnapshotInfo info = new VisorSnapshotInfo.Builder().withCacheConfigurations(cacheCfgs).build();
            oos.writeObject(info);
            oos.flush();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                VisorSnapshotInfo readInfo = (VisorSnapshotInfo)ois.readObject();
                VisorSnapshotInfoTest.assertEquals((String)cacheCfgs, (String)readInfo.getCacheConfigs());
            }
        }
    }

    private SnapshotOperationInfoImpl getSnapshotOperationWithExtraParam(Object extraParam) {
        LinkedHashSet<String> cacheNames = new LinkedHashSet<String>();
        cacheNames.add("cache1");
        cacheNames.add("cache2");
        LinkedHashSet<Integer> cacheGrpIds = new LinkedHashSet<Integer>();
        cacheGrpIds.add(1);
        cacheGrpIds.add(2);
        GridSnapshotOperationImpl gridOperation = new GridSnapshotOperationImpl(SnapshotOperationType.CREATE, 1L, cacheGrpIds, cacheNames, "Message", extraParam, null, null, null);
        return new SnapshotOperationInfoImpl(IgniteUuid.fromUuid((UUID)UUID.fromString("a-a-a-a-a")), (GridSnapshotOperationEx)gridOperation, UUID.fromString("b-b-b-b-b"), new AffinityTopologyVersion(1L), Collections.emptyList());
    }
}

