/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.GridByteArrayInputStream;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class VisorDataTransferObjectsTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVisorSnapshotInfoSerialization() throws Exception {
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            Reflections reflections = new Reflections("org.gridgain", new Scanner[0]);
            Set allClasses = reflections.getSubTypesOf(VisorDataTransferObject.class);
            String bigUTF = IntStream.range(0, 65536).map(i -> i % 65535).mapToObj(i -> String.valueOf((char)i)).collect(Collectors.joining());
            AtomicInteger utfBytes = new AtomicInteger();
            String cutStr = bigUTF.chars().filter(c -> utfBytes.addAndGet(U.utfBytes((char)((char)c))) <= 65535).mapToObj(c -> String.valueOf((char)c)).collect(Collectors.joining());
            for (Class clazz : allClasses) {
                Field[] strFields;
                VisorDataTransferObject instance = (VisorDataTransferObject)clazz.newInstance();
                GridByteArrayOutputStream bos = new GridByteArrayOutputStream();
                oos = new ObjectOutputStream((OutputStream)bos);
                for (Field strField : strFields = this.fieldByType(clazz, String.class)) {
                    strField.set(instance, bigUTF);
                }
                oos.writeObject(instance);
                GridByteArrayInputStream bis = new GridByteArrayInputStream(bos.internalArray());
                ois = new ObjectInputStream((InputStream)bis);
                VisorDataTransferObject v2 = (VisorDataTransferObject)ois.readObject();
                VisorDataTransferObjectsTest.assertEquals((byte)v2.getProtocolVersion(), (byte)instance.getProtocolVersion());
                for (Field strField : strFields) {
                    VisorDataTransferObjectsTest.assertEquals((Object)cutStr, (Object)strField.get(v2));
                }
                IgniteUtils.closeQuiet((AutoCloseable)oos);
                IgniteUtils.closeQuiet((AutoCloseable)ois);
            }
        }
        finally {
            IgniteUtils.closeQuiet(oos);
            IgniteUtils.closeQuiet(ois);
        }
    }

    private Field[] fieldByType(Class<?> cls, Class<?> type) {
        return (Field[])Stream.of(cls.getDeclaredFields()).filter(field -> type.isAssignableFrom(field.getType())).peek(field -> field.setAccessible(true)).toArray(Field[]::new);
    }
}

