/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.junit.Test;

public class TxDrNodesFailoverTest
extends AbstractReplicationTest {
    private static final long CUT_APPLY_TIMEOUT = 15000L;
    private static final long REBALANCE_TIMEOUT = 10000L;
    private List<IgniteEx> masterCluster;
    private List<IgniteEx> replicaCluster;
    private AtomicLong lastAppliedCut = new AtomicLong();
    private long bootstrapSesId;
    private static final String CUSTOM_MASTER_PREFIX = "master-";
    private static final String CUSTOM_REPLICA_PREFIX = "replica-";

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName, consistentId, role).setAutoActivationEnabled(false);
        if (role != ClusterRole.DISABLED) {
            String namePrefix = role == ClusterRole.MASTER ? CUSTOM_MASTER_PREFIX : CUSTOM_REPLICA_PREFIX;
            cfg.setWorkDirectory(new File(U.defaultWorkDirectory(), namePrefix + consistentId).getAbsolutePath());
        }
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 5;
        this.backupsCnt = 3;
        this.consistentCutInterval = Long.MAX_VALUE;
        this.cleanupLfs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.cleanupLfs();
    }

    @Test
    public void testScenario1() throws Exception {
        this.testLeftNodesAndReturnBack(new int[]{1, 2, 3}, null, false);
    }

    @Test
    public void testScenario2() throws Exception {
        this.testLeftNodesAndReturnBack(null, new int[]{1, 2, 3}, false);
    }

    @Test
    public void testScenario3() throws Exception {
        this.testLeftNodesAndReturnBack(null, new int[]{1, 2, 3}, true);
    }

    @Test
    public void testScenario4() throws Exception {
        this.testLeftNodesAndReturnBack(new int[]{1, 2}, new int[]{2, 3}, false);
    }

    @Test
    public void testScenario5() throws Exception {
        this.bootstrapClusters();
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        long cutId0 = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        this.stopClusterNode(ClusterRole.MASTER, 1);
        this.stopClusterNode(ClusterRole.MASTER, 2);
        this.stopClusterNode(ClusterRole.REPLICA, 3);
        this.stopClusterNode(ClusterRole.REPLICA, 4);
        this.stopTxLoad(fut);
        long cutId1 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId0);
        for (IgniteEx ignite : this.replicaCluster) {
            TxDrNodesFailoverTest.assertEquals((long)cutId0, (long)this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId());
        }
        this.assertLaggingBehindNodes(Collections.emptySet());
        this.startClusterNode(ClusterRole.REPLICA, 4);
        this.waitForApplyingCut(cutId1);
        this.waitForDetectLaggingBehindNodes(new HashSet<Integer>(Arrays.asList(1, 2)));
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.awaitPmeOnReplica();
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    @Test
    public void testScenario6() throws Exception {
        this.testLeftCriticalCountOfMasterNodes(false);
    }

    @Test
    public void testScenario7() throws Exception {
        this.testLeftCriticalCountOfMasterNodes(true);
    }

    @Test
    public void testScenario8() throws Exception {
        this.bootstrapClusters();
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        this.stopClusterNode(ClusterRole.REPLICA, 1, true);
        this.stopClusterNode(ClusterRole.REPLICA, 2, true);
        this.stopClusterNode(ClusterRole.REPLICA, 3, true);
        for (IgniteEx ignite : this.replicaCluster) {
            this.txdr((Ignite)ignite).consistentCutWatcher().stop();
        }
        long cutId0 = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        this.stopClusterNode(ClusterRole.MASTER, 4);
        this.stopTxLoad(fut);
        long cutId1 = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        this.replicaCluster.get(0).cluster().active(false);
        IgniteEx replicaNode1 = this.startClusterNode(ClusterRole.REPLICA, 1);
        IgniteEx replicaNode2 = this.startClusterNode(ClusterRole.REPLICA, 2);
        IgniteEx replicaNode3 = this.startClusterNode(ClusterRole.REPLICA, 3);
        replicaNode1.rebalanceEnabled(false);
        replicaNode2.rebalanceEnabled(false);
        replicaNode3.rebalanceEnabled(false);
        this.replicaCluster.get(0).cluster().active(true);
        this.txdr((Ignite)this.replicaCluster.get(0)).consistentCutWatcher().addAppliedCutsListener((IgniteInClosure & Serializable)ccId -> this.lastAppliedCut.set((long)ccId));
        this.waitForApplyingCut(this.replicaCluster, cutId0, 15000L);
        for (IgniteEx ignite : this.replicaCluster) {
            TxDrNodesFailoverTest.assertEquals((long)cutId0, (long)this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId());
        }
        AffinityTopologyVersion topVerBeforeRebalance = this.replicaCluster.get(0).context().discovery().topologyVersionEx();
        replicaNode1.rebalanceEnabled(true);
        replicaNode2.rebalanceEnabled(true);
        replicaNode3.rebalanceEnabled(true);
        GridTestUtils.waitForCondition(() -> this.masterCluster.get(0).context().discovery().topologyVersionEx().minorTopologyVersion() >= topVerBeforeRebalance.minorTopologyVersion() + 3, (long)10000L);
        this.waitForApplyingCut(cutId1);
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.awaitPmeOnReplica();
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    private void bootstrapClusters() throws Exception {
        this.masterCluster = this.startCluster(ClusterRole.MASTER);
        this.replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        this.populateData((Ignite)this.node(ClusterRole.MASTER), "atomicCache");
        this.bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(this.bootstrapSesId);
        this.txdr((Ignite)this.replicaCluster.get(0)).consistentCutWatcher().addAppliedCutsListener((IgniteInClosure & Serializable)cutId -> this.lastAppliedCut.set((long)cutId));
    }

    private void testLeftNodesAndReturnBack(int[] masterNodesIdx, int[] replicaNodesIdx, boolean cleanLFS) throws Exception {
        this.bootstrapClusters();
        if (masterNodesIdx == null) {
            masterNodesIdx = new int[]{};
        }
        if (replicaNodesIdx == null) {
            replicaNodesIdx = new int[]{};
        }
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        HashSet<Integer> deadOnMaster = new HashSet<Integer>();
        for (int nodeIdx : masterNodesIdx) {
            this.stopClusterNode(ClusterRole.MASTER, nodeIdx, cleanLFS);
            deadOnMaster.add(nodeIdx);
        }
        for (int nodeIdx : replicaNodesIdx) {
            this.stopClusterNode(ClusterRole.REPLICA, nodeIdx, cleanLFS);
            deadOnMaster.remove(nodeIdx);
        }
        this.stopTxLoad(fut);
        cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        this.waitForDetectLaggingBehindNodes(deadOnMaster);
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.awaitPmeOnReplica();
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
        this.txdr(ClusterRole.REPLICA).resume().get();
        fut = this.startTxLoad(2, ClusterRole.MASTER);
        for (int nodeIdx : masterNodesIdx) {
            this.startClusterNode(ClusterRole.MASTER, nodeIdx);
        }
        for (int nodeIdx : replicaNodesIdx) {
            this.startClusterNode(ClusterRole.REPLICA, nodeIdx);
        }
        if (masterNodesIdx.length > 0) {
            GridTestUtils.waitForCondition(() -> this.masterCluster.get(0).context().discovery().topologyVersionEx().minorTopologyVersion() == 1, (long)10000L);
        }
        this.stopTxLoad(fut);
        cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        this.assertLaggingBehindNodes(Collections.emptySet());
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.awaitPmeOnReplica();
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    private void testLeftCriticalCountOfMasterNodes(boolean withPause) throws Exception {
        this.bootstrapClusters();
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId);
        if (withPause) {
            this.txdr((Ignite)this.replicaCluster.get(0)).pause().get();
        }
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        this.stopTxLoad(fut);
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        cutId = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        fut = this.startTxLoad(2, ClusterRole.MASTER);
        this.stopClusterNode(ClusterRole.MASTER, 1);
        this.stopClusterNode(ClusterRole.MASTER, 2);
        this.stopClusterNode(ClusterRole.MASTER, 3);
        this.stopClusterNode(ClusterRole.MASTER, 4);
        this.stopTxLoad(fut);
        if (!withPause) {
            this.waitForApplyingCut(cutId);
        }
        this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.startClusterNode(ClusterRole.MASTER, 1);
        GridTestUtils.waitForCondition(() -> this.masterCluster.get(0).context().discovery().topologyVersionEx().minorTopologyVersion() == 1, (long)10000L);
        this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        if (withPause) {
            this.txdr((Ignite)this.replicaCluster.get(0)).resume().get();
            this.waitForApplyingCut(cutId);
        }
        this.waitForClusterRole(this.replicaCluster, ClusterRole.DISABLED);
        this.assertClusterState(this.replicaCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    @Test
    public void testScenario9() throws Exception {
        this.nodesCnt = 2;
        this.backupsCnt = 2;
        this.clientsCnt = 0;
        this.masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx master = this.masterCluster.get(0);
        master.cluster().active(true);
        master.getOrCreateCache("txCache").put((Object)12, (Object)12);
        this.replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx replica = this.replicaCluster.get(0);
        replica.cluster().active(true);
        long sesId = (Long)TxDrNodesFailoverTest.bootstrapMaster((TransactionalDrMaster)this.txdr((Ignite)master), this.snapshotFolder()).get();
        this.txdr((Ignite)replica).bootstrap(this.snapshotFolder(), sesId).get();
        long createdCutId1 = this.forceConsistentCut((Ignite)master);
        boolean awaited = GridTestUtils.waitForCondition(() -> this.txdr((Ignite)replica).localState().lastSuccessfullyAppliedCutId() >= createdCutId1, (long)15000L);
        TxDrNodesFailoverTest.assertTrue((boolean)awaited);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(replica));
        this.stopClusterNode(ClusterRole.REPLICA, 1, true);
        this.forceConsistentCut((Ignite)master);
        this.startClusterNode(ClusterRole.REPLICA, 1);
        this.awaitPartitionMapExchange(false, false, this.replicaCluster.stream().map(n -> n.cluster().localNode()).collect(Collectors.toList()));
        long createdCutId2 = this.forceConsistentCut((Ignite)master);
        this.txdr((Ignite)master).stop().get();
        awaited = GridTestUtils.waitForCondition(() -> this.txdr((Ignite)replica).localState().lastSuccessfullyAppliedCutId() >= createdCutId2, (long)15000L);
        TxDrNodesFailoverTest.assertTrue((boolean)awaited);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(master));
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(replica));
        IgniteCache masterTxCache = master.cache("txCache");
        IgniteCache masterAtomicCache = master.cache("atomicCache");
        IgniteCache replicaTxCache = replica.cache("txCache");
        IgniteCache replicaAtomicCache = replica.cache("atomicCache");
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterTxCache);
        Map<Integer, Long> dumpMasterAtomic = this.dumpCache((IgniteCache<Integer, Long>)masterAtomicCache);
        awaited = GridTestUtils.waitForCondition(() -> {
            Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaTxCache);
            Map<Integer, Long> dumpReplicaAtomic = this.dumpCache((IgniteCache<Integer, Long>)replicaAtomicCache);
            return dumpMasterTx.equals(dumpReplicaTx) && dumpMasterAtomic.equals(dumpReplicaAtomic);
        }, (long)15000L);
        TxDrNodesFailoverTest.assertTrue((boolean)awaited);
        this.txdr((Ignite)replica).stop().get();
    }

    @Test
    public void testScenario10() throws Exception {
        this.bootstrapClusters();
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId0 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId0);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        this.suspendCutApplying();
        long rmvCutId = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        this.removeWalFile(this.masterCluster.get(0), rmvCutId);
        this.stopTxLoad(fut);
        long cutId1 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.resumeCutApplying();
        this.waitForApplyingCut(cutId1);
        for (IgniteEx ignite : this.replicaCluster) {
            TxDrNodesFailoverTest.assertEquals((String)("Wrong last applied cut id for node " + ignite.name()), (long)(ignite == this.replicaCluster.get(0) ? cutId0 : cutId1), (long)this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId());
        }
        this.txdr((Ignite)this.replicaCluster.get(0)).pause().get();
        this.awaitPmeOnReplica();
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(this.replicaCluster.get(0)));
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)this.replicaCluster.get(0).cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    @Test
    public void testScenario11() throws Exception {
        this.backupsCnt = 1;
        this.bootstrapClusters();
        IgniteInternalFuture fut = this.startTxLoad(2, ClusterRole.MASTER);
        long cutId0 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.waitForApplyingCut(cutId0);
        this.suspendCutApplying();
        long rmvCutId = this.forceConsistentCutAndWaitForWalShipping(this.masterCluster.get(0));
        this.removeWalFile(this.masterCluster.get(2), rmvCutId);
        long cutId1 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        this.resumeCutApplying();
        this.waitForApplyingCut(cutId1);
        IgniteEx failedNode = this.replicaCluster.get(2);
        for (IgniteEx ignite : this.replicaCluster) {
            TxDrNodesFailoverTest.assertEquals((String)("Wrong last applied cut id for node " + ignite.name()), (long)(ignite == failedNode ? cutId0 : cutId1), (long)this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId());
        }
        this.stopClusterNode(ClusterRole.REPLICA, 0);
        this.txdr((Ignite)this.replicaCluster.get(0)).consistentCutWatcher().addAppliedCutsListener((IgniteInClosure & Serializable)cutId -> this.lastAppliedCut.set((long)cutId));
        this.stopTxLoad(fut);
        long cutId2 = this.forceConsistentCut((Ignite)this.masterCluster.get(0));
        TxDrNodesFailoverTest.assertFalse((boolean)GridTestUtils.waitForCondition(() -> this.txdr((Ignite)this.replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId() >= cutId2, (long)15000L));
        this.suspendCutApplying();
        this.startClusterNode(ClusterRole.REPLICA, 0);
        this.resumeCutApplying();
        this.waitForApplyingCut(cutId2);
        this.waitForApplyingCut(this.replicaCluster, cutId2, 15000L);
        TxDrNodesFailoverTest.assertTrue((boolean)this.idleVerifyReplica(failedNode));
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)this.masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)failedNode.cache("txCache"));
        TxDrNodesFailoverTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    private void awaitPmeOnReplica() throws InterruptedException {
        this.awaitPartitionMapExchange(false, false, this.replicaCluster.get(0).context().discovery().aliveServerNodes());
    }

    private void waitForApplyingCut(long cutId) throws IgniteInterruptedCheckedException {
        log.info("Waiting for applying cut globally, cutId=" + cutId);
        TxDrNodesFailoverTest.assertTrue((String)("Failed to wait for applying cut globally [cutId=" + cutId + ']'), (boolean)GridTestUtils.waitForCondition(() -> {
            if (this.lastAppliedCut.get() < cutId) {
                this.awakeCutsWatcher(this.replicaCluster);
                return false;
            }
            return true;
        }, (long)15000L));
    }

    private Map<String, Long> collectMasterClusterLastWalIdxs() {
        HashMap<String, Long> nodesLastWalIdxs = new HashMap<String, Long>();
        for (IgniteEx ignite : this.masterCluster) {
            nodesLastWalIdxs.put(ignite.name(), this.txdr((Ignite)ignite).localState().lastSuccessfullySentWalIndex());
        }
        return nodesLastWalIdxs;
    }

    private void waitForWalShipping(Map<String, Long> nodesLastWalIdxs) throws IgniteInterruptedCheckedException {
        log.info("Waiting for shipping WAL segments, nodesLastWalIdxs=" + nodesLastWalIdxs);
        boolean res = GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : this.masterCluster) {
                if (!nodesLastWalIdxs.containsKey(ignite.name())) continue;
                long lastWalIdx = (Long)nodesLastWalIdxs.get(ignite.name());
                if (this.txdr((Ignite)ignite).localState().lastSuccessfullySentWalIndex() > lastWalIdx) continue;
                return false;
            }
            return true;
        }, (long)10000L);
        TxDrNodesFailoverTest.assertTrue((String)("Failed to wait for WAL shipping, nodesLastWalIdxs=" + nodesLastWalIdxs + ", nodesCurWalIdxs=" + this.collectMasterClusterLastWalIdxs()), (boolean)res);
    }

    private long forceConsistentCutAndWaitForWalShipping(IgniteEx ignite) throws IgniteInterruptedCheckedException {
        Map<String, Long> nodesLastWalIdxs = this.collectMasterClusterLastWalIdxs();
        long cutId = this.forceConsistentCut((Ignite)ignite);
        this.waitForWalShipping(nodesLastWalIdxs);
        return cutId;
    }

    private void waitForClusterRole(List<IgniteEx> cluster, ClusterRole role) throws IgniteInterruptedCheckedException {
        log.info("Wait for changing cluster role to " + role);
        TxDrNodesFailoverTest.assertTrue((String)("Failed to wait for cluster role change to " + role), (boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : cluster) {
                if (this.txdr((Ignite)ignite).localState().role() == role) continue;
                this.awakeCutsWatcher(ignite);
                return false;
            }
            return true;
        }, (long)10000L));
    }

    private Set<Integer> collectLaggingBehindNodes() {
        HashSet<Integer> laggingBehindNodes = new HashSet<Integer>();
        for (int nodeIdx = 0; nodeIdx < this.nodesCnt; ++nodeIdx) {
            String instanceName = this.igniteInstanceNameWithRole(ClusterRole.REPLICA, nodeIdx, AbstractReplicationTest.NodeType.BLT_NODE);
            if (Ignition.state((String)instanceName) != IgniteState.STARTED || !this.txdr(Ignition.ignite((String)instanceName)).localState().laggingBehind()) continue;
            laggingBehindNodes.add(nodeIdx);
        }
        return laggingBehindNodes;
    }

    private void assertLaggingBehindNodes(Set<Integer> expLaggingNodes) {
        TxDrNodesFailoverTest.assertEquals(expLaggingNodes, this.collectLaggingBehindNodes());
    }

    private void waitForDetectLaggingBehindNodes(Set<Integer> expLaggingNodes) throws IgniteInterruptedCheckedException {
        log.info("Waiting for detect lagging behind nodes, expLaggingNodes=" + expLaggingNodes);
        GridTestUtils.waitForCondition(() -> {
            if (expLaggingNodes.equals(this.collectLaggingBehindNodes())) {
                return true;
            }
            this.awakeCutsWatcher(this.replicaCluster);
            return false;
        }, (long)10000L);
        TxDrNodesFailoverTest.assertEquals(expLaggingNodes, this.collectLaggingBehindNodes());
    }

    private void stopClusterNode(ClusterRole role, int nodeIdx) {
        this.stopClusterNode(role, nodeIdx, false);
    }

    private void stopClusterNode(ClusterRole role, int nodeIdx, boolean cleanLFS) {
        this.stopClusterNode(role, nodeIdx, cleanLFS, AbstractReplicationTest.NodeType.BLT_NODE);
    }

    private void stopClusterNode(ClusterRole role, int nodeIdx, boolean cleanLFS, AbstractReplicationTest.NodeType nodeType) {
        String instanceName = this.igniteInstanceNameWithRole(role, nodeIdx, nodeType);
        List<IgniteEx> cluster = role == ClusterRole.MASTER ? this.masterCluster : this.replicaCluster;
        IgniteEx node = null;
        for (IgniteEx ignite : cluster) {
            if (!instanceName.equals(ignite.name())) continue;
            node = ignite;
        }
        if (node != null) {
            cluster.remove(node);
            node.close();
            if (cleanLFS) {
                try {
                    this.cleanupServerLfs(role, nodeIdx);
                }
                catch (IgniteCheckedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void cleanupLfs() throws Exception {
        int i;
        for (i = 0; i < this.nodesCnt; ++i) {
            this.cleanupServerLfs(ClusterRole.MASTER, i);
            this.cleanupServerLfs(ClusterRole.REPLICA, i);
        }
        for (i = 0; i < this.clientsCnt; ++i) {
            this.cleanupClientLfs(ClusterRole.MASTER, i);
            this.cleanupClientLfs(ClusterRole.REPLICA, i);
        }
    }

    private void cleanupServerLfs(ClusterRole role, int idx) throws IgniteCheckedException {
        this.cleanupServerLfs(role, this.nodeConsistentId(idx));
    }

    private void cleanupClientLfs(ClusterRole role, int idx) throws IgniteCheckedException {
        this.cleanupServerLfs(role, "client" + idx);
    }

    private void cleanupServerLfs(ClusterRole role, String consistentId) throws IgniteCheckedException {
        String namePrefix = role == ClusterRole.MASTER ? CUSTOM_MASTER_PREFIX : CUSTOM_REPLICA_PREFIX;
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)(namePrefix + consistentId), (boolean)false));
    }

    @Override
    protected IgniteEx startClusterNode(ClusterRole role, int nodeIdx) throws Exception {
        IgniteEx node = super.startClusterNode(role, nodeIdx);
        if (role == ClusterRole.MASTER) {
            this.masterCluster.add(node);
        } else {
            this.replicaCluster.add(node);
        }
        return node;
    }

    private void suspendCutApplying() {
        for (IgniteEx ignite : this.replicaCluster) {
            this.txdr((Ignite)ignite).consistentCutWatcher().waitForCutApplyAndSuspend(0L);
        }
    }

    private void resumeCutApplying() {
        for (IgniteEx ignite : this.replicaCluster) {
            this.txdr((Ignite)ignite).consistentCutWatcher().resume();
        }
    }

    private void removeWalFile(IgniteEx ignite, long cutId) throws IgniteCheckedException {
        ConsistentCut rmvCut = this.txdr((Ignite)ignite).consistentCutStore().restore(cutId);
        FileWALPointer cutPtr = (FileWALPointer)rmvCut.cutPtr();
        long lastWalIdx = cutPtr.index();
        File walDir = this.walDir((Ignite)ignite);
        File lastWalFile = new File(walDir, FileDescriptor.fileName((long)lastWalIdx));
        if (!lastWalFile.exists()) {
            lastWalFile = new File(walDir, FileDescriptor.fileName((long)lastWalIdx) + ".zip");
        }
        TxDrNodesFailoverTest.assertTrue((String)("WAL file doesn't exists " + lastWalFile), (boolean)lastWalFile.exists());
        TxDrNodesFailoverTest.assertTrue((boolean)lastWalFile.delete());
    }
}

