/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrMXBeanImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrMXBean;
import org.junit.Test;

public class TxDrMXBeanTest
extends AbstractReplicationTest {
    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 1;
    }

    @Test
    public void testTxDrMXBeanRegistration() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        IgniteEx master0 = masterCluster.get(0);
        IgniteEx replica0 = replicaCluster.get(0);
        master0.cluster().active(true);
        replica0.cluster().active(true);
        this.assertTxDrMXBeanValues((Ignite)master0, ClusterRole.DISABLED, ReplicationState.STOPPED, false, -1L);
        this.assertTxDrMXBeanValues((Ignite)replica0, ClusterRole.DISABLED, ReplicationState.STOPPED, false, -1L);
        long bootstrapSesId = this.bootstrapMaster();
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        this.assertTxDrMXBeanValues((Ignite)master0, ClusterRole.MASTER, ReplicationState.RUNNING, false, -1L);
        this.assertTxDrMXBeanValues((Ignite)replica0, ClusterRole.REPLICA, ReplicationState.RUNNING, true, (IgnitePredicate<Long>)(IgnitePredicate & Serializable)cutId -> cutId >= bootstrapSesId);
        this.validateMbeans((Ignite)master0, new String[]{"org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrMXBeanImpl"});
        this.validateMbeans((Ignite)replica0, new String[]{"org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrMXBeanImpl"});
    }

    private void assertTxDrMXBeanValues(Ignite ignite, ClusterRole role, ReplicationState state, boolean readOnly, long lastAppliedCutId) throws Exception {
        TransactionalDrMXBean mxBean = this.getTxDrMXBean(ignite);
        TxDrMXBeanTest.assertEquals((String)role.name(), (String)mxBean.clusterRole());
        TxDrMXBeanTest.assertEquals((String)state.name(), (String)mxBean.replicationState());
        TxDrMXBeanTest.assertEquals((boolean)readOnly, (boolean)mxBean.readOnly());
        TxDrMXBeanTest.assertEquals((long)lastAppliedCutId, (long)mxBean.lastSuccessfullyAppliedCutId());
        this.assertTxDrMXBeanValues(ignite, role, state, readOnly, (IgnitePredicate<Long>)(IgnitePredicate & Serializable)cutId -> lastAppliedCutId == cutId);
    }

    private void assertTxDrMXBeanValues(Ignite ignite, ClusterRole role, ReplicationState state, boolean readOnly, IgnitePredicate<Long> cutPred) throws Exception {
        TransactionalDrMXBean mxBean = this.getTxDrMXBean(ignite);
        TxDrMXBeanTest.assertEquals((String)role.name(), (String)mxBean.clusterRole());
        TxDrMXBeanTest.assertEquals((String)state.name(), (String)mxBean.replicationState());
        TxDrMXBeanTest.assertEquals((boolean)readOnly, (boolean)mxBean.readOnly());
        TxDrMXBeanTest.assertTrue((boolean)cutPred.apply((Object)mxBean.lastSuccessfullyAppliedCutId()));
    }

    private TransactionalDrMXBean getTxDrMXBean(Ignite ignite) throws Exception {
        ObjectName mBeanName = U.makeMBeanName((String)ignite.name(), (String)"TxDr", (String)TransactionalDrMXBeanImpl.class.getSimpleName());
        MBeanServer mBeanSrv = ManagementFactory.getPlatformMBeanServer();
        if (!mBeanSrv.isRegistered(mBeanName)) {
            TxDrMXBeanTest.fail((String)("MBean is not registered: " + mBeanName.getCanonicalName()));
        }
        return MBeanServerInvocationHandler.newProxyInstance(mBeanSrv, mBeanName, TransactionalDrMXBean.class, true);
    }
}

