/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeFailureHandler;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutAppliedMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutReadyMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.junit.Test;

public class TxDrFullLifecycleTest
extends AbstractReplicationTest {
    private static final long LOAD_TIMEOUT = 3000L;
    private boolean testCommSpi;

    protected FailureHandler getFailureHandler(String igniteInstanceName) {
        return new StopNodeFailureHandler();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        if (this.testCommSpi && gridName.contains("replica")) {
            cfg.setCommunicationSpi((CommunicationSpi)new TestCommunicationSpi());
        }
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.consistentCutInterval = Long.MAX_VALUE;
        this.testCommSpi = false;
    }

    @Test
    public void testContinueReplicationAfterWorkerTermination() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long bootstrapSesId = this.bootstrapMaster();
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        long cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        this.txdr((Ignite)replicaCluster.get(0)).consistentCutWatcher().addReadyCutsListener((IgniteInClosure & Serializable)cut -> {
            throw new AssertionError();
        });
        cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        replicaCluster.remove(0);
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        this.txdr((Ignite)replicaCluster.get(0)).stop().get();
    }

    @Test
    public void testConsistentPauseAndStop() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(sesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        long cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        this.txdr(ClusterRole.REPLICA).pause().get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.PAUSED, sesId);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        log.info(">>> Replica cluster paused successfully, applied cutId=" + this.txdr((Ignite)replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId());
        cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        for (IgniteEx ignite : replicaCluster) {
            TxDrFullLifecycleTest.assertTrue((this.txdr((Ignite)ignite).localState().lastSuccessfullyAppliedCutId() < cutId ? 1 : 0) != 0);
        }
        this.txdr(ClusterRole.REPLICA).resume().get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        log.info(">>> Replica cluster resumed successfully, applied cutId=" + this.txdr((Ignite)replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId());
        cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.stopTxLoad(txLoadFut);
        this.awakeCutsWatcher(replicaCluster);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.assertClusterState(replicaCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        log.info(">>> Replica cluster stopped successfully, applied cutId=" + this.txdr((Ignite)replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId());
    }

    @Test
    public void testClusterSwitching() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        BiPredicate oldTxErrorFilter = this.txErrorFilter;
        this.txErrorFilter = oldTxErrorFilter.or((tx, e) -> e.getMessage() != null && tx != null && e.getMessage().endsWith(tx.concurrency() == TransactionConcurrency.OPTIMISTIC ? "Failed to perform cache operation (cache topology is not valid): txCache" : "Failed to perform cache operation (cluster is in read only mode)"));
        bootstrapSesId = (Long)this.txdr(ClusterRole.MASTER).switchWithReplica().get();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(masterCluster);
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.stopTxLoad(txLoadFut);
        this.awakeCutsWatcher(replicaCluster);
        TxDrFullLifecycleTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)20000L));
        this.assertClusterState(replicaCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache"));
        TxDrFullLifecycleTest.assertEquals(dumpMasterTx, dumpReplicaTx);
        this.txErrorFilter = oldTxErrorFilter;
        txLoadFut = this.startTxLoad(3, ClusterRole.REPLICA);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        this.stopTxLoad(txLoadFut);
        long cutId = this.forceConsistentCut((Ignite)replicaCluster.get(0));
        this.awakeCutsWatcher(masterCluster);
        this.waitForApplyingCut(masterCluster, cutId, 10000L);
        this.txdr(ClusterRole.MASTER).stop().get();
        dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterCluster.get(0).cache("txCache"));
        dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache"));
        TxDrFullLifecycleTest.assertEquals(dumpMasterTx, dumpReplicaTx);
    }

    @Test
    public void testSwitchWithDeadCrdOnMaster() throws Exception {
        this.consistentCutInterval = 2000L;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        BiPredicate oldTxErrorFilter = this.txErrorFilter;
        this.txErrorFilter = oldTxErrorFilter.or((tx, e) -> e.getMessage() != null && tx != null && e.getMessage().endsWith(tx.concurrency() == TransactionConcurrency.OPTIMISTIC ? "Failed to perform cache operation (cache topology is not valid): txCache" : "Failed to perform cache operation (cluster is in read only mode)"));
        this.stopTxLoad(txLoadFut);
        masterCluster.get(0).close();
        bootstrapSesId = (Long)this.txdr((Ignite)masterCluster.get(1)).switchWithReplica().get();
        this.assertClusterState(masterCluster.subList(1, masterCluster.size()), ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(masterCluster.subList(1, masterCluster.size()));
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.awakeCutsWatcher(replicaCluster);
        TxDrFullLifecycleTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)5000L));
        this.assertClusterState(replicaCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
    }

    @Test
    public void testSwitchCrdLeftOnReplica() throws Exception {
        this.consistentCutInterval = 2000L;
        this.testCommSpi = true;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        BiPredicate oldTxErrorFilter = this.txErrorFilter;
        this.txErrorFilter = oldTxErrorFilter.or((tx, e) -> e.getMessage() != null && tx != null && e.getMessage().endsWith(tx.concurrency() == TransactionConcurrency.OPTIMISTIC ? "Failed to perform cache operation (cache topology is not valid): txCache" : "Failed to perform cache operation (cluster is in read only mode)"));
        this.stopTxLoad(txLoadFut);
        bootstrapSesId = (Long)this.txdr((Ignite)masterCluster.get(0)).switchWithReplica().get();
        TestCommunicationSpi.block = true;
        while (TestCommunicationSpi.switchCutId == 0L) {
            U.sleep((long)100L);
        }
        replicaCluster.get(0).close();
        TestCommunicationSpi.reset();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(masterCluster);
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.awakeCutsWatcher(replicaCluster.subList(1, replicaCluster.size()));
        TxDrFullLifecycleTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replicaCluster.subList(1, replicaCluster.size())) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)20000L));
        this.assertClusterState(replicaCluster.subList(1, replicaCluster.size()), ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
    }

    @Test
    public void testDoubleSwitching() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        this.forceConsistentCutNoRetry((Ignite)masterCluster.get(0));
        this.stopTxLoad(txLoadFut);
        this.switchClusters(masterCluster, replicaCluster, true);
        this.switchClusters(replicaCluster, masterCluster, true);
        long cutId = this.forceConsistentCutNoRetry((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        this.waitForApplyingCut(replicaCluster, cutId, 20000L);
        Map<Integer, Long> dumpMasterTx = this.dumpCache((IgniteCache<Integer, Long>)masterCluster.get(0).cache("txCache"));
        Map<Integer, Long> dumpReplicaTx = this.dumpCache((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache"));
        TxDrFullLifecycleTest.assertEquals(dumpMasterTx, dumpReplicaTx);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.txdr(ClusterRole.MASTER).stop().get();
    }

    @Test
    public void testRebootstrappingAfterSwitch() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        long txTotal = this.populateData((Ignite)this.node(ClusterRole.MASTER), "txCache");
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(replicaCluster);
        TxDrFullLifecycleTest.assertEquals((long)txTotal, (long)this.sumOf((IgniteCache<Integer, Long>)replicaCluster.get(0).cache("txCache")));
        IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.MASTER);
        TxDrFullLifecycleTest.doSleep((long)3000L);
        this.forceConsistentCutNoRetry((Ignite)masterCluster.get(0));
        this.stopTxLoad(txLoadFut);
        this.switchClusters(masterCluster, replicaCluster, true);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.txdr(ClusterRole.MASTER).stop().get();
        bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        this.bootstrapReplica(bootstrapSesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        long cutId = this.forceConsistentCutNoRetry((Ignite)masterCluster.get(0));
        this.waitForApplyingCut(replicaCluster, cutId, 20000L);
        this.txdr(ClusterRole.REPLICA).stop().get();
        this.txdr(ClusterRole.MASTER).stop().get();
    }

    @Test
    public void testNodeLeftAndJoin() throws Exception {
        this.nodesCnt = 2;
        this.clientsCnt = 0;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        TransactionalDrProcessorImpl txdrMaster = this.txdr(ClusterRole.MASTER);
        long sesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        List<IgniteEx> replicaCluster = this.startCluster(ClusterRole.REPLICA);
        TransactionalDrProcessorImpl txdrReplica = this.txdr(ClusterRole.REPLICA);
        this.bootstrapReplica(sesId);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        replicaCluster.get(1).close();
        IgniteEx restartedNode = this.startGrid(ClusterRole.REPLICA, 1);
        replicaCluster.set(1, restartedNode);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.assertClusterReadOnly(replicaCluster);
        this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.awakeCutsWatcher(replicaCluster);
        txdrReplica.pause().get();
        replicaCluster.get(1).close();
        txdrReplica.resume().get();
        restartedNode = this.startGrid(ClusterRole.REPLICA, 1);
        replicaCluster.set(1, restartedNode);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        TxDrFullLifecycleTest.assertEquals((long)this.txdr((Ignite)replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId(), (long)this.txdr((Ignite)replicaCluster.get(1)).localState().lastSuccessfullyAppliedCutId());
        this.assertClusterReadOnly(replicaCluster);
        replicaCluster.get(1).close();
        replicaCluster.remove(1);
        long cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        restartedNode = this.startGrid(ClusterRole.REPLICA, 1);
        replicaCluster.add(restartedNode);
        TxDrFullLifecycleTest.assertTrue((String)("Wrong last applied cut ID: " + cutId), (cutId == this.txdr((Ignite)restartedNode).localState().lastSuccessfullyAppliedCutId() ? 1 : 0) != 0);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.assertClusterReadOnly(replicaCluster);
        txdrReplica.pause().get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.PAUSED, sesId);
        txdrReplica.resume().get();
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        TxDrFullLifecycleTest.assertTrue((String)("Wrong last applied cut ID: " + cutId), (cutId == this.txdr((Ignite)restartedNode).localState().lastSuccessfullyAppliedCutId() ? 1 : 0) != 0);
        cutId = this.forceConsistentCut((Ignite)masterCluster.get(0));
        this.waitForApplyingCut(replicaCluster, cutId, 10000L);
        TxDrFullLifecycleTest.assertEquals((long)cutId, (long)this.txdr((Ignite)restartedNode).localState().lastSuccessfullyAppliedCutId());
        File node1Dir = ((FilePageStoreManager)replicaCluster.get(1).context().cache().context().pageStore()).workDir();
        replicaCluster.get(1).close();
        U.delete((File)node1Dir);
        restartedNode = this.startGrid(ClusterRole.REPLICA, 1);
        replicaCluster.set(1, restartedNode);
        this.assertClusterState(replicaCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        TxDrFullLifecycleTest.assertEquals((long)this.txdr((Ignite)replicaCluster.get(0)).localState().lastSuccessfullyAppliedCutId(), (long)this.txdr((Ignite)replicaCluster.get(1)).localState().lastSuccessfullyAppliedCutId());
        this.assertClusterReadOnly(replicaCluster);
        List<IgniteEx> clients = this.startClients(ClusterRole.REPLICA, 1);
        this.assertClusterState(clients, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.assertClusterReadOnly(clients);
        replicaCluster.get(1).close();
        txdrReplica.stop().get();
        restartedNode = this.startGrid(ClusterRole.REPLICA, 1);
        replicaCluster.set(1, restartedNode);
        this.assertClusterState(replicaCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        masterCluster.get(1).close();
        sesId = (Long)txdrMaster.switchWithReplica().get();
        restartedNode = this.startGrid(ClusterRole.MASTER, 1);
        masterCluster.set(1, restartedNode);
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        this.assertClusterReadOnly(masterCluster);
    }

    private IgniteEx startGrid(ClusterRole role, int idx) throws Exception {
        return this.startGrid(this.getConfiguration(this.igniteInstanceNameWithRole(role, idx), "node" + idx, role));
    }

    private long switchClusters(List<IgniteEx> master, List<IgniteEx> replica, boolean forceConsistentCutAfterSwitch) throws Exception {
        long bootstrapSesId = (Long)this.txdr((Ignite)master.get(0)).switchWithReplica().get();
        this.assertClusterState(master, ClusterRole.REPLICA, ReplicationState.RUNNING, bootstrapSesId);
        this.assertClusterReadOnly(master);
        log.info(">>> Master cluster switched to replica successfully, new sessionId=" + bootstrapSesId);
        this.awakeCutsWatcher(replica);
        TxDrFullLifecycleTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : replica) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)20000L));
        this.assertClusterState(replica, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        log.info(">>> Replica cluster switched to master successfully, new sessionId=" + bootstrapSesId);
        if (forceConsistentCutAfterSwitch) {
            IgniteInternalFuture txLoadFut = this.startTxLoad(3, ClusterRole.REPLICA);
            TxDrFullLifecycleTest.doSleep((long)3000L);
            this.forceConsistentCutNoRetry((Ignite)replica.get(0));
            this.stopTxLoad(txLoadFut);
        }
        return bootstrapSesId;
    }

    private static class TestCommunicationSpi
    extends TcpCommunicationSpi {
        static volatile boolean block;
        static volatile long switchCutId;

        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            if (msg instanceof GridIoMessage) {
                ConsistentCutAppliedMessage msg0;
                GridIoMessage ioMsg = (GridIoMessage)msg;
                if (ioMsg.message() instanceof ConsistentCutReadyMessage) {
                    ConsistentCutReadyMessage msg02 = (ConsistentCutReadyMessage)ioMsg.message();
                    if (block && msg02.switchCutId() != 0L) {
                        switchCutId = msg02.switchCutId();
                    }
                } else if (block && switchCutId > 0L && ioMsg.message() instanceof ConsistentCutAppliedMessage && (msg0 = (ConsistentCutAppliedMessage)ioMsg.message()).cutId() == switchCutId) {
                    return;
                }
                super.sendMessage(node, msg, ackC);
            }
        }

        public static void reset() {
            switchCutId = 0L;
            block = false;
        }
    }
}

