/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Test;

public class TxDrConsistentCutOrderingTest
extends AbstractReplicationTest {
    private static final String CONSISTENT_CUT_TRANSFER_DIR = "cuts";

    @Override
    protected TransactionalDrConfiguration getTxDrConfiguration() throws Exception {
        return super.getTxDrConfiguration().setConsistentCutInterval(Long.MAX_VALUE);
    }

    @Test
    public void testConcurrentCutSkippedOnSwitch() throws Exception {
        this.nodesCnt = 3;
        this.backupsCnt = 1;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        TransactionalDrProcessorImpl txdrMaster = this.txdr((Ignite)masterCluster.get(0));
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        CountDownLatch latchStartCC = new CountDownLatch(1);
        masterCluster.get(0).context().event().addDiscoveryEventListener((evt, discoCache) -> {
            StartSnapshotOperationDiscoveryMessage msg0;
            DiscoveryCustomMessage msg;
            if (evt instanceof DiscoveryCustomEvent && (msg = ((DiscoveryCustomEvent)evt).customMessage()) instanceof StartSnapshotOperationDiscoveryMessage && (msg0 = (StartSnapshotOperationDiscoveryMessage)msg).snapshotOperation().type() == SnapshotOperationType.CONSISTENT_CUT) {
                try {
                    latchStartCC.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, 18, new int[0]);
        ArrayList<ConsistentCutStore> oldStores = new ArrayList<ConsistentCutStore>(this.nodesCnt);
        for (IgniteEx ignite : masterCluster) {
            oldStores.add(this.txdr((Ignite)ignite).consistentCutStore());
        }
        IgniteFuture switchFut = txdrMaster.switchWithReplica();
        SnapshotFuture ccFut = this.snapMgr(ClusterRole.MASTER).startGlobalConsistentCut();
        U.sleep((long)5000L);
        latchStartCC.countDown();
        ccFut.snapshotOperation().snapshotId();
        long switchSesId = (Long)switchFut.get();
        this.assertClusterState(masterCluster, ClusterRole.REPLICA, ReplicationState.RUNNING, switchSesId);
        for (ConsistentCutStore store : oldStores) {
            TxDrConsistentCutOrderingTest.assertEquals(Arrays.asList(bootstrapSesId, switchSesId), (Object)store.list());
        }
    }

    @Test
    public void testConsistentCutProperOrdering() throws Exception {
        this.nodesCnt = 4;
        this.backupsCnt = 1;
        this.clientsCnt = 0;
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx masterIgnite = masterCluster.get(0);
        masterIgnite.cluster().baselineAutoAdjustEnabled(false);
        masterIgnite.cluster().active(true);
        this.populateData((Ignite)masterIgnite, "txCache");
        this.populateData((Ignite)masterIgnite, "atomicCache");
        long sesId = (Long)TxDrConsistentCutOrderingTest.bootstrapMaster((TransactionalDrMaster)this.txdr((Ignite)masterIgnite), this.snapshotFolder()).get();
        this.txdr((Ignite)masterIgnite);
        AtomicBoolean stop = new AtomicBoolean();
        GridTestUtils.runMultiThreadedAsync(() -> {
            IgniteEx nodeToStop = (IgniteEx)masterCluster.get(3);
            for (int i = 0; i < 5; ++i) {
                try {
                    nodeToStop.close();
                    U.sleep((long)1000L);
                    masterIgnite.cluster().setBaselineTopology(masterIgnite.cluster().forServers().nodes());
                    this.awaitPartitionMapExchange();
                    nodeToStop = this.startClusterNode(ClusterRole.MASTER, 3);
                    U.sleep((long)1000L);
                    masterIgnite.cluster().setBaselineTopology(masterIgnite.cluster().forServers().nodes());
                    this.awaitPartitionMapExchange();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            stop.set(true);
        }, (int)1, (String)"cut-thread");
        while (!stop.get()) {
            try {
                this.forceConsistentCut((Ignite)masterIgnite);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            U.sleep((long)100L);
        }
        File transferFolder = this.transferFolder();
        boolean condFail = false;
        for (Ignite node : G.allGrids()) {
            if (node.cluster().localNode().isClient()) continue;
            ConsistentCutStore store = this.getConsistentCutStore(node, transferFolder, sesId);
            log.info("Cuts for node " + node.cluster().localNode());
            ConsistentCut prev = null;
            for (Long cutId : store.list()) {
                ConsistentCut cut = store.restore(cutId.longValue());
                log.info("\tDBG >> id=" + cut.id() + " fuzzyBrdrPtr=" + cut.fuzzyBorderStartPtr() + " cutPtr=" + cut.cutPtr());
                if (prev != null) {
                    condFail = prev.id() >= cut.id();
                    FileWALPointer curFuzzyPtr = (FileWALPointer)cut.fuzzyBorderStartPtr();
                    FileWALPointer curPtr = (FileWALPointer)cut.cutPtr();
                    FileWALPointer prevFuzzyPtr = (FileWALPointer)prev.fuzzyBorderStartPtr();
                    FileWALPointer prevCutPtr = (FileWALPointer)prev.cutPtr();
                    if (curFuzzyPtr.equals((Object)curPtr) && prevFuzzyPtr.equals((Object)prevCutPtr) && curPtr.equals((Object)prevFuzzyPtr)) {
                        log.info("\tDBG >> blt fake cuts above.");
                    } else if (curFuzzyPtr.compareTo(prevCutPtr) <= 0) {
                        log.error("\tInvariant failed on cuts: cur=" + cut + "\n\t prev=" + prev);
                        condFail = true;
                    }
                }
                prev = cut;
            }
        }
        TxDrConsistentCutOrderingTest.assertTrue((String)"Condition failed", (!condFail ? 1 : 0) != 0);
    }

    private ConsistentCutStore getConsistentCutStore(Ignite node, File transferFolder, long bootstrapSesId) {
        File rootFolder = new File(transferFolder, bootstrapSesId + "/" + node.cluster().localNode().consistentId());
        TxDrConsistentCutOrderingTest.assertTrue((boolean)rootFolder.exists());
        File cuts = new File(rootFolder, CONSISTENT_CUT_TRANSFER_DIR);
        TxDrConsistentCutOrderingTest.assertTrue((String)"The CUTs directory does not exist or does not contain CUT files.", (cuts.exists() && cuts.isDirectory() && !F.isEmpty((Object[])cuts.list()) ? 1 : 0) != 0);
        ConsistentCutStore ccStore = this.txdr(node).consistentCutStore();
        TxDrConsistentCutOrderingTest.assertNotNull((Object)ccStore);
        return ccStore;
    }
}

