/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotEncryptionOptions;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotSession;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrGlobalStatus;
import org.gridgain.grid.internal.txdr.TransactionalDrMaster;
import org.gridgain.grid.persistentstore.MessageDigestFactory;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class TxDrBootstrapMasterTest
extends AbstractReplicationTest {
    private static final String CONSISTENT_CUT_TRANSFER_DIR = "cuts";
    private static final String WAL_TRANSFER_DIR = "wal";
    private static final long CONSISTENT_CUT_INTERVAL = 2000L;
    private static final int CREATE = 0;
    private static final int COPY = 1;
    private volatile boolean stopUpload;

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 3;
        this.consistentCutInterval = 2000L;
    }

    protected File folder(String folder) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)folder, (boolean)false);
    }

    @Test
    public void testBootstrapMasterCluster() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        Ignite master0 = (Ignite)masterCluster.get(0);
        master0.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.checkGlobalReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        IgniteCache cache = master0.cache("txCache");
        this.awaitPartitionMapExchange();
        long bootstrapSesId = this.bootstrapMaster();
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        this.checkGlobalReplicationState(ClusterRole.MASTER, ReplicationState.RUNNING, bootstrapSesId);
        IgniteInternalFuture uploadFut = this.startTestLoad(cache);
        Thread.sleep(4000L);
        File snapshotFolder = this.snapshotFolder();
        File transferFolder = this.transferFolder();
        TxDrBootstrapMasterTest.assertTrue((String)"The snapshot directory does not exist or empty.", (snapshotFolder.exists() && snapshotFolder.isDirectory() && !F.isEmpty((Object[])snapshotFolder.list()) ? 1 : 0) != 0);
        TxDrBootstrapMasterTest.assertTrue((boolean)transferFolder.exists());
        ConsistentCut cc = this.findLastConsistentCut(master0, transferFolder, bootstrapSesId);
        TxDrBootstrapMasterTest.assertNotNull((Object)cc);
        for (Ignite ignite : masterCluster) {
            ConsistentCut firstCut = this.findFirstConsistentCut(ignite, transferFolder, bootstrapSesId);
            ConsistentCut locCut = this.findConsistentCut(ignite, transferFolder, bootstrapSesId, cc.id());
            TxDrBootstrapMasterTest.assertNotNull((Object)firstCut);
            TxDrBootstrapMasterTest.assertNotNull((Object)locCut);
            File wal = new File(transferFolder, Long.toString(bootstrapSesId) + "/" + ignite.cluster().localNode().consistentId() + "/" + WAL_TRANSFER_DIR + "/" + this.txdr(ignite).spawnId());
            TxDrBootstrapMasterTest.assertTrue((boolean)wal.exists());
            FileWALPointer ptr = (FileWALPointer)locCut.cutPtr();
            boolean compacted = ignite.configuration().getDataStorageConfiguration().isWalCompactionEnabled();
            String fileName = compacted ? FileDescriptor.fileName((long)ptr.index()) + ".zip" : FileDescriptor.fileName((long)ptr.index());
            TxDrBootstrapMasterTest.assertTrue((boolean)this.waitForFileInTransferDir(wal, fileName, 15000L));
            Stream<Path> files = Files.list(wal.toPath());
            Throwable throwable = null;
            try {
                Set walFiles = files.map(p -> p.getFileName().toString()).collect(Collectors.toSet());
                for (long i = ((FileWALPointer)firstCut.cutPtr()).index(); i < ptr.index(); ++i) {
                    TxDrBootstrapMasterTest.assertTrue((boolean)walFiles.contains(compacted ? FileDescriptor.fileName((long)i) + ".zip" : FileDescriptor.fileName((long)i)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (files == null) continue;
                if (throwable != null) {
                    try {
                        files.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                files.close();
            }
        }
        this.stopUpload = true;
        uploadFut.get();
    }

    @Test
    public void testBootstrapMasterClusterWithWalDisabling() throws Exception {
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.checkGlobalReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        master0.getOrCreateCache("txCache");
        assert (((Boolean)master0.context().cache().context().walState().changeWalMode(Collections.singletonList("txCache"), false).get()).booleanValue());
        try {
            this.bootstrapMaster();
            TxDrBootstrapMasterTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (((Boolean)master0.context().cache().context().walState().changeWalMode(Collections.singletonList("txCache"), true).get()).booleanValue());
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, this.bootstrapMaster());
        try {
            master0.context().cache().context().walState().changeWalMode(Collections.singletonList("txCache"), false).get();
            TxDrBootstrapMasterTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBootstrapMasterClusterClientLeaveOnSnapshotCreate() throws Exception {
        this.concurrentClientLeaveOnMasterBootstrap(0);
    }

    @Test
    public void testBootstrapMasterClusterClientLeaveOnSnapshotCopy() throws Exception {
        this.concurrentClientLeaveOnMasterBootstrap(1);
    }

    private void concurrentClientLeaveOnMasterBootstrap(int cancelPhase) throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(1);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new TestSnapshotSpi(startLatch, finishLatch, cancelPhase));
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.checkGlobalReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        IgniteEx masterClient = this.clientNode(ClusterRole.MASTER);
        TransactionalDrProcessorImpl.MasterBootstrapFuture fut = (TransactionalDrProcessorImpl.MasterBootstrapFuture)TxDrBootstrapMasterTest.bootstrapMaster((TransactionalDrMaster)this.txdr((Ignite)masterClient), this.snapshotFolder());
        startLatch.await();
        ArrayList<SnapshotOperationFuture> snapshotFutures = new ArrayList<SnapshotOperationFuture>();
        for (IgniteEx node : masterCluster) {
            SnapshotOperationFuture snapshotFut = this.snapMgr((Ignite)node).snapshotFuture();
            TxDrBootstrapMasterTest.assertNotNull((Object)snapshotFut);
            TxDrBootstrapMasterTest.assertFalse((boolean)snapshotFut.isDone());
            TxDrBootstrapMasterTest.assertEquals((Object)snapshotFut.type(), (Object)TxDrBootstrapMasterTest.opType(cancelPhase));
            snapshotFutures.add(snapshotFut);
        }
        this.stopGrid(masterClient.name(), false);
        finishLatch.countDown();
        GridTestUtils.waitForCondition(() -> {
            for (SnapshotOperationFuture snapshotFut : snapshotFutures) {
                if (snapshotFut.isDone()) continue;
                return false;
            }
            return true;
        }, (long)5000L);
        for (SnapshotOperationFuture snapshotFut : snapshotFutures) {
            TxDrBootstrapMasterTest.assertNull((Object)snapshotFut.error());
        }
        this.assertClusterState(masterCluster, ClusterRole.MASTER, ReplicationState.RUNNING, fut.internalFuture().sessionId());
        this.checkGlobalReplicationState(ClusterRole.MASTER, ReplicationState.RUNNING, fut.internalFuture().sessionId());
    }

    private static SnapshotOperationType opType(int cancelPhase) {
        switch (cancelPhase) {
            case 0: {
                return SnapshotOperationType.CREATE;
            }
            case 1: {
                return SnapshotOperationType.COPY;
            }
        }
        throw new IllegalArgumentException();
    }

    @Test
    public void testBootstrapMasterClusterFailOnSnapshotCreate() throws Exception {
        this.concurrentCancelSnapshotOperationOnMasterBootstrap(0);
    }

    @Test
    public void testBootstrapMasterClusterFailOnSnapshotCopy() throws Exception {
        this.concurrentCancelSnapshotOperationOnMasterBootstrap(1);
    }

    private void concurrentCancelSnapshotOperationOnMasterBootstrap(int cancelPhase) throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch finishLatch = new CountDownLatch(1);
        GridCacheSnapshotManager.TEST_SNAPSHOT_SPI.set(new TestSnapshotSpi(startLatch, finishLatch, cancelPhase));
        List<IgniteEx> masterCluster = this.startCluster(ClusterRole.MASTER);
        IgniteEx master0 = masterCluster.get(0);
        master0.cluster().active(true);
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.checkGlobalReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        TransactionalDrProcessorImpl.MasterBootstrapFuture fut = (TransactionalDrProcessorImpl.MasterBootstrapFuture)TxDrBootstrapMasterTest.bootstrapMaster((TransactionalDrMaster)this.txdr(ClusterRole.MASTER), this.snapshotFolder());
        startLatch.await();
        IgniteInternalFuture cancelFut = this.snapMgr((Ignite)master0).cancelSnapshotOperation(fut.operationId(), false, "TxDr master bootstrap snapshot operation canceled: " + fut.operationId());
        finishLatch.countDown();
        cancelFut.get();
        try {
            fut.get();
            TxDrBootstrapMasterTest.fail((String)"TxDr master bootstrap operation must fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertClusterState(masterCluster, ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
        this.checkGlobalReplicationState(ClusterRole.DISABLED, ReplicationState.STOPPED, 0L);
    }

    private ConsistentCut findConsistentCut(Ignite node, File transferFolder, long bootstrapSesId, long cutId) throws IgniteCheckedException {
        ConsistentCutStore ccStore = this.getConsistentCutStore(node, transferFolder, bootstrapSesId);
        return ccStore.restore(cutId);
    }

    private ConsistentCut findFirstConsistentCut(Ignite node, File transferFolder, long bootstrapSesId) throws IgniteCheckedException {
        ConsistentCutStore ccStore = this.getConsistentCutStore(node, transferFolder, bootstrapSesId);
        List cutIds = ccStore.list();
        TxDrBootstrapMasterTest.assertTrue((!F.isEmpty((Collection)cutIds) ? 1 : 0) != 0);
        return ccStore.restore(((Long)cutIds.get(0)).longValue());
    }

    private ConsistentCut findLastConsistentCut(Ignite node, File transferFolder, long bootstrapSesId) throws IgniteCheckedException {
        ConsistentCutStore ccStore = this.getConsistentCutStore(node, transferFolder, bootstrapSesId);
        List cutIds = ccStore.list();
        TxDrBootstrapMasterTest.assertTrue((!F.isEmpty((Collection)cutIds) ? 1 : 0) != 0);
        return ccStore.restore(((Long)cutIds.get(cutIds.size() - 1)).longValue());
    }

    private ConsistentCutStore getConsistentCutStore(Ignite node, File transferFolder, long bootstrapSesId) {
        File rootFolder = new File(transferFolder, Long.toString(bootstrapSesId) + "/" + node.cluster().localNode().consistentId());
        TxDrBootstrapMasterTest.assertTrue((boolean)rootFolder.exists());
        File cuts = new File(rootFolder, CONSISTENT_CUT_TRANSFER_DIR);
        TxDrBootstrapMasterTest.assertTrue((String)"The CUTs directory does not exist or does not contain CUT files.", (cuts.exists() && cuts.isDirectory() && !F.isEmpty((Object[])cuts.list()) ? 1 : 0) != 0);
        ConsistentCutStore ccStore = this.txdr(node).consistentCutStore();
        TxDrBootstrapMasterTest.assertNotNull((Object)ccStore);
        return ccStore;
    }

    private void checkGlobalReplicationState(ClusterRole role, ReplicationState state, long bootstrapSesId) {
        TransactionalDrGlobalStatus status = (TransactionalDrGlobalStatus)this.txdr(ClusterRole.MASTER).status().get();
        TxDrBootstrapMasterTest.assertNotNull((Object)status);
        TxDrBootstrapMasterTest.assertEquals((Object)role, (Object)status.role());
        TxDrBootstrapMasterTest.assertEquals((Object)state, (Object)status.state());
        TxDrBootstrapMasterTest.assertEquals((long)bootstrapSesId, (long)status.sessionId());
    }

    private IgniteInternalFuture startTestLoad(final IgniteCache cache) {
        return GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    while (!TxDrBootstrapMasterTest.this.stopUpload && !Thread.currentThread().isInterrupted()) {
                        int i = ThreadLocalRandom.current().nextInt();
                        cache.put((Object)i, (Object)i);
                    }
                }
                catch (Exception e) {
                    if (X.cause((Throwable)e, InterruptedException.class) != null) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    TxDrBootstrapMasterTest.fail((String)("Unexpected exception [exc=" + e + "]"));
                }
            }
        }, (int)5, (String)"upload-thread");
    }

    private boolean waitForFileInTransferDir(File transferFolder, String name, long timeout) throws IOException, InterruptedException {
        Path transferFolderPath = transferFolder.toPath();
        File expFile = transferFolderPath.resolve(name).toFile();
        if (expFile.exists()) {
            return true;
        }
        try (WatchService ws = transferFolderPath.getFileSystem().newWatchService();){
            long remained;
            transferFolderPath.register(ws, StandardWatchEventKinds.ENTRY_CREATE);
            long startedAt = U.currentTimeMillis();
            while ((remained = timeout - (U.currentTimeMillis() - startedAt)) > 0L) {
                WatchKey key = ws.poll(remained, TimeUnit.MILLISECONDS);
                if (key == null) {
                    if (!expFile.exists()) continue;
                    boolean bl = true;
                    return bl;
                }
                if (key.pollEvents().stream().filter(e -> e.kind() == StandardWatchEventKinds.ENTRY_CREATE).map(WatchEvent::context).filter(c -> c instanceof Path).anyMatch(p -> ((Path)p).toFile().getName().equals(name))) {
                    boolean bl = true;
                    return bl;
                }
                TxDrBootstrapMasterTest.assertTrue((boolean)key.reset());
            }
            boolean bl = false;
            return bl;
        }
    }

    private static class TestSnapshotSpi
    extends FileDatabaseSnapshotSpi {
        private final CountDownLatch snapshotStartLatch;
        private final CountDownLatch snapshotFinishLatch;
        private final int waitPnt;

        public TestSnapshotSpi(CountDownLatch snapshotStartLatch, CountDownLatch snapshotFinishLatch, int waitPnt) {
            this.snapshotStartLatch = snapshotStartLatch;
            this.snapshotFinishLatch = snapshotFinishLatch;
            this.waitPnt = waitPnt;
        }

        public SnapshotSession sessionForSnapshotCreation(long id, boolean fullSnapshot, File storePath, CompressionOption compression, int compressionLevel, FutureTaskQueue<GroupPartitionId> futTaskQueue, SnapshotOperationContext snapshotOperationCtx, @Nullable MessageDigestFactory msgDigestFactory, @Nullable SnapshotEncryptionOptions encryptionOptions) throws IgniteCheckedException {
            if (this.waitPnt == 0) {
                this.awaitLatch();
            }
            return super.sessionForSnapshotCreation(id, fullSnapshot, storePath, compression, compressionLevel, futTaskQueue, snapshotOperationCtx, msgDigestFactory, encryptionOptions);
        }

        public void startCopy(long snapshotId, SnapshotPath pathToCp) throws IgniteCheckedException {
            if (this.waitPnt == 1) {
                this.awaitLatch();
            }
            super.startCopy(snapshotId, pathToCp);
        }

        private void awaitLatch() throws IgniteCheckedException {
            this.snapshotStartLatch.countDown();
            try {
                this.snapshotFinishLatch.await();
            }
            catch (InterruptedException ex) {
                throw new IgniteCheckedException((Throwable)ex);
            }
        }
    }
}

