/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.transactions.Transaction;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.BootstrapMasterParameters;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.junit.Test;

public class TxDrBinaryMetadataReplicationTest
extends AbstractReplicationTest {
    private static final String TX_BIN_META_CACHE_NAME = "TX_BIN_META_CACHE_NAME";
    private static final String TX_BIN_IDX_META_CACHE_NAME = "TX_BIN_IDX_META_CACHE_NAME";
    private static List<String> IDX_FIELDS = IntStream.range(0, 20).mapToObj(i -> "s" + i).collect(Collectors.toList());

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.nodesCnt = 3;
        this.backupsCnt = 1;
    }

    @Override
    protected IgniteConfiguration getConfiguration(String igniteInstanceName, String consistentId, ClusterRole role) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName, consistentId, role);
        CacheConfiguration ccfg = new CacheConfiguration(TX_BIN_META_CACHE_NAME);
        ccfg.setBackups(this.backupsCnt);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        CacheConfiguration idxCcfg = new CacheConfiguration(TX_BIN_IDX_META_CACHE_NAME);
        idxCcfg.setBackups(this.backupsCnt);
        idxCcfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        idxCcfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        idxCcfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        idxCcfg.setQueryEntities(this.createCacheIndexingConfiguration());
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>(Arrays.asList(cfg.getCacheConfiguration()));
        ccfgs.add(ccfg);
        ccfgs.add(idxCcfg);
        return cfg.setCacheConfiguration(ccfgs.toArray(cfg.getCacheConfiguration()));
    }

    private List<QueryEntity> createCacheIndexingConfiguration() {
        QueryEntity qryEntity = new QueryEntity("java.lang.Integer", "Value");
        LinkedHashMap fields = new LinkedHashMap();
        ArrayList indexes = new ArrayList(IDX_FIELDS.size());
        IDX_FIELDS.forEach(name -> {
            fields.put(name, "java.lang.String");
            indexes.add(new QueryIndex(name, QueryIndexType.SORTED));
        });
        qryEntity.setFields(fields);
        qryEntity.setIndexes(indexes);
        return Collections.singletonList(qryEntity);
    }

    @Test
    public void testReplication() throws Exception {
        List<IgniteEx> clusterMaster = this.startCluster(ClusterRole.MASTER);
        IgniteEx ignite = clusterMaster.get(0);
        ignite.cluster().active(true);
        IgniteCache cache = ignite.cache("txCache");
        TestValue testVal = new TestValue();
        cache.put((Object)1, (Object)testVal);
        IgniteBinary bin = TxDrBinaryMetadataReplicationTest.binary(ignite);
        BinaryObjectBuilder bldr = bin.builder("TEST_TYPE");
        bldr.setField("field1", (Object)1);
        bldr.setField("field2", (Object)"2");
        BinaryObject testType = bldr.build();
        cache.put((Object)2, (Object)testType);
        bldr = bin.builder("TEST_TYPE");
        bldr.setField("field1", (Object)1);
        bldr.setField("field2", (Object)"2");
        bldr.setField("field3", (Object)3L);
        BinaryObject testType2 = bldr.build();
        cache.put((Object)3, (Object)testType2);
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        TransactionalDrProcessorImpl txdrMaster = this.txdr((Ignite)clusterMaster.get(0));
        BootstrapMasterParameters bootstrapParams = new BootstrapMasterParameters.Builder().withSnapshotFolder(snapshotDir).build();
        long sesId = (Long)txdrMaster.bootstrap(bootstrapParams).get();
        this.assertClusterState(clusterMaster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        log.info(">>> Master cluster bootstrapped successfully");
        List<IgniteEx> clusterReplica = this.startCluster(ClusterRole.REPLICA);
        IgniteEx replicaIgnite = clusterReplica.get(0);
        replicaIgnite.cluster().active(true);
        TransactionalDrProcessorImpl txdrReplica = this.txdr((Ignite)replicaIgnite);
        txdrReplica.bootstrap(snapshotDir, sesId).get();
        log.info(">>> Replica cluster bootstrapped successfully");
        UnregisteredTestValue unregisteredVal = new UnregisteredTestValue();
        cache.put((Object)4, (Object)unregisteredVal);
        bldr = bin.builder("UNREGISTERED_TEST_TYPE");
        bldr.setField("field1", (Object)1);
        bldr.setField("field2", (Object)"2");
        BinaryObject unregisteredType = bldr.build();
        cache.put((Object)5, (Object)unregisteredType);
        bldr = bin.builder("UNREGISTERED_TEST_TYPE");
        bldr.setField("field1", (Object)1);
        bldr.setField("field2", (Object)"2");
        bldr.setField("field3", (Object)3L);
        BinaryObject unregisteredType2 = bldr.build();
        cache.put((Object)6, (Object)unregisteredType2);
        long ccId = this.forceConsistentCut((Ignite)ignite);
        this.forceConsistentCut((Ignite)ignite);
        this.awakeCutsWatcher(clusterReplica);
        this.waitForApplyingCut(clusterReplica, ccId, 500000000L);
        IgniteCache replicaCache = replicaIgnite.cache("txCache");
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)testVal, (Object)replicaCache.get((Object)1));
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)testType, (Object)replicaCache.withKeepBinary().get((Object)2));
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)testType2, (Object)replicaCache.withKeepBinary().get((Object)3));
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)unregisteredVal, (Object)replicaCache.get((Object)4));
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)unregisteredType, (Object)replicaCache.withKeepBinary().get((Object)5));
        TxDrBinaryMetadataReplicationTest.assertEquals((Object)unregisteredType2, (Object)replicaCache.withKeepBinary().get((Object)6));
    }

    @Test
    public void testReplicationMultithreaded() throws Exception {
        this.consistentCutInterval = 3000L;
        List<IgniteEx> clusterMaster = this.startCluster(ClusterRole.MASTER);
        IgniteEx igniteMaster = clusterMaster.get(0);
        igniteMaster.cluster().active(true);
        IgniteCache cacheMaster = igniteMaster.cache(TX_BIN_META_CACHE_NAME);
        AtomicBoolean stop = new AtomicBoolean();
        AtomicBoolean expand = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            while (!stop.get()) {
                int nodeIdx = rnd.nextInt(this.nodesCnt);
                IgniteEx ignite = this.grid(this.igniteInstanceNameWithRole(ClusterRole.MASTER, nodeIdx));
                IgniteCache cache = ignite.cache(TX_BIN_META_CACHE_NAME);
                Transaction tx = ignite.transactions().txStart();
                Throwable throwable = null;
                try {
                    IgniteBinary bin = TxDrBinaryMetadataReplicationTest.binary(ignite);
                    BinaryObjectBuilder bldr = bin.builder("TEST_TYPE_" + rnd.nextInt(!expand.get() ? 100 : 200));
                    int fieldsCnt = rnd.nextInt(20) + 1;
                    for (int i = 0; i < fieldsCnt; ++i) {
                        if (rnd.nextInt(2) > 0) {
                            bldr.setField("fieldInt_" + i, (Object)rnd.nextInt(10));
                            continue;
                        }
                        bldr.setField("fieldStr_" + i, (Object)String.valueOf(rnd.nextInt(10)));
                    }
                    BinaryObject val = bldr.build();
                    cache.put((Object)rnd.nextInt(), (Object)val);
                    tx.commit();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }, (int)this.nodesCnt, (String)"tx-load-thread");
        TxDrBinaryMetadataReplicationTest.doSleep((long)15000L);
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        TransactionalDrProcessorImpl txdrMaster = this.txdr((Ignite)clusterMaster.get(0));
        BootstrapMasterParameters bootstrapParams = new BootstrapMasterParameters.Builder().withSnapshotFolder(snapshotDir).build();
        long sesId = (Long)txdrMaster.bootstrap(bootstrapParams).get();
        this.assertClusterState(clusterMaster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        expand.set(true);
        List<IgniteEx> clusterReplica = this.startCluster(ClusterRole.REPLICA);
        IgniteEx igniteReplica = clusterReplica.get(0);
        igniteReplica.cluster().active(true);
        TransactionalDrProcessorImpl txdrReplica = this.txdr((Ignite)igniteReplica);
        txdrReplica.bootstrap(snapshotDir, sesId).get();
        TxDrBinaryMetadataReplicationTest.doSleep((long)15000L);
        stop.set(true);
        fut.get();
        long ccId = this.forceConsistentCut((Ignite)igniteMaster);
        this.awakeCutsWatcher(clusterReplica);
        this.waitForApplyingCut(clusterReplica, ccId, 500000000L);
        IgniteCache cacheReplica = igniteReplica.cache(TX_BIN_META_CACHE_NAME).withKeepBinary();
        for (Cache.Entry e : cacheMaster.withKeepBinary()) {
            TxDrBinaryMetadataReplicationTest.assertEquals((Object)e.getValue(), (Object)cacheReplica.get((Object)((Integer)e.getKey())));
        }
    }

    @Test
    public void testReplicationWithIndexedCacheAndMultithreaded_SwitchRoles() throws Exception {
        this.consistentCutInterval = 3000L;
        List<IgniteEx> clusterMaster = this.startCluster(ClusterRole.MASTER);
        IgniteEx igniteMaster = clusterMaster.get(0);
        igniteMaster.cluster().active(true);
        AtomicBoolean stop = new AtomicBoolean();
        IgniteInternalFuture fut = GridTestUtils.runMultiThreadedAsync(() -> {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            ArrayList<String> fields = new ArrayList<String>(IDX_FIELDS);
            while (!stop.get()) {
                int nodeIdx = rnd.nextInt(this.nodesCnt);
                IgniteEx ignite = this.grid(this.igniteInstanceNameWithRole(ClusterRole.MASTER, nodeIdx));
                IgniteCache cache = ignite.cache(TX_BIN_IDX_META_CACHE_NAME);
                try {
                    Transaction tx = ignite.transactions().txStart();
                    Throwable throwable = null;
                    try {
                        IgniteBinary bin = TxDrBinaryMetadataReplicationTest.binary(ignite);
                        BinaryObjectBuilder bldr = bin.builder("Value");
                        Collections.shuffle(fields);
                        fields.forEach(s -> bldr.setField(s, (Object)("s" + rnd.nextInt())));
                        BinaryObject val = bldr.build();
                        cache.put((Object)rnd.nextInt(), (Object)val);
                        tx.commit();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }, (int)this.nodesCnt, (String)"tx-load-thread");
        File snapshotDir = new File(U.defaultWorkDirectory(), "snapshot");
        TransactionalDrProcessorImpl txdrMaster = this.txdr((Ignite)clusterMaster.get(0));
        BootstrapMasterParameters bootstrapParams = new BootstrapMasterParameters.Builder().withSnapshotFolder(snapshotDir).build();
        long sesId = (Long)txdrMaster.bootstrap(bootstrapParams).get();
        this.assertClusterState(clusterMaster, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        List<IgniteEx> clusterReplica = this.startCluster(ClusterRole.REPLICA);
        IgniteEx igniteReplica = clusterReplica.get(0);
        igniteReplica.cluster().active(true);
        TransactionalDrProcessorImpl txdrReplica = this.txdr((Ignite)igniteReplica);
        txdrReplica.bootstrap(snapshotDir, sesId).get();
        log.info(">>> Replica with master switch started");
        sesId = (Long)txdrMaster.switchWithReplica().get();
        log.info(">>> Replica with master switched");
        stop.set(true);
        fut.get();
        TxDrBinaryMetadataReplicationTest.assertTrue((boolean)GridTestUtils.waitForCondition(() -> {
            for (IgniteEx ignite : clusterReplica) {
                ReplicationSessionDescriptor state = this.txdr((Ignite)ignite).localState();
                if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) continue;
                return false;
            }
            return true;
        }, (long)40000L));
        this.assertClusterState(clusterReplica, ClusterRole.MASTER, ReplicationState.RUNNING, sesId);
        this.assertClusterState(clusterMaster, ClusterRole.REPLICA, ReplicationState.RUNNING, sesId);
        IgniteCache cacheReplica = igniteReplica.cache(TX_BIN_IDX_META_CACHE_NAME).withKeepBinary();
        IgniteCache cacheMaster = igniteMaster.cache(TX_BIN_IDX_META_CACHE_NAME).withKeepBinary();
        for (Cache.Entry e : cacheMaster.withKeepBinary()) {
            TxDrBinaryMetadataReplicationTest.assertEquals((Object)e.getValue(), (Object)cacheReplica.get((Object)((Integer)e.getKey())));
        }
    }

    private static IgniteBinary binary(IgniteEx ignite) {
        IgniteCacheObjectProcessor cacheObjProc = ignite.context().cacheObjects();
        CacheObjectBinaryProcessorImpl binObjProc = (CacheObjectBinaryProcessorImpl)cacheObjProc;
        return binObjProc.binary();
    }

    private static class UnregisteredTestValue
    extends TestValue {
        private final String val = "UNREGISTERED";

        private UnregisteredTestValue() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnregisteredTestValue that = (UnregisteredTestValue)o;
            return Objects.equals("UNREGISTERED", that.val);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), "UNREGISTERED");
        }
    }

    private static class TestValue {
        protected final long id = ThreadLocalRandom.current().nextLong();
        final String str = "str" + Long.toString(this.id);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestValue testVal = (TestValue)o;
            return this.id == testVal.id && Objects.equals(this.str, testVal.str);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.str);
        }
    }
}

