/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.transactions.LocalPendingTransactionsTracker;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.transactions.TransactionState;
import org.gridgain.grid.internal.processors.cache.database.txdr.TestKeyCacheObject;

public class TestLocalTxEngine {
    private final IgniteWriteAheadLogManager mockWal;
    private final LocalPendingTransactionsTracker transactionsTracker;
    private final ConcurrentHashMap<GridCacheVersion, List<Integer>> transactionKeys;
    private final LockPolicy lockPlc;

    public TestLocalTxEngine(IgniteWriteAheadLogManager mockWal, LocalPendingTransactionsTracker transactionsTracker, LockPolicy lockPlc) {
        this.mockWal = mockWal;
        this.transactionsTracker = transactionsTracker;
        this.transactionKeys = new ConcurrentHashMap();
        this.lockPlc = lockPlc;
    }

    public void lockKey(GridCacheVersion nearXidVer, Integer key) {
        this.lockPlc.lockKey(nearXidVer, key);
        this.transactionKeys.compute(nearXidVer, (tx, keys) -> {
            List txKeys = keys == null ? new ArrayList() : keys;
            txKeys.add(key);
            return txKeys;
        });
    }

    public void lockKeys(GridCacheVersion nearXidVer, List<Integer> keys) {
        for (Integer key : keys) {
            this.lockKey(nearXidVer, key);
        }
    }

    public GridCacheVersion lockOwner(Integer key) {
        return this.lockPlc.lockOwner(key);
    }

    public void unlockKey(GridCacheVersion nearXidVer, Integer key) {
        this.lockPlc.unlockKey(nearXidVer, key);
    }

    private void unlockKeys(GridCacheVersion nearXidVer, List<Integer> keys) {
        for (Integer key : keys) {
            this.unlockKey(nearXidVer, key);
        }
    }

    public FileWALPointer prepareTx(GridCacheVersion nearXidVer) throws IgniteCheckedException {
        TxRecord txRecord = new TxRecord(TransactionState.PREPARED, nearXidVer, null, null);
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)txRecord);
        this.transactionsTracker.onTxPrepared(nearXidVer);
        return ptr;
    }

    public FileWALPointer commitTx(GridCacheVersion nearXidVer) throws IgniteCheckedException {
        TxRecord txRecord = new TxRecord(TransactionState.COMMITTED, nearXidVer, null, null);
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)txRecord);
        this.transactionsTracker.onTxCommitted(nearXidVer);
        this.unlockKeys(nearXidVer, this.transactionKeys.remove(nearXidVer));
        return ptr;
    }

    public FileWALPointer rollbackTx(GridCacheVersion nearXidVer) throws IgniteCheckedException {
        TxRecord txRecord = new TxRecord(TransactionState.ROLLED_BACK, nearXidVer, null, null);
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)txRecord);
        this.transactionsTracker.onTxRolledBack(nearXidVer);
        this.unlockKeys(nearXidVer, this.transactionKeys.remove(nearXidVer));
        return ptr;
    }

    public FileWALPointer writeKey(GridCacheVersion nearXidVer, Integer key) throws IgniteCheckedException {
        if (!nearXidVer.equals((Object)this.lockOwner(key))) {
            throw new IllegalStateException("Key is not locked [owner=" + this.lockOwner(key) + "]");
        }
        TestKeyCacheObject keyObj = new TestKeyCacheObject(key);
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)new DataRecord(new DataEntry(0, (KeyCacheObject)keyObj, null, GridCacheOperation.UPDATE, nearXidVer, null, 0L, 0, 0L, 0)));
        this.transactionsTracker.onKeysWritten(nearXidVer, Collections.singletonList(keyObj));
        return ptr;
    }

    public FileWALPointer writeKeys(GridCacheVersion nearXidVer, List<Integer> keys) throws IgniteCheckedException {
        ArrayList<DataEntry> entries = new ArrayList<DataEntry>(keys.size());
        ArrayList<TestKeyCacheObject> keyObjs = new ArrayList<TestKeyCacheObject>(keys.size());
        for (Integer key : keys) {
            if (!nearXidVer.equals((Object)this.lockOwner(key))) {
                throw new IllegalStateException("Key is not locked [owner=" + this.lockOwner(key) + "]");
            }
            TestKeyCacheObject keyObj = new TestKeyCacheObject(key);
            keyObjs.add(keyObj);
            entries.add(new DataEntry(0, (KeyCacheObject)keyObj, null, GridCacheOperation.UPDATE, nearXidVer, null, 0L, 0, 0L, 0));
        }
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)new DataRecord(entries));
        this.transactionsTracker.onKeysWritten(nearXidVer, keyObjs);
        return ptr;
    }

    public FileWALPointer readKey(GridCacheVersion nearXidVer, Integer key) throws IgniteCheckedException {
        if (!nearXidVer.equals((Object)this.lockOwner(key))) {
            throw new IllegalStateException("Key is not locked [owner=" + this.lockOwner(key) + "]");
        }
        TestKeyCacheObject keyObj = new TestKeyCacheObject(key);
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)new DataRecord(new DataEntry(0, (KeyCacheObject)keyObj, null, GridCacheOperation.READ, nearXidVer, null, 0L, 0, 0L, 0)));
        this.transactionsTracker.onKeysRead(nearXidVer, Collections.singletonList(keyObj));
        return ptr;
    }

    public FileWALPointer readKeys(GridCacheVersion nearXidVer, List<Integer> keys) throws IgniteCheckedException {
        ArrayList<DataEntry> entries = new ArrayList<DataEntry>(keys.size());
        ArrayList<TestKeyCacheObject> keyObjs = new ArrayList<TestKeyCacheObject>(keys.size());
        for (Integer key : keys) {
            if (!nearXidVer.equals((Object)this.lockOwner(key))) {
                throw new IllegalStateException("Key is not locked [owner=" + this.lockOwner(key) + "]");
            }
            TestKeyCacheObject keyObj = new TestKeyCacheObject(key);
            keyObjs.add(keyObj);
            entries.add(new DataEntry(0, (KeyCacheObject)keyObj, null, GridCacheOperation.READ, nearXidVer, null, 0L, 0, 0L, 0));
        }
        FileWALPointer ptr = (FileWALPointer)this.mockWal.log((WALRecord)new DataRecord(entries));
        this.transactionsTracker.onKeysRead(nearXidVer, keyObjs);
        return ptr;
    }

    public static class ReentrantLockPolicy
    implements LockPolicy {
        private final ConcurrentHashMap<Integer, KeyLock> keyLocks = new ConcurrentHashMap();
        private static final KeyLock EMPTY_LOCK = new KeyLock();

        @Override
        public void lockKey(GridCacheVersion nearXidVer, Integer key) {
            KeyLock keyLock = this.keyLocks.computeIfAbsent(key, k -> new KeyLock());
            assert (keyLock != null);
            try {
                keyLock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedException(e);
            }
            keyLock.owner(nearXidVer);
        }

        @Override
        public void unlockKey(GridCacheVersion nearXidVer, Integer key) {
            this.keyLocks.compute(key, (k, v) -> {
                if (v == null) {
                    throw new IllegalStateException("Key is not locked");
                }
                GridCacheVersion owner0 = v.owner();
                if (!owner0.equals((Object)nearXidVer)) {
                    throw new IllegalStateException("Failed to unlock [actualOwner=" + owner0 + ", expectedOwner=" + nearXidVer + "]");
                }
                v.owner(null);
                v.unlock();
                return v;
            });
        }

        @Override
        public GridCacheVersion lockOwner(Integer key) {
            return this.keyLocks.getOrDefault(key, EMPTY_LOCK).owner();
        }

        private static class KeyLock {
            private volatile GridCacheVersion owner;
            private final ReentrantLock lock = new ReentrantLock();

            public void owner(GridCacheVersion owner) {
                assert (this.owner == null || owner == null);
                assert (this.lock.isHeldByCurrentThread());
                this.owner = owner;
            }

            public GridCacheVersion owner() {
                return this.owner;
            }

            public void lockInterruptibly() throws InterruptedException {
                this.lock.lockInterruptibly();
            }

            public void unlock() {
                this.lock.unlock();
            }
        }
    }

    public static class SimpleCheckPolicy
    implements LockPolicy {
        private final ConcurrentHashMap<Integer, GridCacheVersion> keyLocks = new ConcurrentHashMap();

        @Override
        public void lockKey(GridCacheVersion nearXidVer, Integer key) {
            GridCacheVersion owner = this.keyLocks.putIfAbsent(key, nearXidVer);
            if (owner != null) {
                throw new IllegalStateException("Key is locked [owner=" + owner + "]");
            }
        }

        @Override
        public void unlockKey(GridCacheVersion nearXidVer, Integer key) {
            this.keyLocks.compute(key, (k, v) -> {
                if (v == null) {
                    throw new IllegalStateException("Key is not locked");
                }
                if (!v.equals((Object)nearXidVer)) {
                    throw new IllegalStateException("Failed to unlock [actualOwner=" + v + ", expectedOwner=" + nearXidVer + "]");
                }
                return null;
            });
        }

        @Override
        public GridCacheVersion lockOwner(Integer key) {
            return this.keyLocks.get(key);
        }
    }

    public static interface LockPolicy {
        public void lockKey(GridCacheVersion var1, Integer var2);

        public void unlockKey(GridCacheVersion var1, Integer var2);

        public GridCacheVersion lockOwner(Integer var1);
    }
}

