/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.transactions.LocalPendingTransactionsTracker;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.FileConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.GlobalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.LocalConsistentCutData;
import org.gridgain.grid.internal.processors.cache.database.txdr.TestNodeContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConsistentCutUnitTest {
    private static final int NODES = 6;
    private static ScheduledExecutorService timeoutExecutor;
    private TestNodeContext[] nodes;

    @BeforeClass
    public static void setUpClass() {
        timeoutExecutor = new ScheduledThreadPoolExecutor(1);
        U.onGridStart();
        System.setProperty("IGNITE_PENDING_TX_TRACKER_ENABLED", "true");
    }

    @AfterClass
    public static void tearDownClass() {
        timeoutExecutor.shutdown();
        System.clearProperty("IGNITE_PENDING_TX_TRACKER_ENABLED");
    }

    @Before
    public void setUp() throws Exception {
        this.nodes = new TestNodeContext[6];
        for (int i = 0; i < 6; ++i) {
            this.nodes[i] = new TestNodeContext(i, timeoutExecutor);
        }
    }

    @Test
    public void testSimple() throws Exception {
        GridCacheVersion tx1 = new GridCacheVersion(0, 1L, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 1);
        this.nodes[1].txEngine().lockKey(tx1, 1);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[1].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().writeKey(tx1, 1);
        this.nodes[1].txEngine().writeKey(tx1, 1);
        this.nodes[0].txEngine().commitTx(tx1);
        this.nodes[1].txEngine().commitTx(tx1);
        this.startTrackingTransactionsLocally();
        GridCacheVersion tx2 = new GridCacheVersion(0, 2L, 0, 0);
        GridCacheVersion tx3 = new GridCacheVersion(0, 3L, 0, 0);
        GridCacheVersion tx4 = new GridCacheVersion(0, 4L, 0, 0);
        this.nodes[0].txEngine().lockKey(tx2, 2);
        this.nodes[1].txEngine().lockKey(tx2, 2);
        this.nodes[0].txEngine().lockKey(tx3, 3);
        this.nodes[1].txEngine().lockKey(tx3, 3);
        this.nodes[0].txEngine().lockKey(tx4, 4);
        this.nodes[1].txEngine().lockKey(tx4, 4);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[1].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().writeKey(tx2, 2);
        this.nodes[1].txEngine().writeKey(tx2, 2);
        this.nodes[0].txEngine().commitTx(tx2);
        this.nodes[1].txEngine().commitTx(tx2);
        FileWALPointer node0prep3ptr = this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[0].consistentCutContext().markConsistentCutPoint();
        this.nodes[1].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().writeKey(tx3, 3);
        this.nodes[1].txEngine().writeKey(tx3, 3);
        FileWALPointer node0ci3ptr = this.nodes[0].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().commitTx(tx3);
        this.nodes[0].txEngine().prepareTx(tx4);
        this.nodes[1].txEngine().prepareTx(tx4);
        this.nodes[0].txEngine().writeKey(tx4, 4);
        this.nodes[1].txEngine().writeKey(tx4, 4);
        this.nodes[0].txEngine().commitTx(tx4);
        FileWALPointer node1ci4ptr = this.nodes[1].txEngine().commitTx(tx4);
        this.nodes[1].consistentCutContext().markConsistentCutPoint();
        GridCacheVersion tx5 = new GridCacheVersion(0, 5L, 0, 0);
        this.nodes[0].txEngine().lockKey(tx5, 5);
        this.nodes[1].txEngine().lockKey(tx5, 5);
        this.nodes[0].txEngine().prepareTx(tx5);
        this.nodes[1].txEngine().prepareTx(tx5);
        this.nodes[0].txEngine().writeKey(tx5, 5);
        this.nodes[1].txEngine().writeKey(tx5, 5);
        this.nodes[0].txEngine().commitTx(tx5);
        this.nodes[1].txEngine().commitTx(tx5);
        for (int i = 2; i < 6; ++i) {
            this.nodes[i].consistentCutContext().markConsistentCutPoint();
        }
        GlobalConsistentCutData globData = this.finishTrackingTransactionsLocally().global();
        ConsistentCut[] cuts = this.completeConsistentCutCreation(globData);
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx4));
        FileWALPointer cutPtrNode0 = (FileWALPointer)cuts[0].cutPtr();
        Assert.assertTrue((cutPtrNode0.compareTo(node0prep3ptr) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cutPtrNode0.compareTo(node0ci3ptr) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx4));
        FileWALPointer cutPtrNode1 = (FileWALPointer)cuts[1].cutPtr();
        Assert.assertTrue((cutPtrNode1.compareTo(node1ci4ptr) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAwaitTxsFinish() throws Exception {
        GridCacheVersion tx1 = new GridCacheVersion(0, 1L, 0, 0);
        GridCacheVersion tx2 = new GridCacheVersion(0, 2L, 0, 0);
        GridCacheVersion tx3 = new GridCacheVersion(0, 3L, 0, 0);
        GridCacheVersion tx4 = new GridCacheVersion(0, 4L, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 1);
        this.nodes[1].txEngine().lockKey(tx1, 1);
        this.nodes[0].txEngine().lockKey(tx2, 2);
        this.nodes[1].txEngine().lockKey(tx2, 2);
        this.nodes[0].txEngine().lockKey(tx3, 3);
        this.nodes[1].txEngine().lockKey(tx3, 3);
        this.nodes[0].txEngine().lockKey(tx4, 4);
        this.nodes[1].txEngine().lockKey(tx4, 4);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[1].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[1].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[1].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().prepareTx(tx4);
        this.nodes[1].txEngine().prepareTx(tx4);
        this.nodes[0].txEngine().writeKey(tx1, 1);
        this.nodes[1].txEngine().writeKey(tx2, 2);
        long[] trackingMs = new long[2];
        CountDownLatch latch = new CountDownLatch(2);
        int i = 0;
        while (i <= 1) {
            int node = i++;
            new Thread(() -> {
                long curTs = U.currentTimeMillis();
                try {
                    this.nodes[node].consistentCutContext().startTrackingTransactionsLocally();
                    this.nodes[node].consistentCutContext().awaitPendingTransactionsLocally(Collections.emptySet());
                }
                catch (IgniteCheckedException e) {
                    e.printStackTrace();
                }
                finally {
                    trackingMs[node] = U.currentTimeMillis() - curTs;
                    latch.countDown();
                }
            }).start();
        }
        for (i = 2; i < 6; ++i) {
            this.nodes[i].consistentCutContext().startTrackingTransactionsLocally();
        }
        long[] sleepMs = new long[]{1250L, 5000L, 1250L};
        Thread.sleep(sleepMs[0]);
        this.nodes[1].txEngine().writeKey(tx1, 1);
        this.nodes[0].txEngine().writeKey(tx2, 2);
        this.nodes[0].txEngine().writeKey(tx3, 3);
        this.nodes[1].txEngine().writeKey(tx3, 3);
        this.nodes[0].txEngine().writeKey(tx4, 4);
        this.nodes[1].txEngine().writeKey(tx4, 4);
        this.nodes[0].txEngine().commitTx(tx1);
        this.nodes[1].txEngine().commitTx(tx1);
        this.nodes[0].txEngine().commitTx(tx2);
        this.nodes[0].txEngine().commitTx(tx3);
        Thread.sleep(sleepMs[1]);
        this.nodes[1].txEngine().commitTx(tx3);
        Thread.sleep(sleepMs[2]);
        this.nodes[1].txEngine().commitTx(tx2);
        latch.await();
        this.nodes[0].txEngine().commitTx(tx4);
        this.nodes[1].txEngine().commitTx(tx4);
        this.markConsistentCutPoint();
        ConsistentCut[] cuts = this.completeConsistentCutCreation();
        long[] expTrackingMs = new long[]{5000L, sleepMs[0] + sleepMs[1] + sleepMs[2]};
        for (int i2 = 0; i2 <= 1; ++i2) {
            Assert.assertTrue((String)("Tracking transactions for node[" + i2 + "] too short: " + trackingMs[i2]), (trackingMs[i2] > expTrackingMs[i2] - 50L ? 1 : 0) != 0);
            Assert.assertTrue((String)("Tracking transactions for node[" + i2 + "] too long: " + trackingMs[i2]), (trackingMs[i2] < expTrackingMs[i2] + 1000L ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx4));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx4));
    }

    private ConsistentCut[] completeConsistentCutCreation() {
        GlobalConsistentCutData.Builder globDataBuilder = new GlobalConsistentCutData.Builder();
        for (TestNodeContext node : this.nodes) {
            globDataBuilder.merge(node.nodeUuid(), node.consistentCutContext().finishTrackingTransactionsLocally());
        }
        ConsistentCut[] cuts = new ConsistentCut[6];
        for (int i = 0; i < 6; ++i) {
            cuts[i] = this.nodes[i].consistentCutContext().completeConsistentCutCreation(globDataBuilder.build(), null);
        }
        return cuts;
    }

    @Test
    public void testFileStore() throws Exception {
        GridCacheVersion tx1 = new GridCacheVersion(0, 1L, 0, 0);
        GridCacheVersion tx2 = new GridCacheVersion(0, 2L, 0, 0);
        ConcurrentHashMap<GridCacheVersion, GridCacheVersion> txMap = new ConcurrentHashMap<GridCacheVersion, GridCacheVersion>();
        txMap.put(tx1, tx1);
        txMap.put(tx2, tx2);
        FileWALPointer ptr0 = new FileWALPointer(0L, 0, 1);
        FileWALPointer ptr1 = new FileWALPointer(1L, 1, 1);
        FileWALPointer ptr2 = new FileWALPointer(2L, 2, 1);
        FileWALPointer ptr3 = new FileWALPointer(3L, 3, 1);
        ConsistentCut cut1 = this.createConsistentCut(1L, (WALPointer)ptr0, (WALPointer)ptr1, Collections.singleton(tx1));
        ConsistentCut cut2 = this.createConsistentCut(2L, (WALPointer)ptr1, (WALPointer)ptr2, txMap.keySet());
        ConsistentCut cut3 = this.createConsistentCut(3L, (WALPointer)ptr2, (WALPointer)ptr3, Collections.emptySet());
        File dir = U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"cuts", (boolean)true);
        dir.deleteOnExit();
        FileConsistentCutStore store = new FileConsistentCutStore(dir, (Marshaller)new JdkMarshaller());
        store.save(cut1);
        store.save(cut2);
        store.save(cut3);
        Assert.assertEquals((long)3L, (long)store.list().size());
        ConsistentCut cutRestored1 = store.restore(1L);
        ConsistentCut cutRestored2 = store.restore(2L);
        ConsistentCut cutRestored3 = store.restore(3L);
        Assert.assertEquals((Object)cut1, (Object)cutRestored1);
        Assert.assertEquals((Object)cut2, (Object)cutRestored2);
        Assert.assertEquals((Object)cut3, (Object)cutRestored3);
        Assert.assertEquals((long)2L, (long)store.list(2L).size());
        store.delete(1L);
        Assert.assertEquals((long)2L, (long)store.list().size());
        store.cleanup();
        Assert.assertEquals((long)0L, (long)store.list().size());
    }

    @Test
    public void testSimpleDependentTransactions() throws Exception {
        long verOrder = 1L;
        GridCacheVersion tx1 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 1);
        this.nodes[1].txEngine().lockKey(tx1, 1);
        this.nodes[2].txEngine().lockKey(tx1, 1);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[1].txEngine().prepareTx(tx1);
        this.nodes[2].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().writeKey(tx1, 1);
        this.nodes[1].txEngine().writeKey(tx1, 1);
        this.nodes[2].txEngine().writeKey(tx1, 1);
        this.nodes[0].txEngine().commitTx(tx1);
        this.nodes[1].txEngine().commitTx(tx1);
        this.nodes[2].txEngine().commitTx(tx1);
        this.startTrackingTransactionsLocally();
        GridCacheVersion tx2 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx3 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx4 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx5 = new GridCacheVersion(0, verOrder, 0, 0);
        List<Integer> tx2Keys = Arrays.asList(2, 3);
        List<Integer> tx3Keys = Arrays.asList(3, 4);
        List<Integer> tx4Keys = Arrays.asList(4, 5);
        List<Integer> tx5Keys = Arrays.asList(6, 7, 8);
        this.nodes[0].txEngine().lockKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().writeKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().commitTx(tx2);
        this.nodes[0].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[1].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[1].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().writeKeys(tx3, tx3Keys);
        this.nodes[1].txEngine().writeKeys(tx3, tx3Keys);
        this.nodes[1].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().prepareTx(tx4);
        this.nodes[2].txEngine().prepareTx(tx4);
        this.nodes[1].txEngine().writeKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().writeKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().commitTx(tx4);
        this.nodes[2].txEngine().commitTx(tx4);
        this.markConsistentCutPoint();
        this.nodes[0].txEngine().commitTx(tx3);
        this.nodes[0].txEngine().lockKeys(tx5, tx5Keys);
        this.nodes[1].txEngine().lockKeys(tx5, tx5Keys);
        this.nodes[2].txEngine().lockKeys(tx5, tx5Keys);
        this.nodes[0].txEngine().prepareTx(tx5);
        this.nodes[1].txEngine().prepareTx(tx5);
        this.nodes[2].txEngine().prepareTx(tx5);
        this.nodes[0].txEngine().writeKeys(tx5, tx5Keys);
        this.nodes[1].txEngine().writeKeys(tx5, tx5Keys);
        this.nodes[2].txEngine().writeKeys(tx5, tx5Keys);
        this.nodes[0].txEngine().commitTx(tx5);
        this.nodes[1].txEngine().commitTx(tx5);
        this.nodes[2].txEngine().commitTx(tx5);
        GlobalConsistentCutData globData = this.finishTrackingTransactionsLocally().global();
        ConsistentCut[] cuts = this.completeConsistentCutCreation(globData);
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx4));
        Assert.assertTrue((boolean)cuts[2].skipTxs().contains(tx4));
    }

    @Test
    public void testReadWriteDependency() throws Exception {
        long verOrder = 1L;
        GridCacheVersion tx1 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 10);
        this.nodes[1].txEngine().lockKey(tx1, 10);
        this.nodes[2].txEngine().lockKey(tx1, 10);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[1].txEngine().prepareTx(tx1);
        this.nodes[2].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().writeKey(tx1, 10);
        this.nodes[1].txEngine().writeKey(tx1, 10);
        this.nodes[2].txEngine().writeKey(tx1, 10);
        this.nodes[0].txEngine().commitTx(tx1);
        this.nodes[1].txEngine().commitTx(tx1);
        this.nodes[2].txEngine().commitTx(tx1);
        this.startTrackingTransactionsLocally();
        GridCacheVersion tx2 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx3 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx4 = new GridCacheVersion(0, verOrder, 0, 0);
        List<Integer> tx2Keys = Arrays.asList(2, 3);
        List<Integer> tx3Keys = Arrays.asList(2, 3);
        List<Integer> tx4Keys = Arrays.asList(3, 4);
        this.nodes[0].txEngine().lockKeys(tx2, tx2Keys);
        this.nodes[1].txEngine().lockKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[1].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().readKeys(tx2, tx2Keys);
        this.nodes[1].txEngine().readKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().commitTx(tx2);
        this.nodes[1].txEngine().commitTx(tx2);
        this.nodes[0].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[1].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[1].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().readKeys(tx3, tx3Keys);
        this.nodes[0].consistentCutContext().markConsistentCutPoint();
        this.nodes[1].txEngine().readKeys(tx3, tx3Keys);
        this.nodes[0].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().prepareTx(tx4);
        this.nodes[2].txEngine().prepareTx(tx4);
        this.nodes[1].txEngine().writeKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().writeKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().commitTx(tx4);
        this.nodes[2].txEngine().commitTx(tx4);
        for (int i = 1; i < 6; ++i) {
            this.nodes[i].consistentCutContext().markConsistentCutPoint();
        }
        ConsistentCutData cutData = this.finishTrackingTransactionsLocally();
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(0)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx3, tx4)));
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(1)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx3, tx4)));
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(2)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx3, tx4)));
        ConsistentCut[] cuts = this.completeConsistentCutCreation(cutData.global());
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx3));
        Assert.assertFalse((boolean)cuts[0].skipTxs().contains(tx2));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx3));
        Assert.assertFalse((boolean)cuts[1].skipTxs().contains(tx2));
        Assert.assertFalse((boolean)cuts[1].skipTxs().contains(tx4));
        Assert.assertFalse((boolean)cuts[2].skipTxs().contains(tx2));
        Assert.assertFalse((boolean)cuts[2].skipTxs().contains(tx3));
        Assert.assertFalse((boolean)cuts[2].skipTxs().contains(tx4));
    }

    @Test
    public void testWriteReadDependency() throws Exception {
        long verOrder = 1L;
        GridCacheVersion tx1 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 10);
        this.nodes[1].txEngine().lockKey(tx1, 10);
        this.nodes[2].txEngine().lockKey(tx1, 10);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[1].txEngine().prepareTx(tx1);
        this.nodes[2].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().writeKey(tx1, 10);
        this.nodes[1].txEngine().writeKey(tx1, 10);
        this.nodes[2].txEngine().writeKey(tx1, 10);
        this.nodes[0].txEngine().commitTx(tx1);
        this.nodes[1].txEngine().commitTx(tx1);
        this.nodes[2].txEngine().commitTx(tx1);
        this.startTrackingTransactionsLocally();
        GridCacheVersion tx2 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx3 = new GridCacheVersion(0, verOrder++, 0, 0);
        GridCacheVersion tx4 = new GridCacheVersion(0, verOrder, 0, 0);
        List<Integer> tx2Keys = Arrays.asList(2, 3);
        List<Integer> tx3Keys = Arrays.asList(2, 3);
        List<Integer> tx4Keys = Arrays.asList(3, 4);
        this.nodes[0].txEngine().lockKeys(tx2, tx2Keys);
        this.nodes[1].txEngine().lockKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[1].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().readKeys(tx2, tx2Keys);
        this.nodes[1].txEngine().readKeys(tx2, tx2Keys);
        this.nodes[0].txEngine().commitTx(tx2);
        this.nodes[1].txEngine().commitTx(tx2);
        this.nodes[0].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[1].txEngine().lockKeys(tx3, tx3Keys);
        this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[1].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().writeKeys(tx3, tx3Keys);
        this.nodes[0].consistentCutContext().markConsistentCutPoint();
        this.nodes[1].txEngine().writeKeys(tx3, tx3Keys);
        this.nodes[0].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().commitTx(tx3);
        this.nodes[1].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().lockKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().prepareTx(tx4);
        this.nodes[2].txEngine().prepareTx(tx4);
        this.nodes[1].txEngine().readKeys(tx4, tx4Keys);
        this.nodes[2].txEngine().readKeys(tx4, tx4Keys);
        this.nodes[1].txEngine().commitTx(tx4);
        this.nodes[2].txEngine().commitTx(tx4);
        for (int i = 1; i < 6; ++i) {
            this.nodes[i].consistentCutContext().markConsistentCutPoint();
        }
        ConsistentCutData cutData = this.finishTrackingTransactionsLocally();
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(0)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx3, tx4)));
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(1)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx4)));
        Assert.assertTrue((boolean)Collections.disjoint(((LocalConsistentCutData)cutData.locs.get(2)).dependentTxsGraph().keySet(), Arrays.asList(tx1, tx2, tx3, tx4)));
        ConsistentCut[] cuts = this.completeConsistentCutCreation(cutData.global());
        Assert.assertFalse((boolean)cuts[0].skipTxs().contains(tx2));
        Assert.assertTrue((boolean)cuts[0].skipTxs().contains(tx3));
        Assert.assertFalse((boolean)cuts[1].skipTxs().contains(tx2));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[1].skipTxs().contains(tx4));
        Assert.assertFalse((boolean)cuts[2].skipTxs().contains(tx2));
        Assert.assertFalse((boolean)cuts[2].skipTxs().contains(tx3));
        Assert.assertTrue((boolean)cuts[2].skipTxs().contains(tx4));
    }

    @Test
    public void testCommittingTransactionsAreNotSkipped() throws Exception {
        GridCacheVersion tx = new GridCacheVersion(0, 1L, 0, 0);
        this.nodes[0].txEngine().lockKey(tx, 1);
        this.nodes[1].txEngine().lockKey(tx, 1);
        this.nodes[0].txEngine().lockKey(tx, 2);
        this.nodes[1].txEngine().lockKey(tx, 2);
        this.nodes[0].txEngine().prepareTx(tx);
        this.nodes[1].txEngine().prepareTx(tx);
        this.nodes[1].txEngine().writeKey(tx, 1);
        GlobalConsistentCutData globCommiting = this.startTrackingTransactionsLocally();
        this.nodes[0].txEngine().writeKey(tx, 1);
        this.nodes[0].txEngine().writeKey(tx, 2);
        this.nodes[1].txEngine().writeKey(tx, 2);
        this.nodes[0].txEngine().commitTx(tx);
        this.nodes[1].txEngine().commitTx(tx);
        this.awaitPendingTransactionsLocally(globCommiting.globalTxs());
        this.markConsistentCutPoint();
        ConsistentCutData data = this.finishTrackingTransactionsLocally();
        ConsistentCut[] cuts = this.completeConsistentCutCreation(data.global());
        Assert.assertFalse((boolean)cuts[0].skipTxs().contains(tx));
        Assert.assertFalse((boolean)cuts[1].skipTxs().contains(tx));
    }

    @Test
    public void testResetTransactionTrackerStage1() throws Exception {
        IgniteClosure<Long, Long> cutStage = new IgniteClosure<Long, Long>(){

            public Long apply(Long ver) {
                try {
                    ConsistentCutUnitTest.this.startTrackingTransactionsLocally();
                }
                catch (IgniteCheckedException e) {
                    Assert.fail((String)"Cannot initialize the required consistent cut stage.");
                }
                return ver;
            }
        };
        this.testResetTransactionTracker(cutStage);
    }

    @Test
    public void testResetTransactionTrackerStage2() throws Exception {
        IgniteClosure<Long, Long> cutStage = new IgniteClosure<Long, Long>(){

            public Long apply(Long ver) {
                try {
                    ConsistentCutUnitTest.this.startTrackingTransactionsLocally();
                    GridCacheVersion tx1 = new GridCacheVersion(0, ver.longValue(), 0, 0);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().lockKey(tx1, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().prepareTx(tx1);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().writeKey(tx1, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().commitTx(tx1);
                    ConsistentCutUnitTest.this.markConsistentCutPoint();
                }
                catch (IgniteCheckedException e) {
                    Assert.fail((String)"Cannot initialize the required consistent cut stage.");
                }
                return ver + 1L;
            }
        };
        this.testResetTransactionTracker(cutStage);
    }

    @Test
    public void testResetTransactionTrackerStage3() throws Exception {
        IgniteClosure<Long, Long> cutStage = new IgniteClosure<Long, Long>(){

            public Long apply(Long ver) {
                try {
                    ConsistentCutUnitTest.this.startTrackingTransactionsLocally();
                    GridCacheVersion tx1 = new GridCacheVersion(0, ver.longValue(), 0, 0);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().lockKey(tx1, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().prepareTx(tx1);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().writeKey(tx1, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().commitTx(tx1);
                    ConsistentCutUnitTest.this.markConsistentCutPoint();
                    GridCacheVersion tx2 = new GridCacheVersion(0, ver + 1L, 0, 0);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().lockKey(tx2, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().prepareTx(tx2);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().writeKey(tx2, 10);
                    ConsistentCutUnitTest.this.nodes[0].txEngine().commitTx(tx2);
                }
                catch (IgniteCheckedException e) {
                    Assert.fail((String)"Cannot initialize the required consistent cut stage.");
                }
                return ver + 2L;
            }
        };
        this.testResetTransactionTracker(cutStage);
    }

    private void testResetTransactionTracker(IgniteClosure<Long, Long> cutStage) throws IgniteCheckedException {
        long verOrder = 1L;
        IgniteInClosure<Void> noop = new IgniteInClosure<Void>(){

            public void apply(Void aVoid) {
            }
        };
        IgniteInClosure<Void> resetTracker = new IgniteInClosure<Void>(){

            public void apply(Void aVoid) {
                ConsistentCutUnitTest.this.resetTransactionTracker();
            }
        };
        verOrder = this.resetTransactionTrackerAfterCutStage(verOrder, cutStage, resetTracker, noop, noop);
        verOrder = this.resetTransactionTrackerAfterCutStage(verOrder, cutStage, noop, resetTracker, noop);
        this.resetTransactionTrackerAfterCutStage(verOrder, cutStage, noop, noop, resetTracker);
    }

    private long resetTransactionTrackerAfterCutStage(long verOrder, IgniteClosure<Long, Long> cutStage, IgniteInClosure<Void> onPrepareTx, IgniteInClosure<Void> onWriteKey, IgniteInClosure<Void> onCommitTx) throws IgniteCheckedException {
        verOrder = (Long)cutStage.apply((Object)verOrder);
        GridCacheVersion tx1 = new GridCacheVersion(0, verOrder++, 0, 0);
        Integer key = new Random().nextInt();
        this.nodes[0].txEngine().lockKey(tx1, key);
        this.nodes[0].txEngine().prepareTx(tx1);
        onPrepareTx.apply(null);
        this.nodes[0].txEngine().writeKey(tx1, key);
        onWriteKey.apply(null);
        this.nodes[0].txEngine().commitTx(tx1);
        onCommitTx.apply(null);
        return this.createConsistentCutAfterReset(verOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createConsistentCutAfterReset(long verOrder) throws IgniteCheckedException {
        GridCacheVersion tx1 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx1, 10);
        this.nodes[0].txEngine().prepareTx(tx1);
        this.nodes[0].txEngine().writeKey(tx1, 10);
        this.nodes[0].txEngine().commitTx(tx1);
        for (TestNodeContext node : this.nodes) {
            node.tracker().writeLockState();
            try {
                Set trackedCommittedTxs = (Set)GridTestUtils.getFieldValue((Object)node.tracker(), LocalPendingTransactionsTracker.class, (String)"trackedCommittedTxs");
                Map writtenKeysToNearXidVer = (Map)GridTestUtils.getFieldValue((Object)node.tracker(), LocalPendingTransactionsTracker.class, (String)"writtenKeysToNearXidVer");
                Map dependentTransactionsGraph = (Map)GridTestUtils.getFieldValue((Object)node.tracker(), LocalPendingTransactionsTracker.class, (String)"dependentTransactionsGraph");
                Assert.assertTrue((boolean)trackedCommittedTxs.isEmpty());
                Assert.assertTrue((boolean)writtenKeysToNearXidVer.isEmpty());
                Assert.assertTrue((boolean)dependentTransactionsGraph.isEmpty());
            }
            finally {
                node.tracker().writeUnlockState();
            }
        }
        this.startTrackingTransactionsLocally();
        GridCacheVersion tx2 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx2, 10);
        this.nodes[0].txEngine().prepareTx(tx2);
        this.nodes[0].txEngine().writeKey(tx2, 10);
        this.nodes[0].txEngine().commitTx(tx2);
        for (TestNodeContext node : this.nodes) {
            node.tracker().writeLockState();
            try {
                Set trackedPreparedTxs = (Set)GridTestUtils.getFieldValue((Object)node.tracker(), LocalPendingTransactionsTracker.class, (String)"trackedPreparedTxs");
                Assert.assertTrue((boolean)trackedPreparedTxs.isEmpty());
            }
            finally {
                node.tracker().writeUnlockState();
            }
        }
        this.markConsistentCutPoint();
        GridCacheVersion tx3 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx3, 10);
        this.nodes[0].txEngine().prepareTx(tx3);
        this.nodes[0].txEngine().writeKey(tx3, 10);
        this.nodes[0].txEngine().commitTx(tx3);
        ConsistentCutData cutData = this.finishTrackingTransactionsLocally();
        GridCacheVersion tx4 = new GridCacheVersion(0, verOrder++, 0, 0);
        this.nodes[0].txEngine().lockKey(tx4, 10);
        this.nodes[0].txEngine().prepareTx(tx4);
        this.nodes[0].txEngine().writeKey(tx4, 10);
        this.nodes[0].txEngine().commitTx(tx4);
        ConsistentCut[] cuts = this.completeConsistentCutCreation(cutData.global());
        this.resetTransactionTracker();
        return verOrder;
    }

    private void resetTransactionTracker() {
        for (TestNodeContext node : this.nodes) {
            node.resetConsistentCutContext();
        }
    }

    private GlobalConsistentCutData startTrackingTransactionsLocally() throws IgniteCheckedException {
        GlobalConsistentCutData.Builder globDataBuilder = new GlobalConsistentCutData.Builder();
        for (TestNodeContext node : this.nodes) {
            globDataBuilder.merge(node.nodeUuid(), node.consistentCutContext().startTrackingTransactionsLocally());
        }
        return globDataBuilder.build();
    }

    private void awaitPendingTransactionsLocally(Set<GridCacheVersion> globalCommitingTxs) throws IgniteCheckedException {
        for (TestNodeContext node : this.nodes) {
            node.consistentCutContext().awaitPendingTransactionsLocally(globalCommitingTxs);
        }
    }

    private void markConsistentCutPoint() throws IgniteCheckedException {
        for (TestNodeContext node : this.nodes) {
            node.consistentCutContext().markConsistentCutPoint();
        }
    }

    private ConsistentCutData finishTrackingTransactionsLocally() {
        ArrayList<LocalConsistentCutData> locs = new ArrayList<LocalConsistentCutData>(6);
        GlobalConsistentCutData.Builder globDataBuilder = new GlobalConsistentCutData.Builder();
        for (TestNodeContext node : this.nodes) {
            LocalConsistentCutData locData = node.consistentCutContext().finishTrackingTransactionsLocally();
            globDataBuilder.merge(node.nodeUuid(), locData);
            locs.add(locData);
        }
        return new ConsistentCutData(locs, globDataBuilder.build());
    }

    private ConsistentCut[] completeConsistentCutCreation(GlobalConsistentCutData globData) {
        ConsistentCut[] cuts = new ConsistentCut[6];
        for (int i = 0; i < 6; ++i) {
            cuts[i] = this.nodes[i].consistentCutContext().completeConsistentCutCreation(globData, null);
        }
        return cuts;
    }

    private ConsistentCut createConsistentCut(long id, WALPointer fuzzyBorderPtr, WALPointer cutPtr, Set<GridCacheVersion> skippedTxs) {
        return new ConsistentCut(id, 0L, fuzzyBorderPtr, cutPtr, -1L, skippedTxs, Collections.emptyMap(), null, false, Collections.emptyMap(), null);
    }

    private static class ConsistentCutData {
        private final List<LocalConsistentCutData> locs;
        private final GlobalConsistentCutData glob;

        ConsistentCutData(List<LocalConsistentCutData> locs, GlobalConsistentCutData glob) {
            this.locs = locs;
            this.glob = glob;
        }

        List<LocalConsistentCutData> locals() {
            return this.locs;
        }

        GlobalConsistentCutData global() {
            return this.glob;
        }
    }
}

