/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.txdr.AbstractReplicationTest;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.TransactionalDrConfiguration;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class ConsistentCutSmokeTest
extends GridCommonAbstractTest {
    protected static final String TRANSFER_FOLDER_NAME = "transfer-folder";
    protected static final String SNAPSHOT_FOLDER_NAME = "snapshot";

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        DataStorageConfiguration memCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setMaxSize(0x6400000L).setPersistenceEnabled(true)).setWalMode(WALMode.LOG_ONLY);
        cfg.setDataStorageConfiguration(memCfg);
        GridGainTxDrConfiguration ggCfg = new GridGainTxDrConfiguration();
        SnapshotConfiguration ggDbCfg = new SnapshotConfiguration();
        ggCfg.setSnapshotConfiguration(ggDbCfg);
        TransactionalDrConfiguration txDrCfg = new TransactionalDrConfiguration();
        txDrCfg.setTransferFolderPath(this.folder(TRANSFER_FOLDER_NAME).getAbsolutePath());
        ggCfg.setTxDrConfiguration(txDrCfg);
        cfg.setPluginConfigurations(new PluginConfiguration[]{ggCfg});
        cfg.setConsistentId((Serializable)((Object)gridName));
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        U.delete((File)this.folder(SNAPSHOT_FOLDER_NAME));
        U.delete((File)this.folder(TRANSFER_FOLDER_NAME));
        this.cleanPersistenceDir();
    }

    protected File folder(String folder) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)folder, (boolean)false);
    }

    @Test
    public void testSmoke() throws Exception {
        IgniteEx ig = this.startGrids(3);
        ig.cluster().active(true);
        AbstractReplicationTest.replaceTransactionalProcessor(G.allGrids().stream().map(grid -> (IgniteEx)grid).collect(Collectors.toList()));
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        IgniteCache cache = ig.getOrCreateCache(new CacheConfiguration().setName("cache-111").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1));
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SnapshotFuture snFut = snapshot.createFullSnapshot(null, null);
        snFut.get();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
        SnapshotFuture ccFut = snapMgr.startGlobalConsistentCut();
        ccFut.get();
    }

    @Test
    public void testSmokeWithLoad() throws Exception {
        IgniteEx ig = this.startGrids(4);
        ig.cluster().active(true);
        AbstractReplicationTest.replaceTransactionalProcessor(G.allGrids().stream().map(grid -> (IgniteEx)grid).collect(Collectors.toList()));
        GridGain gg = (GridGain)ig.plugin("GridGain");
        GridSnapshot snapshot = gg.snapshot();
        final IgniteCache cache = ig.getOrCreateCache(new CacheConfiguration().setName("cache-111").setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32)).setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setBackups(1));
        for (int i = 0; i < 1000; ++i) {
            cache.put((Object)i, (Object)i);
        }
        SnapshotFuture snFut = snapshot.createFullSnapshot(null, null);
        snFut.get();
        GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
        final AtomicBoolean stop = new AtomicBoolean(false);
        final AtomicReference<Object> err = new AtomicReference<Object>(null);
        GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    while (!stop.get()) {
                        ThreadLocalRandom r = ThreadLocalRandom.current();
                        cache.put((Object)r.nextInt(1000), (Object)r.nextInt());
                    }
                }
                catch (Throwable t) {
                    err.compareAndSet(null, t);
                }
            }
        }, (int)4, (String)"loader-thread");
        SnapshotFuture ccFut = snapMgr.startGlobalConsistentCut();
        ccFut.get();
        stop.set(true);
        ConsistentCutSmokeTest.assertNull(err.get());
    }
}

