/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.sftp;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.snapshot.sftp.AbstractSftpSnapshotTest;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.junit.Test;

public class IgniteDbIncorrectSftpServerTest
extends AbstractSftpSnapshotTest {
    @Test
    public void testMoveSnapshotAndRestoreAfterRestart() throws Exception {
        SnapshotPath sftpDir = this.getSftpfolder();
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.createCache("sftp_test_cache");
        cache.put((Object)KEY, (Object)"val171");
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp1.get();
        IgniteDbIncorrectSftpServerTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        gg.snapshot().move(new MoveSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).destinationPath(sftpDir)).get();
        IgniteDbIncorrectSftpServerTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        this.stopGrid(0);
        this.cleanPersistenceDir();
        ig = this.startGrid(0);
        ig.cluster().active(true);
        gg = (GridGain)ig.plugin("GridGain");
        cache = ig.cache("sftp_test_cache");
        IgniteDbIncorrectSftpServerTest.assertNull((Object)cache);
        SnapshotPath incorrectSfptFile = SnapshotPath.sftp().uri(new URI("sftp://snapshotUser:incorrectPassword@127.0.0.1:" + this.sftpRule.getPort() + "/movedsnapshots")).build();
        GridGain finalGg = gg;
        GridTestUtils.assertThrows(null, () -> (Void)finalGg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).optionalSearchPaths(Arrays.asList(incorrectSfptFile))).get(), IgniteException.class, (String)"Snapshot does not exist");
        cache = ig.cache("sftp_test_cache");
        IgniteDbIncorrectSftpServerTest.assertNull((Object)cache);
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).optionalSearchPaths(Arrays.asList(sftpDir))).get();
        cache = ig.cache("sftp_test_cache");
        IgniteDbIncorrectSftpServerTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
    }

    @Test
    public void testMoveFullSnapshotAndKeepIncrementalRestoreAfterRestart() throws Exception {
        SnapshotPath sftpDir = this.getSftpfolder();
        IgniteEx ig = this.startGrid(0);
        ig.cluster().active(true);
        GridGain gg = (GridGain)ig.plugin("GridGain");
        IgniteCache cache = ig.createCache("sftp_test_cache");
        cache.put((Object)KEY, (Object)"val171");
        SnapshotFuture snp1 = gg.snapshot().createFullSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp1.get();
        IgniteDbIncorrectSftpServerTest.assertEquals((String)((String)cache.get((Object)KEY)), (String)"val171");
        gg.snapshot().move(new MoveSnapshotParams().snapshotId(snp1.snapshotOperation().snapshotId()).destinationPath(sftpDir)).get();
        cache.put((Object)(KEY + 1L), (Object)"val1711");
        SnapshotFuture snp2 = gg.snapshot().createSnapshot(Collections.singleton("sftp_test_cache"), null);
        snp2.get();
        this.stopGrid(0);
        this.cleanPersistenceDir();
        ig = this.startGrid(0);
        ig.cluster().active(true);
        gg = (GridGain)ig.plugin("GridGain");
        cache = ig.cache("sftp_test_cache");
        IgniteDbIncorrectSftpServerTest.assertNull((Object)cache);
        SnapshotPath incorrectSfptFile = SnapshotPath.sftp().uri(new URI("sftp://snapshotUser:incorrectPassword@127.0.0.1:" + this.sftpRule.getPort() + "/movedsnapshots")).build();
        SnapshotPath incorrectFsFile = SnapshotPath.file().path(new File("/**sdcsf/unknownFolder/")).build();
        gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snp2.snapshotOperation().snapshotId()).optionalSearchPaths(Arrays.asList(sftpDir, incorrectSfptFile, incorrectFsFile))).get();
        cache = ig.cache("sftp_test_cache");
        IgniteDbIncorrectSftpServerTest.assertEquals((String)"val171", (String)((String)cache.get((Object)KEY)));
        IgniteDbIncorrectSftpServerTest.assertEquals((String)"val1711", (String)((String)cache.get((Object)(KEY + 1L))));
    }
}

