/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotScheduleTTLTest
extends AbstractSnapshotTest {
    @Parameterized.Parameter(value=0)
    public int iterations;
    @Parameterized.Parameter(value=1)
    public int incSnapshotsPerIteration;
    private static final int CACHE_PUTS_PER_ITERATION = 100;
    private static final int DELAY_BETWEEN_SNAPSHOTS = 5000;
    @Parameterized.Parameter(value=2)
    public int timeBeforeLastSnapshot;

    @Parameterized.Parameters(name="iterations={0}, incSnapshotsPerIteration={1}, timeBeforeLastSnapshot={2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({1, 1, 0}, {2, 2, 5000}, {1, 2, 300000});
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testSnapshotKeepLastIncrementalSnapshot() throws Exception {
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.getOrCreateCache("cache1");
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        int snapsPerIteration = 1 + this.incSnapshotsPerIteration;
        int cachePutsPerSnap = 100;
        HashSet<Long> safeFullSnapshots = new HashSet<Long>();
        HashSet<Long> safeIncSnapshots = new HashSet<Long>();
        HashSet<Long> fullSnapsToDel = new HashSet<Long>();
        HashSet<Long> incSnapsToDel = new HashSet<Long>();
        for (int i = 0; i < this.iterations; ++i) {
            for (int j = 0; j < snapsPerIteration; ++j) {
                for (int k = 0; k < cachePutsPerSnap; ++k) {
                    cache.put((Object)(i * cachePutsPerSnap + j * 10 + k), (Object)k);
                }
                if (j == 0) {
                    SnapshotFuture full = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), "full_" + i);
                    full.get();
                    long snapId = full.snapshotOperation().snapshotId();
                    if (this.willKeep(i)) {
                        safeFullSnapshots.add(snapId);
                    } else {
                        fullSnapsToDel.add(snapId);
                    }
                } else {
                    SnapshotFuture inc = gg.snapshot().createSnapshot(Collections.singleton("cache1"), "full_" + i + "_inc_" + j);
                    inc.get();
                    long incId = inc.snapshotOperation().snapshotId();
                    if (this.willKeep(i)) {
                        safeIncSnapshots.add(incId);
                    } else {
                        incSnapsToDel.add(incId);
                    }
                }
                Thread.sleep(5000L);
            }
        }
        SnapshotScheduleProcessor scheduler = (SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler();
        this.setupSnapshotListener(ignite);
        SnapshotCommonParameters commonParameters = new SnapshotCommonParameters();
        SnapshotCreateParameters createParameters = new SnapshotCreateParameters();
        int tillNextJobExecution = (60 - LocalDateTime.now().getSecond()) * 1000;
        if (tillNextJobExecution <= 2000) {
            tillNextJobExecution = 59000;
            Thread.sleep(3000L);
        }
        int ttl = this.timeBeforeLastSnapshot == 0 ? tillNextJobExecution / 2 : tillNextJobExecution + this.timeBeforeLastSnapshot;
        SnapshotScheduleV2 schedule = new SnapshotScheduleV2("", "", SnapshotOperationType.DELETE, "*/1 * * * *", "* * * * *", Collections.singleton("cache1"), (long)ttl, null, true, commonParameters, createParameters, null, -1, -1, null, -1);
        scheduler.start(schedule);
        ArrayList<StartSnapshotOperationDiscoveryMessage> delMessages = new ArrayList<StartSnapshotOperationDiscoveryMessage>();
        int delCnt = fullSnapsToDel.size() + incSnapsToDel.size();
        if (delCnt == 0) {
            StartSnapshotOperationDiscoveryMessage msg = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(1L, TimeUnit.MINUTES);
            SnapshotScheduleTTLTest.assertNull((Object)msg);
        } else {
            for (int i = 0; i < delCnt; ++i) {
                StartSnapshotOperationDiscoveryMessage msg = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(1L, TimeUnit.MINUTES);
                if (msg == null) continue;
                delMessages.add(msg);
            }
        }
        Set deletedSnapshots = delMessages.stream().map(m -> m.snapshotOperation().snapshotId()).collect(Collectors.toSet());
        SnapshotScheduleTTLTest.assertTrue((boolean)deletedSnapshots.containsAll(fullSnapsToDel));
        SnapshotScheduleTTLTest.assertTrue((boolean)deletedSnapshots.containsAll(incSnapsToDel));
        safeFullSnapshots.addAll(safeIncSnapshots);
        SnapshotScheduleTTLTest.assertFalse((boolean)safeFullSnapshots.stream().anyMatch(deletedSnapshots::contains));
    }

    private boolean willKeep(int iteration) {
        if (this.timeBeforeLastSnapshot == 0) {
            return false;
        }
        return this.timeBeforeLastSnapshot > iteration * (this.incSnapshotsPerIteration + 1) * 5000;
    }
}

