/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.IgniteEx;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleProcessor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotScheduleKeepTest
extends AbstractSnapshotTest {
    private static final int ITERATIONS = 3;
    private static final int INC_SNAPSHOTS_PER_ITERATION = 2;
    private static final int CACHE_PUTS_PER_ITERATION = 100;
    @Parameterized.Parameter(value=0)
    public int keepCount;

    @Parameterized.Parameters(name="keepCount={0}")
    public static Collection parameters() {
        return Arrays.asList({0}, {1}, {2}, {3});
    }

    protected void beforeTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanSnapshotDirs();
    }

    @Test
    public void testSnapshotKeep() throws Exception {
        int i;
        IgniteEx ignite = this.startGrid();
        ignite.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = ignite.getOrCreateCache("cache1");
        GridGainImpl gg = (GridGainImpl)ignite.plugin("GridGain");
        ArrayList<SnapshotOperationInfo> fullSnapshots = new ArrayList<SnapshotOperationInfo>();
        ArrayList<SnapshotOperationInfo> incSnapshots = new ArrayList<SnapshotOperationInfo>();
        int iterations = 3;
        int incSnapsPerIteration = 2;
        int snapsPerIteration = 1 + incSnapsPerIteration;
        int cachePutsPerSnap = 100;
        HashSet<Long> fullSnapsToDelete = new HashSet<Long>();
        HashSet<Long> incSnapsToDelete = new HashSet<Long>();
        for (i = 0; i < iterations; ++i) {
            for (int j = 0; j < snapsPerIteration; ++j) {
                for (int k = 0; k < cachePutsPerSnap; ++k) {
                    cache.put((Object)(i * cachePutsPerSnap + j * 10 + k), (Object)k);
                }
                if (j == 0) {
                    SnapshotFuture full = gg.snapshot().createFullSnapshot(Collections.singleton("cache1"), "full" + i);
                    full.get(1L, TimeUnit.MINUTES);
                    fullSnapshots.add(full.snapshotOperation());
                    continue;
                }
                SnapshotFuture inc = gg.snapshot().createSnapshot(Collections.singleton("cache1"), "full" + i + "_inc" + j);
                inc.get(1L, TimeUnit.MINUTES);
                incSnapshots.add(inc.snapshotOperation());
            }
        }
        for (i = 0; i < iterations - this.keepCount; ++i) {
            fullSnapsToDelete.add(((SnapshotOperationInfo)fullSnapshots.get(i)).snapshotId());
        }
        for (i = 0; i < (iterations - this.keepCount) * incSnapsPerIteration; ++i) {
            incSnapsToDelete.add(((SnapshotOperationInfo)incSnapshots.get(i)).snapshotId());
        }
        this.setupSnapshotListener(ignite);
        SnapshotScheduleV2 schedule = new SnapshotScheduleV2("", "", SnapshotOperationType.DELETE, "*/1 * * * *", "* * * * *", Collections.singleton("cache1"), 0L, null, true, new SnapshotCommonParameters(), new SnapshotCreateParameters(), null, -1, -1, null, this.keepCount);
        ((SnapshotScheduleProcessor)gg.provider().getSnapshotScheduler()).start(schedule);
        int deleteCount = fullSnapsToDelete.size() + incSnapsToDelete.size();
        HashSet<Long> deletedSnapshots = new HashSet<Long>();
        for (int i2 = 0; i2 < deleteCount; ++i2) {
            StartSnapshotOperationDiscoveryMessage msg = (StartSnapshotOperationDiscoveryMessage)this.messages.poll(2L, TimeUnit.MINUTES);
            SnapshotScheduleKeepTest.assertNotNull((Object)msg);
            deletedSnapshots.add(msg.snapshotOperation().snapshotId());
        }
        MatcherAssert.assertThat(deletedSnapshots, (Matcher)Matchers.hasItems((Object[])fullSnapsToDelete.toArray(new Long[0])));
        MatcherAssert.assertThat(deletedSnapshots, (Matcher)Matchers.hasItems((Object[])incSnapsToDelete.toArray(new Long[0])));
    }
}

