/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteLogger;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.DeduplicatingSingleThreadExecutor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeduplicatingSingleThreadExecutorTest {
    private final IgniteLogger log = (IgniteLogger)Mockito.mock(IgniteLogger.class);
    @Captor
    private ArgumentCaptor<String> messageCaptor;
    private final ExecutorService executor = new DeduplicatingSingleThreadExecutor(Thread::new, this.log);

    @After
    public void stopExecutor() {
        this.executor.shutdownNow();
    }

    @Test
    public void jobsGetDeduplicatedOnDequeueing() throws Exception {
        CountDownLatch payloadSubmittedLatch = new CountDownLatch(1);
        this.blockExecutorTillPayloadJobsSubmitted(payloadSubmittedLatch);
        AtomicInteger payloadInvoked = new AtomicInteger(0);
        Runnable payloadTask = payloadInvoked::incrementAndGet;
        this.executor.submit(payloadTask);
        this.executor.submit(payloadTask);
        payloadSubmittedLatch.countDown();
        this.waitTillSubmittedJobsGetExecuted();
        Assert.assertThat((Object)payloadInvoked.get(), (Matcher)Matchers.is((Object)1));
    }

    private void blockExecutorTillPayloadJobsSubmitted(CountDownLatch payloadSubmittedLatch) {
        this.executor.submit(() -> {
            try {
                payloadSubmittedLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        });
    }

    private void waitTillSubmittedJobsGetExecuted() throws InterruptedException {
        CountDownLatch executedJobs = new CountDownLatch(1);
        this.executor.submit(executedJobs::countDown);
        Assert.assertTrue((boolean)executedJobs.await(1L, TimeUnit.SECONDS));
    }

    @Test
    public void nonConsequtiveTasksGetDeduplicated() throws Exception {
        CountDownLatch payloadSubmittedLatch = new CountDownLatch(1);
        this.blockExecutorTillPayloadJobsSubmitted(payloadSubmittedLatch);
        AtomicInteger payloadInvoked = new AtomicInteger(0);
        Runnable payloadTask = payloadInvoked::incrementAndGet;
        this.executor.submit(payloadTask);
        this.executor.submit(() -> {});
        this.executor.submit(payloadTask);
        payloadSubmittedLatch.countDown();
        this.waitTillSubmittedJobsGetExecuted();
        Assert.assertThat((Object)payloadInvoked.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void jobDiscardingGetsLogged() throws Exception {
        CountDownLatch payloadSubmittedLatch = new CountDownLatch(1);
        this.blockExecutorTillPayloadJobsSubmitted(payloadSubmittedLatch);
        Runnable payloadTask = () -> {};
        this.executor.submit(payloadTask);
        this.executor.submit(payloadTask);
        payloadSubmittedLatch.countDown();
        this.waitTillSubmittedJobsGetExecuted();
        ((IgniteLogger)Mockito.verify((Object)this.log)).warning((String)this.messageCaptor.capture());
        Assert.assertThat((Object)this.messageCaptor.getValue(), (Matcher)Matchers.startsWith((String)"Discarded scheduled snapshot operation because it is duplicated: "));
    }
}

