/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.ListeningTestLogger;
import org.apache.ignite.testframework.LogListener;
import org.apache.ignite.testframework.junits.IgniteTestResources;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testframework.junits.logger.GridTestLog4jLogger;
import org.apache.log4j.Level;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.persistentstore.CheckSnapshotParams;
import org.gridgain.grid.persistentstore.CopySnapshotParams;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.junit.Test;

public class SnapshotLogsTest
extends GridCommonAbstractTest {
    private static final String CONSISTENT_ID = "consistentId";
    private static final String SNAPSHOT = "snapshot";
    private static final String MOVE_DIR = "move_test";
    private static final String LOCK_FILE_EXISTS_MSG = "Can't read snapshot, snapshot creation hasn't finished normally. Lock file found: ";
    private IgniteEx srvNode;
    private ListeningTestLogger testLog;

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        this.srvNode = this.startGrid(0);
        this.srvNode.cluster().state(ClusterState.ACTIVE);
        IgniteCache cache = this.srvNode.getOrCreateCache("default");
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)String.valueOf(i), (Object)i);
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        this.testLog = new ListeningTestLogger(cfg.getGridLogger());
        return cfg.setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true))).setConsistentId((Serializable)((Object)CONSISTENT_ID)).setGridLogger((IgniteLogger)this.testLog);
    }

    protected void cleanPersistenceDir() throws Exception {
        super.cleanPersistenceDir();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)SNAPSHOT, (boolean)false));
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)MOVE_DIR, (boolean)true));
    }

    @Test
    public void testSnapshotRestoreWhenLockFileExists() throws Exception {
        long snapshotId = this.createSnapshot();
        String fileName = this.createFileInSnapshotDir(snapshotId, "lock");
        String logMsg = LOCK_FILE_EXISTS_MSG + fileName;
        this.validateLogMsgPresentsWhenSnapshotRestore(snapshotId, logMsg);
    }

    @Test
    public void testSnapshotRestoreWhenLockFileExists2() throws Exception {
        long snapshotId = this.createSnapshot();
        this.validateLogMsgOnLockFileThrottled(snapshotId);
    }

    @Test
    public void testSnapshotRestoreWhenCancelFileExists() throws Exception {
        long snapshotId = this.createSnapshot();
        String fileName = this.createFileInSnapshotDir(snapshotId, "cancelled");
        String logMsg = "Can't read snapshot, snapshot was cancelled. Cancel mark file found: " + fileName;
        this.validateLogMsgPresentsWhenSnapshotRestore(snapshotId, logMsg);
    }

    @Test
    public void testSnapshotRestoreMetadataLookupLogging() throws Exception {
        long snapshotId = this.createSnapshot();
        Path topLevelSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, false);
        Path cidSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, true);
        SnapshotLogsTest.enableDebug();
        this.validateLogMsgDuringSnapshotOperation(() -> this.restoreSnapshot(snapshotId), Arrays.asList("Trying to lookup snapshot metadata file in " + topLevelSnapshotFolder + ", result: not_found", "Trying to lookup snapshot metadata file in " + cidSnapshotFolder + ", result: found"), Collections.singletonList("Snapshot metadata file is missing: "));
    }

    @Test
    public void testSnapshotRestoreWhenMetadataFileNotExists() throws Exception {
        long snapshotId = this.createSnapshot();
        Path topLevelSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, false);
        Path cidSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, true);
        U.delete((Path)cidSnapshotFolder.resolve("snapshot-meta.bin"));
        SnapshotLogsTest.enableDebug();
        this.validateLogMsgDuringSnapshotOperation(() -> {
            IgniteException cfr_ignored_0 = (IgniteException)GridTestUtils.assertThrows((IgniteLogger)this.testLog, () -> this.restoreSnapshot(snapshotId), IgniteException.class, null);
        }, Arrays.asList("Trying to lookup snapshot metadata file in " + topLevelSnapshotFolder + ", result: not_found", "Trying to lookup snapshot metadata file in " + cidSnapshotFolder + ", result: not_found", "Snapshot metadata not found for snapshot " + snapshotId), Collections.singletonList("Snapshot metadata file is missing: "));
    }

    @Test
    public void testSnapshotCopyMetadataLookupLogging() throws Exception {
        long snapshotId = this.createSnapshot();
        SnapshotLogsTest.enableDebug();
        Path topLevelSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, false);
        Path cidSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, true);
        this.validateLogMsgDuringSnapshotOperation(() -> this.copySnapshot(snapshotId), Arrays.asList("Trying to lookup snapshot metadata file in " + topLevelSnapshotFolder + ", result: not_found", "Trying to lookup snapshot metadata file in " + cidSnapshotFolder + ", result: found"), Collections.singletonList("Snapshot metadata file is missing: "));
    }

    @Test
    public void testSnapshotMoveMetadataLookupLogging() throws Exception {
        long snapshotId = this.createSnapshot();
        SnapshotLogsTest.enableDebug();
        Path topLevelSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, false);
        Path cidSnapshotFolder = SnapshotLogsTest.metadataPath(snapshotId, true);
        this.validateLogMsgDuringSnapshotOperation(() -> this.moveSnapshot(snapshotId), Arrays.asList("Trying to lookup snapshot metadata file in " + topLevelSnapshotFolder + ", result: not_found", "Trying to lookup snapshot metadata file in " + cidSnapshotFolder + ", result: found"), Collections.singletonList("Snapshot metadata file is missing: "));
    }

    private long createSnapshot() {
        GridGain gg = (GridGain)this.srvNode.plugin("GridGain");
        SnapshotFuture snapFut = gg.snapshot().createFullSnapshot(null, null);
        snapFut.get(this.getTestTimeout());
        return snapFut.snapshotOperation().snapshotId();
    }

    private void restoreSnapshot(long snapshotId) {
        GridGain gg = (GridGain)this.srvNode.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().restore(new RestoreSnapshotParams().snapshotId(snapshotId));
        fut.get(this.getTestTimeout());
    }

    private void checkSnapshot(long snapshotId) {
        GridGain gg = (GridGain)this.srvNode.plugin("GridGain");
        SnapshotFuture fut = gg.snapshot().check(new CheckSnapshotParams().snapshotId(snapshotId));
        fut.get(this.getTestTimeout());
    }

    private void copySnapshot(long snapshotId) throws IgniteCheckedException {
        GridGain gg = (GridGain)this.srvNode.plugin("GridGain");
        SnapshotPath copyDir = SnapshotPath.file().path(SnapshotLogsTest.resolveDir(MOVE_DIR)).build();
        SnapshotFuture fut = gg.snapshot().copy(new CopySnapshotParams().snapshotId(snapshotId).destinationPath(copyDir).singleFileCopy(true));
        fut.get(this.getTestTimeout());
    }

    private void moveSnapshot(long snapshotId) throws IgniteCheckedException {
        GridGain gg = (GridGain)this.srvNode.plugin("GridGain");
        SnapshotPath moveDir = SnapshotPath.file().path(SnapshotLogsTest.resolveDir(MOVE_DIR)).build();
        SnapshotFuture fut = gg.snapshot().move(new MoveSnapshotParams().snapshotId(snapshotId).destinationPath(moveDir).singleFileCopy(true));
        fut.get(this.getTestTimeout());
    }

    private void validateLogMsgPresentsWhenSnapshotRestore(long snapshotId, String ... logMsgs) {
        assert (logMsgs.length > 0) : "Provide at least one message";
        List<LogListener> listeners = this.setUpLogListeners(b -> {}, Arrays.asList(logMsgs));
        GridTestUtils.assertThrows((IgniteLogger)this.testLog, () -> this.restoreSnapshot(snapshotId), IgniteException.class, null);
        for (int i = 0; i < logMsgs.length; ++i) {
            SnapshotLogsTest.assertTrue((String)("Message \"" + logMsgs[i] + "\" not found!"), (boolean)listeners.get(i).check());
        }
    }

    private void validateLogMsgDuringSnapshotOperation(GridTestUtils.RunnableX operation, List<String> expectedMsgs, List<String> unexpectedMsgs) {
        int i;
        assert (expectedMsgs.size() > 0 || unexpectedMsgs.size() > 0) : "Provide at least one message";
        List<LogListener> expectedListeners = this.setUpLogListeners(b -> b.atLeast(1), expectedMsgs);
        List<LogListener> unexpectedListeners = this.setUpLogListeners(b -> b.times(0), unexpectedMsgs);
        operation.run();
        for (i = 0; i < expectedMsgs.size(); ++i) {
            SnapshotLogsTest.assertTrue((String)("Message not found: \"" + expectedMsgs.get(i) + "\""), (boolean)expectedListeners.get(i).check());
        }
        for (i = 0; i < unexpectedMsgs.size(); ++i) {
            SnapshotLogsTest.assertTrue((String)("Unexpected message found: \"" + unexpectedMsgs.get(i) + "\""), (boolean)unexpectedListeners.get(i).check());
        }
    }

    private List<LogListener> setUpLogListeners(Consumer<LogListener.Builder> setup, List<String> logMsgs) {
        ArrayList<LogListener> listeners = new ArrayList<LogListener>(logMsgs.size());
        for (String logMsg : logMsgs) {
            Pattern ptrn = Pattern.compile(logMsg, 16);
            LogListener.Builder listenerBuilder = LogListener.matches((Pattern)ptrn);
            setup.accept(listenerBuilder);
            LogListener listener = listenerBuilder.build();
            this.testLog.registerListener(listener);
            listeners.add(listener);
        }
        return listeners;
    }

    private void validateLogMsgOnLockFileThrottled(long snapshotId) throws Exception {
        String fileName = this.createFileInSnapshotDir(snapshotId, "lock");
        String logMsg = LOCK_FILE_EXISTS_MSG + fileName;
        Pattern ptrn = Pattern.compile(logMsg, 16);
        LogListener listener = LogListener.matches((Pattern)ptrn).build();
        this.testLog.registerListener(listener);
        GridTestUtils.assertThrows((IgniteLogger)this.testLog, () -> this.checkSnapshot(snapshotId), IgniteException.class, null);
        SnapshotLogsTest.assertTrue((String)("Message \"" + logMsg + "\" not found!"), (boolean)listener.check());
        listener.reset();
        GridTestUtils.assertThrows((IgniteLogger)this.testLog, () -> this.checkSnapshot(snapshotId), IgniteException.class, null);
        SnapshotLogsTest.assertFalse((String)("Message \"" + logMsg + "\" not found!"), (boolean)listener.check());
    }

    private String createFileInSnapshotDir(long snapshotId, String fileName) throws Exception {
        String snapshotDir = FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null);
        Path file = Paths.get(U.defaultWorkDirectory(), SNAPSHOT, snapshotDir, CONSISTENT_ID, fileName);
        SnapshotLogsTest.assertTrue((String)("Can't create file file " + file), (boolean)file.toFile().createNewFile());
        return file.toString();
    }

    private static File resolveDir(String dirName) throws IgniteCheckedException {
        return U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)dirName, (boolean)true);
    }

    private static Path metadataPath(long snapshotId, boolean withConsistentId) throws IgniteCheckedException {
        String snapshotDir = FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null);
        return withConsistentId ? Paths.get(U.defaultWorkDirectory(), SNAPSHOT, snapshotDir, CONSISTENT_ID) : Paths.get(U.defaultWorkDirectory(), SNAPSHOT, snapshotDir);
    }

    private static void enableDebug() {
        ((GridTestLog4jLogger)log).getLogger((Object)IgniteTestResources.class.getName()).setLevel(Level.DEBUG);
    }

    private static void disableDebug() {
        ((GridTestLog4jLogger)log).getLogger((Object)IgniteTestResources.class.getName()).setLevel(null);
    }
}

