/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.spi.discovery.tcp.internal.TcpDiscoveryNode;
import org.apache.ignite.testframework.GridStringLogger;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCopySinglePartitionCopyWorkGenerator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class SnapshotCopySinglePartitionCopyWorkGeneratorTest
extends AbstractSnapshotTest {
    private int pageSize = 4096;
    private int minimumAmountOfWork = 2;

    @Test
    public void testPublicMethodBeforeInitHasCalled() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertFalse((boolean)generator.workIsDone());
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertFalse((boolean)generator.updatesFromAllNodesReceived().isDone());
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.finishedWork().isEmpty());
        try {
            generator.getUpdatedMetadata();
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            generator.generateInitialWorkForCluster();
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSimple() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        generator.init(metadata);
        Map map = generator.generateInitialWorkForCluster();
        HashSet<Long> uniquePartIds = new HashSet<Long>();
        for (Map.Entry e : map.entrySet()) {
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((((long[])e.getValue()).length > this.minimumAmountOfWork ? 1 : 0) != 0);
        }
        this.completeWork(generator, map, uniquePartIds);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.workIsDone());
        this.checkThatWeHaveAssignedAllPartitions(metadata, uniquePartIds);
    }

    @Test
    public void testCreateMetadata() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        generator.init(metadata);
        this.completeWork(generator, generator.generateInitialWorkForCluster(), new HashSet<Long>());
        SnapshotMetadataV2 generated = generator.getUpdatedMetadata();
        Map finishedWorkOnCluster = generator.getFinishedWorkOnCluster();
        for (CacheSnapshotMetadata meta : generated.cacheGroupsMetadata().values()) {
            for (Map.Entry e : meta.partitionSizesPerNode().entrySet()) {
                long uniquePartId = SnapshotUtils.uniquePartId((int)meta.groupId(), (int)((Integer)e.getKey()));
                String s = (String)finishedWorkOnCluster.get(uniquePartId);
                if (s == null) {
                    SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((int)0, (int)((Integer)((Map)e.getValue()).values().iterator().next()));
                    continue;
                }
                for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                    if (((String)entry.getKey()).equals(s)) {
                        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals(((Map)((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(meta.groupId())).partitionSizesPerNode().get(e.getKey())).get(s), entry.getValue());
                        continue;
                    }
                    SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((int)-1, (int)((Integer)entry.getValue()));
                }
            }
        }
    }

    @Test
    public void testWithInitialWorkWereFinishedBeforeInitWasCalled() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        Map<String, GridLongList> initialWork = this.generateInitialWork(metadata, this.minimumAmountOfWork);
        HashSet<Long> uniquePartIds = new HashSet<Long>();
        for (Map.Entry<String, GridLongList> entry : initialWork.entrySet()) {
            long[] finishedWork = entry.getValue().array();
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((int)this.minimumAmountOfWork, (int)finishedWork.length);
            for (long uniqPartId : finishedWork) {
                uniquePartIds.add(uniqPartId);
            }
            long[] newAssignment = generator.updateAndTryAssignWork(entry.getKey(), GridLongList.EMPTY_ARRAY, finishedWork);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertNull((Object)newAssignment);
        }
        generator.init(metadata);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.updatesFromAllNodesReceived().isDone());
        Map map = generator.generateInitialWorkForCluster();
        this.completeWork(generator, map, uniquePartIds);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.workIsDone());
        this.checkThatWeHaveAssignedAllPartitions(metadata, uniquePartIds);
    }

    @Test
    public void testWithInitialWorkWereStartedBeforeInitWasCalled() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        Map<String, GridLongList> initialWork = this.generateInitialWork(metadata, this.minimumAmountOfWork);
        HashSet<Long> uniquePartIds = new HashSet<Long>();
        for (Map.Entry<String, GridLongList> entry : initialWork.entrySet()) {
            long[] startedWork = entry.getValue().array();
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((int)this.minimumAmountOfWork, (int)startedWork.length);
            for (long uniqPartId : startedWork) {
                uniquePartIds.add(uniqPartId);
            }
            long[] newAssignment = generator.updateAndTryAssignWork(entry.getKey(), startedWork, GridLongList.EMPTY_ARRAY);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertNull((Object)newAssignment);
        }
        generator.init(metadata);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.updatesFromAllNodesReceived().isDone());
        Map map = generator.generateInitialWorkForCluster();
        this.completeWork(generator, map, uniquePartIds);
        for (Map.Entry<String, GridLongList> entry : initialWork.entrySet()) {
            long[] finished = entry.getValue().array();
            long[] newAssignment = generator.updateAndTryAssignWork(entry.getKey(), GridLongList.EMPTY_ARRAY, finished);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((Object)GridLongList.EMPTY_ARRAY, (Object)newAssignment);
        }
        this.checkThatWeHaveAssignedAllPartitions(metadata, uniquePartIds);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.workIsDone());
    }

    @Test
    public void testCaseWhenAllWorkHasDoneBeforeInit() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        Map<String, GridLongList> allWork = this.generateInitialWork(metadata, Integer.MAX_VALUE);
        HashSet<Long> uniquePartIds = new HashSet<Long>();
        for (Map.Entry<String, GridLongList> entry : allWork.entrySet()) {
            long[] finishedWork;
            for (long uniqPartId : finishedWork = entry.getValue().array()) {
                uniquePartIds.add(uniqPartId);
            }
            long[] newAssignment = generator.updateAndTryAssignWork(entry.getKey(), GridLongList.EMPTY_ARRAY, finishedWork);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertNull((Object)newAssignment);
        }
        generator.init(metadata);
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.updatesFromAllNodesReceived().isDone());
        Map map = generator.generateInitialWorkForCluster();
        for (long[] assignment : map.values()) {
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((Object)GridLongList.EMPTY_ARRAY, (Object)assignment);
        }
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)generator.workIsDone());
        this.checkThatWeHaveAssignedAllPartitions(metadata, uniquePartIds);
    }

    @Test
    public void testLocalAssignment() throws Exception {
        int work = this.minimumAmountOfWork;
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(work, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotMetadataV2 metadata = this.generate(10, work);
        generator.init(metadata);
        Map map = generator.generateInitialWorkForCluster();
        HashMap<String, AtomicInteger> totalPartCntPerNode = new HashMap<String, AtomicInteger>();
        for (CacheSnapshotMetadata cacheSnapshotMetadata : metadata.cacheGroupsMetadata().values()) {
            for (Map cIdsWithSize : cacheSnapshotMetadata.partitionSizesPerNode().values()) {
                for (String cId : cIdsWithSize.keySet()) {
                    totalPartCntPerNode.computeIfAbsent(cId, x -> new AtomicInteger()).incrementAndGet();
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String cId = (String)entry.getKey();
            long[] assignedWork = (long[])entry.getValue();
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((assignedWork.length >= this.minimumAmountOfWork ? 1 : 0) != 0);
            long size = 0L;
            for (long uniqId : assignedWork) {
                int grpId = SnapshotUtils.grpId((long)uniqId);
                int partId = SnapshotUtils.partId((long)uniqId);
                Integer sizeInPages = (Integer)((Map)((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId)).partitionSizesPerNode().get(partId)).get(cId);
                size += sizeInPages.longValue() * (long)this.pageSize;
            }
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((size >= Integer.MAX_VALUE || assignedWork.length == ((AtomicInteger)totalPartCntPerNode.get(cId)).get() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNodeLeftRightOnTheBeggining() throws Exception {
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)new GridStringLogger());
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertNull((Object)generator.onNodeFailed("cId"));
        SnapshotMetadataV2 metadata = this.generate(10, this.minimumAmountOfWork);
        String anyCId = (String)((Map)((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().values().iterator().next()).partitionSizesPerNode().values().iterator().next()).keySet().iterator().next();
        generator.onNodeFailed(anyCId);
        generator.init(metadata);
        Map map = generator.generateInitialWorkForCluster();
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((int)9, (int)map.size());
        SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertFalse((boolean)map.containsKey(anyCId));
    }

    @Test
    public void testNodeLeft() throws Exception {
        GridStringLogger log = new GridStringLogger(false);
        log.logLength(0x100000);
        SnapshotCopySinglePartitionCopyWorkGenerator generator = new SnapshotCopySinglePartitionCopyWorkGenerator(this.minimumAmountOfWork, this.pageSize, (IgniteLogger)log);
        int topologySize = 10;
        SnapshotMetadataV2 metadata = this.generate(topologySize, this.minimumAmountOfWork);
        Map<String, GridLongList> generatedInitialWork = this.generateInitialWork(metadata, 50);
        for (Map.Entry<String, GridLongList> entry : generatedInitialWork.entrySet()) {
            long[] startedWork = entry.getValue().array();
            long[] newAssignment = generator.updateAndTryAssignWork(entry.getKey(), startedWork, GridLongList.EMPTY_ARRAY);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertNull((Object)newAssignment);
        }
        generator.init(metadata);
        this.completeWork(generator, generator.generateInitialWorkForCluster(), new HashSet<Long>());
        ArrayList<String> keys = new ArrayList<String>(generatedInitialWork.keySet());
        Collections.shuffle(keys);
        int successfullyFinishedNodeCount = ThreadLocalRandom.current().nextInt(3, 7);
        for (int i = 0; i < successfullyFinishedNodeCount; ++i) {
            long[] finished = generatedInitialWork.get(keys.get(i)).array();
            long[] newAssignment = generator.updateAndTryAssignWork((String)keys.get(i), GridLongList.EMPTY_ARRAY, finished);
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((Object)GridLongList.EMPTY_ARRAY, (Object)newAssignment);
        }
        HashSet<String> failed = new HashSet<String>();
        HashMap<Long, String> wasAssignedAfterFail = new HashMap<Long, String>();
        for (int i = successfullyFinishedNodeCount; i < topologySize; ++i) {
            String cId = (String)keys.get(i);
            failed.add(cId);
            GridLongList list = generatedInitialWork.get(cId);
            Map map = generator.onNodeFailed(cId);
            if (map == null) continue;
            for (Map.Entry e : map.entrySet()) {
                SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertFalse((boolean)failed.contains(e.getKey()));
                SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)list.containsAll((GridLongList)e.getValue()));
                for (long l : ((GridLongList)e.getValue()).array()) {
                    wasAssignedAfterFail.put(l, cId);
                }
            }
        }
        String msg = log.toString();
        for (String s : failed) {
            GridLongList list = generatedInitialWork.get(s);
            for (int i = 0; i < list.size(); ++i) {
                long l = list.get(i);
                String cId = (String)wasAssignedAfterFail.get(l);
                if (cId != null || msg.contains("Partition (grpId=" + SnapshotUtils.grpId((long)l) + ", partId=" + SnapshotUtils.partId((long)l) + ") wouldn't be copied")) continue;
                Map map = (Map)((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(SnapshotUtils.grpId((long)l))).partitionSizesPerNode().get(SnapshotUtils.partId((long)l));
                boolean found = false;
                for (String owner : map.keySet()) {
                    if (failed.contains(owner)) continue;
                    found = true;
                    break;
                }
                SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((String)"We didn't detected the partition loss.", (boolean)found);
            }
        }
    }

    private Map<String, GridLongList> generateInitialWork(SnapshotMetadataV2 metadata, int amountOfWork) {
        HashMap<String, GridLongList> initialWork = new HashMap<String, GridLongList>();
        ArrayList values = new ArrayList(metadata.cacheGroupsMetadata().values());
        Collections.shuffle(values);
        for (CacheSnapshotMetadata meta : values) {
            block1: for (Map.Entry e : meta.partitionSizesPerNode().entrySet()) {
                long uniquePartId = SnapshotUtils.uniquePartId((int)meta.groupId(), (int)((Integer)e.getKey()));
                for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                    if ((Integer)entry.getValue() == 0) break;
                    String cId = (String)entry.getKey();
                    GridLongList workAssignment = initialWork.computeIfAbsent(cId, x -> new GridLongList());
                    if (workAssignment.size() >= amountOfWork) continue;
                    workAssignment.add(uniquePartId);
                    continue block1;
                }
            }
        }
        return initialWork;
    }

    private void completeWork(SnapshotCopySinglePartitionCopyWorkGenerator generator, Map<String, long[]> workInProgress, Set<Long> uniquePartIds) throws IgniteCheckedException {
        boolean thereIsSomeWork;
        block0: do {
            int size = uniquePartIds.size();
            HashMap<String, long[]> newAssignment = new HashMap<String, long[]>();
            for (Map.Entry<String, long[]> e : workInProgress.entrySet()) {
                String cId = e.getKey();
                long[] oldWorkAssignment = e.getValue() == null ? GridLongList.EMPTY_ARRAY : e.getValue();
                this.checkAssignment(oldWorkAssignment, uniquePartIds);
                long[] longs = generator.updateAndTryAssignWork(cId, GridLongList.EMPTY_ARRAY, oldWorkAssignment);
                Set finishedWork = generator.finishedWork();
                for (long uniqId : oldWorkAssignment) {
                    SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)finishedWork.contains(uniqId));
                }
                newAssignment.put(cId, longs);
            }
            workInProgress = newAssignment;
            thereIsSomeWork = false;
            for (long[] longs : workInProgress.values()) {
                if (longs != null && longs.length <= 0) continue;
                thereIsSomeWork = true;
                continue block0;
            }
        } while (thereIsSomeWork);
        for (Map.Entry<String, long[]> e : workInProgress.entrySet()) {
            SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertEquals((Object)e.getValue(), (Object)GridLongList.EMPTY_ARRAY);
        }
    }

    private void checkThatWeHaveAssignedAllPartitions(SnapshotMetadataV2 metadata, Set<Long> uniquePartIds) {
        for (CacheSnapshotMetadata meta : metadata.cacheGroupsMetadata().values()) {
            for (Map.Entry e : meta.partitionSizesPerNode().entrySet()) {
                long uniquePartId = SnapshotUtils.uniquePartId((int)meta.groupId(), (int)((Integer)e.getKey()));
                boolean wereAssigned = uniquePartIds.contains(uniquePartId);
                if ((Integer)((Map)e.getValue()).values().iterator().next() == 0) {
                    SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertFalse((boolean)wereAssigned);
                    continue;
                }
                SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((boolean)wereAssigned);
            }
        }
    }

    private void checkAssignment(long[] workAssignment, Set<Long> tracker) {
        if (workAssignment != null) {
            for (long unique : workAssignment) {
                SnapshotCopySinglePartitionCopyWorkGeneratorTest.assertTrue((String)("already contained uniquePartId=" + unique), (boolean)tracker.add(unique));
            }
        }
    }

    private SnapshotMetadataV2 generate(int topologySize, int minimalAmountOfWork) {
        ArrayList<TcpDiscoveryNode> topology = new ArrayList<TcpDiscoveryNode>();
        for (int i = 0; i < topologySize; ++i) {
            TcpDiscoveryNode e = new TcpDiscoveryNode();
            e.setAttributes(new HashMap());
            e.setConsistentId((Serializable)((Object)this.getNodeConsistentId(i)));
            topology.add(e);
        }
        HashMap<Integer, CacheSnapshotMetadata> map = new HashMap<Integer, CacheSnapshotMetadata>();
        int partCnt = minimalAmountOfWork * topologySize * 10;
        for (int i = 0; i < topologySize + 1; ++i) {
            String grpName = "grpName" + i;
            map.put(CU.cacheId((String)grpName), this.generate(topologySize, i, partCnt, grpName));
        }
        String name = "REPLICATED";
        map.put(CU.cacheId((String)name), this.generate(topologySize, Integer.MAX_VALUE, partCnt, name));
        return new SnapshotMetadataV2(System.currentTimeMillis(), UUID.randomUUID(), this.pageSize, Collections.emptyMap(), Collections.emptyMap(), true, false, new AffinityTopologyVersion((long)topologySize, 0), topology, map, Collections.emptyMap(), Collections.emptyMap(), false, Collections.emptyMap(), BaselineTopology.build(topology, (int)0), null, CompressionOption.NONE, 1, true, false, null, null);
    }

    @NotNull
    private String getNodeConsistentId(int i) {
        return ((Object)((Object)this)).getClass().getSimpleName() + "_" + i;
    }

    private CacheSnapshotMetadata generate(int topologySize, int backupCount, int partCnt, String grpName) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        boolean replicated = backupCount == Integer.MAX_VALUE;
        HashMap cntrs = new HashMap();
        for (int partId = 0; partId < partCnt; ++partId) {
            int size;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int i = rand.nextInt(100);
            switch (i) {
                case 0: 
                case 1: {
                    size = 0;
                    break;
                }
                case 2: {
                    size = rand.nextInt(524288, 0x280000);
                    break;
                }
                default: {
                    size = rand.nextInt(5, 262144);
                }
            }
            while ((replicated || map.size() != backupCount + 1) && map.size() != topologySize) {
                map.put(this.getNodeConsistentId(rand.nextInt(topologySize)), size);
            }
            cntrs.put(partId, map);
        }
        CacheConfiguration cfg = new CacheConfiguration(grpName).setCacheMode(replicated ? CacheMode.REPLICATED : CacheMode.PARTITIONED).setBackups(backupCount);
        return new CacheSnapshotMetadata(Collections.singleton(new StoredCacheData(cfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, partCnt)))), CU.cacheId((String)grpName), grpName, Collections.emptyMap(), cntrs, null);
    }
}

