/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.AbstractSnapshotTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FaultyStageFinishedCommunicationSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.persistentstore.RestoreSnapshotParams;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SnapshotCoordinatorChangeDuringStageFinishTest
extends AbstractSnapshotTest {
    private static final String TEST_CACHE_NAME = "some_test_cache";
    private static final String COORDINATOR_CONSISTENT_ID = "crd";
    private static final int NODES = 3;
    private static final int KEY = 1;
    private static final int VALUE = 1;
    @Parameterized.Parameter
    public TestData testData;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return super.getConfiguration(gridName).setConsistentId((Serializable)((Object)gridName)).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration(TEST_CACHE_NAME).setBackups(1)}).setCommunicationSpi((CommunicationSpi)FaultyStageFinishedCommunicationSpi.neverFailing());
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.cleanSnapshotDirs();
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    @Test
    public void testConsistentCut() throws Exception {
        this.testCreateFullSnapshotAndRestore();
    }

    @Test
    @WithSystemProperty(key="GG_EXCHANGELESS_SNAPSHOT_CREATION", value="false")
    public void testSnapshot() throws Exception {
        this.testCreateFullSnapshotAndRestore();
    }

    private void testCreateFullSnapshotAndRestore() throws Exception {
        FaultyStageFinishedCommunicationSpi commSpi = FaultyStageFinishedCommunicationSpi.failing(this.testData.allowance);
        commSpi.setLocalPort(GridTestUtils.getNextCommPort(((Object)((Object)this)).getClass()));
        commSpi.setTcpNoDelay(true);
        IgniteEx crd = this.startGrid(this.getConfiguration(COORDINATOR_CONSISTENT_ID).setCommunicationSpi((CommunicationSpi)commSpi));
        SnapshotCoordinatorChangeDuringStageFinishTest.assertTrue((boolean)this.computeJobWorkerInterruptTimeout((Ignite)crd).propagate((Serializable)Long.valueOf(100L)));
        IgniteEx aNode = null;
        for (int i = 0; i < 3; ++i) {
            aNode = this.startGrid("node" + i);
        }
        crd.cluster().state(ClusterState.ACTIVE);
        GridGain crdGG = (GridGain)crd.plugin("GridGain");
        IgniteCache cache = crd.getOrCreateCache(TEST_CACHE_NAME);
        cache.put((Object)1, (Object)1);
        crdGG.snapshot().createFullSnapshot(Collections.singleton(TEST_CACHE_NAME), "");
        commSpi.waitTillTriedToSendStageFinishedMessageToAllNodes();
        List snapshotOperations = IgnitionEx.allGrids().stream().filter(n -> !COORDINATOR_CONSISTENT_ID.equals(n.name())).map(ignite -> ((GridGain)ignite.plugin("GridGain")).snapshot().ongoingSnapshotOperationFuture()).filter(Objects::nonNull).collect(Collectors.toList());
        SnapshotCoordinatorChangeDuringStageFinishTest.assertEquals((int)3, (int)snapshotOperations.size());
        GridGain nodeGG = (GridGain)aNode.plugin("GridGain");
        SnapshotCreateFuture createFut = (SnapshotCreateFuture)((IgniteFutureImpl)nodeGG.snapshot().ongoingSnapshotOperationFuture()).internalFuture();
        crd.close();
        if (this.testData.cancel) {
            try {
                createFut.cancel();
            }
            catch (IgniteCheckedException e) {
                SnapshotCoordinatorChangeDuringStageFinishTest.assertTrue((boolean)e.getMessage().contains("Snapshot operation in non-cancelable state!"));
                createFut.get(30L, TimeUnit.SECONDS);
                return;
            }
            for (IgniteFuture operation : snapshotOperations) {
                try {
                    operation.get(30L, TimeUnit.SECONDS);
                    String operationState = snapshotOperations.stream().map(f -> {
                        SnapshotCreateFuture c = (SnapshotCreateFuture)((IgniteFutureImpl)f).internalFuture();
                        return c.cctx.localNode() + ": " + c.stage();
                    }).collect(Collectors.joining(", "));
                    SnapshotCoordinatorChangeDuringStageFinishTest.fail((String)("Should've been cancelled. Stages on nodes: " + operationState));
                }
                catch (IgniteException e) {
                    SnapshotCoordinatorChangeDuringStageFinishTest.assertTrue((boolean)e.getMessage().contains("Snapshot operation has been cancelled"));
                }
            }
            return;
        }
        createFut.get(30L, TimeUnit.SECONDS);
        cache = aNode.getOrCreateCache(TEST_CACHE_NAME);
        SnapshotCoordinatorChangeDuringStageFinishTest.assertEquals((int)((Integer)cache.get((Object)1)), (int)1);
        cache.clear();
        SnapshotCoordinatorChangeDuringStageFinishTest.assertNull((Object)cache.get((Object)1));
        SnapshotOperationInfoImpl info = createFut.snapshotInfo();
        nodeGG.snapshot().restore(new RestoreSnapshotParams().snapshotId(info.snapshotId())).get(30L, TimeUnit.SECONDS);
        SnapshotCoordinatorChangeDuringStageFinishTest.assertEquals((int)((Integer)cache.get((Object)1)), (int)1);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestData> testData() {
        return IntStream.range(0, 16).mapToObj(idx -> {
            boolean node0 = (idx & 1) == 1;
            boolean node1 = (idx & 2) == 2;
            boolean node2 = (idx & 4) == 4;
            boolean cancel = (idx & 8) == 8;
            return new TestData(new boolean[]{node0, node1, node2}, cancel);
        }).collect(Collectors.toList());
    }

    private static class TestData {
        private final boolean[] allowance;
        private final boolean cancel;

        private TestData(boolean[] allowance, boolean cancel) {
            this.allowance = allowance;
            this.cancel = cancel;
        }

        public String toString() {
            return "Node accessibility = " + Arrays.toString(this.allowance) + ", cancel = " + this.cancel;
        }
    }
}

