/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.PluginConfiguration;
import org.apache.ignite.testframework.junits.GridAbstractTest;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStageContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStageNodeLeftListener;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotConfigurableFuture;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.junit.Test;

public class SnapshotConfigurableFutureTest
extends GridCommonAbstractTest {
    private static final int SRV_COUNT = 3;
    private static final int CLIENT_TO_STOP = 4;
    private static final int MAGIC_NUMBER = 5;
    private static final String NODE_LEFT_MSG = "Node left!";
    private static final String CRD_LEFT_MSG = "Coordinator left!";
    private static final String TEST_CANCEL_MSG = "testCancel";
    private static final AtomicBoolean finalStageDone = new AtomicBoolean();
    private static final AtomicBoolean stage2Done = new AtomicBoolean();
    private static final AtomicBoolean nodeLeft = new AtomicBoolean();
    private static final AtomicBoolean cancelComplete = new AtomicBoolean();
    private static IgniteEx ignite;
    private static IgniteEx client;
    private int stoppedNode;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        String cId = "consistentId-" + igniteInstanceName;
        return super.getConfiguration(igniteInstanceName).setConsistentId((Serializable)((Object)cId)).setClientMode(igniteInstanceName.contains("client")).setCacheConfiguration(new CacheConfiguration[]{new CacheConfiguration("default").setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL).setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 100)).setBackups(2)}).setPluginConfigurations(new PluginConfiguration[]{new GridGainConfiguration().setSnapshotConfiguration(new SnapshotConfiguration())}).setDataStorageConfiguration(new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)));
    }

    protected void beforeTest() throws Exception {
        nodeLeft.set(false);
        stage2Done.set(false);
        finalStageDone.set(false);
        cancelComplete.set(false);
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.stopAllGrids();
        this.cleanPersistenceDir();
        ignite = this.startGrids(3);
        client = this.startClientGrid(3);
        this.startClientGrid(4);
        ignite.cluster().state(ClusterState.ACTIVE);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTestsStopped();
    }

    @Test
    public void testSimple() throws Exception {
        this.testCustomOperation(null, false, false);
    }

    @Test
    public void testSimpleWithCancel() throws Exception {
        this.testCustomOperation(null, true, false);
    }

    @Test
    public void testStopNode() throws Exception {
        this.testCustomOperation(NodeType.SRV, false, false);
    }

    @Test
    public void testStopCrd() throws Exception {
        this.testCustomOperation(NodeType.CRD, false, false);
    }

    @Test
    public void testStopNodeWithCancelOp() throws Exception {
        this.testCustomOperation(NodeType.SRV, false, true);
    }

    @Test
    public void testStopCrdWithCancelOp() throws Exception {
        this.testCustomOperation(NodeType.CRD, false, true);
    }

    @Test
    public void testStopClient() throws Exception {
        this.testCustomOperation(NodeType.CLIENT, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCustomOperation(NodeType nodeToStop, boolean cancelOperation, boolean cancelOnNodeLeft) throws Exception {
        GridGain gg = (GridGain)client.plugin("GridGain");
        GridSnapshotEx snapshot = (GridSnapshotEx)gg.snapshot();
        CustomStagesConfiguration stagesCfg = new CustomStagesConfiguration().addStage((CustomStage)new TestStage(1000, nodeToStop, !cancelOnNodeLeft)).addStage((CustomStage)new TestStage(1000, nodeToStop, !cancelOnNodeLeft && !cancelOperation, cancelOperation ? new OperationCancelCb() : null)).addStage((CustomStage)new TestStage(1000, nodeToStop, !cancelOnNodeLeft, null, () -> stage2Done.set(true))).finalStage((CustomStage)new TestStage(1000, nodeToStop, !cancelOnNodeLeft, null, () -> finalStageDone.set(true))).onNodeLeftCallback((CustomStageNodeLeftListener)new CustomStageNodeLeftListenerImpl(cancelOnNodeLeft)).onCancelCompleteCallback((IgniteInClosure & Serializable)f -> cancelComplete.set(true));
        SnapshotFuture fut = snapshot.customSnapshotOperation(stagesCfg, null);
        long snapshotId = fut.snapshotOperation().snapshotId();
        SnapshotConfigurableFutureTest.assertTrue((snapshotId > 0L ? 1 : 0) != 0);
        fut.initFuture().get(60L, TimeUnit.SECONDS);
        this.stopNode(nodeToStop);
        int allNodesExpectedCount = 4 + (nodeToStop == null ? 1 : 0);
        SnapshotConfigurableFutureTest.assertEquals((int)allNodesExpectedCount, (int)client.cluster().nodes().size());
        try {
            try {
                fut.get(60L, TimeUnit.SECONDS);
                SnapshotConfigurableFutureTest.assertTrue((boolean)stage2Done.get());
                SnapshotConfigurableFutureTest.assertFalse((cancelOperation || cancelOnNodeLeft ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                try {
                    if (cancelOperation) {
                        SnapshotConfigurableFutureTest.assertTrue((boolean)e.getMessage().contains(TEST_CANCEL_MSG));
                        SnapshotConfigurableFutureTest.assertTrue((boolean)cancelComplete.get());
                    } else if (cancelOnNodeLeft) {
                        SnapshotConfigurableFutureTest.assertTrue((boolean)cancelComplete.get());
                        if (nodeToStop == NodeType.CRD) {
                            SnapshotConfigurableFutureTest.assertTrue((X.getCause((Throwable)e) instanceof CrdLeftException || e.getMessage().contains(CRD_LEFT_MSG) ? 1 : 0) != 0);
                        } else if (nodeToStop == NodeType.SRV) {
                            SnapshotConfigurableFutureTest.assertTrue((X.getCause((Throwable)e) instanceof NodeLeftException || e.getMessage().contains(NODE_LEFT_MSG) ? 1 : 0) != 0);
                        }
                    } else {
                        SnapshotConfigurableFutureTest.assertTrue((boolean)stage2Done.get());
                    }
                }
                catch (AssertionError err) {
                    log.error("Exception occurred when executing custom snapshot operation", e);
                    throw err;
                }
            }
            if (!cancelOperation && !cancelOnNodeLeft) {
                SnapshotConfigurableFutureTest.assertTrue((boolean)finalStageDone.get());
            }
        }
        finally {
            if (nodeToStop != null) {
                this.restartNode();
            }
        }
    }

    private void stopNode(NodeType nodeToStop) {
        if (nodeToStop == null) {
            return;
        }
        ClusterNode crd = this.crd();
        block0 : switch (nodeToStop) {
            case CRD: {
                for (int i = 0; i < 3; ++i) {
                    if (!this.grid(i).cluster().localNode().id().equals(crd.id())) continue;
                    this.stopNode(i);
                    break block0;
                }
                break;
            }
            case SRV: {
                if (this.grid(0).cluster().localNode().id().equals(crd.id())) {
                    this.stopNode(1);
                    break;
                }
                this.stopNode(0);
                break;
            }
            case CLIENT: {
                this.stopNode(4);
            }
        }
    }

    private void stopNode(int nodeToStop) {
        this.stoppedNode = nodeToStop;
        this.stopGrid(nodeToStop);
    }

    private void restartNode() throws Exception {
        if (this.stoppedNode == 4) {
            this.startClientGrid(4);
        } else {
            ignite = this.startGrid(this.stoppedNode);
        }
    }

    private ClusterNode crd() {
        return ignite.context().grid().cluster().forServers().forOldest().node();
    }

    private static enum NodeType {
        SRV,
        CRD,
        CLIENT;

    }

    private static class CancelOperationTestException
    extends IgniteException {
        public CancelOperationTestException() {
            super(SnapshotConfigurableFutureTest.TEST_CANCEL_MSG);
        }
    }

    private static class CrdLeftException
    extends IgniteException {
        public CrdLeftException() {
            super(SnapshotConfigurableFutureTest.CRD_LEFT_MSG);
        }
    }

    private static class NodeLeftException
    extends IgniteException {
        public NodeLeftException() {
            super(SnapshotConfigurableFutureTest.NODE_LEFT_MSG);
        }
    }

    private static class OperationCancelCb
    implements IgniteInClosure<CustomStageContext>,
    Serializable {
        private OperationCancelCb() {
        }

        public void apply(CustomStageContext stageContext) {
            ((SnapshotConfigurableFuture)stageContext.currentFuture()).cancelOperation("test", (Throwable)((Object)new CancelOperationTestException()));
        }
    }

    private static class CustomStageNodeLeftListenerImpl
    implements CustomStageNodeLeftListener {
        private static final long serialVersionUID = 0L;
        private final boolean doCancel;

        public CustomStageNodeLeftListenerImpl(boolean doCancel) {
            this.doCancel = doCancel;
        }

        public <T extends IgniteInternalFuture<R>, R> void onNodeLeft(T fut, ClusterNode node, boolean crdChanged) {
            nodeLeft.set(true);
            if (!this.doCancel) {
                return;
            }
            ((SnapshotConfigurableFuture)fut).cancelOperation("node left", (Throwable)(crdChanged ? new CrdLeftException() : new NodeLeftException()));
        }
    }

    private static interface CrdHook
    extends Runnable,
    Serializable {
    }

    public static class TestStage
    implements CustomStage {
        private static final long serialVersionUID = 0L;
        private final int maxSleep;
        private final boolean checkClusterWidePayload;
        private final AtomicInteger executedCntr = new AtomicInteger();
        private final IgniteInClosure<CustomStageContext> exec;
        private final CrdHook crdHook;
        private final NodeType nodeToStop;

        public TestStage(int maxSleep, NodeType nodeToStop, boolean checkClusterWidePayload) {
            this(maxSleep, nodeToStop, checkClusterWidePayload, null);
        }

        public TestStage(int maxSleep, NodeType nodeToStop, boolean checkClusterWidePayload, IgniteInClosure<CustomStageContext> exec) {
            this(maxSleep, nodeToStop, checkClusterWidePayload, exec, null);
        }

        public TestStage(int maxSleep, NodeType nodeToStop, boolean checkClusterWidePayload, IgniteInClosure<CustomStageContext> exec, CrdHook crdHook) {
            this.maxSleep = maxSleep;
            this.checkClusterWidePayload = checkClusterWidePayload;
            this.exec = exec;
            this.crdHook = crdHook;
            this.nodeToStop = nodeToStop;
        }

        public boolean execute(CustomStageContext stageContext) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            GridAbstractTest.doSleep((long)((Random)random).nextInt(this.maxSleep));
            log.info("Executing stage: " + stageContext.stageNum() + ", previous stage cluster-wide payload: " + stageContext.previousStageClusterWidePayload() + ", previousStage=" + stageContext.previousStageNum());
            if (stageContext.stageType() == SnapshotOperationStage.CANCELLED) {
                SnapshotConfigurableFutureTest.assertNotNull((Object)stageContext.error());
            }
            stageContext.stageResultPayload((Object)5);
            if (this.exec != null) {
                this.exec.apply((Object)stageContext);
            }
            return true;
        }

        public void mergePayloadOnCrd(CustomStageContext stageContext, UUID nodeId, Object payload) {
            block1: {
                int merged;
                Integer globalPayload;
                if (payload == null) break block1;
                do {
                    int n = merged = (globalPayload = (Integer)stageContext.globalPayload()) == null ? (Integer)payload : globalPayload + (Integer)payload;
                } while (!stageContext.globalPayloadRef().compareAndSet(globalPayload, merged));
                this.executedCntr.incrementAndGet();
            }
        }

        public boolean onStageDoneCrdHook(CustomStageContext stageContext, boolean cancelled) {
            log.info("Crd hook of stage " + stageContext.stageNum() + ", type=" + stageContext.stageType() + ", cancelled=" + cancelled);
            int currentSrvCnt = stageContext.ctx().grid().cluster().forServers().nodes().size();
            if (this.checkClusterWidePayload && !cancelled) {
                try {
                    SnapshotConfigurableFutureTest.assertEquals((int)currentSrvCnt, (int)this.executedCntr.get());
                    SnapshotConfigurableFutureTest.assertEquals((int)(5 * currentSrvCnt), (int)((Integer)stageContext.globalPayload()));
                }
                catch (AssertionError err) {
                    if (this.nodeToStop == NodeType.SRV || this.nodeToStop == NodeType.CRD) {
                        SnapshotConfigurableFutureTest.assertEquals((int)currentSrvCnt, (int)(this.executedCntr.get() - 1));
                        SnapshotConfigurableFutureTest.assertEquals((int)(5 * currentSrvCnt), (int)((Integer)stageContext.globalPayload() - 5));
                    }
                    throw err;
                }
            }
            if (this.crdHook != null) {
                this.crdHook.run();
            }
            return true;
        }
    }
}

