/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.PA;
import org.apache.ignite.internal.util.typedef.internal.GPC;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotInfo;
import org.gridgain.grid.persistentstore.SnapshotUpdateOperationParams;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.junit.Test;

public class GridTruncateWalOnMoveOrDeleteSnapshotTest
extends GridPointInTimeRecoveryAbstractTest {
    private File movedSnapshotsRootDir;
    private long maxWalArchiveSize = -1L;

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        cfg.getDataStorageConfiguration().setWalSegments(2).setWalSegmentSize(0x3200000).setMaxWalArchiveSize(this.maxWalArchiveSize);
        return cfg;
    }

    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        return new CacheConfiguration[]{new CacheConfiguration("default")};
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.movedSnapshotsRootDir = new File(U.defaultWorkDirectory(), "movedsnapshots");
    }

    @Override
    protected void afterTest() throws Exception {
        super.afterTest();
        U.delete((File)this.movedSnapshotsRootDir);
    }

    @Test
    public void testTruncateWalOnDeleteSnapshot() throws Exception {
        IgniteEx ig = this.startGrids(1);
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = this.walArchiveDir(walMgr);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        int snapshotCntToCreate = 10;
        int realSnapshotCnt = 11;
        for (int i = 0; i < 10; ++i) {
            gg.snapshot().createFullSnapshot(null, null).get();
            this.loadData(keyGenerator, (Ignite)ig);
        }
        List<Integer> toRemove = Arrays.asList(0, 2, 3, 6);
        List snps = gg.snapshot().list();
        for (Integer idx : toRemove) {
            gg.snapshot().deleteSnapshot(((SnapshotInfo)snps.get(idx)).snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
        }
        GridTestUtils.waitForCondition((GridAbsPredicate)((PA)() -> walMgr.walArchiveSegments() >= 9), (long)10000L);
        FileDescriptor[] descs = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)9, (int)descs.length);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs[0].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)3L, (long)descs[1].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)4L, (long)descs[2].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)5L, (long)descs[3].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)6L, (long)descs[4].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)7L, (long)descs[5].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)8L, (long)descs[6].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)9L, (long)descs[7].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)10L, (long)descs[8].idx());
    }

    @Test
    public void testMoveLastSnapshot() throws Exception {
        IgniteEx ig = this.startGrids(1);
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = this.walArchiveDir(walMgr);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        List snps0 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)snps0.size());
        long snapshotId0 = ((SnapshotInfo)snps0.get(0)).snapshotId();
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().moveSnapshot(snapshotId0, this.movedSnapshotsRootDir, null).get();
            return null;
        }), IgniteException.class, null);
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        List snapshotList1 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)2, (int)snapshotList1.size());
        long snapshotId1 = ((SnapshotInfo)snapshotList1.get(1)).snapshotId();
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().moveSnapshot(snapshotId1, this.movedSnapshotsRootDir, null).get();
            return null;
        }), IgniteException.class, null);
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        List snps2 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)3, (int)snps2.size());
        SnapshotInfo firstSnapshot = (SnapshotInfo)snps2.get(0);
        SnapshotInfo secondSnapshot = (SnapshotInfo)snps2.get(1);
        SnapshotInfo thirdSnapshot = (SnapshotInfo)snps2.get(2);
        GridTestUtils.waitForCondition((GridAbsPredicate)((PA)() -> walMgr.walArchiveSegments() >= 3), (long)10000L);
        gg.snapshot().moveSnapshot(firstSnapshot.snapshotId(), this.movedSnapshotsRootDir, null).get();
        File[] movedSnapshots1 = this.movedSnapshotsRootDir.listFiles();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)movedSnapshots1.length);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((boolean)movedSnapshots1[0].getName().contains(String.valueOf(firstSnapshot.snapshotId())));
        FileDescriptor[] descs0 = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs0.length >= 1 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs0[0].idx());
        gg.snapshot().moveSnapshot(secondSnapshot.snapshotId(), this.movedSnapshotsRootDir, null).get();
        TreeSet<File> movedSnapshots2 = new TreeSet<File>();
        movedSnapshots2.addAll(Arrays.asList(this.movedSnapshotsRootDir.listFiles()));
        String first = ((File)movedSnapshots2.first()).getName();
        String second = ((File)movedSnapshots2.last()).getName();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)2, (int)movedSnapshots2.size());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((String)first, (boolean)first.contains(String.valueOf(firstSnapshot.snapshotId())));
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((String)second, (boolean)second.contains(String.valueOf(secondSnapshot.snapshotId())));
        FileDescriptor[] descs1 = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs1.length >= 1 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs1[0].idx());
    }

    @Test
    public void testDeleteLastSnapshot() throws Exception {
        IgniteEx ig = this.startGrids(1);
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = this.walArchiveDir(walMgr);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        AtomicLong keyGenerator = new AtomicLong();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        List snapshotList0 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)snapshotList0.size());
        long snapshotId0 = ((SnapshotInfo)snapshotList0.get(0)).snapshotId();
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().deleteSnapshot(snapshotId0, (SnapshotUpdateOperationParams)null, null).get();
            return null;
        }), IgniteException.class, null);
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        List snapshotList1 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)2, (int)snapshotList1.size());
        long snapshotId1 = ((SnapshotInfo)snapshotList1.get(1)).snapshotId();
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().deleteSnapshot(snapshotId1, (SnapshotUpdateOperationParams)null, null).get();
            return null;
        }), IgniteException.class, null);
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createSnapshot(null, null).get();
        List snapshotList2 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)3, (int)snapshotList2.size());
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().deleteSnapshot(snapshotId1, (SnapshotUpdateOperationParams)null, null).get();
            return null;
        }), IgniteException.class, null);
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        GridTestUtils.waitForCondition((GridAbsPredicate)((PA)() -> walMgr.walArchiveSegments() >= 3), (long)10000L);
        List snapshotList3 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)4, (int)snapshotList3.size());
        SnapshotInfo firstSnapshot = (SnapshotInfo)snapshotList3.get(0);
        gg.snapshot().deleteSnapshot(firstSnapshot.snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
        FileDescriptor[] descs0 = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs0.length >= 2 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs0[0].idx());
        SnapshotInfo secondSnapshot = (SnapshotInfo)snapshotList3.get(1);
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
            gg.snapshot().deleteSnapshot(secondSnapshot.snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
            return null;
        }), IgniteException.class, null);
        gg.snapshot().forceDeleteSnapshot(secondSnapshot.snapshotId(), null).get();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)gg.snapshot().list().size());
        FileDescriptor[] descs1 = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs1.length >= 1 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)3L, (long)descs1[0].idx());
    }

    @Test
    public void testMoveIncSnapshotFromMiddleOfChain() throws Exception {
        IgniteEx ig = this.startGrids(1);
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = this.walArchiveDir(walMgr);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        AtomicLong keyGenerator = new AtomicLong();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        List snps = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)snps.size());
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        int incrementalSnapshotsToCreate = 5;
        for (int i = 0; i < incrementalSnapshotsToCreate; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
            gg.snapshot().createSnapshot(null, null).get();
        }
        List snps2 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)(incrementalSnapshotsToCreate + 1 + 1), (int)snps2.size());
        for (int i = snps2.size() - 1; i > 0; --i) {
            SnapshotInfo snapshotInfo = (SnapshotInfo)snps2.get(i);
            long snapshotId = snapshotInfo.snapshotId();
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
                gg.snapshot().moveSnapshot(snapshotId, this.movedSnapshotsRootDir, null).get();
                return null;
            }), IgniteException.class, null);
        }
        long firstSnapshotId = ((SnapshotInfo)snps2.get(0)).snapshotId();
        gg.snapshot().moveSnapshot(firstSnapshotId, this.movedSnapshotsRootDir, null).get();
        TreeSet<File> movedSnapshots2 = new TreeSet<File>();
        movedSnapshots2.addAll(Arrays.asList(this.movedSnapshotsRootDir.listFiles()));
        String first = ((File)movedSnapshots2.first()).getName();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)movedSnapshots2.size());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((String)first, (boolean)first.contains(String.valueOf(firstSnapshotId)));
        GridTestUtils.waitForCondition((GridAbsPredicate)((PA)() -> walMgr.walArchiveSegments() >= 5), (long)10000L);
        FileDescriptor[] descs = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs.length >= 5 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs[0].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)3L, (long)descs[1].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)4L, (long)descs[2].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)5L, (long)descs[3].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)6L, (long)descs[4].idx());
    }

    @Test
    public void testDeleteIncSnapshotFromMiddleOfChain() throws Exception {
        IgniteEx ig = this.startGrids(1);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        AtomicLong keyGenerator = new AtomicLong();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        List snps = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)1, (int)snps.size());
        this.loadData(keyGenerator, (Ignite)ig);
        gg.snapshot().createFullSnapshot(null, null).get();
        int incrementalSnapshots = 5;
        for (int i = 0; i < incrementalSnapshots; ++i) {
            this.loadData(keyGenerator, (Ignite)ig);
            gg.snapshot().createSnapshot(null, null).get();
        }
        gg.snapshot().createFullSnapshot(null, null).get();
        List snps2 = gg.snapshot().list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)(incrementalSnapshots + 1 + 1 + 1), (int)snps2.size());
        for (int i = snps2.size() - 1; i > 0; --i) {
            if (i == snps2.size() - 2) continue;
            long snapshotId = ((SnapshotInfo)snps2.get(i)).snapshotId();
            GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)((GPC)() -> {
                gg.snapshot().deleteSnapshot(snapshotId, (SnapshotUpdateOperationParams)null, null).get();
                return null;
            }), IgniteException.class, null);
        }
        gg.snapshot().deleteSnapshot(((SnapshotInfo)snps2.get(0)).snapshotId(), (SnapshotUpdateOperationParams)null, null).get();
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = (File)U.field((Object)walMgr, (String)"walArchiveDir");
        GridTestUtils.waitForCondition((GridAbsPredicate)((PA)() -> walMgr.walArchiveSegments() >= 6), (long)10000L);
        FileDescriptor[] descs = this.walArchiveFiles(archive);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((descs.length >= 6 ? 1 : 0) != 0);
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)2L, (long)descs[0].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)3L, (long)descs[1].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)4L, (long)descs[2].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)5L, (long)descs[3].idx());
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)6L, (long)descs[4].idx());
    }

    @Test
    public void testMoveToUncleanDir() throws Exception {
        IgniteEx ig = this.startGrid();
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)ig);
        File archive = this.walArchiveDir(walMgr);
        ig.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        GridGain gg = (GridGain)ig.plugin("GridGain");
        AtomicLong keyGenerator = new AtomicLong();
        this.loadData(keyGenerator, (Ignite)ig);
        GridSnapshot ggSnapshots = gg.snapshot();
        GridCacheSnapshotManager snapshotMgr = (GridCacheSnapshotManager)ig.context().cache().context().snapshot();
        DatabaseSnapshotSpi snapshotSpi = snapshotMgr.snapshotSpi();
        File origPath = snapshotSpi.snapshotWorkingDirectory();
        SnapshotFuture create = ggSnapshots.createFullSnapshot(null, null);
        create.get();
        this.loadData(keyGenerator, (Ignite)ig);
        ggSnapshots.createFullSnapshot(null, null).get();
        this.loadData(keyGenerator, (Ignite)ig);
        ggSnapshots.createFullSnapshot(null, null).get();
        long snapshotId = create.snapshotOperation().snapshotId();
        String snapshotDirName = FileDatabaseSnapshotSpi.generateSnapshotDirName((long)snapshotId, null);
        Path snapshotPath = origPath.toPath().resolve(snapshotDirName);
        Path targetSnapshotDir = this.movedSnapshotsRootDir.toPath().resolve(snapshotDirName);
        FileUtils.copyDirectory((File)snapshotPath.toFile(), (File)targetSnapshotDir.toFile());
        FsSnapshotPath targetWalDir = ((FsSnapshotPath)snapshotSpi.generateCurNodeSnapshotFolderPath((SnapshotPath)new FsSnapshotPath(this.movedSnapshotsRootDir), snapshotId)).resolve("wal");
        FileUtils.copyDirectory((File)archive, (File)targetWalDir.getFile(), f -> f.getName().endsWith("wal"));
        ggSnapshots.moveSnapshot(snapshotId, this.movedSnapshotsRootDir, null).get();
    }

    @Test
    public void testNoWalArchiveSegmentDeleted() throws Exception {
        this.maxWalArchiveSize = 0x40000000L;
        IgniteEx n = this.startGrids(1);
        IgniteWriteAheadLogManager walMgr = this.walManager((Ignite)n);
        File archiveDir = this.walArchiveDir(walMgr);
        n.cluster().state(ClusterState.ACTIVE);
        this.awaitPartitionMapExchange();
        AtomicLong keyGen = new AtomicLong();
        GridSnapshot snapshot = ((GridGain)n.plugin("GridGain")).snapshot();
        for (int i = 0; i < 3; ++i) {
            this.loadData(keyGen, (Ignite)n);
            snapshot.createFullSnapshot(null, "full" + i).get();
        }
        List snapshotInfos = snapshot.list();
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((int)4, (int)snapshotInfos.size());
        this.checkSequentialWalArchiveFiles(this.walArchiveFiles(archiveDir), 4);
        snapshot.deleteSnapshot(((SnapshotInfo)snapshotInfos.get(2)).snapshotId(), "del0").get();
        this.checkSequentialWalArchiveFiles(this.walArchiveFiles(archiveDir), 4);
        snapshot.deleteSnapshot(((SnapshotInfo)snapshotInfos.get(0)).snapshotId(), "del0").get();
        this.checkSequentialWalArchiveFiles(this.walArchiveFiles(archiveDir), 4);
        snapshot.deleteSnapshot(((SnapshotInfo)snapshotInfos.get(1)).snapshotId(), "del0").get();
        this.checkSequentialWalArchiveFiles(this.walArchiveFiles(archiveDir), 4);
    }

    private void loadData(AtomicLong keyGenerator, Ignite ig) {
        try (IgniteDataStreamer st = ig.dataStreamer("default");){
            st.allowOverwrite(true);
            for (int j = 0; j < 20; ++j) {
                st.addData((Object)keyGenerator.getAndIncrement(), (Object)new byte[1024]);
            }
        }
    }

    private IgniteWriteAheadLogManager walManager(Ignite ig) {
        return ((IgniteEx)ig).context().cache().context().wal();
    }

    private File walArchiveDir(IgniteWriteAheadLogManager walMgr) {
        return (File)U.field((Object)walMgr, (String)"walArchiveDir");
    }

    private FileDescriptor[] walArchiveFiles(File walArchiveDir) {
        return FileWriteAheadLogManager.scan((File[])walArchiveDir.listFiles(FileWriteAheadLogManager.WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
    }

    private void checkSequentialWalArchiveFiles(FileDescriptor[] archiveFiles, int expSize) {
        GridTruncateWalOnMoveOrDeleteSnapshotTest.assertTrue((archiveFiles.length >= expSize ? 1 : 0) != 0);
        long startIdx = archiveFiles[0].idx();
        for (int i = 0; i < expSize; ++i) {
            GridTruncateWalOnMoveOrDeleteSnapshotTest.assertEquals((long)(startIdx + (long)i), (long)archiveFiles[i].idx());
        }
    }
}

