/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.recovery;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.GridGain;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridPointInTimeRecoveryAbstractTest;
import org.junit.Test;

public class GridPointInTimeRecoveryLocalProgressTest
extends GridPointInTimeRecoveryAbstractTest {
    @Override
    protected CacheConfiguration[] prepareCachesConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(CacheMode.PARTITIONED);
        ccfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 32));
        ccfg.setBackups(2);
        return new CacheConfiguration[]{ccfg};
    }

    @Override
    protected IgniteConfiguration getConfiguration(String name) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(name);
        GridGainConfiguration ggCfg = (GridGainConfiguration)cfg.getPluginConfigurations()[0];
        ggCfg.getSnapshotConfiguration().setSnapshotProgressThrottlingInterval(-1L);
        return cfg;
    }

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        U.delete((File)U.resolveWorkDirectory((String)U.defaultWorkDirectory(), (String)"tmp", (boolean)false));
    }

    @Test
    public void testRecoveryTrackProgress() throws Exception {
        final int nodes = 6;
        this.startGrids(nodes);
        IgniteEx igClient = this.startClient(nodes);
        igClient.cluster().active(true);
        GridPointInTimeRecoveryAbstractTest.TestContext test = new GridPointInTimeRecoveryAbstractTest.TestContext(this, (Ignite)igClient, "default");
        test.loadByTime(3000L);
        GridPointInTimeRecoveryAbstractTest.RecoveryPoint pnt = test.savePoint();
        test.removeByTime(1000L);
        GridGain gg = (GridGain)igClient.plugin("GridGain");
        GridSnapshotEx snp = (GridSnapshotEx)gg.snapshot();
        List<SnapshotProgressMessage> messages = Collections.synchronizedList(new ArrayList());
        this.sniffProgressMessages(messages);
        snp.recoveryTo(pnt.time, pnt.msg).get();
        test.checkPoint(pnt, G.allGrids());
        Map<Long, List<SnapshotProgressMessage>> messageMap = messages.stream().collect(Collectors.groupingBy(SnapshotProgressMessage::getTotal));
        long phase4messages = messageMap.get((long)nodes - 1L).size();
        messageMap.forEach(new BiConsumer<Long, List<SnapshotProgressMessage>>(){

            @Override
            public void accept(Long total, List<SnapshotProgressMessage> messages) {
                GridPointInTimeRecoveryLocalProgressTest.assertTrue((boolean)(messages.size() <= 101 && !messages.isEmpty()));
                final HashSet progressValues = new HashSet();
                messages.forEach(new Consumer<SnapshotProgressMessage>(){

                    @Override
                    public void accept(SnapshotProgressMessage message) {
                        GridPointInTimeRecoveryLocalProgressTest.assertTrue((boolean)((double)message.getProcessed() / (double)message.getTotal() <= 1.0));
                        GridPointInTimeRecoveryLocalProgressTest.assertTrue((boolean)((double)message.getProcessed() / (double)message.getTotal() >= 0.0));
                        progressValues.add(message.getProcessed());
                    }
                });
                if (total != (long)nodes - 1L) {
                    GridPointInTimeRecoveryLocalProgressTest.assertEquals((int)messages.size(), (int)progressValues.size());
                } else {
                    GridPointInTimeRecoveryLocalProgressTest.assertEquals((int)messages.size(), (int)(progressValues.size() * nodes));
                }
            }
        });
        GridPointInTimeRecoveryLocalProgressTest.assertEquals((long)(((long)nodes - 1L) * (long)nodes), (long)phase4messages);
        GridPointInTimeRecoveryLocalProgressTest.assertEquals((int)(nodes + 1), (int)messageMap.size());
    }
}

